<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * Include the {@link shared.make_timestamp.php} plugin
 */
require_once $smarty->_get_plugin_filepath('shared', 'make_timestamp');
/**
 * Smarty date_format modifier plugin
 *
 * Type:     modifier<br>
 * Name:     date_format<br>
 * Purpose:  format datestamps via strftime<br>
 * Input:<br>
 *         - string: input date string
 *         - format: strftime format for output
 *         - default_date: default date if $string is empty
 * @link http://smarty.php.net/manual/en/language.modifier.date.format.php
 *          date_format (Smarty online manual)
 * @author   Monte Ohrt <monte at ohrt dot com>
 * @param string
 * @param string
 * @param string
 * @return string|void
 * @uses smarty_make_timestamp()
 */
function smarty_modifier_sdate($timestamp)
{
    $timeStr = ' - ';
    if ($timestamp < 1) {
        return $timeStr;
    } else {
		$addColor = (time() - $timestamp) < 86400*3;
		if ($addColor) {
			$timeStr = '<font color=#ff0000>'.date("Y-m-d", $timestamp).'</font>';
		} else {
			$timeStr = date("Y-m-d", $timestamp);
		}
        return $timeStr;
	}
}

/* vim: set expandtab: */

?>
