<?php

defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class mysql {
	private $host; // 数据库主机
	private $user; // 数据库用户名
	private $pass; // 数据库密码
	private $data; // 数据库名
	private $conn; // 数据库连接标识,0为mysql_connect,1为mysql_pconnect(持久连接)
	private $sql; // sql语句
	private $code; // 数据库编码，GBK,UTF8,GB2312
	private $result; // 执行query命令的结果数据集
	private $showErr; // 是否开启错误提示,具有安全隐患,默认开启,建议仅在本地调试时使用
	private $errLog = true; // 是否开启错误日志,默认开启,推荐开启
	public $haveError;
	public $queryCount = 0;
	public $queryTime = '';
	public $errorMsg;
	protected $transTimes = 0; // 事务指令数
	public static $queries = array ();
	private static $_instance;
	private function __construct() {
		$this->host = DBHOST;
		$this->user = DBUSER;
		$this->pass = DBPWD;
		$this->data = DBNAME;
		$this->conn = DBCONN;
		$this->code = DBCODE;
		$this->showErr = SHOW_SQL_ERROR;
		$this->haveError = false;
		$this->connect ();
	}

	public function __get($name) {
		return $this->$name;
	}

	public function __set($name, $value) {
		$this->$name = $value;
	}

	//公共的
	public static function getInstance() {
		if (! (self::$_instance instanceof self)) {
			self::$_instance = new mysql ();
		}
		return self::$_instance;
	}

	// 数据库连接
	private function connect() {
		if ($this->conn == 1) {
			if (! $this->conn = @mysql_pconnect ( $this->host, $this->user, $this->pass )) {
				exit( 'Can not connect to MySQL server' );
			} // 永久链接
		} else {
			if (! $this->conn = @mysql_connect ( $this->host, $this->user, $this->pass )) {
				exit ( 'Can not connect to MySQL server' );
			}
			; // 临时链接
		}
		$this->select_db ( $this->data );
	}

	public function switchDB($mode) {
		if ($mode == 1) {
			return true;
		} else {
			$dbConfig = include ROOT_PATH . 'backupdb.php';
			if ($this->connType == 1) {
				$this->conn = mysql_pconnect ( $dbConfig ["dbhost"], $dbConfig ["dbuser"], $dbConfig ["dbpwd"] ); // 永久链接
			} else {
				$this->conn = mysql_connect ( $dbConfig ["dbhost"], $dbConfig ["dbuser"], $dbConfig ["dbpwd"] ); // 临时链接
			}
			if (! $this->conn) {
				$this->haltShow ( 'Can not connect to MySQL server' );
			}
			$this->select_db ( $dbConfig ["dbname"] );
		}
	}

	// 数据库选择
	public function select_db($data) {
		$result = mysql_select_db ( $data, $this->conn );
		if (! $result) {
			$this->haltShow ( 'Database Not Find' );
			$this->show_error ( Config::lang ( "DB_DONT_CONNECT" ) . $data );
		}
		$this->query ( 'SET NAMES ' . $this->code );
		$this->query ( "SET CHARACTER_SET_CLIENT='{$this->code}'" );
		$this->query ( "SET CHARACTER_SET_RESULTS='{$this->code}'" );
		return $result;
	}

	/**
	 * 直接执行sql查询
	 * @param $sql							查询sql语句
	 * @return	boolean/query resource		如果为查询语句，返回资源句柄，否则返回true/false
	 */
	public function query($sql) {
		$sql = trim ( $sql );
		if (empty ( $sql )) {
			$this->show_error ( Config::lang ( "SQL_EMPTY" ) );
		}
		$this->sql = $sql;
		$this->setQuery ( $sql );
		$this->result = mysql_query ( $this->sql, $this->conn );
		if (! $this->result) {
			$this->show_error ( Config::lang ( "SQL_ERROR" ), true );
		}
		return $this->result;
	}

	private function setQuery($sql) {
		//执行次数
		$this->queryCount ++;
		//执行时间
		if ($this->queryTime == '') {
			if (PHP_VERSION >= '5.0.0') {
				$this->queryTime = microtime ( true );
			} else {
				$this->queryTime = microtime ();
			}
		}
		//执行的SQL
		self::$queries ++;
		if (isset ( $sql ) && isset ( self::$queries [$sql] )) {
			self::$queries [$sql] += 1;
		} else if (isset ( $sql )) {
			self::$queries [$sql] = 1;
		}
	}

	/**
	 * 列出当前服务器中的所有数据库
	 * @param
	 * @return array
	 */
	public function list_dbs() {
		$this->query ( 'SHOW DATABASES' );
		$dbs = array ();
		while ( $row = $this->fetch_array () ) {
			$dbs [] = $row ['Database'];
		}
		return $dbs;
	}

	/**
	 * 列出数据库中的所有表
	 * @param database
	 * @return array
	 */
	public function list_tables($data = '') {
		if (! empty ( $data )) {
			$data = ' FROM ' . $data;
		}
		$this->query ( 'SHOW TABLES' . $data );
		$tables = array ();
		while ( $row = $this->fetch_row () ) {
			$tables [] = $row [0];
		}
		return $tables;
	}

	/**
	 * 列出表中的所有字段名
	 * @param table
	 * @return array
	 */
	function get_fields($table) {
		$fields = array ();
		$result = $this->query ( "SHOW COLUMNS FROM $table" );
		while ( $r = $this->fetch_array ( $result ) ) {
			$fields [] = $r ['Field'];
		}
		$this->free ( $result );
		return $fields;
	}

	/**
	 * 复制表
	 * @param $tb1, $tb2, $Condition
	 * @return boolean
	 */
	public function copy_tables($tb1, $tb2, $Condition = '') {
		$this->query ( "SELECT * INTO `{$tb1}` FROM `{$tb2}` {$Condition}" );
	}

	/**
	 * 查询数据
	 * @param 参  数：$Table 表名(必填)
	 * @param 参  数：$Fileds 字段名，默认为所有(选填)
	 * @param 参  数：$Condition 查询条件(选填)
	 * @param 参  数：$Rows 待查询记录条数，为0表示不限制(选填)
	 * @return boolean
	 */
	public function Get($Table, $Fileds = '*', $Condition = '', $Rows = 0) {
		if (! $Fileds) {
			$Fileds = '*';
		}
		if ($Rows > 0) {
			$Condition .= " LIMIT 0,{$Rows}";
		}
		$sql = "SELECT {$Fileds} FROM `{$Table}` {$Condition}";
		return $this->query ( $sql );
	}

	/**
	 * 只查询一条记录
	 * @param $Table, $Fileds, $Condition
	 * @return boolean
	 */
	public function GetRs($Table, $Fileds = '*', $Condition = '') {
		if (! $Fileds) {
			$Fileds = '*';
		}
		$sql = "SELECT {$Fileds} FROM `{$Table}` {$Condition} LIMIT 0,1";
		$this->query ( $sql );
		return $this->fetch_assoc ();
	}

	public function getAll($sql) {
		$res = $this->query ( $sql );
		if ($res !== false) {
			$arr = array ();
			while ( $row = mysql_fetch_assoc ( $res ) ) {
				$arr [] = $row;
			}
			return $arr;
		} else {
			return false;
		}
	}

	/**
	 * 添加数据
	 * @param $Table,$Data,$Values
	 * @return boolean
	 * @case $DB->Add('mydb',array('user'=>'admin','password'=>'123456','age'=>'18') 数组类型
	 * @case $DB->Add('mydb','`user`,`password`,`age`',"'admin','123456','18'" 字符串类型
	 */
	public function Add($Table, $Data = array(), $Values = '') {
		if (! isset ( $Data ) || empty ( $Data )) {
			$this->show_error ( 'Insert Data Empty', false );
			return false;
		}
		if (is_array ( $Data )) {
			foreach ( $Data as $key => $val ) {
				$key = trim ( $key );
				if (! empty ( $key )) {
					if ($val === NULL) {
						$Fileds .= "`{$key}`,";
						$Values .= "NULL,";
					} else {
						$val = ($val || $val == 0) ? mysql_real_escape_string ( $val ) : '';
						$Fileds .= "`{$key}`,";
						$Values .= "'{$val}',";
					}
				}
			}
			$Fileds = rtrim ( $Fileds, ',' );
			$Values = rtrim ( $Values, ',' );
		} else {
			$Fileds = $Data;
		}
		return $this->query ( "INSERT INTO `{$Table}` ({$Fileds}) VALUES ({$Values})" );
	}

	/**
	 * 更改数据
	 * @param $Table,$Data,$Condition,$unQuot
	 * @return boolean
	 * @case $DB->Set('mydb',array('user'=>'admin','password'=>'123456','WHERE id=1') 数组类型
	 * @case $DB->Set('mydb',"user='admin',password='123456'",'WHERE id=1') 字符串类型
	 */
	public function Set($Table, $Data, $Condition = '', $unQuot = array()) {
		if (is_array ( $Data )) {
			$unQuot = is_array ( $unQuot ) ? $unQuot : explode ( ',', $unQuot );
			foreach ( $Data as $key => $val ) {
				$val = ($val || $val == 0) ? mysql_real_escape_string ( $val ) : '';
				$Values .= "`" . $key . '`=' . (in_array ( $key, $unQuot ) ? "{$val}," : "'{$val}',");
			}
			$Values = rtrim ( $Values, ',' );
		} else {
			$Values = mysql_real_escape_string ( $Data );
		}
		return $this->query ( "UPDATE `{$Table}` SET {$Values} {$Condition}" );
	}

	/**
	 * @param Del($Table,$Condition)
	 * @return 删除数据
	 * @case $DB->Del('mydb','id=1')
	 */
	public function Del($Table, $Condition = '') {
		$this->query ( "DELETE FROM `{$Table}`" . ($Condition ? " WHERE {$Condition}" : '') );
		return $this->affected_rows ();
	}

	/**
	 * 删除数据
	 * @param Del($Table,$pri,$ids)
	 * @return boolean
	 * @case $DB->Del('mydb','id=1')
	 */
	public function Delete($Table, $pri, $ids) {
		$this->query ( "DELETE FROM `{$Table}`" . " WHERE `{$pri}` in ({$ids})" );
		return $this->affected_rows ();
	}

	// 取得结果数据
	public function result($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if ($result == null) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return mysql_result ( $result );
	}

	/**
	 * 删除数据
	 * @param fetch_array($Table,$Condition)
	 * @return boolean
	 * @case $type 数组类型，可以接受以下值：MYSQL_ASSOC，MYSQL_NUM 和 MYSQL_BOTH(选填)
	 */
	public function fetch_array($result = '', $type = MYSQL_BOTH) {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if (! $result) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return mysql_fetch_array ( $result, $type );
	}

	// 获取关联数组,使用$row['字段名']
	public function fetch_assoc($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if (! $result) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return @mysql_fetch_assoc ( $result );
	}

	// 获取数字索引数组,使用$row[0],$row[1],$row[2]
	public function fetch_row($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if (! $result) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return mysql_fetch_row ( $result );
	}

	// 获取对象数组,使用$row->content
	public function fetch_obj($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if (! $result) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return mysql_fetch_object ( $result );
	}

	// 取得上一步 INSERT 操作产生的 ID
	public function insert_id() {
		return mysql_insert_id ();
	}

	// 指向确定的一条数据记录
	public function data_seek($id) {
		if ($id > 0) {
			$id = $id - 1;
		}
		if (! mysql_data_seek ( $this->result, $id )) {
			$this->show_error ( Config::lang ( "EMPTY_THAT_DATA" ) );
			return false;
		}
		return $this->result;
	}

	/**
	 * 查询字段数量
	 * @param num_fields($result)
	 * @return string
	 * @case $DB->num_fields("mydb")
	 */
	public function num_fields($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if (! $result) {
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return mysql_num_fields ( $result );
	}

	// 根据select查询结果计算结果集条数
	public function num_rows($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		$rows = mysql_num_rows ( $result );
		if ($result == null) {
			$rows = 0;
			$this->show_error ( Config::lang ( "EMPTY_RESULT" ), true );
			return false;
		}
		return $rows > 0 ? $rows : 0;
	}

	// 根据insert,update,delete执行结果取得影响行数
	public function affected_rows() {
		return mysql_affected_rows ();
	}

	function pageAjax($totle, $displaypg = 20, $shownum = 0, $showtext = 0, $showselect = 0, $showlvtao = 7, $url = '', $mid) {
		global $page, $firstcount, $pagenav, $_SERVER;
		@$page = intval ( $_GET ['page'] );
		$GLOBALS ["displaypg"] = $displaypg;
		if (! $page) {
			$page = 1;
		}
		if (! $url) {
			$url = $_SERVER ["REQUEST_URI"];
		}
		$parse_url = parse_url ( $url );
		$url_query = $parse_url ["query"];
		if ($url_query) {
			$url_query = preg_replace ( "/(^|&)page=$page/", "", $url_query );
			$url = str_replace ( $parse_url ["query"], $url_query, $url );
			if ($url_query) {
				$url .= "&page";
			} else {
				$url .= "page";
			}
		} else {
			$url .= "?page";
		}
		$lastpg = ceil ( $totle / $displaypg );
		$page = min ( $lastpg, $page );
		$prepg = $page - 1;
		$nextpg = ($page == $lastpg ? 0 : $page + 1);
		$firstcount = ($page - 1) * $displaypg;
		if ($showtext == 1) {
			$pagenav = "<li class='disabled'><a href='#'>" . ($totle ? ($firstcount + 1) : 0) . "-" . min ( $firstcount + $displaypg, $totle ) . "/$totle " . Config::lang ( "RECORD" ) . "</a></li><li><a href='#' class='disabled'>$page/$lastpg 页</a></li>";
		} else {
			$pagenav = "";
		}
		if ($lastpg <= 1) {
			return false;
		}
		if ($prepg) {
			$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', 1,' . $mid . ')">' . Config::lang("FIRST_PAGE") . '</a></li>';
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "FIRST_PAGE" ) . '</span></li>';
		}
		if ($prepg) {
			$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $prepg . ',' . $mid . ')">' . Config::lang ( "FORWARD_PAGE" ) . '</a></li>';
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "FORWARD_PAGE" ) . '</a></li>';
		}
		if ($shownum == 1) {
			$o = $showlvtao;
			$u = ceil ( $o / 2 );
			$f = $page - $u;
			if ($f < 0) {
				$f = 0;
			}
			$n = $lastpg;
			if ($n < 1) {
				$n = 1;
			}
			if ($page == 1) {
				$pagenav .= '<li class="active"><a href="#">1</a></li>';
			} else {
				$newPage = $page - 1;
				$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $newPage . ',' . $mid . ')">1</a></li>';
			}
			for($i = 1; $i <= $o; $i ++) {
				if ($n <= 1) {
					break;
				}
				$c = $f + $i;
				if ($i == 1 && $c > 2) {
					$pagenav .= '<li><a href="#">...</a></li>';
				}
				if ($c == 1) {
					continue;
				}
				if ($c == $n) {
					break;
				}
				if ($c == $page) {
					$pagenav .= '<li class="active"><a href="#">' . $page . '</a></li>';
				} else {
					$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $c . ',' . $mid . ')">' . $c . '</a></li>';
				}
				if ($i == $o && $c < $n - 1) {
					$pagenav .= '<li><a href="#">...</a></li>';
				}
				if ($i > $n) {
					break;
				}
			}
			if ($page == $n && $n != 1) {
				$pagenav .= '<li class="active"><a href="#">' . $n . '</a></li>';
			} else {
				$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $n . ',' . $mid . ')">' . $n . '</a></li>';
			}
		}
		if ($nextpg) {
			$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $nextpg . ',' . $mid . ')">' . Config::lang ( "NEXT_PAGE" ) . '</a></li>';
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "NEXT_PAGE" ) . '</a></li>';
		}
		if ($nextpg) {
			$pagenav .= '<li><a href="javascript:void(0);" onclick="getAjaxPage(' . intval ( $_GET ["id"] ) . ', ' . $lastpg . ',' . $mid . ')">' . Config::lang ( "LAST_PAGE" ) . '</a></li>';
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "LAST_PAGE" ) . '</a></li>';
		}
		return $pagenav;
	}

	public function getModelStr($model) {
		$urlObj = new Url ();
		$methodName = "get" . ucfirst ( $model ) . "List";
		if (method_exists ( $urlObj, $methodName )) {
			return $methodName;
		}
		return "getList";
	}

	function pageft($totle, $displaypg = 20, $shownum = 0, $showtext = 0, $showselect = 0, $showlvtao = 7, $url = '', $model = 1) {
		global $page, $firstcount, $pagenav, $_SERVER;
		$getListMethod = $this->getModelStr ( $model );
		$urlObj = new Url ();
		@$page = intval ( $_GET ['page'] );
		if (! $page) {
			$page = 1;
		}
		if (! $url) {
			$url = $_SERVER ["REQUEST_URI"];
		}
		$parse_url = parse_url ( $url );
		$url_query = $parse_url ["query"];
		if ($url_query) {
			$url_query = preg_replace ( "/(^|&)page=$page/", "", $url_query );
			$url = str_replace ( $parse_url ["query"], $url_query, $url );
			if ($url_query) {
				$url .= "&page";
			} else {
				$url .= "page";
			}
		} else {
			$url .= "?page";
		}
		$lastpg = ceil ( $totle / $displaypg );
		$page = min ( $lastpg, $page );
		$prepg = $page - 1;
		$nextpg = ($page == $lastpg ? 0 : $page + 1);
		$firstcount = ($page - 1) * $displaypg;
		if ($showtext == 1) {
			$pagenav = "<li class='disabled'><a href='#'>" . ($totle ? ($firstcount + 1) : 0) . "-" . min ( $firstcount + $displaypg, $totle ) . "/$totle" . Config::lang ( "FIRST_PAGE" ) . "</span><span class='disabled'>$page/$lastpg " . Config::lang ( "PAGE" ) . "</a></li>";
		} else {
			$pagenav = "";
		}
		if ($lastpg <= 1) {
			return false;
		}
		if ($prepg) {
			$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], 1 ) . "'>" . Config::lang ( "FIRST_PAGE" ) . "</a></li>";
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "FIRST_PAGE" ) . '</a></li>';
		}
		if ($prepg) {
			$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], $prepg ) . "'>" . Config::lang ( "FORWARD_PAGE" ) . "</a></li>";
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "FORWARD_PAGE" ) . '</a></li>';
		}
		if ($shownum == 1) {
			$o = $showlvtao;
			$u = ceil ( $o / 2 );
			$f = $page - $u;
			if ($f < 0) {
				$f = 0;
			}
			$n = $lastpg;
			if ($n < 1) {
				$n = 1;
			}
			if ($page == 1) {
				$pagenav .= '<li class="active"><a href="#">1</a></li>';
			} else {
				$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], 1 ) . "'>1</a></li>";
			}
			for($i = 1; $i <= $o; $i ++) {
				if ($n <= 1) {
					break;
				}
				$c = $f + $i;
				if ($i == 1 && $c > 2) {
					$pagenav .= '<li><a href="#">...</a></li>';
				}
				if ($c == 1) {
					continue;
				}
				if ($c == $n) {
					break;
				}
				
				if ($c == $page) {
					$pagenav .= '<li class="active"><a href="#">' . $page . '</a></li>';
				} else {
					$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], $c ) . "'>$c</a></li>";
				}
				if ($i == $o && $c < $n - 1) {
					$pagenav .= '<li><a href="#">...</a></li>';
				}
				if ($i > $n) {
					break;
				}
			}
			if ($page == $n && $n != 1) {
				$pagenav .= '<li class="active"><a href="#">' . $n . '</a></li>';
			} else {
				$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], $n ) . "'>$n</a></li>";
			}
		}
		if ($nextpg) {
			$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], $nextpg ) . "'>" . Config::lang ( "NEXT_PAGE" ) . "</a></li>";
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "NEXT_PAGE" ) . '</a>';
		}
		if ($nextpg) {
			$pagenav .= "<li><a href='" . $urlObj->$getListMethod ( $_GET ["classid"], $lastpg ) . "'>" . Config::lang ( "LAST_PAGE" ) . "</a></li>";
		} else {
			$pagenav .= '<li class="disabled"><a href="#">' . Config::lang ( "LAST_PAGE" ) . '</a></li>';
		}
		if ($showselect == 1 && $urlObj->urlType == 1 && $lastpg < 200) {
			$pagenav .= Config::lang ( "JMUPTO" ) . "<select name='topage' style=\"  height: 30px;box-shadow: 0 1px 3px 0 rgba(0,0,0,0.06);position: relative;float: left;padding: 6px 12px;margin-left: -1px;line-height: 1.42857143;color: #428bca;text-decoration: none;background-color: #fff;border: 1px solid #ddd;\" size='1' onchange='window.location=\"$url=\"+this.value'>\n";
			for($i = 1; $i <= $lastpg; $i ++) {
				if ($i == $page) {
					$pagenav .= "<option value='$i' selected>$i</option>\n";
				} else {
					$pagenav .= "<option value='$i'>$i</option>\n";
				}
			}
			$pagenav .= "</select><li class='disabled'><a href='#'>" . Config::lang ( "PAGE" ) . "</a></li>";
		}
		return $pagenav;
	}

	public function show_error($msg = '', $sql = false) {
		$msgObj = new Msg ();
		$this->haveError = true;
		$err = '[' . mysql_errno () . ']' . mysql_error ();
		if ($sql) {
			$sql = Config::lang ( "SQL_STRING" ) . $this->sql;
		}
		$this->errorMsg = "Error Even:" . $msg . "\r\nError Result:" . $err . "\r\n" . ($sql ? $sql . "\r\n" : '') . "Client IP:" . NetUtil::getIp () . "\r\nRecord Date:" . date ( 'Y-m-d H:i:s' ) . "\r\n\r\n";
        $msgObj->addMsg ( 'error', $this->errorMsg );
	}

	public function getPrimary($table) {
		$result = $this->query ( "SHOW COLUMNS FROM $table" );
		while ( $r = $this->fetch_array ( $result ) ) {
			if ($r ['Key'] == 'PRI')
				break;
		}
		$this->free ( $result );
		return $r ['Field'];
	}

	public function haltShow($message = '', $sql = '') {
		$msgObj = new Msg ();
		$this->haveError = true;
		$msg = "<b>MySQL Query : </b> $sql <br /><b> MySQL Error : </b>" . $this->error () . " <br /> <b>MySQL Errno : </b>" . $this->errno () . " <br /><b> Message : </b> $message ";
        $msgObj->addMsg ( 'error', $msg );
	}

	public function error() {
		return @mysql_error ( $this->conn );
	}

	public function errno() {
		return intval ( @mysql_errno ( $this->conn ) );
	}
	
	//后台数据库备份用到的方法
	public function mysqlRead($sqlfile, $old_prefix = "", $new_prefix = "", $separator = ";\n") {
		$sqls = array ();
		$f = fopen ( $sqlfile, "rb" );
		$create = '';
		while ( ! feof ( $f ) ) {
			$line = fgets ( $f );
			if (trim ( $line ) == '' || preg_match ( '/--*?/', $line, $match )) {
				continue;
			}
			if (! preg_match ( '/;/', $line, $match ) || preg_match ( '/ENGINE=/', $line, $match )) {
				$create .= $line;
				if (preg_match ( '/ENGINE=/', $create, $match )) {
					$create = str_replace ( $old_prefix, $new_prefix, $create ); //替换前缀
					$sqls [] = $create;
					$create = '';
				}
				continue;
			}
			$line = str_replace ( $old_prefix, $new_prefix, $line ); //替换前缀
			$sqls [] = $line;
		}
		fclose ( $f );
		return $sqls;
	}

	//自动建立目录,主要是为了给错误日志和导出SQL文件提供支持
	public function makeDirs($dir, $mode = 0777) {
		if (is_dir ( $dir ) || @ mkdir ( $dir, $mode )) {
			return true;
		}
		if (! mkdir ( dirname ( $dir ), $mode )) {
			return false;
		}
		return @mkdir ( $dir, $mode );
	}

	public function fetchall() {
		$data = array ();
		while ( $record = mysql_fetch_assoc ( $this->result ) ) {
			$data [] = $record;
		}
		return $data;
	}
	public function version() {
		return mysql_get_server_info ( $this->conn );
	}

	/**
	 * 启动事务
	 * @access public
	 * @return void
	 */
	public function startTrans() {
		if (! $this->conn)
			return false;
		//数据rollback 支持
		if ($this->transTimes == 0) {
			mysql_query ( 'START TRANSACTION', $this->conn );
		}
		$this->transTimes ++;
		return;
	}

	/**
	 * 用于非自动提交状态下面的查询提交
	 * @access public
	 * @return boolen
	 */
	public function commit() {
		if ($this->transTimes > 0) {
			$result = mysql_query ( 'COMMIT', $this->conn );
			$this->transTimes = 0;
			if (! $result) {
				$this->error ();
				return false;
			}
		}
		return true;
	}

	/**
	 * 事务回滚
	 * @access public
	 * @return boolen
	 */
	public function rollback() {
		if ($this->transTimes > 0) {
			$result = mysql_query ( 'ROLLBACK', $this->conn );
			$this->transTimes = 0;
			if (! $result) {
				$this->error ();
				return false;
			}
		}
		return true;
	}
	// 释放结果集
	public function free($result = '') {
		if (empty ( $result )) {
			$result = $this->result;
		}
		if ($result) {
			@mysql_free_result ( $result );
		}
	}
	// 关闭数据库
	public function close() {
		mysql_close ( $this->conn );
	}
	// 析构函数，自动释放结果集、关闭数据库,垃圾回收机制
	public function __destruct() {
		$this->free ();
		$this->close ();
	}
}
