<?php
class StringUtil {
	/**
     * 获取 设置参数
     * @param $key
     * @param null $value
     * @param null $default
     * @todo 获取GET POST的值和设置值的方法
     * @return null
     */
    public static function get($key, $value = NULL, $default = NULL) {
        if ($value == NULL) {
            if (isset($_GET[$key])) {
                return $_GET[$key];
            } else if (isset($_POST[$key])) {
                return $_POST[$key];
            } else {
                return $default;
            }
        } else {
            $_GET[$key] = $value;
            $_POST[$key] = $value;
        }
    }
	/**
	 +----------------------------------------------------------
	 * 字符串截取，支持中文和其他编码
	 +----------------------------------------------------------
	 * @static
	 * @access public
	 +----------------------------------------------------------
	 * @param string $str 需要转换的字符串
	 * @param string $start 开始位置
	 * @param string $length 截取长度
	 * @param string $charset 编码格式
	 * @param string $suffix 截断显示字符
	 +----------------------------------------------------------
	 * @return string
	 +----------------------------------------------------------
	 */
	public static function msubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = true) {
		if (function_exists("mb_substr"))
		return mb_substr($str, $start, $length, $charset);
		elseif (function_exists('iconv_substr')) {
			return iconv_substr($str, $start, $length, $charset);
		}
		$re['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
		$re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
		$re['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
		$re['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
		preg_match_all($re[$charset], $str, $match);
		$slice = join("", array_slice($match[0], $start, $length));
		if ($suffix)
		return $slice . "…";
		return $slice;
	}
	// 去除空白字符[\r\n\t\s]
	public static function trim_str($str)	{
		return preg_replace('/[\r\n\t\s]+/','',$str);
	}
	/**
	 * Conver utf-8 to gb2312
	 */
	private static function convertUtf8ToGB2312($v) {
		return mb_convert_encoding($v, 'gb2312', 'utf-8');
	}
	/**
	 +----------------------------------------------------------
	 * 产生随机字串，可用来自动生成密码 默认长度6位 字母和数字混合
	 +----------------------------------------------------------
	 * @param string $len 长度
	 * @param string $type 字串类型
	 * 0 字母 1 数字 其它 混合
	 * @param string $addChars 额外字符
	 +----------------------------------------------------------
	 * @return string
	 +----------------------------------------------------------
	 */
	public static function rand_string($len = 6, $type = '', $addChars = '') {
		$str = '';
		switch ($type) {
			case 0 :
				$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' . $addChars;
				break;
			case 1 :
				$chars = str_repeat('0123456789', 3);
				break;
			case 2 :
				$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ' . $addChars;
				break;
			case 3 :
				$chars = 'abcdefghijklmnopqrstuvwxyz' . $addChars;
				break;
			case 4 :
				$chars = Config::lang("RANDSTRINGCN") . $addChars;
				break;
			default :
				// 默认去掉了容易混淆的字符oOLl和数字01，要添加请使用addChars参数
				$chars = 'ABCDEFGHIJKMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789' . $addChars;
				break;
		}
		if ($len > 10) { //位数过长重复字符串一定次数
			$chars = $type == 1 ? str_repeat($chars, $len) : str_repeat($chars, 5);
		}
		if ($type != 4) {
			$chars = str_shuffle($chars);
			$str = substr($chars, 0, $len);
		} else {
			// 中文随机字
			for ($i = 0; $i < $len; $i++) {
				$str .= msubstr($chars, floor(mt_rand(0, mb_strlen($chars, 'utf-8') - 1)), 1);
			}
		}
		return $str;
	}
	//文本输入
	public static function teamplate_in($str) {
		if (is_array($str)) {
			return $str;
		}
		$str = str_replace("&lt;", "<", $str);
		$str = str_replace("&gt;", ">", $str);
		return $str;
	}
	//文本输出
	public static function teamplate_out($str) {
		if (is_array($str)) {
			return $str;
		}
		$str = str_replace("<", "&lt;", $str);
		$str = str_replace(">", "&gt;", $str);
		$str = stripslashes($str);
		return $str;
	}
	//文本输入
	public static function text_in($str) {
		if (is_array($str)) {
			return $str;
		}
		//$str = strip_tags($str, '<br>');
		$str = str_replace(" ", "&nbsp;", $str);
		$str = str_replace("\n", "<br>", $str);
		if (!get_magic_quotes_gpc()) {
			$str = addslashes($str);
		}
		return $str;
	}
	//文本输出
	public static function text_out($str) {
		if (is_array($str)) {
			return $str;
		}
		$str = str_replace("&nbsp;", " ", $str);
		$str = str_replace("<br>", "\n", $str);
		$str = stripslashes($str);
		return $str;
	}

	//文本输出
	public static function js_out($str) {
		$str = str_replace("&lt;", "<", $str);
		$str = str_replace("&gt;", ">", $str);
		$str = str_replace("&nbsp;", " ", $str);
		$str = str_replace("&quot;", '"', $str);
		$str = str_replace("&#39;", "'", $str);
		$str = str_replace("&mdash;", "?", $str);
		return $str;
	}

	//html代码输入
	public static function html_in($str) {
		if (is_array($str)) {
			return $str;
		}
		$search = array(
            "'<script[^>]*.*?</script>'si", // 去掉 javascript
            "'<iframe[^>]*.*?</iframe>'si", // 去掉iframe
		);
		$replace = array(
            "",
            "",
		);
		$str = @ preg_replace($search, $replace, $str);
		$str = htmlspecialchars($str);
		if (!get_magic_quotes_gpc()) {
			$str = addslashes($str);
		}
		return $str;
	}
	//html代码输出
	public static function html_out($str) {
		if (is_array($str)) {
			return $str;
		}
		if (function_exists('htmlspecialchars_decode'))
		$str = htmlspecialchars_decode($str);
		else
		$str = html_entity_decode($str);
		$str = stripslashes($str);
		return $str;
	}
	// 检查字符串是否是UTF8编码,是返回true,否则返回false
	public static function is_utf8($string) {
		return preg_match('%^(?:
                                                             [\x09\x0A\x0D\x20-\x7E]            # ASCII
							   | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte
							   |  \xE0[\xA0-\xBF][\x80-\xBF]        # excluding overlongs
							   | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte
							   |  \xED[\x80-\x9F][\x80-\xBF]        # excluding surrogates
							   |  \xF0[\x90-\xBF][\x80-\xBF]{2}     # planes 1-3
							   | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15
							   |  \xF4[\x80-\x8F][\x80-\xBF]{2}     # plane 16
						   )*$%xs', $string);
	}
	/**
	 * 返回经addslashes处理过的字符串或数组
	 * @param $string 需要处理的字符串或数组
	 * @return mixed
	 */
	public static function new_addslashes($string) {
		if (!is_array($string))
		return addslashes($string);
		foreach ($string as $key => $val)
		$string[$key] = self::new_addslashes($val);
		return $string;
	}
	/**
	 * 返回经stripslashes处理过的字符串或数组
	 * @param $string 需要处理的字符串或数组
	 * @return mixed
	 */
	public static function new_stripslashes($string) {
		if (!is_array($string))
		return stripslashes($string);
		foreach ($string as $key => $val)
		$string[$key] = self::new_stripslashes($val);
		return $string;
	}
	/**
	 * 返回经htmlspecialchars处理过的字符串或数组
	 * @param $obj 需要处理的字符串或数组
	 * @return mixed
	 */
	public static function new_html_special_chars($string) {
		if (!is_array($string))
		return htmlspecialchars($string);
		foreach ($string as $key => $val)
		$string[$key] = self::new_html_special_chars($val);
		return $string;
	}
	/**
	 * 过滤ASCII码从0-28的控制字符
	 * @return String
	 */
	public static function trim_unsafe_control_chars($str) {
		$rule = '/[' . chr(1) . '-' . chr(8) . chr(11) . '-' . chr(12) . chr(14) . '-' . chr(31) . ']*/';
		return str_replace(chr(0), '', preg_replace($rule, '', $str));
	}
	/**
	 * 格式化文本域内容
	 *
	 * @param $string 文本域内容
	 * @return string
	 */
	public static function trim_textarea($string) {
		$string = nl2br(str_replace(' ', '&nbsp;', $string));
		return $string;
	}
	/**
	 * 将文本格式成适合js输出的字符串
	 * @param string $string 需要处理的字符串
	 * @param intval $isjs 是否执行字符串格式化，默认为执行
	 * @return string 处理后的字符串
	 */
	public static function format_js($string, $isjs = 1) {
		$string = addslashes(str_replace(array(
                    "\r",
                    "\n",
                    "\t"
                    ), array(
                    '',
                    '',
                    ''
                    ), $string));
                    return $isjs ? 'document.write("' . $string . '");' : $string;
	}
	/**
	 * 转义 javascript 代码标记
	 *
	 * @param $str
	 * @return mixed
	 */
	public static function trim_script($str) {
		if (is_array($str)) {
			foreach ($str as $key => $val) {
				$str[$key] = self::trim_script($val);
			}
		} else {
			$str = preg_replace('/\<([\/]?)script([^\>]*?)\>/si', '&lt;\\1script\\2&gt;', $str);
			$str = preg_replace('/\<([\/]?)iframe([^\>]*?)\>/si', '&lt;\\1iframe\\2&gt;', $str);
			$str = preg_replace('/\<([\/]?)frame([^\>]*?)\>/si', '&lt;\\1frame\\2&gt;', $str);
			$str = preg_replace('/]]\>/si', ']] >', $str);
		}
		return $str;
	}
	/**
	 * 字符截取 支持UTF8/GBK
	 * @param $string
	 * @param $length
	 * @param $dot
	 */
	public static function str_cut($string, $length, $dot = '...') {
		$strlen = strlen($string);
		if ($strlen <= $length)
		return $string;
		$string = str_replace(array(
            ' ',
            '&nbsp;',
            '&amp;',
            '&quot;',
            '&#039;',
            '&ldquo;',
            '&rdquo;',
            '&mdash;',
            '&lt;',
            '&gt;',
            '&middot;',
            '&hellip;'
            ), array(
            '∵',
            ' ',
            '&',
            '"',
            "'",
            '“',
            '”',
            '?',
            '<',
            '>',
            '?',
            '…'
            ), $string);
            $strcut = '';
            if (strtolower(CHARSET) == 'utf-8') {
            	$length = intval($length - strlen($dot) - $length / 3);
            	$n = $tn = $noc = 0;
            	while ($n < strlen($string)) {
            		$t = ord($string[$n]);
            		if ($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
            			$tn = 1;
            			$n++;
            			$noc++;
            		} elseif (194 <= $t && $t <= 223) {
            			$tn = 2;
            			$n += 2;
            			$noc += 2;
            		} elseif (224 <= $t && $t <= 239) {
            			$tn = 3;
            			$n += 3;
            			$noc += 2;
            		} elseif (240 <= $t && $t <= 247) {
            			$tn = 4;
            			$n += 4;
            			$noc += 2;
            		} elseif (248 <= $t && $t <= 251) {
            			$tn = 5;
            			$n += 5;
            			$noc += 2;
            		} elseif ($t == 252 || $t == 253) {
            			$tn = 6;
            			$n += 6;
            			$noc += 2;
            		} else {
            			$n++;
            		}
            		if ($noc >= $length) {
            			break;
            		}
            	}
            	if ($noc > $length) {
            		$n -= $tn;
            	}
            	$strcut = substr($string, 0, $n);
            	$strcut = str_replace(array(
                '∵',
                '&',
                '"',
                "'",
                '“',
                '”',
                '?',
                '<',
                '>',
                '?',
                '…'
                ), array(
                ' ',
                '&amp;',
                '&quot;',
                '&#039;',
                '&ldquo;',
                '&rdquo;',
                '&mdash;',
                '&lt;',
                '&gt;',
                '&middot;',
                '&hellip;'
                ), $strcut);
            } else {
            	$dotlen = strlen($dot);
            	$maxi = $length - $dotlen - 1;
            	$current_str = '';
            	$search_arr = array(
                '&',
                ' ',
                '"',
                "'",
                '“',
                '”',
                '?',
                '<',
                '>',
                '?',
                '…',
                '∵'
                );
                $replace_arr = array(
                '&amp;',
                '&nbsp;',
                '&quot;',
                '&#039;',
                '&ldquo;',
                '&rdquo;',
                '&mdash;',
                '&lt;',
                '&gt;',
                '&middot;',
                '&hellip;',
                ' '
                );
                $search_flip = array_flip($search_arr);
                for ($i = 0; $i < $maxi; $i++) {
                	$current_str = ord($string[$i]) > 127 ? $string[$i] . $string[++$i] : $string[$i];
                	if (in_array($current_str, $search_arr)) {
                		$key = $search_flip[$current_str];
                		$current_str = str_replace($search_arr[$key], $replace_arr[$key], $current_str);
                	}
                	$strcut .= $current_str;
                }
            }
            return $strcut . $dot;
	}
	/**
	 * 查询字符是否存在于某字符串
	 *
	 * @param $haystack 字符串
	 * @param $needle 要查找的字符
	 * @return bool
	 */
	public static function str_exists($haystack, $needle) {
		return!(strpos($haystack, $needle) === FALSE);
	}
	//信息提示框
	public static function msgbox($msg, $url, $delay, $type="success") {
		$webUrl = Config::getWebPath();
		if (empty($msg) || empty($url)) {
			echo Config::lang("MSGBOXNOTPARAMS");
			exit();
		}
		echo '
				<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
				<html xmlns="http://www.w3.org/1999/xhtml">
				<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
				<META http-equiv="refresh" content='.$delay.';URL='.$url.' />
				<link href="statics/css/msg.css" type="text/css" rel="stylesheet"/>
				<title>'.$msg.'-'.Config::get("webname").'</title>
				<style>
				a:link{color:#06c; text-decoration:none;}
				a:visited{color:#fff; text-decoration:none;}
				a:hover{color:#06c; text-decoration:underline;}
				a:active{blr:expression(this.onFocus=this.blur())}
				a:focus {outline:none;-moz-outline:none;}
				img{border:0;}
				body{margin:0; padding:0; font:12px/1.5 tahoma,arial,"\5b8b\4f53",sans-serif;}
				.window{width:450px; border: solid 1px #172b3e; border-radius: 10px; margin:60px auto 0;}
				.window .tips-title{height: 27px;line-height: 27px;background: #172b3e;padding: 0 12px;border-radius: 10px 10px 0 0;}
				.window .tips-title strong{font-size:14px; color:#FFF; padding-left:24px; height:27px; display:block; background:url(../images/window_icon.png) scroll 0 4px no-repeat;}
				.window .tips-box{padding:25px 20px 25px 65px; min-height:70px; height:70px; height:70px; font-size:14px;}
				.window .tips-box .tip-icon{width:48px; height:48px; float:left; margin-right:18px;}
				.window .tips-box .tip-cont{width:290px; float:left; padding-top:6px;}
				.window .bottom-tips{  height: 29px;line-height: 29px;background: #9AA2AD;color: #666;border-radius: 0 0 10px 10px;}
				.window .bottom-tips .login-t{text-align:center; display:block;}
				</style>
				</head>
				<body>
				<div class="window">
				  <div class="tips-title"><strong>'.Config::lang("SHOWMSG").'</strong></div>
				  <div class="tips-box">
				    <div class="tip-icon" style="background:url(statics/images/icons/'.$type.'.png) 0 0 no-repeat;">&nbsp;</div>
				    <div class="tip-cont">'.$msg.'</div>
				  </div>
				  <div class="bottom-tips"><span class="login-t"><a href="'.$url.'">'.Config::lang("DIRECTMSG").'</a></span></div>
				</div>
				</body>
				</html>';
	}
	//弹出javascript效果提示框
	public static function messages($C_alert, $I_goback = '', $close = 0) {
		$close = $close ? 'window.close();' : '';
		if (!empty($I_goback)) {
			if ($I_goback == 'back')
			$I_goback = 'javascript:history.back();';
			echo "<script>alert('$C_alert');location.href='$I_goback';$close</script>";
		} else {
			echo "<script>alert('$C_alert');$close</script>";
		}
		exit;
	}
	//输出信息后返回到上一个页面
	public static function jsback($str = "") {
		if ($str)
		echo "<script>alert(\"$str\");window.location =\"javascript:history.go(-1)\";</script>";
		else
		echo "<script>window.location =\"javascript:history.go(-1)\";</script>";
		exit;
	}
	public static function goback() {
		header("HTTP/1.1 301 Moved Permanently");
		header("Location:".HTTP_REFERER);
		die();
	}
	//输出信息后返回到链接页面
	public static function gourl($url, $str = "") {
		if ($str)
		echo "<script>alert(\"$str!\");window.location =\"$url\";</script>";
		else
		echo "<script>window.location =\"$url\";</script>";
		exit;
	}
	//跳转函数,例如
	public static function url_redirect($url, $delay = '') {
		if ($delay == '') {
			echo "<script>window.location.href='$url'</script>";
		} else {
			echo "<meta http-equiv='refresh' content='$delay;URL=$url' />";
		}
	}
	//进行过滤
	public static function inject_check($sql_str) {
		return eregi('select|insert|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile', $sql_str);
	}
	//javascript,框架，样式的过滤
	public static function htmlgl($str) {
		$str = preg_replace("@<script(.*?)</script>@is", "", $str);
		$str = preg_replace("@<iframe(.*?)</iframe>@is", "", $str);
		$str = preg_replace("@<style(.*?)</style>@is", "", $str);
		$str = preg_replace("@<(.*?)>@is", "", $str);
		return $str;
	}
	//敏感字符过滤
	public static function safegl($str) {
		$str = trim($str);
		$str = str_replace(",", "", $str);
		$str = str_replace("'", "", $str);
		$str = str_replace("%", "", $str);
		$str = str_replace("<", "", $str);
		$str = str_replace("?", "", $str);
		$str = str_replace(".", "", $str);
		$str = str_replace("/", "", $str);
		return $str;
	}
	//在预定义字符前加上反斜杠，包括 单引号、双引号、反斜杠、NULL，以保护数据库安全
	public static function d_addslashes($string, $force = 0) {
		if (!$GLOBALS['magic_quotes_gpc'] || $force) {
			if (is_array($string)) {
				foreach ($string as $key => $val)
				$string[$key] = self::d_addslashes($val, $force);
			} else
			$string = addslashes($string);
		}
		return $string;
	}
	//格式化数据（防止注入）
	public static function site_addslashes($string, $force = 0) {
		!defined('MAGIC_QUOTES_GPC') && define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc());
		if (!MAGIC_QUOTES_GPC || $force) {
			if (is_array($string)) {
				foreach ($string as $key => $val) {
					$string[$key] = daddslashes($val, $force);
				}
			} else {
				$string = addslashes($string);
			}
		}
		return $string;
	}
	// 防止XSS攻击,用在表单textarea中内容过滤较多
	public static function remove_xss($val) {
		$val = preg_replace('/([\x00-\x08,\x0b-\x0c,\x0e-\x19])/', '', $val);
		$search = 'abcdefghijklmnopqrstuvwxyz';
		$search .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$search .= '1234567890!@#$%^&*()';
		$search .= '~`";:?+/={}[]-_|\'\\';
		for ($i = 0; $i < strlen($search); $i++) {
			$val = preg_replace('/(&#[xX]0{0,8}' . dechex(ord($search[$i])) . ';?)/i', $search[$i], $val); // with a ;
			$val = preg_replace('/(&#0{0,8}' . ord($search[$i]) . ';?)/', $search[$i], $val); // with a ;
		}
		$ra1 = array(
            'javascript',
            'vbscript',
            'expression',
            'applet',
            'meta',
            'xml',
            'blink',
            'style',
            'script',
            'embed',
            'object',
            'iframe',
            'frame',
            'frameset',
            'ilayer',
            'layer',
            'bgsound',
            'title',
            'base'
            );
            $ra2 = array(
            'onabort',
            'onactivate',
            'onafterprint',
            'onafterupdate',
            'onbeforeactivate',
            'onbeforecopy',
            'onbeforecut',
            'onbeforedeactivate',
            'onbeforeeditfocus',
            'onbeforepaste',
            'onbeforeprint',
            'onbeforeunload',
            'onbeforeupdate',
            'onblur',
            'onbounce',
            'oncellchange',
            'onchange',
            'onclick',
            'oncontextmenu',
            'oncontrolselect',
            'oncopy',
            'oncut',
            'ondataavailable',
            'ondatasetchanged',
            'ondatasetcomplete',
            'ondblclick',
            'ondeactivate',
            'ondrag',
            'ondragend',
            'ondragenter',
            'ondragleave',
            'ondragover',
            'ondragstart',
            'ondrop',
            'onerror',
            'onerrorupdate',
            'onfilterchange',
            'onfinish',
            'onfocus',
            'onfocusin',
            'onfocusout',
            'onhelp',
            'onkeydown',
            'onkeypress',
            'onkeyup',
            'onlayoutcomplete',
            'onload',
            'onlosecapture',
            'onmousedown',
            'onmouseenter',
            'onmouseleave',
            'onmousemove',
            'onmouseout',
            'onmouseover',
            'onmouseup',
            'onmousewheel',
            'onmove',
            'onmoveend',
            'onmovestart',
            'onpaste',
            'onpropertychange',
            'onreadystatechange',
            'onreset',
            'onresize',
            'onresizeend',
            'onresizestart',
            'onrowenter',
            'onrowexit',
            'onrowsdelete',
            'onrowsinserted',
            'onscroll',
            'onselect',
            'onselectionchange',
            'onselectstart',
            'onstart',
            'onstop',
            'onsubmit',
            'onunload'
            );
            $ra = array_merge($ra1, $ra2);
            $found = true; // keep replacing as long as the previous round replaced something
            while ($found == true) {
            	$val_before = $val;
            	for ($i = 0; $i < sizeof($ra); $i++) {
            		$pattern = '/';
            		for ($j = 0; $j < strlen($ra[$i]); $j++) {
            			if ($j > 0) {
            				$pattern .= '(';
            				$pattern .= '(&#[xX]0{0,8}([9ab]);)';
            				$pattern .= '|';
            				$pattern .= '|(&#0{0,8}([9|10|13]);)';
            				$pattern .= ')*';
            			}
            			$pattern .= $ra[$i][$j];
            		}
            		$pattern .= '/i';
            		$replacement = substr($ra[$i], 0, 2) . '<x>' . substr($ra[$i], 2); // add in <> to nerf the tag
            		$val = preg_replace($pattern, $replacement, $val); // filter out the hex tags
            		if ($val_before == $val) {
            			// no replacements were made, so exit the loop
            			$found = false;
            		}
            	}
            }
            $string = self::safegl($val);
            return $string;
	}
	//输出安全的html
	public static function h($text, $tags = null) {
		$text = trim($text);
		//完全过滤注释
		$text = preg_replace('/<!--?.*-->/', '', $text);
		//完全过滤动态代码
		$text = preg_replace('/<\?|\?' . '>/', '', $text);
		//完全过滤js
		$text = preg_replace('/<script?.*\/script>/', '', $text);
		$text = str_replace('[', '&#091;', $text);
		$text = str_replace(']', '&#093;', $text);
		$text = str_replace('|', '&#124;', $text);
		//过滤换行符
		$text = preg_replace('/\r?\n/', '', $text);
		//br
		$text = preg_replace('/<br(\s\/)?' . '>/i', '[br]', $text);
		$text = preg_replace('/(\[br\]\s*){10,}/i', '[br]', $text);
		//过滤危险的属性，如：过滤on事件lang js
		while (preg_match('/(<[^><]+)( lang|on|action|background|codebase|dynsrc|lowsrc)[^><]+/i', $text, $mat)) {
			$text = str_replace($mat[0], $mat[1], $text);
		}
		while (preg_match('/(<[^><]+)(window\.|javascript:|js:|about:|file:|document\.|vbs:|cookie)([^><]*)/i', $text, $mat)) {
			$text = str_replace($mat[0], $mat[1] . $mat[3], $text);
		}
		if (empty($tags)) {
			$tags = 'table|td|th|tr|i|b|u|strong|img|p|br|div|strong|em|ul|ol|li|dl|dd|dt|a';
		}
		//允许的HTML标签
		$text = preg_replace('/<(' . $tags . ')( [^><\[\]]*)>/i', '[\1\2]', $text);
		//过滤多余html
		$text = preg_replace('/<\/?(html|head|meta|link|base|basefont|body|bgsound|title|style|script|form|iframe|frame|frameset|applet|id|ilayer|layer|name|script|style|xml)[^><]*>/i', '', $text);
		//过滤合法的html标签
		while (preg_match('/<([a-z]+)[^><\[\]]*>[^><]*<\/\1>/i', $text, $mat)) {
			$text = str_replace($mat[0], str_replace('>', ']', str_replace('<', '[', $mat[0])), $text);
		}
		//转换引号
		while (preg_match('/(\[[^\[\]]*=\s*)(\"|\')([^\2=\[\]]+)\2([^\[\]]*\])/i', $text, $mat)) {
			$text = str_replace($mat[0], $mat[1] . '|' . $mat[3] . '|' . $mat[4], $text);
		}
		//过滤错误的单个引号
		while (preg_match('/\[[^\[\]]*(\"|\')[^\[\]]*\]/i', $text, $mat)) {
			$text = str_replace($mat[0], str_replace($mat[1], '', $mat[0]), $text);
		}
		//转换其它所有不合法的 < >
		$text = str_replace('<', '&lt;', $text);
		$text = str_replace('>', '&gt;', $text);
		$text = str_replace('"', '&quot;', $text);
		//反转换
		$text = str_replace('[', '<', $text);
		$text = str_replace(']', '>', $text);
		$text = str_replace('|', '"', $text);
		//过滤多余空格
		$text = str_replace('  ', ' ', $text);
		return $text;
	}
	/**
	 * 递归方式的对变量中的特殊字符进行转义
	 *
	 * @access  public
	 * @param   mix     $value
	 *
	 * @return  mix
	 */
	public static function addslashes_deep($value){
		if (empty($value))    {
			return $value;
		}    else    {
			return is_array($value) ? array_map('addslashes_deep', $value) : addslashes($value);
		}
	}
	/**
	 * 将对象成员变量或者数组的特殊字符进行转义
	 *
	 * @access   public
	 * @param    mix        $obj      对象或者数组
	 * @author   Xuan Yan
	 *
	 * @return   mix                  对象或者数组
	 */
	public static function addslashes_deep_obj($obj){
		if (is_object($obj) == true)    {
			foreach ($obj AS $key => $val)        {
				$obj->$key = self::addslashes_deep($val);
			}
		}    else    {
			$obj = self::addslashes_deep($obj);
		}
		return $obj;
	}
	/**
	 * 递归方式的对变量中的特殊字符去除转义
	 *
	 * @access  public
	 * @param   mix     $value
	 *
	 * @return  mix
	 */
	public static function stripslashes_deep($value){
		if (empty($value))    {
			return $value;
		}   else    {
			return is_array($value) ? array_map('stripslashes_deep', $value) : stripslashes($value);
		}
	}
	/**
	 * 安全过滤函数
	 *
	 * @param $string
	 * @return string
	 */
	public static function safe_replace($string) {
		$string = str_replace("_", '\_', $string); // 把 '_'过滤掉
    	$string = str_replace("%", '\%', $string); // 把' % '过滤掉
		$string = str_replace('%20', '', $string);
		$string = str_replace('%27', '', $string);
		$string = str_replace('%2527', '', $string);
		$string = str_replace('*', '', $string);
		$string = str_replace('"', '&quot;', $string);
		$string = str_replace("'", '', $string);
		$string = str_replace('"', '', $string);
		$string = str_replace('&', '', $string);
		$string = str_replace(';', '', $string);
		$string = str_replace('<', '&lt;', $string);
		$string = str_replace('>', '&gt;', $string);
		$string = str_replace("{", '', $string);
		$string = str_replace('}', '', $string);
		$string = str_replace('\\', '', $string);
		$string = str_replace('or', '', $string);
		$string = str_replace('insert', '', $string);
		$string = str_replace('select', '', $string);
		$string = str_replace('delete', '', $string);
		$string = str_replace('and', '', $string);
		$string = str_replace('union', '', $string);
		$string = str_replace('load_file', '', $string);
		$string = str_replace('outfil', '', $string);
		$string = str_replace('truncate', '', $string);
		$string = str_replace('..', '', $string);
		$string = str_replace('//', '/', $string);
		$string = str_replace('http:/', 'http://', $string);
		return $string;
	}
	public static function killAllHtml($string) {
		$string = preg_replace('/&((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1', str_replace(array('&', '"', '<', '>'), array('&', '"', '<', '>'), $string));
		$string = htmlspecialchars_decode($string);
		$string = preg_replace("@<script(.*?)</script>@is", "", $string);
		$string = preg_replace("@<iframe(.*?)</iframe>@is", "", $string);
		$string = preg_replace("@<style(.*?)</style>@is", "", $string);
		$string = preg_replace("@<(.*?)>@is", "", $string);
		$string = preg_replace("/\s+/", " ", $string);
		$string = preg_replace("/<\!--.*?-->/si", "", $string);
		$string = str_replace("&nbsp;", "", $string);
		return $string;
	}
	public static function getStrByAry($ary,$dou) {
		$str = "";
		foreach ($ary as $v) {
			$str .= "'".$v."'".$dou;
		}
		return rtrim($str,$dou);
	}
	/**
	* 脏文字过滤
	*
	* @access public
	* @param  $str
	* @return string
	*/
	public static function fbword($str) {
		$fbword = explode(',', Config::get('fbword'));
		foreach($fbword as $val) {
			if (!$val) continue;
			$v = explode('=', $val);
			$v[1] or $v[1] = '***';
			if (strpos($str, $v[0]) !== false) {
				$str = str_replace($v[0], $v[1], $str);
			}
		}
		return $str;
	}

	public static function GetSQLValueString($theValue, $theType = 'text', $theDefinedValue = "", $theNotDefinedValue = "") {
	  if (PHP_VERSION < 6) {
	    $theValue = get_magic_quotes_gpc() ? stripslashes($theValue) : $theValue;
	  }
	  $theValue = function_exists("mysql_real_escape_string") ? mysql_real_escape_string($theValue) : mysql_escape_string($theValue);
	  switch ($theType) {
	    case "text":
	      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "";
	      break;
	    case "long":
	    case "int":
	      $theValue = ($theValue != "") ? intval($theValue) : "";
	      break;
	    case "double":
	      $theValue = ($theValue != "") ? doubleval($theValue) : "";
	      break;
	    case "date":
	      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "";
	      break;
	    case "defined":
	      $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
	      break;
	  }
	  //XSS
	  $theValue = self::remove_xss($theValue);
	  return $theValue;
	}
}
