<?php
class Validate {

    //验证是否为指定长度的字母/数字组合

    public static function fun_text1($num1, $num2, $str) {
        Return (preg_match("/^[a-zA-Z0-9]{" . $num1 . "," . $num2 . "}$/", $str)) ? true : false;
    }

    //验证是否为指定长度数字

    public static function fun_text2($num1, $num2, $str) {
        return (preg_match("/^[0-9]{" . $num1 . "," . $num2 . "}$/i", $str)) ? true : false;
    }

    //验证是否为指定长度汉字

    public static function fun_font($num1, $num2, $str) {
        // preg_match("/^[\xa0-\xff]{1,4}$/", $string);

        return (preg_match("/^([\x81-\xfe][\x40-\xfe]){" . $num1 . "," . $num2 . "}$/", $str)) ? true : false;
    }

    //验证身份证号码

    public static function fun_status($str) {
        return (preg_match('/(^([\d]{15}|[\d]{18}|[\d]{17}x)$)/', $str)) ? true : false;
    }

    //验证邮件地址

    public static function fun_email($str) {
        return (preg_match('/^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,4}$/', $str)) ? true : false;
    }

    //验证电话号码

    public static function fun_phone($str) {
        return (preg_match("/^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$/", $str)) ? true : false;
    }

    /**
     * 移动：134、135、136、137、138、139、150、151、152、157、158、159、182、183、184、187、188、178(4G)、147(上网卡)；
     * 联通：130、131、132、155、156、185、186、176(4G)、145(上网卡)；
     * 电信：133、153、180、181、189 、177(4G)；
     * 卫星通信：1349
     * 虚拟运营商：170
     * @author ZhiyuanLi < 956889120@qq.com >
     * @since 1.0
     * @param $mobile
     * @return bool
     */
    public static function isMobile($mobile) {
        if (!is_numeric($mobile)) {
            return false;
        }
        return preg_match('#^13[\d]{9}$|^14[5,7]{1}\d{8}$|^15[^4]{1}\d{8}$|^17[0,6,7,8]{1}\d{8}$|^18[\d]{9}$#', $mobile) ? true : false;
    }

    //验证邮编

    public static function fun_zip($str) {
        return (preg_match("/^[1-9]\d{5}$/", $str)) ? true : false;
    }

    //验证ip
    public static function fun_ip($str) {
        return (preg_match("/^(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])$/", $str)) ? true : false;
    }

    //验证url地址
    public static function fun_url($str) {
        return (preg_match("/^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/", $str)) ? true : false;
    }

    // 数据入库 转义 特殊字符 传入值可为字符串 或 一维数组

    public static function data_join(& $data) {
        if (get_magic_quotes_gpc() == false) {
            if (is_array($data)) {
                foreach ($data as $k => $v) {
                    $data[$k] = addslashes($v);
                }
            } else {
                $data = addslashes($data);
            }
        }
        Return $data;
    }

    // 数据出库 还原 特殊字符 传入值可为字符串 或 一/二维数组

    public static function data_revert(& $data) {
        if (is_array($data)) {
            foreach ($data as $k1 => $v1) {
                if (is_array($v1)) {
                    foreach ($v1 as $k2 => $v2) {
                        $data[$k1][$k2] = stripslashes($v2);
                    }
                } else {
                    $data[$k1] = stripslashes($v1);
                }
            }
        } else {
            $data = stripslashes($data);
        }
        Return $data;
    }

    // 数据显示 还原 数据格式 主要用于内容输出 传入值可为字符串 或 一/二维数组
    // 执行此方法前应先data_revert()，表单内容无须此还原

    public static function data_show(& $data) {
        if (is_array($data)) {
            foreach ($data as $k1 => $v1) {
                if (is_array($v1)) {
                    foreach ($v1 as $k2 => $v2) {
                        $data[$k1][$k2] = nl2br(htmlspecialchars($data[$k1][$k2]));
                        $data[$k1][$k2] = str_replace(" ", " ", $data[$k1][$k2]);
                        $data[$k1][$k2] = str_replace("\n", "<br>\n", $data[$k1][$k2]);
                    }
                } else {
                    $data[$k1] = nl2br(htmlspecialchars($data[$k1]));
                    $data[$k1] = str_replace(" ", " ", $data[$k1]);
                    $data[$k1] = str_replace("\n", "<br>\n", $data[$k1]);
                }
            }
        } else {
            $data = nl2br(htmlspecialchars($data));
            $data = str_replace(" ", " ", $data);
            $data = str_replace("\n", "<br>\n", $data);
        }
        Return $data;
    }

}
