<?php

class clientUtil {
	
	public static function is_mobile_request() {
		$_SERVER ['ALL_HTTP'] = isset ( $_SERVER ['ALL_HTTP'] ) ? $_SERVER ['ALL_HTTP'] : '';
		$mobile_browser = '0';
		if (preg_match ( '/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|iphone|ipad|ipod|android|xoom)/i', strtolower ( $_SERVER ['HTTP_USER_AGENT'] ) ))
			$mobile_browser ++;
		if ((isset ( $_SERVER ['HTTP_ACCEPT'] )) and (strpos ( strtolower ( $_SERVER ['HTTP_ACCEPT'] ), 'application/vnd.wap.xhtml+xml' ) !== false))
			$mobile_browser ++;
		if (isset ( $_SERVER ['HTTP_X_WAP_PROFILE'] ))
			$mobile_browser ++;
		if (isset ( $_SERVER ['HTTP_PROFILE'] ))
			$mobile_browser ++;
		$mobile_ua = strtolower ( substr ( $_SERVER ['HTTP_USER_AGENT'], 0, 4 ) );
		$mobile_agents = array ('w3c ', 'acs-', 'alav', 'alca', 'amoi', 'audi', 'avan', 'benq', 'bird', 'blac', 'blaz', 'brew', 'cell', 'cldc', 'cmd-', 'dang', 'doco', 'eric', 'hipt', 'inno', 'ipaq', 'java', 'jigs', 'kddi', 'keji', 'leno', 'lg-c', 'lg-d', 'lg-g', 'lge-', 'maui', 'maxo', 'midp', 'mits', 'mmef', 'mobi', 'mot-', 'moto', 'mwbp', 'nec-', 'newt', 'noki', 'oper', 'palm', 'pana', 'pant', 'phil', 'play', 'port', 'prox', 'qwap', 'sage', 'sams', 'sany', 'sch-', 'sec-', 'send', 'seri', 'sgh-', 'shar', 'sie-', 'siem', 'smal', 'smar', 'sony', 'sph-', 'symb', 't-mo', 'teli', 'tim-', 'tosh', 'tsm-', 'upg1', 'upsi', 'vk-v', 'voda', 'wap-', 'wapa', 'wapi', 'wapp', 'wapr', 'webc', 'winw', 'winw', 'xda', 'xda-' );
		if (in_array ( $mobile_ua, $mobile_agents ))
			$mobile_browser ++;
		if (strpos ( strtolower ( $_SERVER ['ALL_HTTP'] ), 'operamini' ) !== false)
			$mobile_browser ++;
			// Pre-final check to reset everything if the user is on Windows  
		if (strpos ( strtolower ( $_SERVER ['HTTP_USER_AGENT'] ), 'windows' ) !== false)
			$mobile_browser = 0;
			// But WP7 is also Windows, with a slightly different characteristic  
		if (strpos ( strtolower ( $_SERVER ['HTTP_USER_AGENT'] ), 'windows phone' ) !== false)
			$mobile_browser ++;
		if ($mobile_browser > 0)
			return true;
		else
			return false;
	}
	
	public static function getBrowse() {
		if (! empty ( $_SERVER ['HTTP_USER_AGENT'] )) {
			$br = $_SERVER ['HTTP_USER_AGENT'];
			if (preg_match ( '/MSIE/i', $br )) {
				$br = 'MSIE';
			} elseif (preg_match ( '/Firefox/i', $br )) {
				$br = 'Firefox';
			} elseif (preg_match ( '/Chrome/i', $br )) {
				$br = 'Chrome';
			} elseif (preg_match ( '/Safari/i', $br )) {
				$br = 'Safari';
			} elseif (preg_match ( '/Opera/i', $br )) {
				$br = 'Opera';
			} else {
				$br = 'Other';
			}
			return $br;
		} else {
			return "UnKnowBrowse";
		}
	}
	public static function getIP() {
		global $_SERVER;
		if (getenv ( 'HTTP_CLIENT_IP' )) {
			$ip = getenv ( 'HTTP_CLIENT_IP' );
		} else if (getenv ( 'HTTP_X_FORWARDED_FOR' )) {
			$ip = getenv ( 'HTTP_X_FORWARDED_FOR' );
		} else if (getenv ( 'REMOTE_ADDR' )) {
			$ip = getenv ( 'REMOTE_ADDR' );
		} else {
			$ip = $_SERVER ['REMOTE_ADDR'];
		}
		return $ip;
	}
	public static function getOS() {
		global $_SERVER;
		$agent = $_SERVER ['HTTP_USER_AGENT'];
		$os = false;
		if (eregi ( 'win', $agent ) && strpos ( $agent, '95' )) {
			$os = 'Windows 95';
		} else if (eregi ( 'win 9x', $agent ) && strpos ( $agent, '4.90' )) {
			$os = 'Windows ME';
		} else if (eregi ( 'win', $agent ) && ereg ( '98', $agent )) {
			$os = 'Windows 98';
		} else if (eregi ( 'win', $agent ) && eregi ( 'nt 5.1', $agent )) {
			$os = 'Windows XP';
		} else if (eregi ( 'win', $agent ) && eregi ( 'nt 5', $agent )) {
			$os = 'Windows Server';
		} else if (eregi ( 'win', $agent ) && eregi ( 'nt', $agent )) {
			$os = 'Windows NT';
		} else if (eregi ( 'win', $agent ) && ereg ( '32', $agent )) {
			$os = 'Windows 32';
		} else if (eregi ( 'linux', $agent )) {
			$os = 'Linux';
		} else if (eregi ( 'unix', $agent )) {
			$os = 'Unix';
		} else if (eregi ( 'sun', $agent ) && eregi ( 'os', $agent )) {
			$os = 'SunOS';
		} else if (eregi ( 'ibm', $agent ) && eregi ( 'os', $agent )) {
			$os = 'IBM OS/2';
		} else if (eregi ( 'Mac', $agent ) && eregi ( 'PC', $agent )) {
			$os = 'Macintosh';
		} else if (eregi ( 'PowerPC', $agent )) {
			$os = 'PowerPC';
		} else if (eregi ( 'AIX', $agent )) {
			$os = 'AIX';
		} else if (eregi ( 'HPUX', $agent )) {
			$os = 'HPUX';
		} else if (eregi ( 'NetBSD', $agent )) {
			$os = 'NetBSD';
		} else if (eregi ( 'BSD', $agent )) {
			$os = 'BSD';
		} else if (ereg ( 'OSF1', $agent )) {
			$os = 'OSF1';
		} else if (ereg ( 'IRIX', $agent )) {
			$os = 'IRIX';
		} else if (eregi ( 'FreeBSD', $agent )) {
			$os = 'FreeBSD';
		} else if (eregi ( 'teleport', $agent )) {
			$os = 'teleport';
		} else if (eregi ( 'flashget', $agent )) {
			$os = 'flashget';
		} else if (eregi ( 'webzip', $agent )) {
			$os = 'webzip';
		} else if (eregi ( 'offline', $agent )) {
			$os = 'offline';
		} else {
			$os = 'Unknown';
		}
		return $os;
	}
	public static function Getaddress($ip = '') {
		if (empty ( $ip )) {
			$ip = self::getIP ();
		}
		$ipadd = file_get_contents ( "http://int.dpool.sina.com.cn/iplookup/iplookup.php?ip=" . $ip ); //根据新浪api接口获取
		if ($ipadd) {
			$charset = iconv ( "gbk", "utf-8", $ipadd );
			preg_match_all ( "/[\x{4e00}-\x{9fa5}]+/u", $charset, $ipadds );
			return $ipadds; //返回一个二维数组
		} else {
			return "addree is none";
		}
	}
	
	public static function isMobile() {
		// 如果有HTTP_X_WAP_PROFILE则一定是移动设备
		if (isset ( $_SERVER ['HTTP_X_WAP_PROFILE'] )) {
			return true;
		}
		// 如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
		if (isset ( $_SERVER ['HTTP_VIA'] )) {
			// 找不到为flase,否则为true
			return stristr ( $_SERVER ['HTTP_VIA'], "wap" ) ? true : false;
		}
		// 脑残法，判断手机发送的客户端标志,兼容性有待提高
		if (isset ( $_SERVER ['HTTP_USER_AGENT'] )) {
			$clientkeywords = array ('nokia', 'sony', 'ericsson', 'mot', 'samsung', 'htc', 'sgh', 'lg', 'sharp', 'sie-', 'philips', 'panasonic', 'alcatel', 'lenovo', 'iphone', 'ipod', 'blackberry', 'meizu', 'android', 'netfront', 'symbian', 'ucweb', 'windowsce', 'palm', 'operamini', 'operamobi', 'openwave', 'nexusone', 'cldc', 'midp', 'wap', 'mobile' );
			// 从HTTP_USER_AGENT中查找手机浏览器的关键字
			if (preg_match ( "/(" . implode ( '|', $clientkeywords ) . ")/i", strtolower ( $_SERVER ['HTTP_USER_AGENT'] ) )) {
				return true;
			}
		}
		// 协议法，因为有可能不准确，放到最后判断
		if (isset ( $_SERVER ['HTTP_ACCEPT'] )) {
			// 如果只支持wml并且不支持html那一定是移动设备
			// 如果支持wml和html但是wml在html之前则是移动设备
			if ((strpos ( $_SERVER ['HTTP_ACCEPT'], 'vnd.wap.wml' ) !== false) && (strpos ( $_SERVER ['HTTP_ACCEPT'], 'text/html' ) === false || (strpos ( $_SERVER ['HTTP_ACCEPT'], 'vnd.wap.wml' ) < strpos ( $_SERVER ['HTTP_ACCEPT'], 'text/html' )))) {
				return true;
			}
		}
		return false;
	}
	
	public static function getLang() {
		$lang = substr ( $_SERVER ['HTTP_ACCEPT_LANGUAGE'], 0, 4 ); //只取前4位，这样只判断最优先的语言。如果取前5位，可能出现en,zh的情况，影响判断。
		if (preg_match ( "/zh-c/i", $lang ))
			return "zh-c"; //简体
		else if (preg_match ( "/zh/i", $lang ))
			return "zh"; //繁体
		else if (preg_match ( "/en/i", $lang ))
			return "en"; //英文
		else if (preg_match ( "/fr/i", $lang ))
			return "fr";
		else if (preg_match ( "/de/i", $lang ))
			return "de";
		else if (preg_match ( "/jp/i", $lang ))
			return "jp";
		else if (preg_match ( "/ko/i", $lang ))
			return "ko";
		else if (preg_match ( "/es/i", $lang ))
			return "Spanish";
		else if (preg_match ( "/sv/i", $lang ))
			return "Swedish";
		else
			return "zh-c";
	}
}