<?php
/**
 *
 * create by hly on 2016/02/19
 * @author hly
 */
class ApiUtils {
	
	static $FAILED = 'FAILED';
	static $SUCCESS = 'SUCCESS';
	
	//第一个是原串,第二个是 部份串
	public function startWith($str, $needle) {
		return strpos ( $str, $needle ) === 0;
	
	}
	
	//第一个是原串,第二个是 部份串
	public function endWith($haystack, $needle) {
		
		$length = strlen ( $needle );
		if ($length == 0) {
			return true;
		}
		return (substr ( $haystack, - $length ) === $needle);
	}
	
	/**
	 * 判断是否以http://开头
	 * @param unknown_type $valueStr
	 */
	public static function isHttpStart($valueStr) {
		return substr ( $valueStr, 0, 5 ) == "http:";
	}
	
	/**
	 * 获取正确的图片路径地址
	 * @param unknown_type $valueStr
	 */
	public static function getUrlImg($imgurl) {
		if ($imgurl == '')
			return $imgurl;
		if (self::isHttpStart ( $imgurl ))
			return $imgurl;
		if (! self::isHttpStart ( Config::get ( 'url' ) ))
			$result = "http://" . Config::get ( 'url' ) . '/' . $imgurl;
		else
			$result = Config::get ( 'url' ) . '/' . $imgurl;
		return $result;
	}
	
	/**
	 * post请求验证
	 * @author hly
	 * @param unknown_type $action
	 */
	public static function postRequestAuth($action) {
		$result = $_REQUEST [$action];
		if (empty ( $result )) {
			return self::apiCallback ( self::$FAILED, array (), '请用POST请求!' );
		}
		return $result;
	}
	/**
	 * get 请求验证
	 * @author hly
	 * @param $action
	 */
	public static function getRequestAuth($action) {
		$result = $_GET [$action];
		if (empty ( $result )) {
			return self::apiCallback ( self::$FAILED, array (), '请用GET请求!' );
		}
		return $result;
	}
	/**
	 * @author hly
	 * @param unknown_type $code
	 * @param unknown_type $data
	 * @param unknown_type $msg
	 */
	public static function apiCallback($code, $data = array(), $msg) {
		if (empty ( $msg ))
			$msg = '';
		echo json_encode ( array ("code" => $code, "data" => $data, "msg" => $msg ) );
		exit ();
	}
}

?>