<?php

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class Config {
	
	public function __construct() {
	
	}
	
	public static function get($key) {
		global $webConfig;
		return $webConfig [$key];
	}
	
	public static function lang($key) {
		global $L;
		$langStr = $L [func_get_arg ( 0 )];
		$numargs = func_num_args ();
		if ($numargs >= 2) {
			//echoln("Second argument is: " . func_get_arg(1));
			$arg_list = func_get_args ();
			for($i = 0; $i < $numargs; $i ++) {
				//echoln("Argument $i is: " . $arg_list[$i]);
				if ($i > 0) {
					$langStr = str_replace ( '{' . $i . '}', $arg_list [$i], $langStr );
				}
			}
		}
		return $langStr;
	}
	
	public static function getWebPath() {
		$webpath = Config::get ( "webpath" );
		if (strlen ( $webpath ) == 1) {
			$webpath = "";
		}
		$webUrl = self::get ( "website" );
		return $webUrl;
	}
	
	/**
	 * 获取正确的图片路径地址
	 *
	 * @param unknown_type $valueStr
	 */
	public static function getUrlImg($imgurl, $directoryName) {
		// 可能出现的类型 http、www 1301/08/jdlasjasdj.jpg 空
		// 如果为空
		if (empty ( $imgurl )) {
			return 'http://' . self::getWebUrl () . '/' . $directoryName . '/UserFace/nophoto.gif';
		}
		// 如果已经是http开头的
		if (self::isHttpStart ( $imgurl ))
			return $imgurl;
			// 如果已经是www开头的
		if (self::isWwwStart ( $imgurl ))
			return $imgurl;
			// 如果服务器是http开头的
		$imgurl = (substr ( $imgurl, 0, 1 ) == '/') ? $imgurl : '/' . $imgurl;
		if (self::isHttpStart ( self::getWebUrl () )) {
			$result = empty ( $directoryName ) ? self::getWebUrl () . $imgurl : self::getWebUrl () . '/' . $directoryName . $imgurl;
		} else { // 如果没有
			$result = empty ( $directoryName ) ? 'http://' . self::getWebUrl () . $imgurl : 'http://' . self::getWebUrl () . '/' . $directoryName . $imgurl;
		}
		return $result;
	}
	
	/**
	 * 判断是否以http://开头
	 *
	 * @param unknown_type $valueStr
	 */
	public static function isHttpStart($valueStr) {
		return substr ( $valueStr, 0, 5 ) == 'http:';
	}
	
	public static function isWwwStart($valueStr) {
		return substr ( $valueStr, 0, 4 ) == 'www.';
	}
	
	/**
	 * 获取服务器ip
	 *
	 * @param unknown_type $value
	 */
	public static function getWebUrl() {
		return Config::getWebPath ();
	}

}
