<?php

class MemcacheModel {
	
	private $mc = null;
	
	/**
	 * 构造方法,用于添加服务器并创建memcahced对象
	 */
	function __construct($servers = array()) {
		
		if (class_exists ( 'Memcache' )) {
			$mc = new Memcache ();
		} else {
			return false;
		}
		
		if (count ( $servers ) > 1) {
			//如果有多个memcache服务器
			foreach ( $servers as $v ) {
				call_user_func_array ( array ($mc, 'addServer' ), $v );
			}
		
		} else {
			//如果只有一个memcache服务器
			call_user_func_array ( array ($mc, 'addServer' ), $servers [0] );
		}
		$this->mc = $mc;
	}
	
	/**
	 * 获取memcached对象
	 * @return object memcached对象
	 */
	function getMem() {
		return $this->mc;
	}
	
	/**
	 * 检查mem是否连接成功
	 * @return	bool	连接成功返回true,否则返回false
	 */
	function mem_connect_error() {
		$stats = $this->mc->getStats ();
		if (empty ( $stats )) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * 向memcache中添加数据
	 * @param	string	$key		memcache的key
	 * @param	mixed	$val		需要缓存的数据
	 */
	function addCache($key, $val, $cache_time = 7200, $isCommon = true) {
		$key = $isCommon ? md5 ( $key ) : md5 ( $key . SSID );
		
		$cache_time = $cache_time ? $cache_time : 7200;
		$this->mc->set ( $key, $val, MEMCACHE_COMPRESSED, $cache_time );
	}
	
	/**
	 * 获取memcahce中保存的数据
	 * @param	string	$sql	使用SQL的key
	 * @return 	mixed		返回缓存中的数据
	 */
	function getCache($key, $isCommon = true) {
		$key = $isCommon ? md5 ( $key ) : md5 ( $key . SSID );
		return $this->mc->get ( $key );
	}
	
	/**
	 * 删除单独一个语句的缓存
	 * @param	string	$sql 执行的SQL语句
	 */
	function del($key, $isCommon = true) {
		$key = $isCommon ? md5 ( $key ) : md5 ( $key . SSID );
		$this->mc->delete ( $key, 0 ); //0 表示立刻删除
	}
	
	/**
	 * 刷新缓存
	 */
	function flush() {
		$this->mc->flush ();
	}

}