<?php

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class Url {
	
	public $urlType = 1;
	private $website;
	
	public function __construct() {
		$webUrl = Config::getWebPath ();
		$this->urlType = Config::get ( "urlType" );
		$this->website = $webUrl;
	}
	
	public function getList($id="", $page="") {
		$currentPage = $_GET['page'];
		$url = $_SERVER["REQUEST_URI"];
		$pageStr = empty($page) ? "" : '&page=' . $page;
		$url_query = preg_replace("/(^|&)page=$currentPage/", "", $url);
		return $url_query.$pageStr;
	}
	
	public function getStyleUrl($id, $mid, $dir) {
		$b = "";
		$f = "";
		$_Obj = get($dir,$id);
		if ($_Obj->fonttype) {
			$b .= "<b>";
		}
		if (strlen ( $_Obj->color ) > 2) {
			$b .= "<font color = " . $_Obj->color . ">";
		}
		if (strlen ( $_Obj->color ) > 2) {
			$f .= "</font>";
		}
		if ($_Obj->fonttype) {
			$f .= "</b>";
		}
		$title = $b . $_Obj->title . $f;
		if ($this->urlType == 1) { //动态
			$url = '<a href="' . $this->website . '/index.php?a=show&c=content&id=' . $_Obj->id . '&mid=' . $mid . '" target=_blank>' . $title . '</a>';
		} else { //静态或伪静态
			$url = '<a href="' . $this->website . '/' . $dir . '/' . $_Obj->id . '.html" target=_blank>' . $title . '</a>';
		}
		return $url;
	}
	
	public function getHrefUrl($id, $mid, $dir) {
		if ($this->urlType == 1) { //动态
			$url = $this->website . '/index.php?c=content&a=show&id=' . $id . '&mid='.$mid;
		} else { //静态或伪静态
			$url = $this->website . '/' . $dir . '/' . $id . ".html";
		}
		return $url;
	}
	
	public function getListUrl($classid, $page = 0, $mid, $dir) {
		if (defined ( "IN_ADMIN" )) {
			return $this->getList ( $page );
		}
		if ($this->urlType == 1) {
			$pageStr = empty ( $page ) ? "" : '&page=' . $page;
			$url = $this->website . '/index.php?c=content&a=index&mid='.$mid.'&classid=' . $classid . $pageStr;
		} else {
			$url = $this->website . '/' . $dir . '/list-' . $classid . '-' . $page . '.html';
		}
		return $url;
	}
	
	public function getSpecialUrl() {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?a=index&c=special';
		} else {
			$url = $this->website . '/special/index.html';
		}
		return $url;
	}

	public function getSpecialHref($id) {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?a=index&c=special&id=' . $id;
		} else {
			$url = $this->website . '/special/'.$id.'.html';
		}
		return $url;
	}
	
	//用户中心
	public function getUserhomeHref() {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?ac=user_home';
		} else if ($this->urlType == 2) {
			$url = $this->website . '/index.php?ac=user_home';
		} else {
			$url = $this->website . '/home.html';
		}
		return $url;
	}
	
	//退出
	public function getLoginoutHref() {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?ac=user_loginout';
		} else if ($this->urlType == 2) {
			$url = $this->website . '/index.php?ac=user_loginout';
		} else {
			$url = $this->website . '/loginout.html';
		}
		return $url;
	}
	
	//登陆
	public function getLoginHref() {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?ac=user_login';
		} else if ($this->urlType == 2) {
			$url = $this->website . '/index.php?ac=user_login';
		} else {
			$url = $this->website . '/login.html';
		}
		return $url;
	}
	
	//注册
	public function getRegHref() {
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?ac=user_reg';
		} else if ($this->urlType == 2) {
			$url = $this->website . '/index.php?ac=user_reg';
		} else {
			$url = $this->website . '/reg.html';
		}
		return $url;
	}
	
	public function getAboutHref($id) {
		$_Obj = get ( "bulletin", $id );
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?a=about&c=index&id=' . $id;
		} else {
			$url = $this->website . '/about/' . $id . ".html";
		}
		return $url;
	}
	
	public function getBulletinHref($id) {
		$_Obj = get ( "bulletin", $id );
		if ($this->urlType == 1) {
			$url = $this->website . '/index.php?a=bulletin&c=index&id=' . $id;
		} else {
			$url = $this->website . '/bulletin/' . $id . ".html";
		}
		return $url;
	}
	
	public function getSearchList($id = "", $page = "", $isAdmin = "") {
		$pageStr = empty ( $page ) ? "" : '&page=' . $page;
		return $this->website . '/index.php?ac=index_search' . $pageStr;
	}
}
