<?php
defined('IN_ADMIN') or exit('Access Denied');
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class admin extends controller {

    /* 后台默认首页转向 */
    public function defaultAction() {
    	$__RememberLogin = Cookies::get('__RememberLogin');
        if (!empty($__RememberLogin)) {
        	$userObj = get("user",intval($_SESSION['userId']));
            $this->setValue("username",$userObj->username);
        }
        $pos = strrpos($_SERVER["REQUEST_URI"], "//");
        if ($pos !== false) {// 注意: 三个等号
        	header("Location:".Config::get("website")."/".Config::get('admin'));
        	exit;
        }
		$this->setValue("background",rand(1,8));
        $this->forward("admin/login.html");
    }

    /* 后台管理员登陆 */
    public function login() {
        $userObj = M('user');
		$this->setValue("background",rand(1,8));
        if (empty($_POST['username']) || empty($_POST['password']) || empty($_POST['code'])) {
            $this->setValue("error", Config::lang("LOGINMSGNOTBEEMPTY"));
            $this->forward("admin/login.html");
            exit;
        }
        //防注入
        $username = trim($_POST['username']);
        $username = StringUtil::safe_replace($username);
		$username = StringUtil::remove_xss($username);
        $password = $_POST['password'];
        $isLogin = $userObj->checkUserLogin($username, $password, 1);
        $codeStr = $_SESSION["sebigdatacom"];
        unset($_SESSION["sebigdatacom"]);
        if (strcmp($codeStr, trim(strtolower($_POST['code'])))) {
            $this->setValue("error", Config::lang("CHECKCODEWRONG"));
            $this->forward("admin/login.html");
            exit;
        }
        $this->checkErrorLogin ( $userObj, $username, $password );
        if (!$isLogin) {
            Log::Login($username,Config::lang("USERNAMEORPASSWORDWRONG"));
            $this->setValue("error", Config::lang("USERNAMEORPASSWORDWRONG"));
            $this->forward("admin/login.html");
            exit;
        } else {
            if (!empty($_POST["isRememberUsername"])) {
                Cookies::set('__RememberLogin',Config::get("cookdomain"),86400);
            }
            $_SESSION['user'] = $isLogin;
            Authen::setUserLogin($_SESSION['user']['id'], $_SESSION['user']['password']);
            $userObj->id = $_SESSION['user']['id'];
            $userObj->lastvist = time();
            $userObj->lastip = NetUtil::getIp();
            $userObj->logintime = $isLogin['logintime'] + 1;
            $userObj->update();
            $this->tpl->clear_all_cache();
            $onlineObj = M("online");
            $onlineObj->id = $_SESSION['user']['id'];
            $onlineObj->intime = time();
            $onlineObj->islogin = 1;
            $onlineObj->saveOrUpdate();
            //
            Log::Login($username,Config::lang("LOGINSUCCESSSECRECY"));
            StringUtil::msgbox(Config::lang("LOGINSUCCESS"), Config::get('admin').'?ac=admin_home', 1);
        }
    }

	private function checkErrorLogin($userObj, $username, $password) {
		$password = md5 ( trim ( $password ) );
		$open = Config::get ( "logincheck" );
		if (! empty ( $open )) {
			$row = $userObj->query ( "SELECT id,password,errortime,errorcount FROM tc_user WHERE username='" . $username . "'" );
			if ($row) {
				//是否被锁定
				if ($row [0] ['password'] !=  $password && $row [0] ['errorcount'] == Config::get ( "errorcount" )){
					$lastTimes = (time () - $row [0] ['errortime']) < 60 * Config::get ( "errortime" );
					if ($row [0] ['errorcount'] >= Config::get ( "errorcount" ) && $lastTimes) {
						StringUtil::gourl(Config::get("admin"),Config::lang ( "LOCKLOGINPRESSING"));
						exit ();
					}
				}
				//密码错了
				if ($row [0] ['password'] != $password && $row [0] ['errorcount'] < Config::get ( "errorcount" )) {
					$times = Config::get ( "errorcount" ) - $row [0] ['errorcount'];
					$updateStr = "update tc_user set errorcount = errorcount + 1,errortime= " . time () . " WHERE username='" . $username . "'";
					$userObj->query ( $updateStr );
					StringUtil::gourl(Config::get("admin"),Config::lang ( "WILLLOCKLOGININTIMES", $times ));
					exit ();
				}
				//密码对了
				if ($row [0] ['password'] == $password) {
					$updateStr = "update tc_user set errorcount = 0,errortime= " . time () . " WHERE username='" . $username . "'";
					$userObj->query ( $updateStr );
				}
			}
		}
	}

    /* 后台管理员退出 */
    public function loginout() {
        session_destroy();
        session_unset();
        session_write_close();
        $this->tpl->clear_all_cache();
        $onlineObj = M("online");
        $onlineObj->id = $_SESSION['userId'];
        $onlineObj->outtime = time();
        $onlineObj->islogin = 0;
        $onlineObj->saveOrUpdate();
        Cookies::set('userId',Config::get("cookdomain"),0);
        Cookies::set('AuthenId',Config::get("cookdomain"),0);
        Cookies::set('__RememberLogin',Config::get("cookdomain"),0);
        Log::Login($_SESSION['user']['username'],Config::lang("LOGINOUT"));
        StringUtil::msgbox(Config::lang("LOGINOUTSUCCESS"), Config::get('admin'), 1);
    }

	/* 后台管理主页 */
    public function home() {
		if (!Authen::isAdmin()) {StringUtil::msgbox(Config::lang("NOTRIGHT"), Config::get('admin'), 1);Authen::setUserLoginOut();exit;}
		$userObj = M("user");
		$messageObj = M("message");
		$agentCheckAry = $userObj->query("select * from tc_agent_check order by addtime desc limit 7");
		$codeCheckAry = $messageObj->query("select * from tc_code_check order by addtime desc limit 7");
		$this->setValue("agentCheckAry",$agentCheckAry);
		$this->setValue("codeCheckAry",$codeCheckAry);
		//产品
		$this->setValue("product_num", M('product')->count());
		$this->setValue("product_Time", M('product')->max('addtime'));
		//下载
		$this->setValue("agent_check_Num", M('agent_check')->count());
		$this->setValue("agent_check_Time", M('agent_check')->max('addtime'));
		//视频
		$this->setValue("code_check_Num", M('code_check')->count());
		$this->setValue("code_check_Time", M('code_check')->max('addtime'));
		//文章
		$this->setValue("agentNum", M('agent')->count());
		$this->setValue("agentTime", M('agent')->max('addtime'));
		//用户
		$this->setValue("user_Num", M('user')->count());
		$this->setValue("user_Time", M('user')->max('regdate'));
		//留言
		$this->setValue("codeNum", M('code')->count());
		$this->setValue("codeTime", M('code')->max('addtime'));
		//版本号
		$this->setValue("phpversion",phpversion());
        $this->forward("admin/index.html");
    }
}
