<?php
defined ( 'IN_ADMIN' ) or exit ( 'Access Denied' );
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class group extends controller {
	public $objName = 'group';
	
	public function listAll() {
		$_Obj = M ( $this->objName );
		$_Obj->pageSize = 15;
		$_Obj->orderby ( 'id desc' );
		$_objAry = $_Obj->getList ();
		$this->setValue ( "Obj", $_Obj );
		$this->setValue ( "objAry", $_objAry );
		$this->setValue ( "action", "list" );
		$this->forward ( "admin/" . $this->objName . "-list.html" );
	}
	
	public function add() {
		$_Obj = M ( $this->objName );
		$_Obj = $_Obj->copyData ();
		$categoryObj = M ( "category" );
		$pidSelectStr = $categoryObj->getTree ( $categoryObj, 0, true );
		$this->setValue ( "pidSelectStr", $pidSelectStr );
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "-add.html" );
	}
	
	public function edite() {
		$categoryObj = M ( "category" );
		$_Obj = M ( $this->objName );
		$_Obj = $_Obj->load ( intval ( $_GET ['id'] ) );
		$pidSelectStr = $categoryObj->getTree ( $categoryObj, 0, true );
		$this->setValue ( "pidSelectStr", $pidSelectStr );
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "-add.html" );
	}
	
	public function saveOrUpdate() {
		$categoryObj = M ( "category" );
		$_Obj = M ( $this->objName );
		$msgObj = new Msg ();
		$_Obj->create ();
		$_Obj->post = implode ( ",", $_POST ["pid"] );
		$_Obj->haveDoubleRow ( $msgObj, "name", Config::lang ( "NAMECANNOTDOUBLE" ) );
		if ($_Obj->name == "") {
			$msgObj->addMsg ( 'error', Config::lang ( "GROUPNAMECANBEEMPTY" ) );
		}
		if (! $msgObj->hasMsg) {
			$errorMsg = $_Obj->id > 0 ? Config::lang ( "UPDATESUCCESS" ) : Config::lang ( "SAVESUCCESS" );
			$msgObj->addMsg ( 'success', $errorMsg );
		} else {
			$errorMsg = $_Obj->id > 0 ? '更新失败' : '添加失败';
			$msgObj->addMsg ( 'error', $errorMsg );
		}
		//保存
		$_Obj->saveOrUpdate ();
		
		$pidSelectStr = $categoryObj->getTree ( $categoryObj, 0, true );
		$this->setValue ( "pidSelectStr", $pidSelectStr );
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "-add.html" );
	}
	
	public function delete() {
		$_Obj = M ( $this->objName );
		$msgObj = new Msg ();
		$id = $_GET ['id'];
		$idAry = $_POST ['id'];
		$idStr = count ( $idAry ) == 0 ? intval ( $id ) : implode ( ",", $idAry );
		$newIdAry = explode ( ",", $idStr );
		$idSize = count ( $newIdAry );
		if (empty ( $newIdAry [0] ) && empty ( $id )) {
			$msgObj->addMsg ( 'error', Config::lang ( "PLEASECHOOSEDELETEDATA" ) );
		}
		for($i = 0; $i < $idSize; $i ++) {
			if (! self::isSystem ( $newIdAry [$i] )) {
				$_Obj->deleteById ( $newIdAry [$i] );
			} else {
				$msgObj->addMsg ( 'error', Config::lang ( "SYSTEMGROUPCANBEDEL" ) );
			}
		}
		if (! $msgObj->hasMsg) {
			$_Obj->delete ();
		}
		$this->listAll ();
	}
	
	private function isSystem($groupId) {
		$groupObj = get ( "group", $groupId );
		return $groupObj->issystem;
	}
	
	public function savePermit() {
		$groupObj = M ( "group" );
		if (Authen::checkUserLogin () && Authen::isAdmin ()) {
			$grade = empty ( $_POST ["grade"] ) ? 0 : $_POST ["grade"];
			$module = empty ( $_POST ["module"] ) ? "admin" : $_POST ["module"];
			$Groupe = $_REQUEST['magicBoxes'];
            $powerAry = explode(',', $Groupe );
			$query = "delete from " . TABLEPRE . "permit where groupid=" . $grade . " AND powerid IN (SELECT id FROM " . TABLEPRE . "power WHERE module='" . $module . "')";
			$groupObj->query ( $query );
			$sqlStr = '';
			foreach ( $powerAry as $v ) {
				$sqlStr .= "('" . $v . "','" . $grade . "'),";
			}
			$sqlStr = rtrim ( $sqlStr, "," );
			$sqlStr = "INSERT INTO " . TABLEPRE . "permit (powerid,groupid) values " . $sqlStr;
			$groupObj->query ( $sqlStr );
			$power = ROOT_PATH . "/data/power/*.php";
			array_map ( "unlink", glob ( $power ) );
			StringUtil::msgbox ( Config::lang ( "POWERSETTINGSUCCESS" ), Config::get ( 'admin' ) . "?ac=group_setPower&grade=" . $grade . "&module=" . $module, 1 );
		} else {
			StringUtil::msgbox ( Config::lang ( "POWERSETTINGFAIL" ), Config::get ( 'admin' ) . "?ac=group_setPower&grade=" . $grade . "&module=" . $module, 1 );
		}
		exit ();
	}
	
	public function setPower() {
		$powerObj = M ( "power" );
		$ary = array ();
		$module = empty ( $_GET ['module'] ) ? "controller" : $_GET ['module'];
		$tableAry = ArrayUtil::getTables ( $module );
		$this->setValue ( "tableAry", $tableAry );
		foreach ( $tableAry as $v ) {
			$ary [$v] = $powerObj->query ( "SELECT id,memo FROM " . TABLEPRE . "power WHERE MODULE = '" . $module . "' AND ACTION = '" . $v . "' order by rank asc" );
		}
		$modules = ArrayUtil::getModules ();
		$this->setValue ( "modules", $modules );
		$this->setValue ( "objAry", $ary );
		$this->setValue ( "powerObj", $powerObj );
		$this->setValue ( "action", "powers" );
		$this->forward ( "admin/group-setPower.html" );
	}
	/*
    说明:显示菜单列表
    作者:jiangxiaowu
    时间:2016-11-1
    */
	public function setCat() {
		$_Obj = M ( "category" );
		$_Obj->pageSize = 1000;
		$categoryAry = $_Obj->getCategoryListNoCURD ( $_Obj );
		
		$menuObj = M ( "menu_rel" );
		$menuObj->pageSize = 1000;
		
		$this->setValue ( "gid", $_GET ['gid'] );
		$this->setValue ( "Obj", $_Obj );
		$this->setValue ( "categoryAry", $categoryAry );
		$this->forward ( "admin/category-setMenu.html" );
	}
	
	/*
    说明:保存指定用户组的设定的菜单列表
    作者:jiangxiaowu
    时间:2016-11-1
    */
	public function saveCat() {
		$menurelObj = M ( "menu_rel" );
		$msgObj = new Msg ();
		$cids = $_POST ['id'];
		$gid = $_POST ['groupid'];
		if (empty ( $cids )) {
			$msgObj->addMsg ( 'error', Config::lang ( "PLEASECHOOSEDELETEDATA" ) );
		}
		if (! $msgObj->hasMsg) {
			//先删除所有该用户组在表中的菜单记录
			$menurelObj->query ( "delete from tc_menu_rel where gid = " . $gid );
			
			//添加选择的菜单
			foreach ( $cids as $key => $value ) {
				$Obj = M ( "menu_rel" );
				$Obj->cid = $value;
				$Obj->gid = $gid;
				$Obj->save ();
			}
			$msgObj->addMsg ( 'success', Config::lang ( "SAVESUCCESS" ) );
		}
		
		$this->setValue ( 'gid', $gid );
		
		$_Obj = M ( "category" );
		$_Obj->pageSize = 1000;
		$categoryAry = $_Obj->getCategoryListNoCURD ( $_Obj );
		$this->setValue ( "Obj", $_Obj );
		$this->setValue ( "categoryAry", $categoryAry );
		$this->forward ( "admin/category-setMenu.html" );
	}
}

