<?php
defined ( 'IN_ADMIN' ) or exit ( 'Access Denied' );
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class order extends controller {
	public $objName = 'order';
	public function add() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$this->getValidAry ( $_Obj );
		$_Obj = $_Obj->copyData ();
		if ($row ["usercategory"] == 1) {
			$this->showCategory ( $_Obj, $row ["id"] );
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	public function listAll() {
		$_Obj = M ( $this->objName );
		$msgObj = new Msg();
		$_Obj->pageSize = 15;
		$_Obj->orderby ( 'id desc' );
		//搜索字段
		$where = '1=1';
		if(!empty($_GET['order_id'])){$where .= " and order_id like '%{$_GET['order_id']}%'";}
		if(!empty($_GET['status'])){
			$status = intval($_GET['status']);
			$status = $status > 1 ? 0 : 1;
			$swhere = " and status = ".$status;
		}
		if(!empty($_REQUEST['s_date']) && !empty($_REQUEST['e_date'])){
			$stime = strtotime($_REQUEST['s_date']);
			$etime = strtotime($_REQUEST['e_date'])+86399;
			if($etime < $stime){
				$msgObj->addMsg('error','结束时间不能小于开始时间');
			}else{
				$where .= " and (ordtime >= ".$stime." and ordtime <= ".$etime.") ";
			}
		}
		if(!empty($_REQUEST['paytype'])){
			$paytype = intval($_REQUEST['paytype']);
			if($paytype == 1){
				$where .= " and (paytype = 1 or alipay_orderid != '') ";
			}else{
				$where .= " and (paytype = 2 or wechat_orderid != '') ";
			}
		}
		// if(!empty($_GET['type'])){$where .= " and type = {$_GET['type']}";}
		$_objAry = $_Obj->where ( $where.$swhere )->getList ();
		$payTrue = $_Obj->query("SELECT sum(amount) as total from tc_order where ".$where." and status = 1 ");
		$payFalse = $_Obj->query("SELECT sum(amount) as total from tc_order where ".$where." and status = 0 ");
		$this->setValue ( "Obj", $_Obj );
		$this->setValue ( "objAry", $_objAry );
		$this->setValue ( "payTrue", (float)$payTrue[0]['total'] );
		$this->setValue ( "payFalse", (float)$payFalse[0]['total'] );
		$this->forward ( "admin/" . $this->objName . "_list.html" );
	}
	
	public function edite() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$_Obj = $_Obj->load ( intval ( $_GET ['id'] ) );
		if ($row ["usercategory"] == 1) {
			$this->showCategory ( $_Obj, $row ["id"] );
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	private function getValidAry($_Obj) {
		$row = $this->getMid ();
		//表单验证字段
		$validAry = $_Obj->query ( "SELECT id,name,fieldname,pattern,errortips,tips FROM tc_field WHERE not_null =1 AND isshow=1 and mid=" . $row ["id"] );
		$this->setValue ( "validAry", $validAry );
		return $validAry;
	}
	
	private function showAreaSelect() {
		//地区
		$areaObj = M ( 'area' );
		$areaAry = $areaObj->getPrentAry ();
		$this->setValue ( "areaAry", $areaAry );
		$this->setValue ( "areaObj", $areaObj );
		//end
	}
	
	private function showCategory($Obj, $mid) {
		$categoryObj = M ( "category" );
		if (! empty ( $Obj->pid )) {
			$categoryObj = get ( "category", $Obj->pid );
			$categoryObj->isSelf = true;
		}
		$pidSelectStr = $categoryObj->getTree ( $categoryObj, $mid, false );
		$this->setValue ( "pidSelectStr", $pidSelectStr );
	}
	
	public function saveOrUpdate() {
		$fieldObj = M ( "field" );
		$row = $this->getMid ();
		$_Obj = M ( $this->objName );
		$msgObj = new Msg ();
		$_Obj->create ();
		
		//checkbox
		$keys = array_keys ( $_Obj->fields );
		foreach ( $_POST as $k => $v ) {
			if (is_array ( $v ) && $k != 'info' && in_array ( $k, $keys )) {
				$rt = implode ( ",", $_POST [$k] );
				$_Obj->$k = $rt;
			}
		}
		//end
		//特殊字段赋值IP地址,用户ID，添加时间
		$fields = $fieldObj->where ( "mid=" . $row ["id"] . " and formtype IN ('ipaddress','userid','addtime')" )->orderby ( "listorder desc" )->limit ( 1000 )->find ();
		if (! empty ( $fields )) {
			foreach ( $fields as $k => $v ) {
				if ($v ["formtype"] == 'userid') {
					$_Obj->$v ["fieldname"] = $_SESSION ["userId"];
				} else if ($v ["formtype"] == 'ipaddress') {
					$_Obj->$v ["fieldname"] = NetUtil::getIp ();
				} else if ($v ["formtype"] == 'addtime') {
					$_Obj->$v ["fieldname"] = time ();
				}
			}
		}
		//end
		//表单验证
		$validAry = $this->getValidAry ( $_Obj );
		foreach ( $validAry as $k => $v ) {
			$fieldname = $v ["fieldname"];
			if (isset($_POST[$_Obj->$fieldname]) && empty ( $_Obj->$fieldname ) && empty ( $v ["pattern"] )) {
				$msgObj->addMsg ( 'error', $v ["name"] . "不能为空!" );
			} else if (! empty ( $v ["pattern"] ) && ! preg_match ( '/' . StringUtil::stripslashes_deep ( $v ["pattern"] ) . "/", $_Obj->$fieldname )) {
				$msgObj->addMsg ( 'error', $v ["errortips"] );
			}
		}
		//end
		if (!$msgObj->hasMsg) {
        	if ($_Obj->saveOrUpdate ()) {
				$errorMsg = empty($_Obj->id) ? Config::lang ( "SAVESUCCESS" ) : Config::lang ( "UPDATESUCCESS" );
				$msgObj->addMsg ( 'success', $errorMsg );
			} else {
				$errorMsg = empty($_Obj->id) ? '添加失败' : '更新失败';
				$msgObj->addMsg ( 'error', $errorMsg );
			}
        }
		if ($row ["usercategory"] == 1) {
			//栏目
			$this->showCategory ( $_Obj, $row ["id"] );
			//
		}
		if ($this->haveArea ()) {
			$this->showAreaSelect ();
		}
		$this->setValue ( "Obj", $_Obj );
		$this->forward ( "admin/" . $this->objName . "_add.html" );
	}
	
	public function delete() {
		$_Obj = M ( $this->objName );
		$_Obj->delete ();
		header ( "Location:?ac=order_list" );
		exit ();
	}
	
	private function getMid() {
		$_Obj = M ( $this->objName );
		$sql = 'SELECT id,usercategory FROM tc_model WHERE tablename= "' . $_Obj->table . '"';
		$info = $_Obj->query ( $sql );
		return $info [0];
	}
	
	private function haveArea() {
		$_Obj = M ( $this->objName );
		$row = $this->getMid ();
		$sql = "SELECT count(*) as total FROM tc_field WHERE mid= '" . $row ["id"] . "' and formtype = 'linkage'";
		$info = $_Obj->query ( $sql );
		return $info [0] ["total"] > 0;
	}

	public function orderPayByMonth(){
	    if(NetUtil::isAjax()){
	        $order = M($this->objName);
            $z = date('Y-m');
            $m = 15 - date("m");
            $a = date('Y-m', strtotime("-{$m} months"));
            $begin = new DateTime($a);
            $end = new DateTime($z);
            $end = $end->modify('+1 month');
            $interval = new DateInterval('P1M');
            $range = new DatePeriod($begin, $interval ,$end);
            $month = array();
            foreach($range as $date){
                $temp = $date->format("Y-m");
                $month[] = $temp;
                $month_start = strtotime($temp);//指定月份月初时间戳 2018-06
                $month_end = strtotime(date("Y-m-d", strtotime($temp . ' +1 month'))) -1 ;//指定月份月末时间戳
                $row = $order->execute("select SUM(amount) as total from tc_order WHERE ordtime BETWEEN {$month_start} AND {$month_end} AND status = 0", 86400); //未支付
                $unPay[] = empty($row[0]['total']) ? 0 : (int)$row[0]['total'];
                $row = $order->execute("select SUM(amount) as total from tc_order WHERE ordtime BETWEEN {$month_start} AND {$month_end} AND status = 1", 86400); //未支付
                $pay[] = empty($row[0]['total']) ? 0 : (int)$row[0]['total'];
            }
            $data['month'] = $month;
            $data['unPay'] = $unPay;
            $data['pay'] = $pay;
	        $this->apiCallback(0, $data);
        }
	    $this->forward("admin/order_pay_by_month.html");
    }
}

