<?php
defined('IN_ADMIN') or exit('Access Denied');
defined('WODE_CMS') or exit('Access Denied');

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */

class plugins extends controller {

	public $objName = 'plugins';
	public function init() {
		$_Obj = M($this->objName);
		$this->setValue("Obj", $_Obj);
		$this->forward("admin/plugins-init.html");
	}

	public function edite() {
		$_Obj = M($this->objName);
		$groupAry = $_Obj->query('SELECT id,name from '.TABLEPRE.'group');
		$this->setValue("groupAry", $groupAry);
		$_Obj = $_Obj->load(intval($_GET['id']));
		$this->setValue("action", "edite");
		$this->setValue("Obj", $_Obj);
		$this->forward("admin/plugins-add.html");
	}

	public function install() {
		$_Obj = M($this->objName);
		$msgObj = new Msg();
		if (!empty($_POST['isRemote'])){
			$folder = $_POST['folder'];
		} else {
			$folder = $_POST['info']['folder'];
		}
		if (empty($folder)){
			$msgObj->addMsg('error', Config::lang("FOLDERNOTBEEMPTY"));
		}
		$_Obj->folder = $folder;
		$_Obj->haveDoubleRow($msgObj,"folder", Config::lang("HACKINSTALLDOUBLE"));
		if (!$msgObj->hasMsg) {
			//插入配置信息
			$datas = include ROOT_PATH . "/plugins/".$folder."/Config.php";
			$_Obj->create($datas);
			$_Obj->save();
			Log::info(var_export($_Obj,true));
			//导入数据
			$filepath = ROOT_PATH . "/plugins/".$folder."/install.sql";
			$str = file_get_contents($filepath);
			$sqlStr=str_replace($datas['tablepre'], Config::get('dbpre'), $str);
			$sqls = explode("--br",$sqlStr);
			foreach ( $sqls as $sql ) {
				str_replace ( "--br", "", $sql);
				$msg = '执行语句' . $sql . '成功<br />';
				Log::warning($msg);
				if (! mysql_query ( trim ( $sql ) )) {
					$msg = '执行语句' . $sql . '失败<br />';
					Log::warning($msg);
				}
			}
			$msgObj->addMsg('success', Config::lang("HACKINSTALLSUCCESS"));
		}
		$this->setValue("Obj", $_Obj);
		$this->forward("admin/plugins-init.html");
	}

	public function uninstall() {
		$msgObj = new Msg();
		$_Obj = M($this->objName);
		$_Obj = $_Obj->load(intval($_GET['id']));
		$folder = $_Obj->folder;
		if (!$msgObj->hasMsg) {
			//删除插入配置信息
			$_Obj->delete();
			//导入数据
			$datas = include ROOT_PATH . "/plugins/".$folder."/Config.php";
			if (!empty($datas)) {
				$filepath = ROOT_PATH . "/plugins/".$folder."/uninstall.sql";
				$sqls = mysql::mysqlRead($filepath, $datas['tablepre'], Config::get('dbpre'));
				foreach ( $sqls as $sql ) {
					str_replace ( "\n", "", $sql );
					if (! mysql_query ( trim ( $sql ) )) {
						$msg = '执行语句' . $sql . '失败<br />';
						Log::warning($msg);
					}
				}
			}
			$msgObj->addMsg('success', Config::lang("HACKUNINSTALLSUCCESS"));
		}
		$this->listAll();
	}

	public function saveOrUpdate() {
		$_Obj = M($this->objName);
		$msgObj = new Msg();
		$_Obj->create();
		if (empty($_Obj->name)) {
			$msgObj->addMsg('error', Config::lang("HACKNAMEISEMPTY"));
		}
		$_Obj->allowdo = implode(",", $_POST['info']['allowdo']);
		$_Obj->allowview = implode(",", $_POST['info']['allowview']);
		if (!$msgObj->hasMsg) {
			$errorMsg = $_Obj->id > 0 ? Config::lang("UPDATESUCCESS") : Config::lang("SAVESUCCESS");
			$_Obj->saveOrUpdate();
			$msgObj->addMsg('success', $errorMsg);
		}
		$this->createCache($_POST['info'],$_POST["info"]['folder']);
		header('Location:'.Config::get('admin').'?ac=plugins_edite&id='.$_Obj->id);
	}

	private function createCache($data,$folder) {
		$targetFile = ROOT_PATH . "/plugins/".$folder."/Config.php";
		unset($data['id']);
		$set = "<?php\ndefined('WODE_CMS') or exit('Access Denied');\n return " . var_export($data, true) . ";\n";
		file_put_contents($targetFile, $set);
	}

	public function listAll() {
		$_Obj = M($this->objName);
		$_Obj->pageSize = 8;
		$_Obj->orderby('rank asc');
		$_objAry = $_Obj->getList();
		$this->setValue("Obj", $_Obj);
		$this->setValue("objAry", $_objAry);
		$this->forward("admin/" . $this->objName . "-list.html");
	}

	public function lock() {
		$_Obj = M($this->objName);
		$sql = "update " . $_Obj->table . " set disabled = 0 where id = " . $_GET['id'];
		$_Obj->db->query($sql);
		$info = $_Obj->query("select * from ".TABLEPRE."plugins where id=".$_GET['id']);
		$this->createCache($info[0],$info[0]['folder']);
		$msgObj = new Msg ();
		$msgObj->addMsg ( 'warn', Config::lang ( "UNLOCKSUCCESS" ) );
		header("Location:".Config::get('admin')."?ac=plugins_list");
		exit;
	}

	public function open() {
		$_Obj = M($this->objName);
		$sql = "update " . $_Obj->table . " set disabled = 1 where id = " . $_GET['id'];
		$_Obj->db->query($sql);
		$info = $_Obj->query("select * from ".TABLEPRE."plugins where id=".$_GET['id']);
		$this->createCache($info[0],$info[0]['folder']);
		$msgObj = new Msg ();
		$msgObj->addMsg ( 'warn', Config::lang ( "LOCKSUCCESS" ) );
		header("Location:".Config::get('admin')."?ac=plugins_list");
		exit;
	}
	//远程安装
	public function remoteInstall() {
		$pluginsObj = M("plugins");
		$msgObj = new Msg();
		$sql = "select id from ".TABLEPRE."plugins where folder = '".$_GET["dir"]."'";
		$ifExists = $pluginsObj->ifExists($sql,1);
		if (!empty($ifExists)) {
			$msgObj->addMsg('warn', Config::lang("HACKINSTALLDOUBLE"));
			header("Location:".Config::get('admin')."?ac=plugins_init");
			exit;
		}
		$dir = $_GET["dir"];
		$zip_path = ROOT_PATH."/plugins/".$dir.".zip";
		$testzip_path = ROOT_PATH."/plugins/";
		$url = "http://admin.wodecms.com/index.php?ac=common_download&dir=".$dir;
		$down = NetUtil::getDataByUrl($url);
		@file_put_contents($zip_path, $down);
		$zip = new PclZip();
		$zip->PclFile($zip_path);
		if ($zip->extract(PCLZIP_OPT_PATH, $testzip_path, PCLZIP_OPT_REPLACE_NEWER) == 0) {
			$msgObj->addMsg ( 'error',$dir. '安装包已经存在');
		} else {
			Http::doPost(Config::get("website")."/".Config::get('admin')."?ac=plugins_install",array("folder"=>$dir,'isRemote'=>1),10);
		}
		@unlink($zip_path);
		$msgObj->addMsg ( 'success',$dir. '安装成功');
		header("Location:".Config::get('admin')."?ac=plugins_list");
		exit;
	}
}

