<?php
defined('WODE_CMS') or exit('Access Denied');
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class content extends controller {
	
	public $mid = 0;
	public $imgStr;
	protected  $model;
	public $objName = '';
	
	public function __construct() {
		$model = get('model',$_GET['mid']);
		if (empty($model)) {exit('模型不存在');}
		$this->model = $model;
		$this->mid = $model->id;
		$this->objName = $objName = str_replace(TABLEPRE,'',$model->tablename);
		parent::__construct();
    }
    
	//前台详细	
	public function show() {
		$model = $this->model;
		$objName = $this->objName;
		$_Obj = get($objName, intval($_GET['id']));
		if (empty($_Obj) || $_Obj->yz == 2) {
			$this->setValue("error", Config::lang("NEWSNOTEXISTSORPENDDING"));
			$this->forward("error.html");
            return false;//避免生成静态卡死
		}
		$hits = $_Obj->hits;
		$_Obj->hits = $hits+1;
		$_Obj->update();
		//得到同级栏目分类
		$categoryObj = M("category");
		$pObj = $categoryObj->load($_Obj->classid);
		//自定义模板
		$themepath = $pObj->themepath;
		$categoryAry = $categoryObj->field("id, pid, name,mid")->where("pid = " . $pObj->pid . " and mid=".$model->id )->limit(100)->find();
		//end
		$_Obj->where("classid=" . $_Obj->classid);
		$_Obj->id = $_Obj->id;
		if ($_Obj->edittime == NULL) {
			$_Obj->edittime = 0;
		}
		$forwardFile = $objName."_detail.html";
		if ($_Obj->ckjump == 1) {
			header('HTTP/1.1 301 Moved Permanently');
			header("Location: {$_Obj->jumpurl}");
		}
		if (!empty($themepath)) {
			$forwardFile = $themepath;
		}
		$_Obj->mid = 1;
		$_Obj->where = '';
		$nextdb = $_Obj->where("id > " . intval($_GET['id']))->orderby("id asc")->limit(1)->find();
		$_Obj->where = '';
		$backdb = $_Obj->where("id < " . intval($_GET['id']))->orderby("id desc")->limit(1)->find();
		//关键字，描述，标题
		$title = $_Obj->title . " - " . $pObj->name;
		$keywords = substr($_Obj->smallmemo, 0, 30);
		$description = substr($_Obj->smallmemo, 0, 120);
		$this->setValue("title", StringUtil::killAllHtml($title));
		$this->setValue("keywords", StringUtil::killAllHtml($keywords));
		$this->setValue("description", StringUtil::killAllHtml($description));
		//END
		$_Obj->title = StringUtil::text_out($_Obj->title);
		$_Obj->smallmemo = StringUtil::text_out($_Obj->smallmemo);
		$_Obj->post_key = explode(',',$_Obj->post_key);
		$url = New Url();
		if (empty($_GET["showAll"])) {
			$_Obj->content = ContentsPages(Config::get('website').'/index.php?c=model&a=show&id='.$_Obj->id.'&mid='.$model->id,$_Obj->content);
		}
		$_Obj->content = StringUtil::html_out($_Obj->content);
		if (!empty($_SESSION ['userId'])) {
			$sql = "select * from tc_collect where mid = {$model->id} and uid = " . $_SESSION ['userId'] . " and aid = " . $_GET ['id'];
			$arr = $_Obj->query ( $sql );
			if (!empty ( $arr )) {
				$this->setValue ( "isfavs", 1 );
			}
		} else {
			$this->setValue ( "isfavs", 2 );
		}
		$this->setValue("Obj", $_Obj);
		$this->setValue("nextdb", $nextdb);
		$this->setValue("backdb", $backdb);
		$this->setValue("categoryObj", $categoryObj);
		$this->setValue("categoryAry", $categoryAry);
		if ($_Obj->ckiframe == 1) {
			$this->forward("iframe.html");
			exit;
		}
		$this->forward($objName.'/'.$forwardFile);
	}
	
	public function index() {
		//幻灯片
		$flashObj = M('flash');
		$flashObj -> where('sid = 6');
		$flash = $flashObj->getList();
		$this->setValue('flash',$flash);
		$categoryObj = M("category");
		$_Obj = M($this->objName);
		$categoryAry = array();
		$model = $this->model;
		$objName = $this->objName;
		$classId = intval($_GET['classid']);
		if (empty($classId)) { //没有栏目ID,模型主页,返回所有栏目
			$title = empty($model->title) ? "请在{$model->modelname}模型设置标题" : $model->title;
			$keywords = empty($model->keywords) ? "请在{$model->modelname}模型设置关键字" : $model->keywords;
			$description = empty($model->description) ? "请在{$model->description}模型设置网页描述" : $model->description;
			$categoryAry = $categoryObj->query("select id, pid, name, mid from ".TABLEPRE."category where mid={$model->id} and pid = 0");
		} else {
			$categoryObj = $categoryObj->load($classId);
			if (empty($categoryObj)) {
				StringUtil::msgbox(Config::lang("CLASSNOTEXISTS"), REFERER, 1, "error");
			}
			$isParent = $categoryObj->ifHavePid($classId);
			if ($isParent) { //有子栏目,返回所有子栏目
				$categoryAry = $categoryObj->query("select id, pid, name, mid from ".TABLEPRE."category where mid={$model->id} and pid = " . $classId);
			} else { //无子栏目,返回同级别所有主栏目
				$categoryAry = $categoryObj->query("select id, pid, name, mid from ".TABLEPRE."category where mid={$model->id} and pid = " . $categoryObj->pid);
			}
			$title = empty($categoryObj->title) ? "请在{$categoryObj->name}栏目设置标题" : $categoryObj->title;
			$keywords = empty($categoryObj->keywords) ? "请在{$categoryObj->name}栏目设置关键字" : $categoryObj->keywords;
			$description = empty($categoryObj->description) ? "请在{$categoryObj->name}栏目设置网页描述" : $categoryObj->description;
		}
		//字段筛选
		$where = "n.yz=1";
		$filter = $skey = StringUtil::GetSQLValueString($_REQUEST["filter"]);
		if(!empty($filter) && in_array($filter,array('top','levels','special','flashpic','isphoto'))){
			$where .= " and n.{$filter} = 1";
		}
		if(!empty($classId)){//栏目字段特殊筛选
			$where .= " and (c.id = ".$classId." or c.pid =".$classId.")";
		}
		//排序 ory
		$rank = $skey = StringUtil::GetSQLValueString($_REQUEST["rank"]);
		if(!empty($rank)){
			$_Obj->orderby ( "n.{$rank} desc" );
		}
		$_Obj->pageSize = empty($model->pageSize) ? 30 : $model->pageSize;
		// $_Obj->field = "n.id,n.classid,n.title,n.photo,n.addtime";
		$_Obj->field = "n.*";
		$_Obj->table = "tc_{$objName} as n left join tc_category as c on c.id=n.classid";
		$_objAry = $_Obj->where($where)->orderby("id desc")->getList ();
		$this->setValue("Obj", $_Obj);
		$this->setValue("model", $model);
		$this->setValue("objAry", $_objAry);
		$this->setValue("categoryObj", $categoryObj);
		$this->setValue("categoryAry", $categoryAry);
		$this->setValue("title", $title);
		$this->setValue("keywords", $keywords);
		$this->setValue("description", $description);
		$themepath = '';
		if(empty($_GET[$filter]) && empty($_GET[$rank]) && empty($classId)){
			 $themepath = $objName."_index.html";
		}else{
			$themepath = $objName."_list.html";
		}
		if (!empty($categoryObj->themepath)) {
			$themepath = $categoryObj->themepath;//自定义模板优先
		}
		 $this->forward($objName . '/' . $themepath);
	}

	public function add() {
		$_Obj = M($this->objName);
		$categoryObj = M("category");
		$_Obj->hits = rand(20, 1000);
		$pidSelectStr = $categoryObj->getTree($categoryObj, 1, false);
		if (!empty($_GET['id'])) {
			$categoryObj = $categoryObj->load(intval($_GET['id']));
			$categoryObj->isSelf = true;
		}
		$_Obj = $_Obj->copyData();
		$_Obj->title = StringUtil::text_out($_Obj->title);
		$_Obj->smallmemo = StringUtil::text_out($_Obj->smallmemo);
		$this->setValue("Obj", $_Obj);
		$this->setValue("pidSelectStr", $pidSelectStr);
		$this->forward($this->objName.'/'."news_add.html");
	}
	
	public function delete() {
		$this->userIsLogin ();
		$_Obj = M($this->objName);
		$msgObj = new Msg();
		$id = $_GET['id'];
		$idAry = $_POST['id'];
		$idStr = count($idAry) == 0 ? intval($id) : implode(",", $idAry);
		$newIdAry = explode(",", $idStr);
		$idSize = count($newIdAry);
		if (empty($newIdAry[0]) && empty($id)) {
			$msgObj->addMsg('error', Config::lang("PLEASECHOOSEDELETEDATA"));
		}
		for ($i = 0; $i < $idSize; $i++) {
			$news = get($this->objName,$newIdAry[$i]);
			if (Authen::checkIsSelfData($news->uid)) {
				$_Obj->deleteById($newIdAry[$i]);
			} else {
				$msgObj->addMsg('error', Config::lang("CANBEDELNOTSELFNEWS"));
			}
		}
		if (!$msgObj->hasMsg) {
			$_Obj->delete();
		}
		header('Location: index.php?c=model&a=list&mid='.$this->mid.'&type=user&page='.$_GET["page"]);
	}

	public function edite() {
		$this->userIsLogin ();
		$_Obj = M($this->objName);
        $fieldObj = M("field");
		$_Obj = $_Obj->load(intval($_GET['id']));
		if (!Authen::checkIsSelfData($_Obj->uid)) {
			echo Config::lang("NEWSNOTEXISTSORPOWERWRONG");
			exit;
		}
		$categoryObj = get("category", $_Obj->classid);
		$categoryObj->isSelf = true;
		$pidSelectStr = $categoryObj->getTree($categoryObj, 1, false);
		$this->setValue("pidSelectStr", $pidSelectStr);
		$_Obj->title = StringUtil::text_out($_Obj->title);
		$_Obj->smallmemo = StringUtil::text_out($_Obj->smallmemo);
		$this->setValue("Obj", $_Obj);
		$this->forward($this->objName.'/'."news_add.html");
	}


	public function saveOrUpdate() {
		$this->userIsLogin ();
		$powerObj = M('power');
		$groupObj = M('group');
        $fieldObj = M("field");
		$_Obj = M($this->objName);
		$msgObj = new Msg();
		//栏目发布权限判断
		$userGroupId = $powerObj->getUserGroupId();
		$groupObj->load($userGroupId);
		$postCategoryAry = explode(",", $groupObj->post);
		$_Obj->classid = $_POST['info']['pid'];
		
		if (!Authen::isAdmin() && !in_array($_Obj->classid, $postCategoryAry)) {
			StringUtil::jsback(Config::lang("NOTPOWERADDNEWSTHISCATEGORY"));
		}
		//表单数据获取
		$_Obj->create();
		if (!empty($_Obj->id)) {
        	$obj = get($this->objName,$_Obj->id);
	        if (!Authen::checkIsSelfData($obj->uid)) {
				echo Config::lang("NEWSNOTEXISTSORPOWERWRONG");
				exit;
			}
        }
		$_Obj->content = $_POST['content'];
        //校验数据
		if (empty($_Obj->id) || $_POST["updatetime"]==1) {
			$_Obj->addtime = time();
		}
		$_Obj->edittime = time();
		if (empty($_Obj->title)) {
			StringUtil::jsback(Config::lang("TITLENOTBEEMPTY"));
		}
		if (empty($_Obj->content)) {
			StringUtil::jsback(Config::lang("CONTENTNOTBEEMPTY"));
		}
	
		if ($_Obj->classid == 0) {
			StringUtil::jsback(Config::lang("PLEASECHOOSENEWSCATEGORY"));
		}
		//文章简介处理
		if ($_POST['smallmemo']) {
			$smallmemo = StringUtil::killAllHtml($_Obj->content);
			$str = substr($smallmemo, 0, 180);
			$str = StringUtil::killAllHtml($str);
			$_Obj->smallmemo = $str;
		}
		if (empty($_SESSION['userId'])) {
			$_Obj->uid = 0;
		} else {
			$_Obj->uid = $_SESSION['userId'];
		}
		$_Obj->isphoto = 0;
		//批量获取远程图片到本地
		$content = StringUtil::text_out($_Obj->content);
		if ($_POST['fetch']) {
			$_Obj->content = $this->collectImg($content);
		}
		//end
		if (!empty($_Obj->photo_s)) {
			$_Obj->isphoto = 1;
		} else {
			$ord=$_POST['smallpic']-1;
			$imgs = explode("@@", $this->imgStr);
			$imgFace = str_replace('/uploadfiles/', "", $imgs[$ord]);
			if (!empty($imgFace) && $_POST['smallpic']) {
				$_Obj->photo = $imgFace;
				$_Obj->photo_s = $imgFace;
				$_Obj->isphoto = 1;
			}
		}
		$_Obj->haveDoubleRow($msgObj,"title", Config::lang("TITLECANNOTDOUBLE"));
		$_Obj->imgstr = $this->imgStr;
			$errorMsg = $_Obj->id > 0 ? Config::lang("UPDATESUCCESS") : Config::lang("SAVESUCCESS");
			if ($_Obj->id > 0 && !Authen::checkIsSelfData($_Obj->uid)) {
				echo Config::lang("NEWSNOTEXISTSORPOWERWRONG");
				exit;
			}
			$this->resetValues($_Obj);
			//脏话过滤
			$_Obj->title = StringUtil::fbword($_Obj->title);
			$_Obj->smallmemo = StringUtil::fbword($_Obj->smallmemo);
			$_Obj->content = StringUtil::fbword($_Obj->content);
			//HTML过滤
			$_Obj->title = StringUtil::text_in($_Obj->title);
			$_Obj->smallmemo = StringUtil::text_in($_Obj->smallmemo);
			//保存
			$id = $_Obj->saveOrUpdate();
		
		//定向URL处理
		$categoryObj = M("category");
		if ($_Obj->classid > 0) {
			$categoryObj = $categoryObj->load($_Obj->classid);
			$categoryObj->isSelf = true;
		}
		$pidSelectStr = $categoryObj->getTree($categoryObj, 1,false);
		//生成HTML
		if (Config::get("urlType") == 2 && $_Obj->id > 0) {
			$this->makeNewsInfoById($_Obj->id);
		}
		//还原HTML
		$_Obj->title = StringUtil::text_out($_Obj->title);
		$_Obj->smallmemo = StringUtil::text_out($_Obj->smallmemo);
		$this->setValue("Obj", $_Obj);
		$this->setValue("pidSelectStr", $pidSelectStr);
		if($id){
        	StringUtil::msgbox("操作成功！", "index.php?c=model&a=edite&mid={$this->mid}&id={$id}", 1);
        }
	}
	
	private function collectImg($content) {
		$fileArray = "";
		$img_array = array();
		$ctx = stream_context_create(array('http' => array('timeout' => 20)));
		preg_match_all("/<[img|IMG].*?src=[\'|\"](.*?(?:[\.gif|\.jpg|\.bmp|\.png|\.jpeg]))[\'|\"].*?[\/]/", $content, $img_array);
		$img_array = array_unique($this->dhtmlspecialchars($img_array[1]));
		foreach ($img_array as $key => $value) {
			$randNum = rand(10000, 999999);
			$imageStr = strrchr($value, ".");
			$imgName = substr($imageStr, 1, strlen($imageStr));
			$get_file = file_get_contents($value, 0, $ctx);
			$filetime = time();
			$filepath = "./uploadfiles/" . date("Y", $filetime) . "-" . date("m", $filetime) . "/";
			!is_dir($filepath) ? FileUtil::createDir($filepath) : null;
			$filename = date("YmdHis", $filetime) . $randNum . "." . $imgName;
			$partStr = substr($value, 0, 13);
			if (!strpos($partStr, "uploadfiles") && !strpos($partStr, Config::get("website"))) {
				$fp = @fopen($filepath . $filename, "w");
				@fwrite($fp, $get_file);
				fclose($fp);
				$content = preg_replace("/" . addcslashes($value, "/") . "/isU", "/uploadfiles/" . date("Y", $filetime) . "-" . date("m", $filetime) . "/" . $filename, $content);
				$imgStr .= date("Y", $filetime) . "-" . date("m", $filetime) . "/" . $filename . "@@";
			} else {
				$imgStr .= str_replace('/uploadfiles/', "", $value) . "@@";
			}
		}
		$this->imgStr = $imgStr;
		return $content;
	}


	private function dhtmlspecialchars($string, $is_url = 0) {
		if (is_array($string)) {
			foreach ($string as $key => $val) {
				$string[$key] = $this->dhtmlspecialchars($val);
			}
		} else {
			if (!$is_url)
				$string = str_replace('&', '&', $string);
			$string = preg_replace('/&((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1', str_replace(array('&', '"', '<', '>'), array('&', '"', '<', '>'), $string));
		}
		return $string;
	}


	private function resetValues($_Obj) {
		if (empty($_Obj->top)) {
			$_Obj->top = 0;
		}
		if (empty($_Obj->levels)) {
			$_Obj->levels = 0;
		}
		if (empty($_Obj->special)) {
			$_Obj->special = 0;
		}
		if (empty($_Obj->flashpic)) {
			$_Obj->flashpic = 0;
		}
		if (empty($_Obj->fonttype)) {
			$_Obj->fonttype = 0;
		}
		if (empty($_Obj->yz)) {
			$_Obj->yz = 1;
		}
		if (empty($_Obj->money)) {
			$_Obj->money = 0;
		}
		if (empty($_Obj->forbidcomment)) {
			$_Obj->forbidcomment = 0;
		}
		if (empty($_Obj->ckjump)) {
			$_Obj->ckjump = 0;
		}
		if (empty($_Obj->ckiframe)) {
			$_Obj->ckiframe = 0;
		}
	}

	public function getContent() {
		$newsObj = get('news',$_GET['id']);
		if (empty($_SESSION["userId"])) {
			exit('<div style="border:1px dotted #F90; border-left:6px solid #F60; padding:15px; background:#FFC;margin-top:8px;width:90%"><a href="index.php?ac=user_login">'.Config::lang("NOTLOGIN").',点击马上登陆(注册送100积分)</a></div>');
		}
		$userObj = get("user",$_SESSION["userId"]);
		if ($userObj->money < $newsObj->money) {
			exit('<div style="border:1px dotted #F90; border-left:6px solid #F60; padding:15px; background:#FFC;margin-top:8px;width:90%">'.Config::lang("NOTMONEY").'</div>');
		}
		//积分减去
		$userObj->money = $userObj->money - $newsObj->money;
		$userObj->update();
		//获取文章内容
		echo StringUtil::html_out($newsObj->content);
	}
	
	private function userIsLogin() {
		if (! Authen::checkIsSelfData ( $_SESSION ["userId"] )) {
			$this->setValue ( "error", Config::lang ( "NOTRIGHT" ) );
			$this->forward ( "noRight.html" );
			exit ();
		}
	}
	
	public function makeList() {
		if (!Authen::isAdmin()) {
    		exit('Not Right');
    	}
		$startTime = DateUtil::utime();
		$displaypg = Config::get($this->objName."page");
		$_Obj = M($this->objName);
		$_GET['ac'] = $this->objName."_list";
		FileUtil::createDir(ROOT_PATH . "/html/".$this->objName);
		$totle = $_Obj->getCount();
		$lastpg = ceil($totle / $displaypg);
		ob_start();
		$this->listAll();
		$cacheStr = ob_get_contents();
		$handle = fopen("html/".$this->objName."/list_1.html", "w");
		fwrite($handle, $cacheStr);
		ob_clean();
		copy("html/".$this->objName."/list_1.html", "html/".$this->objName."/list.html");
		$this->makeEachList($_Obj, $displaypg,$startTime);
	}


	private function makeEachList($_Obj, $displaypg,$startTime) {
		//栏目分类
		$categoryObj = M("category");
		$categoryAry = $categoryObj->where("mid = ".$model->mid)->field("id")->limit(10000)->find();
		$categoryObj->where = '';
		$categorySize = count($categoryAry);
		//新闻文章
		$where = "1=1";
		for ($i = 0; $i < $categorySize; $i++) {
			$_GET['classid'] = $categoryAry[$i]["id"];
			$isParent = $categoryObj->ifHavePid($categoryAry[$i]["id"]);
			if ($isParent) {
				$aryStr = $categoryObj->getCids($categoryAry[$i]["id"]);
				$where .= " and classid in(" . $aryStr . ")";
			} else {
				$where .= " and classid=" . $categoryAry[$i]["id"];
			}
			$newsAry = $_Obj->field("id")->where($where)->limit(10000000)->find();
			$_Obj->where = '';
			$where = "1=1";
			$newsNum = count($newsAry);
			if (!empty($newsNum)) {
				$lastpg = ceil($newsNum / $displaypg);
				for ($j = 1; $j <= $lastpg; $j++) {
					$_GET['page'] = $j;
					ob_start();
					$this->listAll();
					$cacheStr = ob_get_contents();
					$handle = fopen("html/".$this->objName."/list_" . $categoryAry[$i]["id"] . "_" . $j . ".html", "w");
					fwrite($handle, $cacheStr);
					ob_clean();
				}
			} else {
				$_GET['page'] = 1;
				ob_start();
				$this->listAll();
				$cacheStr = ob_get_contents();
				$handle = fopen("html/".$this->objName."/list_" . $categoryAry[$i]["id"] . "_1.html", "w");
				fwrite($handle, $cacheStr);
				ob_clean();
			}
		}
		$endTime = DateUtil::utime();
		echo '{"buildCount":'.$categorySize.',"status":"'.$this->objName.'ListFinish","buildTime":'.DateUtil::spent($endTime,$startTime).'}';
	}

	public function makeInfo() {
		if (!Authen::isAdmin()) {
    		exit('Not Right');
    	}
		$startTime = DateUtil::utime();
		$_Obj = M($this->objName);
		$_GET['ac'] = $this->objName."_show";
		$startDate = strtotime($_GET["beginDate"]);
		$endDate = strtotime($_GET["endDate"]);
		$where = "1=1";
		if (!empty($startDate) && !empty($endDate)) {
			$where .= " and addtime BETWEEN '".$startDate."' AND '".$endDate."'";
		}
		$page = $_GET["page"];
		$_Obj->pageSize = $_GET["pageSize"];
		$_Obj->field("id,addtime")->where($where);
		$newAry = $_Obj->getList();
		$newsSize = count($newAry);
		for ($i = 0; $i < $newsSize; $i++) {
			$id = $newAry[$i]["id"];
			$time = date("Ym", $newAry[$i]["addtime"]);
			$_GET["id"] = $id;
			FileUtil::createDir(ROOT_PATH . "/html/".$this->objName."/" . $time);
			$filename = ROOT_PATH . "/html/".$this->objName."/" . $time . "/" . $id . ".html";
			ob_start();
			$this->show();
			$cacheStr = ob_get_contents();
			$handle = fopen($filename, "w");
			fwrite($handle, $cacheStr);
			ob_clean();
		}
		$pageNum = ceil($_Obj->count/$_Obj->pageSize);
		$thisPage = $page + 1;
		$endTime = DateUtil::utime();
		if ($page < $pageNum) {
			echo '{"buildCount":'.$newsSize.',"status":"'.$this->objName.'Finish","buildTime":'.DateUtil::spent($endTime,$startTime).',"page":'.$thisPage.'}';
		} else {
			echo '{"buildCount":'.$newsSize.',"status":"'.$this->objName.'Finish","buildTime":'.DateUtil::spent($endTime,$startTime).',"page":1}';
		}
	}
	
	public function makeInfoById($id) {
		if (!Authen::isAdmin()) {
    		exit('Not Right');
    	}
    	$id = empty($id) ? $_GET["id"] : $id;
		$_Obj = get($this->objName, $id);
		$_GET['ac'] = $this->objName."_show";
		$_GET["id"] = $id;
		$time = date("Ym", $_Obj->addtime);
		FileUtil::createDir(ROOT_PATH . "/".$this->objName."/" . $time);
		$filename = ROOT_PATH . "/".$this->objName."/" . $time . "/" . $id . ".html";
		ob_start();
		$this->show();
		$cacheStr = ob_get_contents();
		$handle = fopen($filename, "w");
		fwrite($handle, $cacheStr);
		ob_clean();
	}
}

