<?php

defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */
class crontab extends controller {
	public function Runner() {
		$crontab = M ( 'crontab' );
		$crontabAry = $crontab->query ( "SELECT * FROM tc_crontab WHERE status =1" );
		foreach ( $crontabAry as $kk => $vv ) {
			$method = $vv ['funcName'];
			if (! empty ( $vv ['hourStr'] )) { //1~24,指定执行小时数
				$lasttimeDiff = time () - $vv ['lasttime']; //过去了多久
				$dotime = $vv ['timeStr'] * 60; //每N分钟执行一次
				if (date ( 'H' ) == $vv ['hourStr'] && $lasttimeDiff > $dotime) { //小时数相等,大于间隔时间
					$this->$method ();
					$crontabObj = get ( 'crontab', $vv ['id'] );
					$crontabObj->lasttime = time ();
					$crontabObj->runtimes = $crontabObj->runtimes + 1;
					$crontabObj->update ();
				}
			} else { //不指定执行小时数,每小时执行一次的
				$dotime = $vv ['timeStr'] * 60; //每N分钟执行一次
				$lasttimeDiff = time () - $vv ['lasttime']; //过去了多久
				if ($lasttimeDiff >= $dotime) { //过去的分钟大于每N分钟执行的时间,就执行，并更新
					$this->$method ();
					$crontabObj = get ( 'crontab', $vv ['id'] );
					$crontabObj->lasttime = time ();
					$crontabObj->runtimes = $crontabObj->runtimes + 1;
					$crontabObj->update ();
				}
			}
		}
	}
	
	public function runById() {
		$crontabObj = get ( 'crontab', $_GET ['id'] );
		$crontabObj->runtime = time ();
		$crontabObj->status = 2;
		$crontabObj->update ();
		$method = $crontabObj->funcName;
		$this->$method ();
		$crontabObj = get ( 'crontab', $_GET ['id'] );
		$crontabObj->lasttime = time ();
		$crontabObj->status = 1;
		$crontabObj->runtimes = $crontabObj->runtimes + 1;
		$crontabObj->update ();
		if(!empty($_GET['id'])){
			$this->apiCallback ( 'SUCCESS', array (), '手动执行成功' );
		}
	}
	
	/**
	 * 生成XML
	 */
	public function Sitemap() {
		$user = Authen::getCurrentUser ();
		$video = $user->execute ( "select id,title,addtime as time from tc_video where yz = 1 and fetch_id > 0 and is_del = 0 order by id desc", 0 );
		$news = $user->execute ( "select id,title,addtime as time from tc_news where yz = 1 order by id desc", 0 );
		$singer = $user->execute ( "select id,name as title,addtime as time from tc_singer order by id desc", 0 );
		$videoAry = array ();
		foreach ( $video as $key => $item ) {
			$videoAry [$key] ['loc'] = Config::get ( "website" ) . "/video/{$item['id']}.html";
			$videoAry [$key] ['lastmod'] = date ( "Y-m-d", $item ['time'] );
			$videoAry [$key] ['changefreq'] = "weekly"; //标示数据更新频率：always、hourly、daily、weekly、monthly、yearly、never
			$videoAry [$key] ['priority'] = 0.9;
		}
		$newsAry = array ();
		foreach ( $news as $key => $item ) {
			$newsAry [$key] ['loc'] = Config::get ( "website" ) . "/news/{$item['id']}.html";
			$newsAry [$key] ['lastmod'] = date ( "Y-m-d", $item ['time'] );
			$newsAry [$key] ['changefreq'] = "daily"; //标示数据更新频率：always、hourly、daily、weekly、monthly、yearly、never
			$newsAry [$key] ['priority'] = 0.9;
		}
		
		$singerAry = array ();
		foreach ( $singer as $key => $item ) {
			$singerAry [$key] ['loc'] = Config::get ( "website" ) . "/download/{$item['id']}.html";
			$singerAry [$key] ['lastmod'] = date ( "Y-m-d", $item ['time'] );
			$singerAry [$key] ['changefreq'] = "daily"; //标示数据更新频率：always、hourly、daily、weekly、monthly、yearly、never
			$singerAry [$key] ['priority'] = 0.9;
		}
		
		$list = array_merge ( $videoAry, $newsAry, $singerAry);
		$res = $this->createXML ( $list );
		$file = ROOT_PATH . "/Sitemap.xml";
		$res = file_put_contents ( $file, $res ); // 如果遇到文件转码可使用 iconv() 进行转换
		//Log::info ( "Sitemap执行时间:" . DateUtil::getRunTime () . "内存消耗:" . DateUtil::getRunM (), 'Return FileSize：' . $res );
	}
	
	/**
	 * 创建Sitemap XML
	 * @author ZhiYuan TIME
	 * @param array $arr
	 * @return string
	 */
	public function createXML($arr = array()) {
		$string = '<?xml version="1.0" encoding="utf-8"?><urlset>' . "\r\n";
		foreach ( $arr as $kk => $item ) {
			$string .= "<url>\r\n";
			foreach ( $item as $key => $value ) {
				$string .= "<" . $key . ">" . $value . "</" . $key . ">\r\n";
			}
			$string .= "</url>\r\n";
		}
		$string .= "</urlset>\r\n";
		return $string;
	}
	
	public function updateSipderCount() {
		$botObj = M ( "bot" );
		$date = date ( "Y-m-d" );
		$starttime = strtotime ( $date ) - 86400;
		$endtime = $starttime + 86399;
		$botAry = $botObj->query ( "SELECT COUNT(1) AS count,bot,serverip FROM tc_bot WHERE ADDTIME >= {$starttime} and ADDTIME <= {$endtime} AND (bot = 'Baidu' OR bot = '360' OR bot = 'Google' OR bot = 'Sogou' OR bot = 'Yahoo!') GROUP BY serverip" );
		if (! empty ( $botAry )) {
			$sipder = $this->sipder ();
			foreach ( $botAry as $key => $value ) {
				$botAry [$key] ['class'] = null;
				foreach ( $sipder as $kk => $vv ) {
					foreach ( $vv as $k => $v ) {
						if (strpos ( $value ['serverip'], $v ) !== false) {
							$botAry [$key] ['class'] = $kk;
						}
					}
				}
			}
			$sipderCountAry = array ('Baidu' => array ('grkz' => 0, 'qzzq' => 0, 'zhqz' => 0, 'nyqz' => 0, 'qzsy' => 0, 'sh' => 0, 'ybzq' => 0, 'xzkc' => 0, 'wzyc' => 0, 'xl' => 0, 'dqz' => 0, 'count' => 0 ), 'Google' => array ('grkz' => 0, 'qzzq' => 0, 'zhqz' => 0, 'nyqz' => 0, 'qzsy' => 0, 'sh' => 0, 'ybzq' => 0, 'xzkc' => 0, 'wzyc' => 0, 'xl' => 0, 'dqz' => 0, 'count' => 0 ), '360' => array ('grkz' => 0, 'qzzq' => 0, 'zhqz' => 0, 'nyqz' => 0, 'qzsy' => 0, 'sh' => 0, 'ybzq' => 0, 'xzkc' => 0, 'wzyc' => 0, 'xl' => 0, 'dqz' => 0, 'count' => 0 ), 'Sogou' => array ('grkz' => 0, 'qzzq' => 0, 'zhqz' => 0, 'nyqz' => 0, 'qzsy' => 0, 'sh' => 0, 'ybzq' => 0, 'xzkc' => 0, 'wzyc' => 0, 'xl' => 0, 'dqz' => 0, 'count' => 0 ), 'Yahoo!' => array ('grkz' => 0, 'qzzq' => 0, 'zhqz' => 0, 'nyqz' => 0, 'qzsy' => 0, 'sh' => 0, 'ybzq' => 0, 'xzkc' => 0, 'wzyc' => 0, 'xl' => 0, 'dqz' => 0, 'count' => 0 ) );
			;
			foreach ( $botAry as $key => $value ) {
				switch ($value ['bot']) {
					case 'Baidu' :
						$sipderCountAry [$value ['bot']] ['count'] += ( int ) $value ['count'];
						break;
					case 'Google' :
						$sipderCountAry [$value ['bot']] ['count'] += ( int ) $value ['count'];
						break;
					case '360' :
						$sipderCountAry [$value ['bot']] ['count'] += ( int ) $value ['count'];
						break;
					case 'Sogou' :
						$sipderCountAry [$value ['bot']] ['count'] += ( int ) $value ['count'];
						break;
					case 'Yahoo!' :
						$sipderCountAry [$value ['bot']] ['count'] += ( int ) $value ['count'];
						break;
				}
				switch ($value ['class']) {
					case 'grkz' :
						$sipderCountAry [$value ['bot']] ['grkz'] = ( int ) $value ['count'];
						break;
					case 'qzzq' :
						$sipderCountAry [$value ['bot']] ['qzzq'] = ( int ) $value ['count'];
						break;
					case 'zhqz' :
						$sipderCountAry [$value ['bot']] ['zhqz'] = ( int ) $value ['count'];
						break;
					case 'nyqz' :
						$sipderCountAry [$value ['bot']] ['nyqz'] = ( int ) $value ['count'];
						break;
					case 'qzsy' :
						$sipderCountAry [$value ['bot']] ['qzsy'] = ( int ) $value ['count'];
						break;
					case 'sh' :
						$sipderCountAry [$value ['bot']] ['sh'] = ( int ) $value ['count'];
						break;
					case 'ybzq' :
						$sipderCountAry [$value ['bot']] ['ybzq'] = ( int ) $value ['count'];
						break;
					case 'xzkc' :
						$sipderCountAry [$value ['bot']] ['xzkc'] = ( int ) $value ['count'];
						break;
					case 'wzyc' :
						$sipderCountAry [$value ['bot']] ['wzyc'] = ( int ) $value ['count'];
						break;
					case 'xl' :
						$sipderCountAry [$value ['bot']] ['xl'] = ( int ) $value ['count'];
						break;
					case 'dqz' :
						$sipderCountAry [$value ['bot']] ['dqz'] = ( int ) $value ['count'];
						break;
				}
			}
			$spiderCountObj = M ( 'spider_count' );
			$sql = " INSERT INTO tc_spider_count (spider,date,sum,grkz,qzzq,zhqz,nyqz,qzsy,sh,ybzq,xzkc,wzyc,xl,dqz) VALUES";
			$starttimeStr = date ( 'Y-m-d', $starttime );
			foreach ( $sipderCountAry as $key => $value ) {
				$sql .= " ('" . $key . "','" . $starttimeStr . "'," . $value ['count'] . "," . $value ['grkz'] . "," . $value ['qzzq'] . "," . $value ['zhqz'] . "," . $value ['nyqz'] . "," . $value ['qzsy'] . "," . $value ['sh'] . "," . $value ['ybzq'] . "," . $value ['xzkc'] . "," . $value ['wzyc'] . "," . $value ['xl'] . "," . $value ['dqz'] . "),";
			}
			$sql = trim ( $sql, ',' );
			$spiderCountObj->query ( $sql );
			$res = $spiderCountObj->db->affected_rows ();
			if ($res > 0) {
				$botObj->query ( "DELETE FROM tc_bot WHERE addtime <= " . $endtime ); //删除昨天的数据
			}
		}
		//Log::info ( "蜘蛛爬行统计分析执行时间:" . DateUtil::getRunTime () . "内存消耗:" . DateUtil::getRunM (), 'Return FileSize：' . $res );
	}
	
	private function sipder() {
		return $sipder = array ('grkz' => array ('220.181.108.95' ), 'qzzq' => array ('220.181.108.92' ), 'zhqz' => array ('220.181.108.91' ), 'nyqz' => array ('220.181.108.75' ), 'qzsy' => array ('220.181.108.86', '220.181.108.89', '220.181.108.94', '220.181.108.97', '220.181.108.80', '220.181.108.77', '220.181.108.83' ), 'sh' => array ('123.125.68', '220.181.68' ), 'ybzq' => array ('220.181.7', '123.125.66' ), 'xzkc' => array ('121.14.89' ), 'wzyc' => array ('203.208.60' ), 'xl' => array ('210.72.225' ), 'dqz' => array ('123.125.71.106', '123.125.71.95', '123.125.71.97', '123.125.71.117' ) ); //需要的搜索引擎蜘蛛
	}
	
	public function makeAboutHtmlById() {
    	$id = empty($id) ? intval($_GET["id"]) : $id;
		$_Obj = get ( 'about', $id );
		ob_start ();
		$content = file_get_contents ( Config::get("website"). "/index.php?a=about&c=index&id=".$id);
		ob_end_clean ();
		$filename = ROOT_PATH . "/".$_Obj->HtmlUrl;
		file_put_contents ( $filename, $content );
		header("Location:".$_Obj->HtmlUrl);
	}
	
	public function makeAboutHtml() {
		$_Obj = M ( 'about');
		$msgObj = new Msg ();
		$info = $_Obj->query("select * from tc_about");
		foreach($info as $kk=>$vv){
			ob_start ();
			$content = file_get_contents ( Config::get("website"). "/index.php?a=about&c=index&id=".$vv['id']);
			ob_end_clean ();
			$dir = explode('/',$vv['HtmlUrl']);
			if(empty($dir[1])) {
				$filename = ROOT_PATH . "/".$vv['HtmlUrl'];
			} else {
				FileUtil::createDir(ROOT_PATH . "/{$dir[0]}/");
				$filename = ROOT_PATH . "/{$dir[0]}/{$dir[1]}";
			}
			file_put_contents ( $filename, $content );
		}
		$msgObj->addMsg ( 'success', '所有单页面生成HTML成功.' );
		header("Location:".Config::get('admin').'?ac=about_list');
	}
	
	public function makeInfoById() {
		$id = intval($_GET["id"]);
		$objName = $_GET["objName"];
    	$_GET["id"] = $id;
		$_GET['ac'] = $objName."_show";
        FileUtil::createDir ( ROOT_PATH . "/{$objName}/" );
        $filename = ROOT_PATH . "/{$objName}/{$id}.html";
		ob_start ();
		$content = file_get_contents ( Config::get('website')."/index.php?ac={$objName}_show&id=".$id);
		ob_end_clean ();
		file_put_contents ( $filename, $content );
		$dateStr = date('Y-m-d H:i:s');
		$_Obj = M($objName);
		$_Obj->query("update tc_{$objName} set htmlTime='{$dateStr}' WHERE id=".$id);
	}
	
	public function redel() {
		$_Obj = M ( 'code' );
		$ary = $_Obj->query ("SELECT COUNT(id) AS total,bianhao,product,hits,pihao FROM tc_code where product !='未知' and pihao!='' GROUP BY bianhao ORDER BY total DESC LIMIT 200");
		$str = '';
		foreach($ary as $kk=>$vv){
			if ($vv['total']>1){
				$str .="bianhao='".$vv['bianhao']."' or ";
			}
		}
		$strlen = strlen($str);
		$str = substr($str,0,$strlen-3);
		$str1 ="update tc_code set hits=0,product='未知',pihao='' where {$str}";
		$_Obj->query ($str1);
		echo $str1.'success';
		echo '<meta http-equiv="refresh" content="0.1;url=index.php?ac=crontab_rdel">';
	}
}