<?php

defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.vipshop.com，并保留所有权利。
 * 网站地址: http://www.vipshop.com
 * 
 * -------------------------------------------------------
 *
 * @author :     vipshop team
 * @version :    v1.0
 * =======================================================
 */
class categoryAction extends categoryBase {
	
	function category() {
		parent::__construct ();
	}
	
	public function getCategoryTree($mid) {
		return $this->getTree ( $this, $mid, false );
	}
	
	//得到select下拉框
	public function getTree($_Obj, $mid, $multiple = false) {
		$multipleStr = $multiple ? "multiple=multiple name=\"classid[]\"" : " name=\"info[classid]\"";
		$selectStr = "<select " . $multipleStr . " class='form-control' style='float: left; width: 180px; display: block;' >";
		$selectStr .= "<option value=\"0\" > -  </option>";
		$where = "1=1";
		if (empty ( $mid )) {
			$order = "mid asc";
			$where .= " and pid=0";
		} else {
			$order = "rank asc";
			$where .= " and pid=0 and mid = " . $mid;
		}
		$moduleAry = $this->where ( $where )->orderby ( $order )->getList ();
		$showId = empty ( $_Obj->pid ) ? 0 : $_Obj->pid;//是否父类
		for($i = 0; $i < count ( $moduleAry ); $i ++) {
			if ($_Obj->id == $moduleAry [$i] ['id']) {
				$selectStr .= "<option selected value=" . $moduleAry [$i] ['id'] . ">" . str_repeat ( "&nbsp;", 0 ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "</option>";
			} else {
				$selectStr .= "<option value=" . $moduleAry [$i] ['id'] . ">" . str_repeat ( "&nbsp;", 0 ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "</option>";
			}
			$selectStr .= $this->getCid ( $_Obj, $moduleAry [$i] ['id'], 4 );
		}
		$selectStr .= "</select>";
		return $selectStr;
	}
	
	public function getCid($_Obj, $pId, $times) {
		$this->pageSize = 1000;
		$this->where = '';
		$moduleAry = $this->where ( 'pid = ' . $pId . " " )->orderby ( "rank asc" )->getList ();
		$selectStr = "";
		$j = 1;
		for($i = 0; $i < count ( $moduleAry ); $i ++) {
			if ($_Obj->id == $moduleAry [$i] ['id']) {
				$selectStr .= "<option selected value=" . $moduleAry [$i] ['id'] . ">" . str_repeat ( "&nbsp;", $times ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "</option>";
			} else {
				$selectStr .= "<option value=" . $moduleAry [$i] ['id'] . ">" . str_repeat ( "&nbsp;", $times ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "</option>";
			}
			if ($this->ifHavePid ( $moduleAry [$i] ['id'] )) {
				$j ++;
				$selectStr .= $this->getCid ( $_Obj, $moduleAry [$i] ['id'], $times + $j );
			}
		}
		return $selectStr;
	}
	
	//后台列表
	public function getCategoryList($_Obj) {
		$mid = $_GET ["mid"];
		$where = "pid = 0";
		if (! empty ( $mid )) {
			$where .= ' and mid = ' . $mid;
		}
		$this->pageSize = 1000;
		$moduleAry = $this->where ( $where )->getList ();
		$selectStr .= "";
		for($i = 0; $i < count ( $moduleAry ); $i ++) {
			
			//模型名
			$modelObj = get ( "model", $moduleAry [$i] ['mid'] );
			$tablenameStr = str_replace ( TABLEPRE, "", $modelObj->tablename );
		
			$selectStr .= "<tr>";
			$selectStr .= "<td class=\"price\">" . $moduleAry [$i] ['id'] . "</td>";
			$selectStr .= "<td class=\"title\">" . str_repeat ( "&nbsp;", 0 ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "&nbsp;</td>";
			$selectStr .= "<td class=\"category\"> " . $this->getModuleName ( $moduleAry [$i] ['mid'] ) . " </td>";
			$selectStr .= "<td class=\"category\"> " . $moduleAry [$i] ['rank'] . " </td>";
			$selectStr .= "<td class=\"date\">";
			$selectStr .= "<a class='btn btn-danger' href=\"" . Config::get ( 'admin' ) . "?ac=category_delete&id=" . $moduleAry [$i] ['id'] . "&mid=" . $moduleAry [$i] ['mid'] . "\">" . Config::lang ( "DELETE" ) . "</a>&nbsp;&nbsp;";
			if ($mid == 11) {
				$selectStr .= "<a class='btn btn-success' href=\"" . Config::get ( 'admin' ) . "?ac=category_add&mid=" . $mid . "&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "ADD" ) . "</a>&nbsp;&nbsp;";
			} else {
				$selectStr .= "<a class='btn btn-success' href=\"" . Config::get ( 'admin' ) . "?ac=category_add&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "ADD" ) . "</a>&nbsp;&nbsp;";
			}
			$selectStr .= "<a class='btn btn-info' href=\"" . Config::get ( 'admin' ) . "?ac=category_edite&mid=" . $moduleAry [$i] ['mid'] . "&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "MODIFY" ) . "</a>&nbsp;&nbsp;";
			$selectStr .= "<a class='btn btn-primary' href=\"" . Config::get ( 'admin' ) . "?ac=" . $tablenameStr . "_add&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "PUBLISH" ) . "</a>&nbsp;&nbsp;";
			$selectStr .= "</td>";
			$selectStr .= " </tr>";
			$selectStr .= $this->getCList ( $_Obj, $moduleAry [$i] ['id'], 4 );
		}
		return $selectStr;
	}
	
	public function getCList($_Obj, $pId, $times) {
		$this->where = '';
		$where = ' pid=' . $pId;
		$this->where ( $where )->orderby ( '  pid asc' );
		$this->pageSize = 1000;
		$moduleAry = $this->getList ();
		$selectStr = "";
		$j = 1;
		for($i = 0; $i < count ( $moduleAry ); $i ++) {
			$selectStr .= "<tr>";
			//$selectStr .= "<td class=\"selected last\"><input  name=\"id[]\" id=\"ids\" value=\"" . $moduleAry[$i]['id'] . "\" type=\"checkbox\"></td>";
			$selectStr .= "<td class=\"price\">" . $moduleAry [$i] ['id'] . "</td>";
			$selectStr .= "<td class=\"title\">" . str_repeat ( "&nbsp;", $times ) . "|-&nbsp;" . $moduleAry [$i] ['name'] . "</td>";
			$selectStr .= "<td class=\"category\"> - </td>";
			$selectStr .= "<td class=\"category\"> " . $moduleAry [$i] ['rank'] . " </td>";
			$selectStr .= "<td class=\"date\">";
			$selectStr .= "<a class='btn btn-danger' href=\"" . Config::get ( 'admin' ) . "?ac=category_delete&id=" . $moduleAry [$i] ['id'] . "&mid=" . $moduleAry [$i] ['mid'] . "\">" . Config::lang ( "DELETE" ) . "</a>&nbsp;&nbsp;";
			if ($mid == 11) {
				$selectStr .= "<a class='btn btn-success' href=\"" . Config::get ( 'admin' ) . "?ac=category_add&mid=" . $mid . "&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "ADD" ) . "</a>&nbsp;&nbsp;";
			} else {
				$selectStr .= "<a class='btn btn-success' href=\"" . Config::get ( 'admin' ) . "?ac=category_add&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "ADD" ) . "</a>&nbsp;&nbsp;";
			}
			$selectStr .= "<a class='btn btn-info' href=\"" . Config::get ( 'admin' ) . "?ac=category_edite&mid=" . $moduleAry [$i] ['mid'] . "&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "MODIFY" ) . "</a>&nbsp;&nbsp;";
			//模型名
			$modelObj = get ( "model", $moduleAry [$i] ['mid'] );
			$tablenameStr = str_replace ( TABLEPRE, "", $modelObj->tablename );
			//
			if (in_array($moduleAry [$i] ['mid'],array(1,2,3,4,5,6))) {
				$selectStr .= "<a class='btn btn-primary' href=\"" . Config::get ( 'admin' ) . "?ac=" . $tablenameStr . "_add&id=" . $moduleAry [$i] ['id'] . "\">" . Config::lang ( "PUBLISH" ) . "</a>&nbsp;&nbsp;";
			} 
			$selectStr .= "</td>";
			$selectStr .= " </tr>";
			if ($this->ifHavePid ( $moduleAry [$i] ['id'] )) {
				$j ++;
				$selectStr .= $this->getCList ( $_Obj, $moduleAry [$i] ['id'], $times + $j );
			}
		}
		return $selectStr;
	}
	
	public function ifHavePid($cId) {
		if ($cId == 0) {
			return false;
		}
		$sql = "select * from " . $this->table . " where pid='$cId'";
		$rt = $this->db->query ( $sql );
		$row = mysql_fetch_array ( $rt );
		$havePid = false;
		if (! $row) {
			$havePid = false;
		} else {
			$havePid = true;
		}
		return $havePid;
	}
	
	public function getParentName($cId) {
		if ($cId == 0) {
			return Config::lang ( "TOPTYPE" );
		}
		$categoryObj = get ( "category", $cId );
		return $categoryObj->name;
	}
	
	public function getCategoryNameById($classId) {
		if (empty ( $classId )) {
			return false;
		}
		$_Obj = $this->load ( $classId );
		return $_Obj->name;
	}
	
	public function getCategoryLink($classId, $mid) {
		$urlObj = new Url ();
		if (empty ( $classId )) {
			return false;
		}
		$aryStr = "";
		$linkStr = "";
		$_Obj = $this->load ( $classId );
		$aryStr .= $_Obj->id . "_" . $_Obj->name . ",";
		while ( $_Obj->pid != 0 ) {
			$_Obj = $this->load ( $_Obj->pid );
			$aryStr .= $_Obj->id . "_" . $_Obj->name . ",";
		}
		$ary = explode ( ",", $aryStr );
		$newAry = array_reverse ( $ary );
		$arySize = count ( $newAry );
		for($i = 0; $i < $arySize; $i ++) {
			$linkAry = explode ( "_", $newAry [$i] );
			
			if ($mid == 1) {
				$href = $urlObj->getNewsList ( $linkAry [0], 1 );
				$linkStr .= "<A href=\"" . $href . "\">" . $linkAry [1] . "</A> / ";
			} else {
				$href = $urlObj->getPictureList ( $linkAry [0], 1 );
				$linkStr .= "<A href=\"" . $href . "\">" . $linkAry [1] . "</A> / ";
			}
		}
		return $linkStr;
	}
	
	public function checkHaveRow($cid) {
		$categoryObj = get ( "category", $cid );
		if ($categoryObj->mid == 1) {
			$sql = "select * from " . TABLEPRE . "news where classid='$cid' limit 1";
		} else if ($categoryObj->mid == 2) {
			$sql = "select * from " . TABLEPRE . "picture where classid='$cid' limit 1";
		} else {
			$modelObj = get ( "model", $categoryObj->mid );
			$modelName = $modelObj->tablename;
			$sql = "select * from " . $modelName . " where pid='$cid' limit 1";
		}
		$rt = $this->db->query ( $sql );
		$row = mysql_fetch_array ( $rt );
		$haveNews = false;
		if (! $row) {
			$haveNews = false;
		} else {
			$haveNews = true;
		}
		return $haveNews;
	}
	
	public function checkHaveChild($id) {
		if ($id == 0) {
			return false;
		}
		$sql = "select id from " . $this->table . " where pid='$id' limit 1";
		$rt = $this->db->query ( $sql );
		$row = mysql_fetch_array ( $rt );
		$haveChild = false;
		if (! $row) {
			$haveChild = false;
		} else {
			$haveChild = true;
		}
		return $haveChild;
	}
	
	public function deleteCategoryById($id) {
		$this->db->Delete ( $this->table, $this->PRI, $id );
	}
	
	public function getModuleName($mid) {
		$modelObj = get ( "model", $mid );
		return $modelObj->modelname;
	}
	
	public function getCids($classId) {
		$childAry = $this->query ("select id from tc_category where pid = " . $classId );
		$this->where = '';
		$arySize = count ( $childAry );
		$aryStr = "";
		for($i = 0; $i < $arySize; $i ++) {
			$aryStr .= $childAry [$i] ["id"] . ",";
		}
		$aryStr = substr ( $aryStr, 0, strlen ( $aryStr ) - 1 );
		return $aryStr;
	}
	
	public function getMenus($cid) {
		$ary = $this->query ( "select * from tc_category where isleft=1 and pid=" . $cid . " order by rank desc" );
		return $ary;
	}
	
	public function saveGorys($cateStr, $mid, $cid) {
		$cateAry = explode ( ",", $cateStr );
		if (empty ( $cateAry )) {
			return false;
		}
		$str = '';
		foreach ( $cateAry as $kk => $vv ) {
			$cates = M ( "menu_rel" );
			$cates->mid = $mid;
			$ary = $cates->query ( "select * from tc_menu_rel where gid='" . $vv . "'" );
			if (empty ( $ary )) { //新词 tags表只增加不减少
				$cates->gid = $vv;
				$cates->cid = $cid;
				$cates_id = $cates->save ();
			}
			$str .= "'" . $vv . "',";
		}
		$str = rtrim ( $str, "," );
		$this->query ( "delete from tc_menu_rel where mid={$mid} and gid not in({$str})" );
		return true;
	}
	/*
    说明:获取菜单列表（一级）
    作者:jiangxiaowu
    时间:2016-11-1
    */
	public function getCategoryListNoCURD($_Obj) {
		$mid = $_GET ["mid"];
		$where = "pid = 0";
		if (! empty ( $mid )) {
			$where .= ' and mid = ' . $mid;
		}
		//$this->where('pid = 0 and mid = '.$mid);
		$this->pageSize = 1000;
		$moduleAry = $this->where ( $where )->getList ();
		foreach ( $moduleAry as $key => $value ) {
			$moduleAry [$key] ['son'] = $this->getCListNoCURD ( $_Obj, $value ['id'], 4 );
		}
		return $moduleAry;
	}
	
	/*
    说明:获取菜单列表（二级）
    作者:jiangxiaowu
    时间:2016-11-1
    */
	public function getCListNoCURD($_Obj, $pId, $times) {
		$this->where = '';
		$where = ' pid=' . $pId;
		$this->where ( $where )->orderby ( '  pid asc' );
		$this->pageSize = 1000;
		$moduleAry = $this->getList ();
		
		return $moduleAry;
	}
	
	/**
	 * [ifHaveRow description]
	 * @Describe=>判断是否有数据
	 * @Author=>jiangxiaowu
	 * @DateTime=>2016-11-01T22:28:35+0800
	 * @param                              [type] $powerid [description]
	 * @param                              [type] $groupid [description]
	 * @return                             [type]          [description]
	 */
	public function ifHaveRow($cid, $gid) {
		$sql = "select id from " . TABLEPRE . "menu_rel where gid=" . $gid . " and cid=" . $cid;
		return $this->ifExists ( $sql, 1 );
	}
}

