﻿using System;
using System.Xml;
using System.Data;
using System.Data.SqlClient;

namespace WebUI.AjaxSearchSystem
{
    /// <summary>
    /// SearchMethod 的摘要说明。
    /// </summary>
    public class AjaxSearchMethod
    {
        private string[] TEXT_OP = new string[] { "相似于|Like", "不相似于|Not Like" };
        private string[] CHAR_OP = new string[] { "等于|=", "不等于|<>", "相似于|Like", "不相似于|Not Like" };
        private string[] NUM_OP = new string[] { "大于|>", "大于或等于|>=", "等于|=", "不等于|<>", "小于|<", "小于或等于|<=" };
        private string[] DATE_OP = new string[] { "等于|=", "不等于|<>", "先于|<", "后于|>" };
        AjaxSearchEnty XmlFileEnty1 = new AjaxSearchEnty();
        public AjaxSearchMethod()
        { }

        /// <summary>
        /// 根据表名获取包含的字段
        /// </summary>
        /// <param name="table">表名</param>
        /// <returns></returns>
        public string GetXmlFileName(AjaxSearchEnty XmlFileEnty)
        {
            string xmlfile = XmlFileEnty.XmlFileName;
            return xmlfile;
        }
        [AjaxPro.AjaxMethod]
        public string[] GetFields(string table, string xmlfilename)
        {
            string[] strArrFields = null;
            string XmlFileNAme = "AJAXXmlFile\\" + xmlfilename;
            try
            {
                XmlDocument xd = LoadXml(@"\" + XmlFileNAme);
                XmlElement xe = xd.DocumentElement;
                XmlNode xn = xe.SelectSingleNode("descendant::Table[@value='" + table + "']");
                XmlNodeList xnl = xn.ChildNodes;
                int iLen = xnl.Count;
                strArrFields = new string[iLen];

                int iIndex = 0;

                foreach (XmlNode xnField in xnl)
                {
                    strArrFields[iIndex] = xnField.Attributes["Name"].InnerText + "|" + xnField.Attributes["Value"].InnerText;
                    iIndex++;
                }
            }
            catch (Exception ee)
            {
                throw new ArgumentOutOfRangeException("@" + XmlFileNAme, "/Table[@value='" + table + "']：指定的接点不存在，请重新定义XML文档！");
            }
            return strArrFields;
        }

        /// <summary>
        /// 根据字段获取对应的操作符列表
        /// </summary>
        /// <param name="field"></param>
        /// <returns></returns>
        [AjaxPro.AjaxMethod]
        public string[] GetOpts(string table, string field, string xmlfilename)
        {
            string strTypeofField = GetTypeofField(table, field, xmlfilename);

            switch (strTypeofField)
            {
                case "char":
                    return CHAR_OP;
                    break;
                case "text": return TEXT_OP;
                case "int":
                    if (GetEnumField(table, field, xmlfilename) == null)
                    {
                        return NUM_OP;
                    }
                    else
                    {
                        return (new string[] { "是|=", "不是|<>" });
                    }

                    break;
                case "decimal":
                    return NUM_OP;
                    break;
                case "datetime":
                    return DATE_OP;
                    break;
                default:
                    return (new string[] { "等于|=" });
                    break;
            }
        }

        /// <summary>
        /// 根据字段获取对应的可能存在的枚举值列表

        /// </summary>
        /// <param name="field"></param>
        /// <returns></returns>
        [AjaxPro.AjaxMethod]
        public string[] GetEnums(string table, string field, string xmlfilename)
        {
            string strTypeofField = GetTypeofField(table, field, xmlfilename);
            string[] enums = GetEnumField(table, field, xmlfilename);

            int iLen = enums == null ? 0 : enums.Length;

            string[] result = new string[iLen + 1];

            result[0] = strTypeofField;

            if (iLen == 0)
            {
                return result;
            }

            int iIndex = 1;

            foreach (string str in enums)
            {
                result[iIndex] = str;
                iIndex++;
            }

            return result;

        }

        #region 内部支持脚本
        //装载XML文档
        private XmlDocument LoadXml(string xmlPath)
        {
            XmlDocument xd = new XmlDocument();

            try
            {
                xd.Load(System.Web.HttpContext.Current.Request.PhysicalApplicationPath + xmlPath);
            }
            catch (XmlException ee)
            {
                throw new ArgumentOutOfRangeException(ee.Message, "读取条件编辑信息失败，请检查XML文档路径设置是否正确！");
            }

            return xd;
        }

        //获取字段的数据类型

        private string GetTypeofField(string table, string field, string xmlfilename)
        {
            string strTypeofField = string.Empty;
            string XmlFileNAme = "AJAXXmlFile\\" + xmlfilename;
            try
            {
                XmlDocument xd = LoadXml(@"\\" + XmlFileNAme);
                XmlElement xe = xd.DocumentElement;
                XmlNode xn = xe.SelectSingleNode("descendant::Table[@value='" + table + "']");
                xn = xn.SelectSingleNode("descendant::Field[@Value='" + field + "']");

                strTypeofField = xn.Attributes["DataType"].InnerText;

            }
            catch (Exception ee)
            {
                throw new ArgumentOutOfRangeException("@" + XmlFileNAme, "/Field[@Value='" + field + "']：指定的接点不存在，请重新定义XML文档！");
            }

            return strTypeofField.ToLower();
        }

        //获取字段的数据类型

        private string[] GetEnumField(string table, string field, string xmlfilename)
        {
            string strTypeofField = string.Empty;
            string strEnumSqlSyntax = string.Empty;
            string strTextField = string.Empty;
            string strValueField = string.Empty;
            string XmlFileNAme = "AJAXXmlFile\\" + xmlfilename;

            try
            {
                XmlDocument xd = LoadXml(@"\" + XmlFileNAme);
                XmlElement xe = xd.DocumentElement;
                XmlNode xn = xe.SelectSingleNode("descendant::Table[@value='" + table + "']");
                xn = xn.SelectSingleNode("descendant::Field[@Value='" + field + "']");
                xn = xn.ChildNodes[0];

                if (xn == null)
                {
                    return null;
                }
                else
                {
                    strEnumSqlSyntax = xn.Attributes["SqlSyntax"] == null ? "" : xn.Attributes["SqlSyntax"].InnerText;
                    strTextField = xn.Attributes["TextField"] == null ? "" : xn.Attributes["TextField"].InnerText;
                    strValueField = xn.Attributes["ValueField"] == null ? "" : xn.Attributes["ValueField"].InnerText;
                }

                return GetEnumField1(strEnumSqlSyntax, strTextField, strValueField);
            }
            catch (NullReferenceException ee)
            {
                throw new ArgumentOutOfRangeException("@" + XmlFileNAme, "/Field[@Value='" + field + "']：指定的接点不存在，请重新定义XML文档！");
            }
        }

        private string[] GetEnumField1(string sqlSyntax, string text, string value)
        {

            if (sqlSyntax.Length == 0 || text.Length == 0 || value.Length == 0)
            {
                return null;
            }

            DataSet ds = DSZQ.DataAccess.DataSet(sqlSyntax);
            DataTable dt = ds.Tables[0];
            if (dt == null)
            {
                return null;
            }

            DataRowCollection drc = dt.Rows;

            string[] enumFields = new string[drc.Count];
            int iIndex = 0;

            foreach (DataRow dr in drc)
            {
                enumFields[iIndex] = dr[text].ToString().Trim() + "|" + dr[value].ToString().Trim();
                iIndex++;
            }

            return enumFields;
        }
        #endregion
    }
}
