﻿<%@ Page Language="C#" AutoEventWireup="true"%>
<%@ Import namespace="System" %>
<%@ Import namespace="System.Data" %>
<%@ Import namespace="CNVP.Framework.Config" %>
<%@ Import namespace="CNVP.Framework.Helper" %>
<%@ Import namespace="CNVP.Framework.Utils" %>
<%@ Import namespace="CNVP.CMS.Publish" %>
<%
    string _ColumnID = Request.Params["ColumnID"];
    string _NewsID = Request.Params["NewsID"];
    string _SiteID = Request.Params["SiteID"];
    bool IsCache = true;
    string TemplateFilePath = string.Empty;
    #region "JCms1.3.2 站点有效性判断"
    if ((!string.IsNullOrEmpty(_ColumnID)) && (!string.IsNullOrEmpty(_SiteID)))
    {
        int _CurrentParentID = new CNVP.CMS.Data.Column().GetParentID(Convert.ToInt32(_ColumnID));
        if (!(new CNVP.CMS.Data.SiteInfo().IsExist(_CurrentParentID, _SiteID, true)))
        {
            Response.Write("<script>alert('该站点不存在哦，请检查站点标识是否正确。');history.back();</script>");
            Response.End();
        }
    }
    #endregion
    
    if (string.IsNullOrEmpty(_NewsID) || (!Public.IsNumber(_NewsID)))
    {
        _NewsID = "0";
    }
    CNVP.CMS.Data.NewsInfo bll_NewsInfo = new CNVP.CMS.Data.NewsInfo();
    DataTable Dt_NewsInfo = bll_NewsInfo.GetNewsInfo(Convert.ToInt32(_NewsID));
    if (Dt_NewsInfo != null && Dt_NewsInfo.Rows.Count > 0)
    {
        //只允许会员浏览
        if (Dt_NewsInfo.Rows[0]["ISMember"].ToString() == "1")
        {
            IsCache = false;

            //判断会员登录状态
            if (!CNVP.Framework.UI.UserPage.LoginIn())
            {
                StringBuilder Str = new StringBuilder();
                Str.Append("<script language='javascript' type='text/javascript'>\r\n");
                Str.Append("var ThisURL = document.location.href;\r\n");
                Str.Append(string.Format("window.location.href='{0}User/Login.aspx?GoToUrl='+ThisURL", UIConfig.InstallDir));
                Str.Append("</script>");
                Response.Write(Str.ToString());
                Response.End();
            }

            //判读会员浏览权限
            CNVP.CMS.Data.UserPermissions bll_NewsPermissions = new CNVP.CMS.Data.UserPermissions();
            if (!bll_NewsPermissions.NewsCheckGroup(Convert.ToInt32(_NewsID), new CNVP.CMS.JCmsAjax.GetUserInfo().UserGroupID))
            {
                Response.Redirect(UIConfig.InstallDir + "Error.aspx?Error=2");
                Response.End();
            }
        }
        if (CNVP.Framework.UI.UserPage.LoginIn()) { IsCache = false; }
        CNVP.CMS.Data.IPAllow bll_ipallow = new CNVP.CMS.Data.IPAllow();
        //只允许在内网显示
        if (Dt_NewsInfo.Rows[0]["ISInShow"].ToString() == "1" && (!bll_ipallow.ISAllow("Intranet")))
        {
            IsCache = false;
            Response.Redirect(UIConfig.InstallDir + "Error.aspx?Error=1");
            Response.End();
        }
    }
    #region "数据缓存"
    if ((UIConfig.AutoCache == "1") && (IsCache))
    {
        if (CNVP.Cache.CacheUtils.FileCacheProgress()) { return; }
    }
    #endregion
    Template bll_Template = new Template();
    string _NewsContent = General.ReadHtml(Convert.ToInt32(_ColumnID), 2, UIConfig.TemplateDir, out TemplateFilePath);
    bll_Template.TemplateDir = UIConfig.TemplateDir;
    bll_Template.TemplateFilePath = TemplateFilePath;
    bll_Template.TemplatePublish = true;
    bll_Template.TemplateContent = _NewsContent;
    bll_Template.ModuleType = 2;
    bll_Template.ColumnID = _ColumnID;
    bll_Template.NewsID = _NewsID;
    bll_Template.SiteID = _SiteID;
    bll_Template.ReplaceLabels();
    Response.Write(CNVP.CMS.Publish.General.HeadRight);
    //智能压缩HTML
    if (UIConfig.FileCompression == "1")
    {
        Response.Write(Public.FilterBlank(bll_Template.TemplateContent));
    }
    else
    {
        Response.Write(bll_Template.TemplateContent);
    }
    Response.Write(CNVP.CMS.Publish.General.CopyRight);
%>