﻿var READY_STATE_UNINITIALIZED = 0;
var READY_STATE_LOADING = 1;
var READY_STATE_LOADED = 2;
var READY_STATE_INTERACTIVE = 3;
var READY_STATE_COMPLETE = 4;

var globalHandle = 0;
var globalObjects = {};
var contentVersion = "2009110301";

function setElementText(element, text) {
    if (typeof (element) == "undefined") return;
    text = text ? text : "";
    if (typeof (element.textContent) != "undefined")
        element.textContent = text;
    else (typeof (element.innerText) != "undefined")
    element.innerText = text;
}

function JCmsContent(rootTitle, rootText,rootUrl, rootSource,
	rootReader, rootVisible, target) {
    this.execActionUrl = "";
    this.rootVisible = rootVisible;
    this.searchHint = "";
    this.key = "";
    this.speed = 0;
    this.searchActive = false;
    this.selectedNode = null;
    this.defaultNode = null;
    this.hodgepodgeNode = null;
    this.bookmarkNode = null;
    this.homeNode = null;
    this.target = target;
    this.root = this.appendChildNode(null, "root", rootTitle, rootText, "", rootUrl, rootSource, rootReader, true);
    this.root.doChange();
}

JCmsContent.prototype.appendChildNode = function(
	parent, alias, title, text, flag, url, source, reader, expand, hide, selected, target) {
    var node = new JCmsContentNode(
		this, parent, alias, title, text, flag, url,source, reader, expand, hide, selected, target);
    if (node.selected == "true") {
        this.defaultNode = node;
        this.setSelectedNode(this.defaultNode);
    }
    return node;
}

JCmsContent.prototype.setSelectedNode = function (node) {
    if (this.selectedNode == node) return;
    if (this.selectedNode)
        this.selectedNode.setSelected(false);
    this.selectedNode = node;
    if (this.selectedNode)
        this.selectedNode.setSelected(true);
}

JCmsContent.prototype.execAction = function(action, alias)
{
	var xmlhttp = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP")
	if (xmlhttp == null) return;
	try
	{
		xmlhttp.open("get", this.execActionUrl + "?action=" + action + "&alias=" + alias);
	}
	catch (e)
	{
		xmlhttp = null;
		return;
	}
	xmlhttp.onreadystatechange = function()
	{
		if (!xmlhttp) return;
		if (xmlhttp.readyState == READY_STATE_COMPLETE)
		{
            if (xmlhttp.responseText && xmlhttp.responseText.substr(0, 1) == "{")
            {
                eval("var resultInfo = " + xmlhttp.responseText + ";");
                if (typeof(resultInfo.info) == "string")
		            alert(resultInfo.info);
		        else if (typeof(resultInfo.error) == "string")
		            alert(resultInfo.error);
		    }
			xmlhttp = null;
		}
	}
	xmlhttp.send(null);
}

function JCmsContentNode(content, parent, alias, title, text, flag, url, source, reader, expand, hide, selected, target) {
    this.alias = alias;
    this.handle = globalHandle++;
    globalObjects[this.handle] = this;

    this.content = content;
    this.source = source;
    this.target = target;
    this.reader = typeof (reader) == "undefined" || !reader ? "js" : reader;
    this.loaded = false;
    this.loading = false;
    this.expand = expand;
    this.flag = flag;
    this.url = url;
    this.level = parent == null ? 0 : parent.level + 1;
    this.title = typeof (title) == "undefined" || !title ? text : title;
    this.text = text;
    this.parent = parent;
    this.hot = false;
    this.nodes = [];
    this.hide = hide;
    this.selected = selected;

    this.element = document.createElement("div");
    this.element.setAttribute("alias", "node_" + alias);
    if (parent == null)
        document.body.appendChild(this.element);
    else {
        parent.element_nodes.appendChild(this.element);
        parent.nodes.push(this);
    }

    this.element_item = document.createElement("div");
    this.element_item.className = "item";
    this.element.appendChild(this.element_item);

    this.element_table = document.createElement("table");
    this.element_table.cellPadding = "0px";
    this.element_table.cellSpacing = "0px";
    this.element_item.appendChild(this.element_table);
    
    this.element_tr = this.element_table.insertRow(-1);

    this.element_td_label = this.element_tr.insertCell(-1);
    this.element_td_label.noWrap = true;
    this.element_nobr_label = document.createElement("nobr");
    this.element_td_label.appendChild(this.element_nobr_label);

    this.element_space = [];

    for (var i = 0; i < this.level; i++) {
        var space = spaceTemplate.cloneNode(true);
        space.className = "space";
        space.node = this;
        if (i == this.level - 1) {
            space.onclick = function() {
                if (this.node && this.node.content) {
                    this.node.setExpand(!this.node.expand);
                    this.node.content.setSelectedNode(this.node);
                }
            }
        }
        this.element_space.push(space);
        this.element_nobr_label.appendChild(space);
    }

    /*if (this.level > 0) {
        this.element_checkbox = document.createElement("input");
        this.element_checkbox.setAttribute("type", "checkbox");
        this.element_checkbox.setAttribute("id", "inputid");
        this.element_checkbox.setAttribute("name", "inputname");
        this.element_checkbox.setAttribute("value", this.text);
        if (this.flag == "√") {
            this.element_checkbox.setAttribute("checked", "checked");
        }
        this.element_checkbox.className = "notice";
        this.element_nobr_label.appendChild(this.element_checkbox);
    }*/

    this.element_icon = spaceTemplate.cloneNode(true);
    this.element_icon.className = "icon";
    this.element_icon.node = this;
    this.element_icon.onclick = function() {
        if (this.node && this.node.content) {
            this.node.setExpand(!this.node.expand);
            this.node.content.setSelectedNode(this.node);
        }
    }
    this.element_nobr_label.appendChild(this.element_icon);

    this.element_label_a = document.createElement("a");
    this.element_label_a.setAttribute("title", title);
    this.element_label_a.setAttribute("href", this.url);

    if (this.target) {
    	this.element_label_a.setAttribute("target", this.target);
    } else {
    	if (typeof (this.url) == "string" && this.url.length > 0 && this.url != "#" && this.content && this.content.target)
    		this.element_label_a.setAttribute("target", this.content.target);
    }
    this.element_label_a.setAttribute("handle", this.handle);

    setElementText(this.element_label_a, text);
    this.element_label_a.node = this;
    this.element_label_a.onmouseover = label_a_mouseover;
    this.element_label_a.onmouseout = label_a_mouseout;
    this.element_label_a.onclick = function label_a_click() {
        if (this.node && this.node.content) {
            this.node.content.setSelectedNode(this.node);
            if (!this.node.expand) this.node.setExpand(true);
        }
        if (typeof (this.node.url) == "undefined" || this.node.url == "#" || this.node.url == "")
            return false;
    }
    
    this.element_label_a.ondblclick = label_a_dblclick;
    this.element_nobr_label.appendChild(this.element_label_a);

    this.element_flag = document.createElement("span");
    this.element_flag.className = "notice";
    this.element_nobr_label.appendChild(this.element_flag);

    this.element_action = document.createElement("span");
    this.element_action.className = "functionbtn";
    this.element_nobr_label.appendChild(this.element_action);

    this.element_nodes = document.createElement("div");
    this.element.appendChild(this.element_nodes);

    if (this.expand && !this.loaded && this.source)
        this.loadNodes(this.content, this.source);
}

JCmsContentNode.prototype.doChange = function () {
    this.element.style.display = this.hide ? "none" : "";
    this.element_label_a.className = this.selected ? "linkfocus" : "";
    this.element_label_a.setAttribute("title", this.title + (this.error ? "[" + this.error + "]" : ""));
    setElementText(this.element_flag, typeof (this.flag) == "string" ? this.flag : "");
    this.element_item.style.display = (this.parent == null) && this.content && !this.content.rootVisible ? "none" : "";

    this.element_item.className = "item";

    this.element_nodes.style.display = this.expand ? "" : "none";
    var temp = this
    for (var i = this.element_space.length - 1; i >= 0; i--) {
        if (i == this.element_space.length - 1) {
            if (!this.parent ||
                this.parent.nodes[this.parent.nodes.length - 1] == this) {
                if (typeof (this.source) != "string" || !this.source)
                    this.element_space[i].className = "line2";
                else this.element_space[i].className = this.expand ? "minus2" : "plus2";
            }
            else {
                if (typeof (this.source) != "string" || !this.source)
                    this.element_space[i].className = "line1";
                else this.element_space[i].className = this.expand ? "minus1" : "plus1";
            }
        }
        else {
            this.element_space[i].className = temp.parent &&
                temp.parent.nodes.length > 0 &&
                temp.parent.nodes[temp.parent.nodes.length - 1] == temp ? "space" : "line4";
            this.element_space[i].style.cursor = "default";
        }
        temp = temp.parent;
    }

    if (this.loading) {
        this.element_icon.className = "loading";
    }
    else this.element_icon.className = typeof (this.source) != "string" || !this.source ? "icon" :
		(this.expand ? "folderopen" : "folder");

    this.element.style.display = this.hide ? "none" : "";
}

JCmsContentNode.prototype.setFlag = function(flag) {
    if (this.flag == flag) return;
    this.flag = flag;
    this.doChange();
}

JCmsContentNode.prototype.setHide = function(hide) {
    if (this.hide == hide) return;
    this.hide = hide;
    this.doChange();
}

JCmsContentNode.prototype.setHot = function(hot) {
    if (this.hot == hot) return;
    this.hot = hot;
    this.doChange();
}

JCmsContentNode.prototype.setSelected = function (selected) {
    if (this.selected == selected) return;
    this.selected = selected;
    this.doChange();
    if (typeof this.content.onSelectedChange == "function") {
        this.content.onSelectedChange(this)
    }
}

JCmsContentNode.prototype.setExpand = function (expand) {
    if (this.expand == expand) return;
    this.expand = expand;
    if (this.expand && !this.loaded && this.source) {
        this.loadNodes(this.content, this.source);
    }
    this.doChange();
}

JCmsContentNode.prototype.setError = function(error) {
    if (this.error == error) return;
    this.error = error;
    this.doChange();
}

JCmsContentNode.prototype.setLoading = function(loading) {
    if (this.loading == loading) return;
    this.loading = loading;
    this.doChange();
}

JCmsContentNode.prototype.clearNodes = function() {
    for (var i = this.nodes.length - 1; i >= 0; i--) {
        this.nodes[i].clearNodes();
        this.nodes[i].dispose();
    }
    this.nodes = [];
}

JCmsContentNode.prototype.dispose = function() {
    this.element.removeChild(this.element_nodes);
    this.element_nobr_label.removeChild(this.element_action);
    this.element_nobr_label.removeChild(this.element_flag);
    this.element_nobr_label.removeChild(this.element_label_a);
    this.element_nobr_label.removeChild(this.element_icon);
    for (var i = 0; i < this.level; i++) {
        var space = this.element_space.shift();
        this.element_nobr_label.removeChild(space);
    }
    this.element_td_label.removeChild(this.element_nobr_label);
    this.element_item.removeChild(this.element_table);
    this.element.removeChild(this.element_item);

    if (parent == null)
        document.body.removeChild(this.element);
    else {
        this.parent.element_nodes.removeChild(this.element);
        this.parent.nodes.pop();
    }
    globalObjects[this.handle] = null;
}

JCmsContentNode.prototype.copyNodes = function(node) {
    if (!node || !this.content) return;
    for (var i = 0; node.nodes && i < node.nodes.length; i++) {
        var newnode = this.content.appendChildNode(
            this,
            node.nodes[i].alias,
            node.nodes[i].title,
            node.nodes[i].text,
            node.nodes[i].flag,
            node.nodes[i].url,
            node.nodes[i].source,
            node.nodes[i].reader,
            node.nodes[i].target
        );
        newnode.copyNodes(node.nodes[i]);
    }
    this.loaded = node.loaded;
}

var globalLoadNodes = [];
var globalLoading = false;

JCmsContentNode.prototype.doChangeNodes = function(alias) {
    for (var i = 0; i < this.nodes.length; i++) {
        this.nodes[i].doChangeNodes();
        if (typeof (alias) == "undefined" || alias == this.nodes[i] == alias)
            this.nodes[i].doChange();
    }
}

JCmsContentNode.prototype.loadNodes = function(key) {
    if (typeof (this.source) == "undefined" || !this.source ||
    this.loaded || this.source == "#") return;
    this.setLoading(true);
    if (globalLoading) {
        globalLoadNodes.push(this);
        return;
    }

    var node = this;
    if (node.content && node.content.searchNode == node && typeof (key) != "string")
        key = "";

    var xmlhttp = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject("Microsoft.XMLHTTP");
    if (xmlhttp == null) return;
    try {
        if (typeof (key) == "string")
            var keyUri = encodeURI(key).replace(/\+/g, "%2B").replace(/\&/g, "%26").replace(/\#/g, "%23");
        xmlhttp.open("get", node.source + (node.source.indexOf("?") < 0 ? "?" : "&") +
            "version=" + contentVersion + (node.nocache ? "&_t_=" + new Date().getTime().toString(36) : "") +
            (typeof (key) == "string" ? "&key=" + keyUri : ""), true);
    }
    catch (e) {
        node.setError("载入错误");
        xmlhttp = null;
        return;
    }
    xmlhttp.onreadystatechange = function() {
        if (!xmlhttp) return;
        if (xmlhttp.readyState == READY_STATE_COMPLETE) {
            var loadinfo = null;
            switch (node.reader) {
                case "xml":
                    if (xmlhttp.responseXML)
                        loadinfo = node.loadNodesFromXml({}, xmlhttp.responseXML.documentElement);
                    break;
                case "js":
                    if (xmlhttp.responseText && xmlhttp.responseText.substr(0, 1) == "{")
                        eval("var loadinfo = node.loadNodesFromJson(" + xmlhttp.responseText + ");");
                    break;
            }

            if (loadinfo != null) {
                if (typeof (key) == "string" && node.content &&
                    node.content.searchNode == node)
                    node.content.searchBuffer[key] = loadinfo;
                node.loaded = true;
                node.setError(null);
                if (node == node.content.bookmarkNode)
                    node.parent.doChangeNodes();
                else node.doChangeNodes();
            } else node.setError("载入错误");
            xmlhttp = null;
            globalLoading = false;
            node.setLoading(false);
            var temp = globalLoadNodes.shift();
            if (temp) temp.loadNodes();
        }
    }
    globalLoading = true;
    xmlhttp.send(null);
}

JCmsContentNode.prototype.loadNodesFromXml = function(jsonnode, xmlnode) {
    if (!jsonnode || !xmlnode || this.loaded ||
    !this.content || xmlnode.tagName != "node") return null;
    this.clearNodes();
    jsonnode.sum = xmlnode.getAttribute("sum");
    jsonnode.key = xmlnode.getAttribute("key");
    jsonnode.nodes = [];
    for (var i = 0; i < xmlnode.childNodes.length; i++) {
        if (xmlnode.childNodes[i].tagName != "nodes") continue;
        var xmlnodes = xmlnode.childNodes[i];
        for (var j = 0; j < xmlnodes.childNodes.length; j++) {
            var xmlchild = xmlnodes.childNodes[j];
            if (xmlchild.tagName != "node") continue;
            var item = {};
            item.alias = xmlchild.getAttribute("alias"),
            item.title = xmlchild.getAttribute("title"),
            item.text = xmlchild.getAttribute("text"),
            item.flag = xmlchild.getAttribute("flag"),
            item.url = xmlchild.getAttribute("url"),
            item.source = xmlchild.getAttribute("source"),
            item.reader = xmlchild.getAttribute("reader"),
            item.expand = xmlchild.getAttribute("expand"),
            item.hide = xmlchild.getAttribute("hide"),
            item.selected = xmlchild.getAttribute("selected")
            item.nodes = [];

            var childNode = this.content.appendChildNode(this,
                item.alias,
                item.title,
                item.text,
                item.flag,
                item.url,
                item.source,
                item.reader,
                item.expand,
                item.hide,
                item.selected,
                item.target
            );

            childNode.loadNodesFromXml(item, xmlchild);
            if (item.nodes.length > 0) {
                childNode.source = "#";
                childNode.loaded = true;
                childNode.doChange();
            }
            jsonnode.nodes.push(item);
        }
    }
    return jsonnode;
}

JCmsContentNode.prototype.loadNodesFromJson = function (jsonnode, key) {
    if (!jsonnode || this.loaded || !this.content) return null;
    this.clearNodes();
    for (var i = 0; jsonnode.nodes && i < jsonnode.nodes.length; i++) {
        var item = jsonnode.nodes[i];
        if (typeof (item) == "undefined") continue;
        if (typeof (key) == "string" && key && item.text &&
            item.text.toLowerCase().indexOf(key) < 0) continue;
        var childNode = this.content.appendChildNode(this,
            item.alias,
            item.title,
            item.text,
            item.flag,
            item.url,
            item.source,
            item.reader,
            item.expand,
            item.hide,
            item.selected,
            item.target
        );
        childNode.loadNodesFromJson(item);
        if (item.nodes && item.nodes.length > 0) {
            childNode.source = "#";
            childNode.loaded = true;
            childNode.doChange();
        }
    }
    return jsonnode;
}

function button_click() {
    var node = globalObjects[this.getAttribute("handle")];
    if (node && node.content) {
        node.setExpand(!node.expand);
        node.content.setSelectedNode(node);
    }
    return false;
}

function label_a_dblclick() {
    var node = globalObjects[this.getAttribute("handle")];
    if (node && node.content) {
        node.setExpand(!node.expand);
        node.content.setSelectedNode(node);
    }
}

function label_a_mouseover() {
    var node = globalObjects[this.getAttribute("handle")];
    if (node) node.setHot(true);
}

function label_a_mouseout() {
    var node = globalObjects[this.getAttribute("handle")];
    if (node) node.setHot(false);
}