﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StatisticsProToCol.aspx.cs" Inherits="CNVP.CMS.Admin.Statistics.StatisticsProToCol" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="CNVP.Framework.Config" %>
<%@ Import Namespace="CNVP.Framework.Helper" %>
<%@ Import Namespace="CNVP.Framework.Utils" %>
<script language="c#" runat="server">
    protected void btHighExport_Click(object sender, EventArgs e)
    {
        _HotSearch = Public.FilterSql(txtHotSearch1.Text.Trim());
        _TimeStart = Public.FilterSql(TimeStart.Text);
        _TimeEnd = Public.FilterSql(TimeEnd.Text);
        _ISShow = ddlISShow.SelectedValue;
        _ISAuditing = ddlISAuditing.SelectedValue;
        _ISPublish = ddlISPublish.SelectedValue;
        _ISMember = ddlISMember.SelectedValue;
        _ISInShow = ddlISInShow.SelectedValue;
        _ISBest = ddlISBest.SelectedValue;
        _ISHot = ddlISHot.SelectedValue;
        _ISTop = ddlISTop.SelectedValue;
        _ISImages = Public.FilterSql(Request.Params["ISImages"]);
        _OrderType = ddlOrderType.SelectedValue;
        _ISOrder = ddlISOrder.SelectedValue;


        string StrWhere = "select count(*) as countNum, isnull(AdminID,0) as AdminID, isnull(AdminName,'未知') as AdminName from " + DBConfig.Prefix + "NewsInfo as a left join " + DBConfig.Prefix + "Admin as b on a.AuthorID = b.AdminID Where 1=1";
        if (!string.IsNullOrEmpty(_HotSearch))
        {
            StrWhere += " And AdminName Like '%" + _HotSearch + "%'";
        }

        #region "时间检索"

        if ((!string.IsNullOrEmpty(_TimeStart)) && (!string.IsNullOrEmpty(_TimeEnd)))
        {
            StrWhere += string.Format(
                " And DateDiff(Day,'{0}',a.PostTime)>=0 And DateDiff(Day,'{1}',a.PostTime)<=0", _TimeStart, _TimeEnd);
        }

        #endregion

        #region "属性检索"
        switch (_ISShow)
        {
            case "0":
                StrWhere += " And a.ISShow=0";
                break;
            case "1":
                StrWhere += " And a.ISShow=1";
                break;
        }
        switch (_ISAuditing)
        {
            case "0":
                StrWhere += " And a.ISAuditing=0";
                break;
            case "1":
                StrWhere += " And a.ISAuditing=1";
                break;
            case "-1":
                StrWhere += " And a.ISAuditing=-1";
                break;
        }
        switch (_ISPublish)
        {
            case "0":
                StrWhere += " And a.ISPublish=0";
                break;
            case "1":
                StrWhere += " And a.ISPublish=1";
                break;
        }
        switch (_ISMember)
        {
            case "0":
                StrWhere += " And a.ISMember=0";
                break;
            case "1":
                StrWhere += " And a.ISMember=1";
                break;
        }
        switch (_ISInShow)
        {
            case "0":
                StrWhere += " And a.ISInShow=0";
                break;
            case "1":
                StrWhere += " And a.ISInShow=1";
                break;
        }
        switch (_ISBest)
        {
            case "0":
                StrWhere += " And a.ISBest=0";
                break;
            case "1":
                StrWhere += " And a.ISBest=1";
                break;
        }
        switch (_ISHot)
        {
            case "0":
                StrWhere += " And a.ISHot=0";
                break;
            case "1":
                StrWhere += " And a.ISHot=1";
                break;
        }
        switch (_ISTop)
        {
            case "0":
                StrWhere += " And a.ISTop=0";
                break;
            case "1":
                StrWhere += " And a.ISTop=1";
                break;
        }
        switch (_ISImages)
        {
            case "0":
                StrWhere += " And a.ISImages=0";
                break;
            case "1":
                StrWhere += " And a.ISImages=1";
                break;
        }

        #endregion

        StrWhere += " group by AdminID, AdminName";
        DataTable dtAll = null;
        DataTable dtNew = DbHelper.ExecuteTable(StrWhere);
        dtNew.Columns.Add("CountAuditing24", Type.GetType("System.Int64"));//本地动态
        dtNew.Columns.Add("CountAuditing26", Type.GetType("System.Int64"));//喜讯报道
        dtNew.Columns.Add("CountAuditing68", Type.GetType("System.Int64"));//学前教育
        dtNew.Columns.Add("CountAuditing66", Type.GetType("System.Int64"));//义务教育
        dtNew.Columns.Add("CountAuditing67", Type.GetType("System.Int64"));//职(高)教育
        dtNew.Columns.Add("CountAuditing", Type.GetType("System.Int64"));//总数
        if (dtNew != null && dtNew.Rows.Count > 0)
        {
            foreach (DataRow dr in dtNew.Rows)
            {
                int CountAuditing24 = this.GetcountAuditing(Convert.ToInt32(dr["AdminID"]), 24);
                int CountAuditing26 = this.GetcountAuditing(Convert.ToInt32(dr["AdminID"]), 26);
                int CountAuditing68 = this.GetcountAuditing(Convert.ToInt32(dr["AdminID"]), 68);
                int CountAuditing66 = this.GetcountAuditing(Convert.ToInt32(dr["AdminID"]), 66);
                int CountAuditing67 = this.GetcountAuditing(Convert.ToInt32(dr["AdminID"]), 67);
                int CountAuditing = CountAuditing24 + CountAuditing26 + CountAuditing68 + CountAuditing66 + CountAuditing67;

                dr["CountAuditing24"] = CountAuditing24;
                dr["CountAuditing26"] = CountAuditing26;
                dr["CountAuditing68"] = CountAuditing68;
                dr["CountAuditing66"] = CountAuditing66;
                dr["CountAuditing67"] = CountAuditing67;
                dr["CountAuditing"] = CountAuditing;
            }
            DataView dv = dtNew.DefaultView;

            #region "排序"

            switch (_OrderType)
            {
                case "CountAuditing24":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing24 ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing24 DESC";
                            break;
                    }
                    break;
                case "CountAuditing26":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing26 ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing26 DESC";
                            break;
                    }
                    break;
                case "CountAuditing68":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing68 ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing68 DESC";
                            break;
                    }
                    break;
                case "CountAuditing66":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing66 ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing66 DESC";
                            break;
                    }
                    break;
                case "CountAuditing67":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing67 ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing67 DESC";
                            break;
                    }
                    break;
                case "CountAuditing":
                    switch (_ISOrder)
                    {
                        case "ASC":
                            dv.Sort = " CountAuditing ASC";
                            break;
                        case "DESC":
                            dv.Sort = " CountAuditing DESC";
                            break;
                    }
                    break;
            }

            #endregion

            dtAll = dv.ToTable();


            DataTable data = dtAll;
            string fileName = "按人员横向统计-" + DateTime.Now.ToString("yyyyMMdd");
            string[] DataColumn = { "姓名", "本地动态", "喜讯报道", "学前教育", "义务教育", "职(高)教育", "总数" };
            try
            {
                if (data != null && data.Rows.Count > 0)
                {
                    HttpContext.Current.Response.ContentType = "application/vnd.ms-excel";
                    HttpContext.Current.Response.ContentEncoding = System.Text.Encoding.UTF8;
                    HttpContext.Current.Response.Charset = "Utf-8";
                    HttpContext.Current.Response.AppendHeader("Content-Disposition",
                        "attachment;filename=" + HttpUtility.UrlEncode(fileName + ".xls", System.Text.Encoding.UTF8));

                    StringBuilder sbHtml = new StringBuilder();
                    sbHtml.AppendLine("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
                    sbHtml.AppendLine("<table cellspacing=\"0\" cellpadding=\"5\" rules=\"all\" border=\"1\">");

                    //写出列名
                    sbHtml.AppendLine(
                        "<tr style=\"background-color: #FFE88C;font-weight: bold; white-space: nowrap;\">");

                    foreach (string item in DataColumn)
                    {
                        sbHtml.AppendLine("<td>" + item + "</td>");
                    }
                    sbHtml.AppendLine("</tr>");

                    //写数据
                    foreach (System.Data.DataRow row in data.Rows)
                    {
                        sbHtml.Append("<tr>");

                        sbHtml.Append("<td>").Append(row["AdminName"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing24"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing26"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing68"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing66"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing67"].ToString()).Append("</td>");
                        sbHtml.Append("<td>").Append(row["CountAuditing"].ToString()).Append("</td>");
                        sbHtml.AppendLine("</tr>");
                    }
                    sbHtml.AppendLine("</table>");
                    HttpContext.Current.Response.Write(sbHtml.ToString());
                    HttpContext.Current.Response.End();
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write("Excel导出数据异常", "-----------Excel导出数据异常-----------\r\n" + ex.ToString() + "\r\n");
            }
        }
    }
</script> 
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<title></title>
<link type="text/css" href="../Images/Global.css" rel="stylesheet"/>
<link type="text/css" href="../common/option.css" rel="stylesheet"/>
<link type="text/css" href="../common/thickbox.css" rel="stylesheet"/>
<script type="text/javascript" language="javascript" src="../common/jquery.js"></script>
<script language="javascript" src="../common/jquery.maskinput.js"></script>
<script type="text/javascript" language="javascript" src="../common/thickbox.js"></script>
<script type="text/javascript" language="javascript" src="../common/option.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $(".list_tb tr").mouseover(function () {
            $(this).addClass("over");
        }).mouseout(function () {
            $(this).removeClass("over");
        })
        $(".list_tb tr:even").addClass("alt");
        $("#TimeStart").mask("9999-99-99", { completed: function () { CheckDate($(this).get(0), $(this).val(), 'date', false); } });
        $("#TimeEnd").mask("9999-99-99", { completed: function () { CheckDate($(this).get(0), $(this).val(), 'date', false); } });
    });
</script> 
</head>
<body>
<form id="form1" runat="server">
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td class="cell_group"><img src="../Images/ListIconTitle.jpg" />&nbsp;您的位置：工作统计 > 按人员横向统计</td>
</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td style="height:5px"></td>
</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td>
</td>
<td width="240" align="right" style="padding-right:2px">
    <asp:TextBox ID="txtHotSearch" runat="server" CssClass="list_search_input" MaxLength="20"></asp:TextBox>
</td>
<td width="60" align="right">
    <asp:Button ID="btSearch" runat="server"  CssClass="list_search_btn" Text="检 索" OnClick="btSearch_Click" />
</td>
<td width="70" align="center"><a href="#" onclick="showQueDetail(true);" class="link_quedetail">高级检索</a></td>
</tr>
</table>
<div id="div_quedetail" class="div_quedetail_cms">
<table width="100%" align="center" cellspacing="0" cellpadding="0">
<tr>
<td colspan="4" align="right"><img src="../images/ListClose.gif" onclick="showQueDetail(false);" style="cursor:hand" title="关闭检索"/></td>
</tr>
<tr>
<td height="30">姓 名：</td>
<td colspan="3">
    <asp:TextBox ID="txtHotSearch1" runat="server" CssClass="list_search_input" MaxLength="20" style="width:263px" ></asp:TextBox></td>
</tr>
<tr>
<td height="30">开始时间：</td>
<td>
    <asp:TextBox ID="TimeStart" runat="server" CssClass="list_search_input" style="width:76px"></asp:TextBox>

</td>
<td align="right">(到)结束时间：</td>
<td>
     <asp:TextBox ID="TimeEnd" runat="server" CssClass="list_search_input" style="width:76px"></asp:TextBox>
    </td>
</tr>
<tr>
<td height="30">文章属性：</td>
<td>
 <asp:DropDownList ID="ddlISShow" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否显示</asp:ListItem>
        <asp:ListItem Value="1">显示状态</asp:ListItem>
        <asp:ListItem Value="0">隐藏状态</asp:ListItem>
    </asp:DropDownList>
</td>
<td align="center">
     <asp:DropDownList ID="ddlISAuditing" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否审核</asp:ListItem>
        <asp:ListItem Value="1">已经审核</asp:ListItem>
        <asp:ListItem Value="0">还未审核</asp:ListItem>
        <asp:ListItem Value="-1">未通过审核</asp:ListItem>
    </asp:DropDownList>
</td>
<td>
    <asp:DropDownList ID="ddlISPublish" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否发布</asp:ListItem>
        <asp:ListItem Value="1">已经发布</asp:ListItem>
        <asp:ListItem Value="0">还未发布</asp:ListItem>
    </asp:DropDownList>
</td>
</tr>
<tr>
<td height="30"></td>
<td>
    <asp:DropDownList ID="ddlISMember" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否会员</asp:ListItem>
        <asp:ListItem Value="1">会员文章</asp:ListItem>
        <asp:ListItem Value="0">非会员文章</asp:ListItem>
    </asp:DropDownList>
</td>
<td align="center">
    <asp:DropDownList ID="ddlISInShow" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否内网</asp:ListItem>
        <asp:ListItem Value="1">内网文章</asp:ListItem>
        <asp:ListItem Value="0">非内网文章</asp:ListItem>
    </asp:DropDownList>
</td>
<td>
    <asp:DropDownList ID="ddlISBest" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否推荐</asp:ListItem>
        <asp:ListItem Value="1">推荐文章</asp:ListItem>
        <asp:ListItem Value="0">非推荐文章</asp:ListItem>
    </asp:DropDownList>
</td>
</tr>
<tr>
<td height="30"></td>
<td>
    <asp:DropDownList ID="ddlISHot" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否热门</asp:ListItem>
        <asp:ListItem Value="1">热门文章</asp:ListItem>
        <asp:ListItem Value="0">非热门文章</asp:ListItem>
    </asp:DropDownList>
</td>
<td align="center">
    <asp:DropDownList ID="ddlISTop" runat="server"  style="width:80px">
        <asp:ListItem Value="">是否置顶</asp:ListItem>
        <asp:ListItem Value="1">置顶文章</asp:ListItem>
        <asp:ListItem Value="0">非置顶文章</asp:ListItem>
    </asp:DropDownList>
</td>
<td>
</td>
</tr>
<tr>
    <td height="30" >排序范围：</td>
    <td>
        <asp:DropDownList ID="ddlOrderType" runat="server" style="width:80px">
            <asp:ListItem Value="">选择排序范围</asp:ListItem>
            <asp:ListItem Value="CountAuditing24">本地动态</asp:ListItem>
            <asp:ListItem Value="CountAuditing26">喜讯报道</asp:ListItem>
            <asp:ListItem Value="CountAuditing68">学前教育</asp:ListItem>
            <asp:ListItem Value="CountAuditing66">义务教育</asp:ListItem>
            <asp:ListItem Value="CountAuditing67">职(高)教育</asp:ListItem>
            <asp:ListItem Value="CountAuditing">总数</asp:ListItem>
        </asp:DropDownList>
    </td>
    <td align="right">排序：</td>
    <td colspan="3">
        <asp:DropDownList ID="ddlISOrder" runat="server" style="width:80px">
            <asp:ListItem Value="">是否排序</asp:ListItem>
            <asp:ListItem Value="ASC">升序ASC</asp:ListItem>
            <asp:ListItem Value="DESC">降序DESC</asp:ListItem>
        </asp:DropDownList>
    </td>
</tr>
<tr>
<td height="30"></td>
<td colspan="3">
    <asp:Button ID="btHighSearch" runat="server" Text="检 索" CssClass="list_search_btn" OnClick="btHighSearch_Click" />
    <asp:Button ID="btHighExport" runat="server"  CssClass="list_search_btn" Text="导 出" OnClick="btHighExport_Click" />
    <input type="button" value="关 闭" class="list_search_btn" onclick="showQueDetail(false);"/></td>
</tr>
</table>
</div>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td style="height:5px"></td>
</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="list_tb">
<tr>
<th width="10%">姓名</th>
<th width="15%">本地动态</th>
<th width="15%">喜讯报道</th>
<th width="15%">学前教育</th>
<th width="15%">义务教育</th>
<th width="15%">职(高)教育</th>
</tr>
<asp:Repeater ID="Repeater1" runat="server">
<ItemTemplate>
<tr>
<td><%#Eval("AdminName")%>&nbsp;</td>
<td><a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),24,1) %>"><b style="color:blue;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),24,1) %></b>通过</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),24,0) %>"><b style="color:saddlebrown;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),24,0) %></b>未审核</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),24) %>"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),24) %>总</a>
</td>
<td>
   <a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),26,1) %>"><b style="color:blue;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),26,1) %></b>通过</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),26,0) %>"><b style="color:saddlebrown;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),26,0) %></b>未审核</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),26) %>"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),26) %>总  
</td>
<td>
    <a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),68,1) %>"> <b style="color:blue;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),68,1) %></b>通过</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),68,0) %>"><b style="color:saddlebrown;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),68,0) %></b>未审核</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),68) %>"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),68) %>总</a> 
</td>   
<td>
   <a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),66,1) %>"> <b style="color:blue;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),66,1) %></b>通过</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),66,0) %>"><b style="color:saddlebrown;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),66,0) %></b>未审核</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),66) %>"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),66) %>总</a>  
</td>  
<td>
    <a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),67,1) %>"><b style="color:blue;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),67,1) %></b>通过</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),67,0) %>"><b style="color:saddlebrown;"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),67,0) %></b>未审核</a>/<a href="<%#GetISAuditingUrl(Convert.ToInt32(Eval("AdminID")),67) %>"><%#GetcountAuditing(Convert.ToInt32(Eval("AdminID")),67) %>总</a> 
</td> 
</tr>
</ItemTemplate>
</asp:Repeater>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td style="height:5px"></td>
</tr>
</table>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
<tr>
<td style="text-align:right" class="cell_group"><asp:Literal ID="LitPager" runat="server"></asp:Literal></td>
</tr>
</table>
</form>
</body>
</html>
