using System;
using System.Collections;
using System.Drawing;

namespace LLK.AI
{
	/// <summary>
	/// 㷨
	/// дڣ2005-6-6
	///  x to x ,ǺȽֱ
	/// Ȼ y to y ,Ƚֱ
	/// 
	/// Ȼ 1۵
	/// 㷨ܼ;
	/// 7x3
	/// 0001000
	/// 0000000
	/// 0000001
	/// 
	/// p1  3,0
	/// p2  6,2
	/// 
	/// ô۵
	/// 000100x
	/// 0000000
	/// 000x001
	/// ۵1 6,0 ,۵2 3,2
	/// עֵp1,p2ıȽ,ǲǺܼ,۵,ͿԱȽx/yֱ,ͨ.
    /// 
	/// 2۾͸һ,涼,
	/// һθҷֱ1㷨ٱȽϼ.
	/// </summary>
	public class TestPath
	{
		private int pathPointCount = 0;
		private ArrayList PathRecord = new ArrayList();
		private int[,] map = null; //ͼ
		private Point startPos; //
		private Point endPos; //յ

		public TestPath()
		{
			;
		}

		public TestPath(Point StartPos, Point EndPos, int[,] Map)
		{
			this.startPos = StartPos;
			this.endPos = EndPos;
			this.map = Map;
		}


		private void EmptyPathRecord()
		{
			PathRecord.Clear();
			PathRecord.TrimToSize();
			PathRecord.Add(this.startPos);
			PathRecord.Add(this.endPos);
		}

		private bool IsEmptyPoint(Point p)
		{
			return this.map[p.X, p.Y] == 0;
		}

		private bool CheckHorizontal(Point p1, Point p2)
		{
			return this.CheckHorizontal(p1, p2, false);
		}

		private bool CheckHorizontal(Point p1, Point p2, bool isAddPath)
		{
			//ˮƽxλ,yͬ

			Point sp = p1.X < p2.X ? p1 : p2;
			Point ep = p2.X < p1.X ? p1 : p2;

			for (int x = sp.X + 1; x < ep.X; x++)
			{
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(x, p1.Y));
				}
				//ͨ
				if (map[x, p1.Y] != 0)
					return false;
			}

			return true;
		}

		private bool CheckVertical(Point p1, Point p2)
		{
			return CheckVertical(p1, p2, false);
		}

		private bool CheckVertical(Point p1, Point p2, bool isAddPath)
		{
			//鴹ֱyλ,xͬ

			Point sp = p1.Y < p2.Y ? p1 : p2;
			Point ep = p2.Y < p1.Y ? p1 : p2;

			for (int y = sp.Y + 1; y < ep.Y; y++)
			{
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(p1.X, y));
				}
				//ͨ
				if (map[p1.X, y] != 0)
					return false;
			}

			return true;
		}

		private bool CheckOneCorner(Point p1, Point p2)
		{
			return CheckOneCorner(p1, p2, true, true);
		}

		private bool CheckOneCorner(Point p1, Point p2, bool isAddPath, bool isClear)
		{
			//н

			//ȡʼx
			Point CrossStart;
			Point CrossEnd;

			if (p1.X < p2.X)
			{
				CrossStart = p1;
				CrossEnd = p2;
			}
			else
			{
				CrossStart = p2;
				CrossEnd = p1;
			}

			//X
			//
			Point CrossX;
			//Y
			//
			Point CrossY;

			if (CrossStart.Y < CrossEnd.Y)
			{
				CrossX = new Point(
					Math.Max(CrossStart.X, CrossEnd.X),
					Math.Min(CrossStart.Y, CrossEnd.Y)
					);
				CrossY = new Point(
					Math.Min(CrossStart.X, CrossEnd.X),
					Math.Max(CrossStart.Y, CrossEnd.Y)
					);
			}
			else
			{
				CrossX = new Point(
					Math.Min(CrossStart.X, CrossEnd.X),
					Math.Min(CrossStart.Y, CrossEnd.Y)
					);
				CrossY = new Point(
					Math.Max(CrossStart.X, CrossEnd.X),
					Math.Max(CrossStart.Y, CrossEnd.Y)
					);
			}

			//齻ǷΪͨ
			if (!this.IsEmptyPoint(CrossX) && !this.IsEmptyPoint(CrossY))
				return false;

			//齻X
			if (this.IsEmptyPoint(CrossX))
			{
				//λ
				if (CrossStart.Y < CrossEnd.Y)
				{
					//Ϊ~|
					if (this.CheckHorizontal(CrossStart, CrossX) && this.CheckVertical(CrossX, CrossEnd))
					{
						//
						if (isClear)
						{
							this.EmptyPathRecord();
						}
						//¼
						if (isAddPath)
						{
							this.PathRecord.Add(CrossX); //¼ǰ
						}
						return (this.CheckHorizontal(CrossStart, CrossX, true) && this.CheckVertical(CrossX, CrossEnd, true));
					}
					//һ
				}
				else
				{
					//Ϊ|~
					if (this.CheckHorizontal(CrossX, CrossEnd) && this.CheckVertical(CrossX, CrossStart))
					{
						//
						if (isClear)
						{
							this.EmptyPathRecord();
						}
						//¼
						if (isAddPath)
						{
							this.PathRecord.Add(CrossX); //¼ǰ
						}
						return (this.CheckHorizontal(CrossX, CrossEnd, true) && this.CheckVertical(CrossX, CrossStart, true));
					}
					//һ
				}

			}

			//齻Y
			if (this.IsEmptyPoint(CrossY))
			{
				//λ			
				if (CrossStart.Y < CrossEnd.Y)
				{
					//Ϊ|_
					if (this.CheckVertical(CrossStart, CrossY) && this.CheckHorizontal(CrossY, CrossEnd))
					{
						//
						if (isClear)
						{
							this.EmptyPathRecord();
						}
						//¼
						if (isAddPath)
						{
							this.PathRecord.Add(CrossY); //¼ǰ
						}
						return (this.CheckVertical(CrossStart, CrossY, true) && this.CheckHorizontal(CrossY, CrossEnd, true));
					}
				}
				else
				{
					//_|
					if (this.CheckVertical(CrossEnd, CrossY) && this.CheckHorizontal(CrossY, CrossStart))
					{
						//
						if (isClear)
						{
							this.EmptyPathRecord();
						}
						//¼
						if (isAddPath)
						{
							this.PathRecord.Add(CrossY); //¼ǰ
						}
						return (this.CheckVertical(CrossEnd, CrossY, true) && this.CheckHorizontal(CrossY, CrossStart, true));
					}
				}

			}

			return false; //ȫ,2۵

		}

		private bool CheckTwoCornerLeft(Point p1, Point p2, bool isAddPath)
		{
			//
			//ռ¼
			this.EmptyPathRecord();
			for (int x = p1.X - 1; x > -1; x--)
			{
				if (this.map[x, p1.Y] != 0)
					return false;
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(x, p1.Y));
				}

				//
				if (this.CheckOneCorner(new Point(x, p1.Y), p2, false, false))
				{
					return this.CheckOneCorner(new Point(x, p1.Y), p2, isAddPath, false);
				}
			}

			return false;
		}

		private bool CheckTwoCornerRight(Point p1, Point p2, bool isAddPath)
		{
			//
			//ռ¼
			this.EmptyPathRecord();
			for (int x = p1.X + 1; x < this.map.GetLength(0); x++)
			{
				if (this.map[x, p1.Y] != 0)
					return false;
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(x, p1.Y));
				}

				//
				if (this.CheckOneCorner(new Point(x, p1.Y), p2, false, false))
				{
					return this.CheckOneCorner(new Point(x, p1.Y), p2, isAddPath, false);
				}
			}

			return false;
		}

		private bool CheckTwoCornerUp(Point p1, Point p2, bool isAddPath)
		{
			//
			//ռ¼
			this.EmptyPathRecord();
			for (int y = p1.Y - 1; y > -1; y--)
			{
				if (this.map[p1.X, y] != 0)
					return false;
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(p1.X, y));
				}

				//
				if (this.CheckOneCorner(new Point(p1.X, y), p2, false, false))
				{
					return this.CheckOneCorner(new Point(p1.X, y), p2, isAddPath, false);
				}
			}

			return false;
		}

		private bool CheckTwoCornerDown(Point p1, Point p2, bool isAddPath)
		{
			//
			//ռ¼
			this.EmptyPathRecord();
			for (int y = p1.Y + 1; y < this.map.GetLength(1); y++)
			{
				if (this.map[p1.X, y] != 0)
					return false;
				//¼
				if (isAddPath)
				{
					this.PathRecord.Add(new Point(p1.X, y));
				}

				//
				if (this.CheckOneCorner(new Point(p1.X, y), p2, false, false))
				{
					return this.CheckOneCorner(new Point(p1.X, y), p2, isAddPath, false);
				}
			}

			return false;
		}

		private void CopyArrayListTo(ref ArrayList srcAl, ref ArrayList destAl)
		{
			//destAl = (ArrayList) (object)srcAl;
			if(srcAl==null || destAl == null)
				return;
			destAl.Clear();
			destAl.TrimToSize();

			foreach (Point p in srcAl)
			{
				Point newPnt = new Point(p.X, p.Y);
				destAl.Add(newPnt);
			}
		}

		private bool CheckTwoCorner(Point p1, Point p2)
		{
			//ȡʼx
			Point CrossStart;
			Point CrossEnd;

			if (p1.X < p2.X)
			{
				CrossStart = p1;
				CrossEnd = p2;
			}
			else
			{
				CrossStart = p2;
				CrossEnd = p1;
			}

			//ΪѰ·㷨
			//ܼ򵥣Ϊǰ㷽ȷѡظܳɹ
			//Ȼҵ·ٵ

			//4ΣѰ̵·

			ArrayList[] backFindPath = new ArrayList[4];
			bool isFind = false;
			int nextPathList = 0;
			while (nextPathList < 4)
			{
				backFindPath[nextPathList] = null;

				if (this.CheckTwoCornerUp(CrossStart, CrossEnd, false))
				{
					this.PathRecord.Clear();
					this.CheckTwoCornerUp(CrossStart, CrossEnd, true);
					backFindPath[nextPathList] = new ArrayList();
					CopyArrayListTo(ref this.PathRecord, ref backFindPath[nextPathList]);
					isFind = true;
					nextPathList ++;
				}

				if (this.CheckTwoCornerDown(CrossStart, CrossEnd, false))
				{
					this.PathRecord.Clear();
					this.CheckTwoCornerDown(CrossStart, CrossEnd, true);
					backFindPath[nextPathList] = new ArrayList();
					CopyArrayListTo(ref this.PathRecord, ref backFindPath[nextPathList]);
					
					isFind = true;
					nextPathList ++;
				}

				if (this.CheckTwoCornerLeft(CrossStart, CrossEnd, false))
				{
					this.PathRecord.Clear();
					this.CheckTwoCornerLeft(CrossStart, CrossEnd, true);
					backFindPath[nextPathList] = new ArrayList();
					CopyArrayListTo(ref this.PathRecord, ref backFindPath[nextPathList]);
					isFind = true;
					nextPathList ++;
				}

				if (this.CheckTwoCornerRight(CrossStart, CrossEnd, false))
				{
					this.PathRecord.Clear();
					this.CheckTwoCornerRight(CrossStart, CrossEnd, true);
					backFindPath[nextPathList] = new ArrayList();
					CopyArrayListTo(ref this.PathRecord, ref backFindPath[nextPathList]);
					isFind = true;
					nextPathList ++;
				}

				//ûн
				if (!isFind)
					break;
			}

			//н
			if (isFind)
			{
				//С
				int minCount = 0;
				//¼λ
				int index = 0;
				for (int i = 0; i < 4; i++)
				{
					if (backFindPath[i] != null)
					{
						if (backFindPath[i].Count > 0)
						{
							if (minCount == 0)
							{
								minCount = backFindPath[i].Count;
								index = i;
							}
							else if (backFindPath[i].Count < minCount)
							{
								minCount = backFindPath[i].Count;
								index = i;
							}
						}
					}
				}

				//ظ
				this.PathRecord.Clear();
				this.PathRecord.TrimToSize();
				CopyArrayListTo(ref backFindPath[index], ref this.PathRecord);

				return true;
			}

			return false;
		}


		public bool Execute()
		{
			pathPointCount = -1;
			//ĿλǷһ
			if (this.startPos.X == this.endPos.X && this.startPos.Y == this.endPos.Y)
			{
				pathPointCount = -1;
				return false;
			}

			//Ϊͬһ
			if (this.startPos.Y == this.endPos.Y)
				if (this.CheckHorizontal(this.startPos, this.endPos))
				{
					this.EmptyPathRecord();
					pathPointCount = 1;
					return (this.CheckHorizontal(this.startPos, this.endPos, true));
				}

			//Ϊͬһ
			if (this.startPos.X == this.endPos.X)
				if (this.CheckVertical(this.startPos, this.endPos))
				{
					this.EmptyPathRecord();
					pathPointCount = 1;
					return (this.CheckVertical(this.startPos, this.endPos, true));
				}

			//һ۵
			if (this.CheckOneCorner(this.startPos, this.endPos))
			{
				pathPointCount = 2;
				return true;
			}

			//۵
			if (this.CheckTwoCorner(this.startPos, this.endPos))
			{
				pathPointCount = 3;
				return true;
			}

			return false;
		}

		/// <summary>
		/// 
		/// </summary>
		public Point StartPosition
		{
			get { return this.startPos; }
			set { this.startPos = value; }
		}

		/// <summary>
		/// յ
		/// </summary>
		public Point EndPosition
		{
			get { return this.endPos; }
			set { this.endPos = value; }
		}

		/// <summary>
		/// ͼ
		/// </summary>
		public int[,] MapData
		{
			get { return this.map; }
			set { this.map = value; }
		}

		/// <summary>
		/// ȡ۵
		/// </summary>
		public int PathPointCount
		{
			get { return this.pathPointCount; }
		}

		/// <summary>
		/// ȡ·
		/// </summary>
		public Point[] PathPointList
		{
			get
			{
				if (this.PathRecord.Count >= 0)
				{
					Point[] tmpPointList = new Point[this.PathRecord.Count];
					int i = 0;
					foreach (Point p in this.PathRecord)
					{
						tmpPointList[i] = new Point(p.X, p.Y);
						i++;
					}
					return tmpPointList;
				}
				else
				{
					return null;
				}
			}
		}

		public ArrayList PathPointArray
		{
			get { return this.PathRecord; }
		}

	}
}