using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.IO;
using System.Text;
using LLK.UI;

namespace LLK
{
	/// <summary>
	/// GameOption ժҪ˵
	/// </summary>
	public class GameOption : System.Windows.Forms.Form
	{
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button btnOk;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.RadioButton rbL1;
		private System.Windows.Forms.RadioButton rbL2;
		private System.Windows.Forms.RadioButton rbL3;
		private System.Windows.Forms.CheckBox cbPM;
		private System.Windows.Forms.CheckBox cbPS;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.ToolTip toolTip1;


		public struct Options
		{
			public int Level;
			public bool PlayMusic;
			public bool PlaySound;
		}

		private Options options = new Options();
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private SoundPlayList Spl = null;

		public GameOption(SoundPlayList soundPlayList)
		{
			//
			// Windows ֧
			//
			InitializeComponent();

			//
			// TODO:  InitializeComponent úκι캯
			//

			this.Spl = soundPlayList;
			string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
			if(!File.Exists(appPath +"\\config.inf"))
			{
				this.SaveOption();
			}
			
			this.ReadOption();
		}

		public Options OptionInfo
		{
			get
			{
				return this.options;
			}
			set
			{
				this.options =value;
			}
		}

		private void InitOptions()
		{
			this.options.Level = 1;
			this.options.PlayMusic = true;
			this.options.PlaySound = true;
			ApplyControls();
		}

		private void ApplyControls()
		{
			switch(this.options.Level)
			{
				case 1:
					rbL1.Checked = true;
					break;
				case 2:
					rbL2.Checked = true;
					break;
				default:
					rbL3.Checked = true;
					break;
			}

			this.cbPM.Checked = this.options.PlayMusic;
			this.cbPS.Checked = this.options.PlaySound;
		}
		/// <summary>
		/// ʹõԴ
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows ɵĴ
		/// <summary>
		/// ֧ķ - Ҫʹô༭޸
		/// ˷ݡ
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.rbL3 = new System.Windows.Forms.RadioButton();
			this.rbL2 = new System.Windows.Forms.RadioButton();
			this.rbL1 = new System.Windows.Forms.RadioButton();
			this.cbPM = new System.Windows.Forms.CheckBox();
			this.cbPS = new System.Windows.Forms.CheckBox();
			this.btnOk = new System.Windows.Forms.Button();
			this.btnCancel = new System.Windows.Forms.Button();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.button3 = new System.Windows.Forms.Button();
			this.button4 = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.rbL3);
			this.groupBox1.Controls.Add(this.rbL2);
			this.groupBox1.Controls.Add(this.rbL1);
			this.groupBox1.ForeColor = System.Drawing.Color.Goldenrod;
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(80, 104);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Ѷȼ";
			// 
			// rbL3
			// 
			this.rbL3.Checked = true;
			this.rbL3.Location = new System.Drawing.Point(16, 72);
			this.rbL3.Name = "rbL3";
			this.rbL3.Size = new System.Drawing.Size(48, 24);
			this.rbL3.TabIndex = 2;
			this.rbL3.TabStop = true;
			this.rbL3.Text = "߼";
			// 
			// rbL2
			// 
			this.rbL2.Location = new System.Drawing.Point(16, 48);
			this.rbL2.Name = "rbL2";
			this.rbL2.Size = new System.Drawing.Size(56, 24);
			this.rbL2.TabIndex = 1;
			this.rbL2.Text = "м";
			// 
			// rbL1
			// 
			this.rbL1.Location = new System.Drawing.Point(16, 24);
			this.rbL1.Name = "rbL1";
			this.rbL1.Size = new System.Drawing.Size(56, 24);
			this.rbL1.TabIndex = 0;
			this.rbL1.Text = "";
			// 
			// cbPM
			// 
			this.cbPM.Checked = true;
			this.cbPM.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbPM.ForeColor = System.Drawing.Color.Goldenrod;
			this.cbPM.Location = new System.Drawing.Point(96, 8);
			this.cbPM.Name = "cbPM";
			this.cbPM.Size = new System.Drawing.Size(80, 24);
			this.cbPM.TabIndex = 1;
			this.cbPM.Text = "";
			// 
			// cbPS
			// 
			this.cbPS.Checked = true;
			this.cbPS.CheckState = System.Windows.Forms.CheckState.Checked;
			this.cbPS.ForeColor = System.Drawing.Color.Goldenrod;
			this.cbPS.Location = new System.Drawing.Point(96, 32);
			this.cbPS.Name = "cbPS";
			this.cbPS.Size = new System.Drawing.Size(80, 24);
			this.cbPS.TabIndex = 2;
			this.cbPS.Text = "Ч";
			// 
			// btnOk
			// 
			this.btnOk.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOk.ForeColor = System.Drawing.Color.Cornsilk;
			this.btnOk.Location = new System.Drawing.Point(96, 64);
			this.btnOk.Name = "btnOk";
			this.btnOk.Size = new System.Drawing.Size(75, 24);
			this.btnOk.TabIndex = 3;
			this.btnOk.Text = "ȷ";
			this.btnOk.Click += new System.EventHandler(this.btnOk_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.ForeColor = System.Drawing.Color.Cornsilk;
			this.btnCancel.Location = new System.Drawing.Point(96, 88);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(75, 24);
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "ȡ";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// listBox1
			// 
			this.listBox1.BackColor = System.Drawing.Color.DimGray;
			this.listBox1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.listBox1.ForeColor = System.Drawing.Color.GreenYellow;
			this.listBox1.HorizontalScrollbar = true;
			this.listBox1.ItemHeight = 12;
			this.listBox1.Location = new System.Drawing.Point(184, 8);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(256, 98);
			this.listBox1.TabIndex = 5;
			// 
			// button1
			// 
			this.button1.Font = new System.Drawing.Font("Webdings", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(134)));
			this.button1.ForeColor = System.Drawing.Color.FromArgb(((System.Byte)(192)), ((System.Byte)(255)), ((System.Byte)(192)));
			this.button1.Location = new System.Drawing.Point(448, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(24, 23);
			this.button1.TabIndex = 6;
			this.button1.Text = "5";
			this.toolTip1.SetToolTip(this.button1, "");
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.Font = new System.Drawing.Font("Webdings", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(134)));
			this.button2.ForeColor = System.Drawing.Color.FromArgb(((System.Byte)(192)), ((System.Byte)(255)), ((System.Byte)(192)));
			this.button2.Location = new System.Drawing.Point(448, 32);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(24, 23);
			this.button2.TabIndex = 7;
			this.button2.Text = "6";
			this.toolTip1.SetToolTip(this.button2, "");
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button3
			// 
			this.button3.ForeColor = System.Drawing.Color.FromArgb(((System.Byte)(192)), ((System.Byte)(255)), ((System.Byte)(192)));
			this.button3.Location = new System.Drawing.Point(448, 56);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(24, 23);
			this.button3.TabIndex = 8;
			this.button3.Text = "";
			this.toolTip1.SetToolTip(this.button3, "");
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button4
			// 
			this.button4.ForeColor = System.Drawing.Color.FromArgb(((System.Byte)(192)), ((System.Byte)(255)), ((System.Byte)(192)));
			this.button4.Location = new System.Drawing.Point(448, 80);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(24, 23);
			this.button4.TabIndex = 9;
			this.button4.Text = "";
			this.toolTip1.SetToolTip(this.button4, "ɾ");
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "|*.mp3;*.mid;*.rmi;*.wav|Mp3 ļ|*.mp3|ļ|*.wav|MIDI |*.mdi;*.rmi";
			this.openFileDialog1.Multiselect = true;
			// 
			// GameOption
			// 
			this.AcceptButton = this.btnOk;
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.BackColor = System.Drawing.Color.DimGray;
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(480, 120);
			this.ControlBox = false;
			this.Controls.Add(this.button4);
			this.Controls.Add(this.button3);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.listBox1);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOk);
			this.Controls.Add(this.cbPS);
			this.Controls.Add(this.cbPM);
			this.Controls.Add(this.groupBox1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "GameOption";
			this.Opacity = 0.9;
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Ϸ";
			this.Load += new System.EventHandler(this.GameOption_Load);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		public void SaveOption()
		{
			int GetLevel = 0;
			if(rbL1.Checked) GetLevel = 1;
			if(rbL2.Checked) GetLevel = 2;
			if(rbL3.Checked) GetLevel = 3;

			string playMusic = this.cbPM.Checked ? "1" : "0";
			string playSound = this.cbPS.Checked ? "1" : "0";

			this.options.Level = GetLevel;
			this.options.PlayMusic = this.cbPM.Checked;
			this.options.PlaySound = this.cbPS.Checked;

			string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
			StreamWriter sw = new StreamWriter(appPath + "\\config.inf",false,Encoding.Default);

			sw.WriteLine("{0}{1}{2}",GetLevel,playMusic,playSound);

			sw.Close();
		}

		public Options ReadOption()
		{
			Options result = new Options();
			string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
			StreamReader sr = new StreamReader(appPath + "\\config.inf",Encoding.Default);
			string buffer = sr.ReadToEnd();
			sr.Close();
			try
			{
				int p1 = Convert.ToInt32(buffer.Substring(0,1));
				int p2 = Convert.ToInt32(buffer.Substring(1,1));
				int p3 = Convert.ToInt32(buffer.Substring(2,1));
				this.options.Level = p1;
				this.options.PlayMusic = (p2 == 1);
				this.options.PlaySound = (p3 == 1);
			}
			catch
			{
				InitOptions();
			}

			result.Level = this.options.Level;
			result.PlayMusic = this.options.PlayMusic;
			result.PlaySound = this.options.PlaySound;
			ApplyControls();
			return result;
		}

		private void btnOk_Click(object sender, System.EventArgs e)
		{
			string appPath = Application.ExecutablePath.Substring(0,Application.ExecutablePath.LastIndexOf("\\"));
			File.Delete(appPath + "\\Music.list");
			System.IO.StreamWriter wr = new StreamWriter(appPath + "\\Music.list",false,Encoding.Default);
			foreach(string s in this.listBox1.Items)
			{
				wr.WriteLine(s);
			}
			wr.Close();

			this.Spl.ClearReInit();
			this.SaveOption();
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void GameOption_Load(object sender, System.EventArgs e)
		{
			this.listBox1.Items.Clear();
			ArrayList al = Spl.MusicList;
			foreach(string s in al)
			{
				if(File.Exists(s))
				{
					this.listBox1.Items.Add(s);
				}
			}
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			if(openFileDialog1.ShowDialog(this)==DialogResult.OK)
			{
				foreach(string f in openFileDialog1.FileNames)
				{
					listBox1.Items.Add(f);
				}
			}
		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			if(listBox1.SelectedIndex>=0 && listBox1.SelectedIndex<listBox1.Items.Count)
			{
				listBox1.Items.RemoveAt(listBox1.SelectedIndex);
				if(listBox1.SelectedIndex>0)
				{
					listBox1.SelectedItem = listBox1.Items[listBox1.SelectedIndex-1];
				}
				else
				{
					if(listBox1.SelectedIndex<listBox1.Items.Count-1)
						listBox1.SelectedItem = listBox1.Items[listBox1.SelectedIndex+1];
				}
			}
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			if(listBox1.Items.Count<1)return;
			if(listBox1.SelectedIndex>0)
			{
				string s = (string)listBox1.Items[listBox1.SelectedIndex-1];
				listBox1.Items[listBox1.SelectedIndex-1] = listBox1.Items[listBox1.SelectedIndex];
				listBox1.Items[listBox1.SelectedIndex] = s;
				listBox1.SelectedItem = listBox1.Items[listBox1.SelectedIndex-1];
			}
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			if(listBox1.Items.Count<1)return;
			if(listBox1.SelectedIndex<listBox1.Items.Count-1)
			{
				string s = (string)listBox1.Items[listBox1.SelectedIndex+1];
				listBox1.Items[listBox1.SelectedIndex+1] = listBox1.Items[listBox1.SelectedIndex];
				listBox1.Items[listBox1.SelectedIndex] = s;
				listBox1.SelectedItem = listBox1.Items[listBox1.SelectedIndex+1];
			}
		}
	}
}
