using System;
using System.Collections;
using System.Drawing;
using System.Drawing.Imaging;
using LLK.ACTION;

namespace LLK.UI
{
	/// <summary>
	/// Map ժҪ˵
	/// </summary>
	public class Map
	{
		public const int TileRowCount = 19;
		public const int TileColCount = 12;
		public const int TileWidth = 31;
		public const int TileHeight = 34;
		public const int DotWidth = 16;
		public const int DotHeight = 16;
		public const int BombWidth = 61;
		public const int BombHeight = 60;

		private MapTile[,] oMapTile;
		private Image[] objImage = null;
		private Image[] objImageL1 = null;
		private Image[] objImageL2 = null;
		private Bitmap[] objBombEff = null;
		private Image objDot = null;
		//private VirtualUndo vu = null;

		private int[] array = new int[(TileRowCount - 2)*(TileColCount - 2)]; //ʵʷռ
		private int level = 0;
		private int offsetX = 0;
		private int offsetY = 0;

		public MapTile[,] MapView
		{
			get { return this.oMapTile; }
		}

		public int[,] TestMapArray(Line StartPoint, Line EndPoint)
		{
			int[,] intMap = new int[TileRowCount,TileColCount];
			for (int y = 0; y < TileColCount; y++)
				for (int x = 0; x < TileRowCount; x++)
				{
					if ((StartPoint.X == x && StartPoint.Y == y) || (EndPoint.X == x && EndPoint.Y == y) || (oMapTile[x, y].ID == 0))
					{
						intMap[x, y] = 0; //Ϊ
					}
					else
					{
						intMap[x, y] = 1; //ϰ
					}
				}
			return intMap;
		}

		public Map(ScreenObject screenObject, int Offset_X, int Offset_Y)
		{
			oMapTile = new MapTile[TileRowCount,TileColCount];
			level = 28;
			offsetX = Offset_X;
			offsetY = Offset_Y;
			this.objImage = screenObject.objImage;
			this.objImageL1 = screenObject.objImageL1;
			this.objImageL2 = screenObject.objImageL2;
			this.objBombEff = screenObject.objBombEff;
			this.objDot = screenObject.objDot;
			//initObjImg();
			//vu = new VirtualUndo(this);
			initMap();
		}

		public Map(ScreenObject screenObject, int iLevel, int Offset_X, int Offset_Y)
		{
			oMapTile = new MapTile[TileRowCount,TileColCount];
			level = iLevel;
			offsetX = Offset_X;
			offsetY = Offset_Y;
			this.objImage = screenObject.objImage;
			this.objImageL1 = screenObject.objImageL1;
			this.objImageL2 = screenObject.objImageL2;
			this.objBombEff = screenObject.objBombEff;
			this.objDot = screenObject.objDot;
			//initObjImg();
			//vu = new VirtualUndo(this);
			initMap();
		}

		public int Level
		{
			get { return level; }
			set { level = value; }
		}

		public int Offset_X
		{
			get { return offsetX; }
			set { offsetX = value; }
		}

		public int Offset_Y
		{
			get { return offsetY; }
			set { offsetY = value; }
		}

		public void ResetMap()
		{
			//ʼڼ
			for (int i = 0; i < array.Length; i++)
			{
				array[i] = 0;
			}
			for (int y = 0; y < TileColCount; y++)
				for (int x = 0; x < TileRowCount; x++)
				{
					oMapTile[x, y].ID = 0;
				}
			initMap();
		}

//		private void initObjImg()
//		{
//			for(int i=0;i<39;i++)
//			{
//				objImage[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + ".bmp");
//				objImageL1[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + "_L1.bmp");
//				objImageL2[i] = Image.FromFile(".\\Images\\" + (i+1).ToString() + "_L2.bmp");
//			}
//		}


		//ʼͼ
		private void initMap()
		{
			//ֲID
			for (int i = 0; i < level; i++)
			{
				array[i*4] = i + 1;
				array[i*4 + 1] = i + 1;
				array[i*4 + 2] = i + 1;
				array[i*4 + 3] = i + 1;
			}

			//
			RandomObject(array);

			//Ԥ߽
			for (int y = 0; y < TileColCount; y++)
			{
				for (int x = 0; x < TileRowCount; x++)
				{
					if (x == 0 || x == TileRowCount - 1)
					{
						oMapTile[x, y] = new MapTile((x)*TileWidth + offsetX, (y)*TileHeight + offsetY, 0, x, y);
					}
					else if (y == 0 || y == TileColCount - 1)
					{
						oMapTile[x, y] = new MapTile((x)*TileWidth + offsetX, (y)*TileHeight + offsetY, 0, x, y);
					}
				}
			}

			//ʼڼ
			for (int y = 1; y < TileColCount - 1; y++)
				for (int x = 1; x < TileRowCount - 1; x++)
				{
					oMapTile[x, y] = new MapTile((x)*TileWidth + offsetX, (y)*TileHeight + offsetY, array[(y - 1)*(TileRowCount - 2) + (x - 1)], x, y);
				}

//			if(!vu.IsCanUndo())
//			{
//				throw new Exception("!¿ʼϷ!");
//			}
		}

		//ID
		private void RandomObject(int[] array)
		{
			Random random = new Random((int) DateTime.Now.Millisecond);
			for (int i = array.Length; i > 0; i--)
			{
				int j = random.Next(i);
				int temp = array[j];
				array[j] = array[i - 1];
				array[i - 1] = temp;
			}
		}

		public void Draw(Graphics g)
		{
			this.Draw(g, 1f);
		}

		public void Draw(Graphics g, float Zoom)
		{
			//޶ͼ;Ҹһλ
			g.SetClip(new Rectangle(offsetX, offsetY, TileWidth*TileRowCount, TileHeight*TileColCount));
			//ͼ
			for (int y = 0; y < TileColCount; y++)
				for (int x = 0; x < TileRowCount; x++)
				{
					if (oMapTile[x, y].ID != 0)
					{
						//Image img = null;
						//img = Image.FromFile(".\\Images\\" + oMapTile[x,y].ID.ToString() + ".bmp");
						g.DrawImage(
							//img,
							this.objImage[oMapTile[x, y].ID - 1],
							oMapTile[x, y].X + ((oMapTile[x, y].Width - ((int) oMapTile[x, y].Width*Zoom))/2),
							oMapTile[x, y].Y + ((oMapTile[x, y].Height - ((int) oMapTile[x, y].Height*Zoom))/2),
							(int) oMapTile[x, y].Width*Zoom,
							(int) oMapTile[x, y].Height*Zoom
							);
					}

				}
		}

		public void Draw(Graphics g, bool IsGrayScale, int Lv)
		{
			//޶ͼ;Ҹһλ
			g.SetClip(new Rectangle(offsetX, offsetY, TileWidth*TileRowCount, TileHeight*TileColCount));
			//ͼ
			for (int y = 0; y < TileColCount; y++)
				for (int x = 0; x < TileRowCount; x++)
				{
					if (oMapTile[x, y].ID != 0)
					{
						Image img = null;
						if (IsGrayScale)
						{
							//Bitmap m_Bitmap = (Bitmap)Bitmap.FromFile(".\\Images\\" + oMapTile[x,y].ID.ToString() + "_L" + Lv.ToString() + ".bmp", false);
							//ScreenDraw.GrayScale(m_Bitmap);
							//img = m_Bitmap;
							if (Lv == 1)
								img = this.objImageL1[oMapTile[x, y].ID - 1];
							else
								img = this.objImageL2[oMapTile[x, y].ID - 1];
						}
						else
						{
							//img = Image.FromFile(".\\Images\\" + oMapTile[x,y].ID.ToString() + ".bmp");
							img = this.objImage[oMapTile[x, y].ID - 1];
						}

						g.DrawImage(
							img,
							oMapTile[x, y].X,
							oMapTile[x, y].Y,
							oMapTile[x, y].Width,
							oMapTile[x, y].Height
							);
					}

				}
		}

		public void DrawPathPoints(Graphics g, int[,] PathPoints, int PathID)
		{
			//int c = 0;
			for (int y = 0; y < TileColCount; y++)
				for (int x = 0; x < TileRowCount; x++)
				{
					if (PathPoints[x, y] == PathID)
					{
						//c ++;

						//Image img = Image.FromFile(".\\Images\\dots.gif");
						g.DrawImage(
							this.objDot, //img,
							x*TileWidth + offsetX + (int) ((TileWidth - DotWidth)/2),
							y*TileHeight + offsetY + (int) ((TileHeight - DotHeight)/2),
							DotWidth,
							DotHeight
							);
						//						g.DrawString(
						//							c.ToString(),
						//							new Font("",9F),
						//							new SolidBrush(Color.Black),
						//							x * TileWidth + offsetX + (int)((TileWidth-DotWidth) / 2), 
						//							y * TileHeight + offsetY + (int)((TileHeight-DotHeight) / 2)
						//							);
					}
				}
		}

		public void DrawPathPoints(Graphics g, ArrayList PathPoints)
		{
			for (int i = 0; i < PathPoints.Count; i++)
			{
				Point p = (Point) PathPoints[i];
				g.DrawImage(
					this.objDot,
					p.X*TileWidth + offsetX + (int) ((TileWidth - DotWidth)/2),
					p.Y*TileHeight + offsetY + (int) ((TileHeight - DotHeight)/2),
					DotWidth,
					DotHeight
					);
				//g.DrawString(i.ToString(),new Font("",9f),new SolidBrush(Color.Red),p.X * TileWidth + offsetX,p.Y * TileHeight + offsetY);
			}
		}

		public Bitmap DrawBombEff(Bitmap SurfaceImage, int FrameIndex, MapTile mapTile)
		{
			int ox = mapTile.X - ((BombWidth - TileWidth)/2);
			int oy = mapTile.Y - ((BombHeight - TileHeight)/2);

			ImageBlender ib = new ImageBlender();
			Bitmap destBmp = (Bitmap) this.objBombEff[FrameIndex].Clone();
			Image destImg = (Image) destBmp;
			Bitmap srcBmp = (Bitmap) SurfaceImage.Clone(new Rectangle(ox, oy, BombWidth + 1, BombHeight + 1), PixelFormat.Format24bppRgb);
			Image srcImg = (Image) srcBmp;
			ib.BlendImages(destImg, 0, 0, destImg.Width, destImg.Height, srcImg, 0, 0, ImageBlender.BlendOperation.Blend_Lighten);

			try
			{
				return (Bitmap) destBmp.Clone();
			}
			finally
			{
				destBmp.Dispose();
			}
		}

		//뵱ǰλ
		public MapTile TranPointToMapTile(int PointX, int PointY)
		{
			int x = PointX - offsetX;
			int y = PointY - offsetY;

			int idx = (x%TileWidth) != 0 ? (int) (x/TileWidth) + 1 : (int) (x/TileWidth);
			int idy = (y%TileHeight) != 0 ? (int) (y/TileHeight) + 1 : (int) (y/TileHeight);

			idx--;
			idy--; //0ʼ

			if ((idx >= 0 && idx < TileRowCount) && (idy >= 0 && idy < TileColCount))
			{
				try
				{
					return oMapTile[idx, idy];
				}
				catch (IndexOutOfRangeException)
				{
					//Console.Out.WriteLine("idx{0} idy{1} Px{2} Py{3}" , idx,idy,PointX,PointY);
					return null;
				}
			}
			else
			{
				return null;
			}
		}
        //by http://www.hellocsharp.com
		//ȡĿ
		public int GetCount()
		{
			int count = 0;
			for (int x = 0; x < TileRowCount; x++)
				for (int y = 0; y < TileColCount; y++)
				{
					if (oMapTile[x, y].ID > 0)
					{
						count ++;
					}
				}
			return count;
		}

		public ArrayList GetObjectList()
		{
			ArrayList ol = new ArrayList();

			for (int x = 0; x < TileRowCount; x++)
				for (int y = 0; y < TileColCount; y++)
				{
					if (oMapTile[x, y].ID > 0)
					{
						Line l = new Line();
						l.X = x;
						l.Y = y;
						l.ID = oMapTile[x, y].ID;
						ol.Add(l);
					}
				}

			return ol;
		}

		//ˢ,
		public void RandomRefresh()
		{
			int count = GetCount();
			if (count <= 0)
				return;

			int[] temp = new int[count];
			count = 0;
			for (int x = 0; x < TileRowCount; x++)
				for (int y = 0; y < TileColCount; y++)
				{
					if (oMapTile[x, y].ID > 0)
					{
						temp[count] = oMapTile[x, y].ID;
						count ++;
					}
				}

			RandomObject(temp);
			count = 0;
			for (int x = 0; x < TileRowCount; x++)
				for (int y = 0; y < TileColCount; y++)
					if (oMapTile[x, y].ID > 0)
					{
						oMapTile[x, y].ID = temp[count];
						count++;
					}

		}

		public void SetCell(int x, int y, int ImageID)
		{
			this.oMapTile[x, y].ID = ImageID;
		}

		public void DestroyObject(int x, int y)
		{
			this.oMapTile[x, y].ID = 0;
		}

		public MapTile GetMapTile(int x, int y)
		{
			return this.oMapTile[x, y];
		}
	}
}