using System;
using System.Runtime.InteropServices;

namespace LLK.UI
{
	/// <summary>
	/// SoundPlayer ժҪ˵
	/// MCI 
    /////by http://www.hellocsharp.com
	/// </summary>
	public class SoundPlayer
	{
		[MarshalAs(UnmanagedType.ByValTStr,SizeConst=128)] 
		private string mciStatus = "" ; 
		[MarshalAs(UnmanagedType.ByValTStr,SizeConst=260)] 
		private string shortFileName = "" ; 

		[DllImport("winmm.dll",EntryPoint="mciSendString",SetLastError=true, CharSet=CharSet.Auto)]
		private static extern long mciSendString(
			string lpstrCommand, 
			string lpstrReturnString, 
			long uReturnLength, 
			long hwndCallback
			);
		[DllImport("kernel32.dll",SetLastError=true, CharSet = CharSet.Auto)] 
		public static extern int GetShortPathName ( 
			string lpszLongPath, 
			string shortFile, 
			int cchBuffer 
			); 
		private string File;
		private string Alias;
		private string status = "close";
	
		public SoundPlayer(string strFileName,string strAliasName) 
		{
			this.File = LongNameToShortName(strFileName); 
			this.Alias = strAliasName;
			status = "close";
		}

		private string LongNameToShortName(string strFileName)
		{
			shortFileName = ""; //bug 
			shortFileName = shortFileName.PadLeft(260,Convert.ToChar(" ")) ; 
			GetShortPathName(strFileName,shortFileName, shortFileName.Length); 
			return GetCurrPath(shortFileName);
		}

		private string GetCurrPath(string name) 
		{ 
			if(name.Length <1) return ""; 
			name = name.Trim(); 
			name = name.Substring(0,name.Length-1); 
			return name; 
		} 

		public string FileName
		{
		
			get
			{
				return File;
			}
			set
			{
				File = LongNameToShortName(value);
			}
		}

		public string AliasName
		{
			get
			{
				return Alias;
			}
		}
	
		public bool PlaySound()
		{
			if (PlayFile() == true)
			{
				return true;
			}
			else
			{
				return false;
			}		
		}
	
		public bool StopSound()
		{
		
			StopFile();
		
			return false;
		}
	
		private bool PlayFile()
		{
			bool returnValue;
		
			long lRet;
		
			try
			{
				StopFile();
			
				lRet = mciSendString("open " + this.File + " alias " + Alias, "", 0, 0);
				lRet = mciSendString("play "+ Alias, "", 0, 0);
				returnValue = (lRet == 0);
			
				status = "play";
			}
			catch (Exception)
			{
				return false;
			}
		
			return true;
		
		}
	
		public void CloseAudio()
		{
		
			mciSendString("close all","", 0, 0);
			status = "close";
	
		}
	
		private bool StopFile()
		{
		
			long lRet;
		
			try
			{
				lRet = mciSendString("stop "+Alias, "", 0, 0);
				lRet = mciSendString("close "+Alias, "", 0, 0);
				status = "stop";
				return true;
			}
			catch (Exception)
			{
				return false;
			}
		
		}

		public bool IsPlaying
		{
			get
			{
				if(status!="play")
					return false;

				mciStatus = "";
				mciStatus = mciStatus.PadLeft(128,Convert.ToChar(" "));
				mciSendString("status " + this.Alias + " mode",mciStatus,128,0);
				return mciStatus.Substring(0,7).ToLower() == "playing".ToLower();
			}
		}

	}
}
