﻿
/****** Object:  StoredProcedure [dbo].[USP_SplitPage]    Script Date: 12/27/2012 10:47:10 ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[USP_SplitPage]
@sql		Nvarchar(4000),		 --要执行的sql语句
@currentpage	INT = 1,			--要显示的页码
@pagesize	INT = 10,  		--每页的大小
@pagecount	INT = 0 OUT		 --总页数
AS

SET NOCOUNT ON

DECLARE
@p1 INT

EXEC sp_cursoropen @p1 OUTPUT,@sql,@scrollopt=1,@ccopt=1,@rowcount=@pagecount OUTPUT

SET @pagecount=CEILING(1.0*@pagecount/@pagesize)
SET @currentpage=(@currentpage-1)*@pagesize+1

EXEC sp_cursorfetch @p1,16,@currentpage,@pagesize 
EXEC sp_cursorclose @p1

--SELECT @currentpage
SELECT @pagecount

SET NOCOUNT OFF
GO
/****** Object:  Table [dbo].[DT_VisteIPList]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_VisteIPList](
	[ID] [uniqueidentifier] NOT NULL,
	[UserName] [varchar](50) NULL,
	[CreationDate] [datetime] NOT NULL,
	[IPAddress] [varchar](50) NOT NULL,
	[IsPoint] [bit] NULL,
	[IsTreadOrPeak] [bit] NULL,
	[IsPlayer] [bit] NULL,
	[MediaID] [int] NOT NULL,
	[isHd] [bit] NOT NULL,
 CONSTRAINT [PK_DT_VisteIPList] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[DT_Template]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_Template](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](20) NOT NULL,
	[Type] [bit] NULL,
	[FileUrl] [varchar](2100) NULL,
	[FileSize] [int] NULL,
	[Description] [varchar](100) NULL,
	[CreateTime] [datetime] NULL,
	[UpdateTime] [datetime] NULL,
	[FilePath] [varchar](100) NULL,
	[FileName] [varchar](100) NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[DT_Template] ON
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (1, N'index', 0, N'/template/index.html', 0, N'首页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (5, N'list', 0, N'/template/list.html', 0, N'频道内容列表', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (6, N'player', 0, N'/template/player.html', 0, N'播放页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (7, N'help', 0, N'/template/help.html', 0, N'帮助页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (8, N'albums', 0, N'/template/albums.html', 0, N'专辑列表页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (9, N'album', 0, N'/template/album.html', 0, N'专辑内容列表页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (10, N'channels', 0, N'/template/channels.html', 0, N'频道列表页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (11, N'all', 0, N'/template/all.html', 0, N'所有视频列表页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (16, N'login', 0, N'/template/login.html', 0, N'登录页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (17, N'register', 0, N'/template/register.html', 0, N'注册页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (18, N'search', 0, N'/template/search.html', 0, N'搜索页', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (19, N'clause', 0, N'/template/clause.html', 0, N'服务条款', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (20, N'forgetpassword', 0, N'/template/forgetpassword.html', 0, N'忘记密码', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (21, N'contactus', 0, N'/template/contactus.html', 0, N'联系我们', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (22, N'ad', 0, N'/template/ad.html', 0, N'广告合作', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (23, N'duty', 0, N'/template/duty.html', 0, N'免责声明', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (24, N'services', 0, N'/template/services.html', 0, N'客户服务', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (25, N'sitemap', 0, N'/template/sitemap.html', 0, N'网站地图', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (26, N'aboutus', 0, N'/template/aboutus.html', 0, N'关于我们', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N'', N'')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (28, N'allPinot', 0, N'/template/allPinot.html', 0, N'所有视频评分、点击排序列表', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N' ', N' ')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (30, N'ChanList', 0, N'/template/ChanList.html', 0, N'频道视频评分、点击排序列表', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N' ', N' ')
INSERT [dbo].[DT_Template] ([ID], [Name], [Type], [FileUrl], [FileSize], [Description], [CreateTime], [UpdateTime], [FilePath], [FileName]) VALUES (31, N'AmlList', 0, N'/template/AmlList.html', 0, N'专辑视频评分、点击排序列表', CAST(0x00009F17009457C8 AS DateTime), CAST(0x00009F17009457C8 AS DateTime), N' ', N' ')
SET IDENTITY_INSERT [dbo].[DT_Template] OFF
/****** Object:  Table [dbo].[DT_Tag]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_Tag](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [varchar](20) NOT NULL,
	[Type] [int] NULL,
	[TempID] [int] NULL,
	[IsSys] [bit] NULL,
	[TSql] [varchar](200) NULL,
	[CreateTime] [datetime] NULL,
	[UpdateTime] [datetime] NULL,
 CONSTRAINT [PK__DT_Tag__442B18F2] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[DT_Tag] ON
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (1, N'ListPageIndex', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (2, N'ListPageCount', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (3, N'Cache', 0, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (4, N'MediaType', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (5, N'Title', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (6, N'Path', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (7, N'ID', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (8, N'Type', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (9, N'Page', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (10, N'MediasObj', 0, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (12, N'AlbumsObj', 0, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (13, N'ChannelsObj', 0, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (16, N'IndexChannels', 1, 1, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (21, N'MediasByChannels', 1, 5, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (22, N'Media', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (23, N'UserMedia', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (24, N'AboatMedia', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (25, N'Albums', 1, 8, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (26, N'AlbumTop1', 1, 9, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (27, N'MediasByAlbum', 1, 9, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (28, N'Channels', 1, 10, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (29, N'Medias', 1, 11, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
INSERT [dbo].[DT_Tag] ([ID], [Name], [Type], [TempID], [IsSys], [TSql], [CreateTime], [UpdateTime]) VALUES (51, N'Comment', 1, 0, 1, N'', CAST(0x00009F3300000000 AS DateTime), CAST(0x00009F3300000000 AS DateTime))
SET IDENTITY_INSERT [dbo].[DT_Tag] OFF
/****** Object:  Table [dbo].[DT_Script]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_Script](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Val] [varchar](500) NULL,
	[CreationDate] [datetime] NOT NULL,
	[Type] [int] NOT NULL,
	[TempName] [varchar](50) NOT NULL,
	[Num] [int] NOT NULL,
 CONSTRAINT [PK_DT_Script] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[DT_Script] ON
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (1, N'<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (2, N'<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 1)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (3, N'<meta name="description" content="鼎太播客。" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 2)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (4, N'<meta name="keywords" content="播客，视频。" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 3)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (5, N'<meta content="all" name="robots" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 4)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (6, N'<meta name="author" content="http://www.dingtai.biz,鼎太网络科技有限公司" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 5)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (7, N'<meta name="Copyright" content="请勿转载，版权所有" />', CAST(0x00009F5D00000000 AS DateTime), 0, N'', 6)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (8, N'$Title', CAST(0x00009F5D00000000 AS DateTime), 3, N'', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (9, N'<link href="/html/Skins/default/css/all.css" rel="stylesheet" type="text/css" />', CAST(0x00009F5D00000000 AS DateTime), 1, N'', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (10, N'<link href="/html/Skins/default/css/slides.css" rel="stylesheet" type="text/css" />', CAST(0x00009F5D00000000 AS DateTime), 1, N'', 1)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (11, N'/html/Skins/default/js/so.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (12, N'/html/Skins/default/js/tab.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 1)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (13, N'/html/Skins/default/js/slides_2.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 2)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (14, N'/html/Skins/default/js/slides_1.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 3)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (15, N'/JS/Login.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 4)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (16, N'/JS/index.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 5)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (17, N'/JS/Dingtai_V50.List.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 6)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (18, N'/JS/hdindex.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'', 7)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (19, N'/JS/Regsiter.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'register', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (20, N'/JS/Dingtai_V50.search.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'search', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (21, N'/JS/Dingtai_V50.Player.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'hdplayer', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (22, N'/JS/Dingtai_V50.Player.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'player', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (23, N'/JS/Dingtai_V50.allList.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'allPinot', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (24, N'/JS/Dingtai_V50.allhdList.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'allhdList', 0)
INSERT [dbo].[DT_Script] ([ID], [Val], [CreationDate], [Type], [TempName], [Num]) VALUES (25, N'/JS/Dingtai_V50.chanList.js', CAST(0x00009F5D00000000 AS DateTime), 2, N'ChanList', 0)
SET IDENTITY_INSERT [dbo].[DT_Script] OFF
/****** Object:  Table [dbo].[DT_Progress]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Progress](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[indexPage] [int] NULL,
	[countPage] [int] NULL,
PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[DT_Progress] ON
INSERT [dbo].[DT_Progress] ([ID], [indexPage], [countPage]) VALUES (1, 0, 0)
SET IDENTITY_INSERT [dbo].[DT_Progress] OFF
/****** Object:  Table [dbo].[DT_Passport_VisitList]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Passport_VisitList](
	[hostname] [nvarchar](100) NOT NULL,
	[visitorname] [nvarchar](100) NOT NULL,
	[visittime] [datetime] NOT NULL
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Passport_UsersInRoles]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Passport_UsersInRoles](
	[UserID] [uniqueidentifier] NOT NULL,
	[RoleID] [uniqueidentifier] NOT NULL,
 CONSTRAINT [PK_DT_Passport_UsersInRoles] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[RoleID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[DT_Passport_UsersInRoles] ([UserID], [RoleID]) VALUES (N'56221f16-fa3b-4f24-96e9-42d6823f30fb', N'00000000-0000-0000-0000-000000000000')
INSERT [dbo].[DT_Passport_UsersInRoles] ([UserID], [RoleID]) VALUES (N'56221f16-fa3b-4f24-96e9-42d6823f30fb', N'7b23f324-87b0-464d-9375-eab1327f5cc0')
INSERT [dbo].[DT_Passport_UsersInRoles] ([UserID], [RoleID]) VALUES (N'56221f16-fa3b-4f24-96e9-42d6823f30fb', N'b79b17e2-00c0-4031-a818-f3db5a72137d')
/****** Object:  Table [dbo].[DT_Passport_Users]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Passport_Users](
	[ID] [uniqueidentifier] NOT NULL,
	[UserName] [nvarchar](32) NULL,
	[Nick] [nvarchar](32) NULL,
	[Password] [nvarchar](32) NULL,
	[Email] [nvarchar](32) NULL,
	[PasswordQuestion] [nvarchar](32) NULL,
	[PasswordAnswer] [nvarchar](32) NULL,
	[CreationDate] [datetime] NULL,
	[IsApproved] [bit] NULL,
	[IsLockedOut] [bit] NULL,
	[LastLockoutDate] [datetime] NULL,
	[LastLoginDate] [datetime] NULL,
	[LastPasswordChangedDate] [datetime] NULL,
	[FailedPasswordAttemptCount] [int] NULL,
	[FailedPasswordAttemptWindowStart] [datetime] NULL,
	[TotalView] [int] NULL,
	[ImageUrl] [nvarchar](256) NULL,
	[Point] [int] NULL,
	[IsVipMember] [bit] NULL,
	[IsVipUser] [bit] NULL,
	[ParentID] [uniqueidentifier] NULL,
	[ChannalID] [uniqueidentifier] NULL,
	[City] [nvarchar](50) NULL,
	[ColumnID] [uniqueidentifier] NULL,
	[Province] [nvarchar](50) NULL,
	[RealName] [nvarchar](32) NULL,
	[Gender] [int] NULL,
	[IMType] [int] NULL,
	[IM] [nvarchar](50) NULL,
	[TEL] [nvarchar](50) NULL,
	[Birthday] [datetime] NULL,
	[RegisterType] [tinyint] NULL,
 CONSTRAINT [PK_DT_Passport_User] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'UserName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户昵称' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Nick'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'用户密码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Password'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'注册邮箱' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Email'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'提示问题' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'PasswordQuestion'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'提示问题答案' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'PasswordAnswer'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'注册时间' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'CreationDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否通过用户审查' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'是否被锁定' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'IsLockedOut'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后锁定日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'LastLockoutDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后登录日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'LastLoginDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'最后修改密码日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'LastPasswordChangedDate'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'头像地址' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'ImageUrl'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'城市' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'City'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'省份' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Province'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'真实姓名' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'RealName'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0-保密，1-男性，2-女性' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Gender'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'即时通讯类型：0-QQ，1-MSN' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'IMType'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'即时通讯工具号码' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'IM'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'联系电话' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'TEL'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'出生日期' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DT_Passport_Users', @level2type=N'COLUMN',@level2name=N'Birthday'
GO
INSERT [dbo].[DT_Passport_Users] ([ID], [UserName], [Nick], [Password], [Email], [PasswordQuestion], [PasswordAnswer], [CreationDate], [IsApproved], [IsLockedOut], [LastLockoutDate], [LastLoginDate], [LastPasswordChangedDate], [FailedPasswordAttemptCount], [FailedPasswordAttemptWindowStart], [TotalView], [ImageUrl], [Point], [IsVipMember], [IsVipUser], [ParentID], [ChannalID], [City], [ColumnID], [Province], [RealName], [Gender], [IMType], [IM], [TEL], [Birthday], [RegisterType]) VALUES (N'56221f16-fa3b-4f24-96e9-42d6823f30fb', N'admin', N'播客管理员', N'uGkodM9w7oszqJhyOQiw4Q==', N'admin1@qq.com', N'admin11', N'admin11', CAST(0x0000A01C00B78F04 AS DateTime), 1, 0, CAST(0x0000A12A010981EC AS DateTime), CAST(0x0000A1330133C128 AS DateTime), CAST(0x0000A01C00B78F04 AS DateTime), 0, CAST(0x0000A1330133BB4C AS DateTime), 0, N'', 778, 0, 0, N'00000000-0000-0000-0000-000000000000', N'00000000-0000-0000-0000-000000000000', N'黄浦', N'00000000-0000-0000-0000-000000000000', N'上海市', N'admin1', 0, 0, N'admin1', N'321321', CAST(0x0000A01C00B78B80 AS DateTime), 0)
/****** Object:  Table [dbo].[DT_Passport_Roles]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Passport_Roles](
	[ID] [uniqueidentifier] NOT NULL,
	[RoleName] [nvarchar](16) NULL,
	[IsSystem] [bit] NULL,
 CONSTRAINT [PK_DT_Passport_Roles] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[DT_Passport_Roles] ([ID], [RoleName], [IsSystem]) VALUES (N'00000000-0000-0000-0000-000000000000', N'Administrators', 1)
INSERT [dbo].[DT_Passport_Roles] ([ID], [RoleName], [IsSystem]) VALUES (N'7b23f324-87b0-464d-9375-eab1327f5cc0', N'VIP', 0)
INSERT [dbo].[DT_Passport_Roles] ([ID], [RoleName], [IsSystem]) VALUES (N'b79b17e2-00c0-4031-a818-f3db5a72137d', N'普通管理员', 1)
/****** Object:  Table [dbo].[DT_PageOutput]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_PageOutput](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PageName] [varchar](50) NOT NULL,
	[Page] [int] NULL,
	[Numbers] [int] NULL,
 CONSTRAINT [PK__DT_PageOutput__51851410] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
SET IDENTITY_INSERT [dbo].[DT_PageOutput] ON
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (1, N'all', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (2, N'allhd', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (62, N'listabf08634-40e8-4ae3-aeef-04b4b88c25fb', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (63, N'listabf08634-40e8-4ae3-aeef-04b4b88c25fb', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (64, N'list7870ec31-2f31-4ed6-b69e-05c604005d6e', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (65, N'list7870ec31-2f31-4ed6-b69e-05c604005d6e', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (66, N'list2b8c38e1-986d-43ef-9c67-0b92473aa859', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (67, N'list2b8c38e1-986d-43ef-9c67-0b92473aa859', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (68, N'list3f6d6cd1-6fa2-4ff4-9581-0bab241930ab', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (69, N'list3f6d6cd1-6fa2-4ff4-9581-0bab241930ab', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (70, N'list4fd36ca5-d35c-45e0-8d24-52d6a45e2176', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (71, N'list4fd36ca5-d35c-45e0-8d24-52d6a45e2176', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (72, N'listd6122d63-349c-4c44-8f56-be150599a109', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (73, N'listd6122d63-349c-4c44-8f56-be150599a109', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (74, N'listb7c6fafc-fff3-410a-9d88-c510524f3a56', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (75, N'listb7c6fafc-fff3-410a-9d88-c510524f3a56', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (76, N'list4fad3352-9aab-4d30-bf2b-f356da57a388', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (77, N'list4fad3352-9aab-4d30-bf2b-f356da57a388', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (78, N'listd2970287-3e4a-45b7-9113-fb3175a62e9d', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (79, N'listd2970287-3e4a-45b7-9113-fb3175a62e9d', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (80, N'listb60b918f-c6bc-424d-850a-fe5e147308eb', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (81, N'listb60b918f-c6bc-424d-850a-fe5e147308eb', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (82, N'hdlist903cf6a0-c246-4582-815c-2a92ca8978c1', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (83, N'hdlistab4b2a4b-2c92-4f89-997b-44cb2edd36bd', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (84, N'hdlistd09292c1-7fb1-464c-a928-4a68bc6b10cc', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (85, N'hdlist5c6e919d-1ac1-4d50-8529-4c4aa261a068', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (86, N'hdlist108cf0fd-f5b4-4d85-9bc0-4f74b6383ba9', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (87, N'hdlista05374b7-ee1d-4dff-9384-595a96d12c4e', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (88, N'hdlist348cfb1f-8686-4e28-90fa-5d006583974d', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (89, N'hdlistfa155221-550e-4356-9bd0-66bd2633cbad', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (90, N'hdlist3bbe0452-f7be-4074-bdcc-888fdab676d5', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (91, N'hdlistbdcc6589-617e-4408-b84d-9193a67023fa', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (92, N'hdlist1bdb513c-361a-4559-9a3b-94da8badd4ad', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (93, N'hdlist7faaec8b-1986-429a-a951-9bccc4227e52', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (94, N'hdlist85a3b6b2-b29b-44a3-9a7d-b13a3285725a', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (95, N'hdlist4c9ba74a-eb90-4a7e-bbfe-d74159da7655', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (96, N'hdlist91643c48-e313-4f7b-84f9-d7778f27ecf0', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (97, N'hdliste555eb7c-2fb6-474d-9c89-e5fc8ce99f1e', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (98, N'hdlistccee7f9c-a200-41c1-aa0a-fdecd78ffcc6', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (99, N'hdlista9b865fe-8e63-4258-ae45-fe73fa634fbd', 1, 0)
INSERT [dbo].[DT_PageOutput] ([ID], [PageName], [Page], [Numbers]) VALUES (100, N'hdlist9a7d4289-35ac-4112-aa50-ffd0c86126c8', 1, 0)
SET IDENTITY_INSERT [dbo].[DT_PageOutput] OFF
/****** Object:  Table [dbo].[DT_Pack]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Pack](
	[ID] [uniqueidentifier] NOT NULL,
	[UserName] [nvarchar](32) NULL,
	[Tag] [nvarchar](32) NULL,
	[Title] [nvarchar](256) NULL,
	[Url] [nvarchar](256) NULL,
	[CreationDate] [datetime] NULL,
	[MediaID] [int] NULL,
	[IsHD] [bit] NULL,
 CONSTRAINT [PK_DT_Pack] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Messages]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Messages](
	[ID] [uniqueidentifier] NOT NULL,
	[ReceiveUserName] [nvarchar](32) NULL,
	[SendUserName] [nvarchar](32) NULL,
	[Title] [nvarchar](256) NULL,
	[Context] [ntext] NULL,
	[CreationDate] [datetime] NULL,
	[State] [tinyint] NULL,
	[IsReaded] [bit] NULL,
	[ParentID] [uniqueidentifier] NULL,
 CONSTRAINT [PK_DT_Messages] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Media_UserData]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_UserData](
	[UserName] [nvarchar](32) NOT NULL,
	[MediaCount] [int] NULL,
	[CommentCount] [int] NULL,
	[Company] [nvarchar](128) NULL,
	[Url] [nvarchar](256) NULL,
	[AlbumCount] [int] NULL,
 CONSTRAINT [PK_DT_Media_UserData] PRIMARY KEY CLUSTERED 
(
	[UserName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[DT_Media_UserData] ([UserName], [MediaCount], [CommentCount], [Company], [Url], [AlbumCount]) VALUES (N'admin', 2, 0, N'测试网', N'www.test.com', 0)
/****** Object:  Table [dbo].[DT_Media_Servers]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_Servers](
	[ID] [uniqueidentifier] NOT NULL,
	[Type] [tinyint] NULL,
	[Domain] [nvarchar](256) NULL,
	[FMSPath] [nvarchar](256) NULL,
	[Path] [nvarchar](256) NULL,
	[Running] [bit] NULL,
	[LastActiveTime] [datetime] NULL
) ON [PRIMARY]
GO
--INSERT [dbo].[DT_Media_Servers] ([ID], [Type], [Domain], [FMSPath], [Path], [Running], [LastActiveTime]) VALUES (N'ad36b076-a158-4612-b317-a7b6cb8419b1', 3, N'http://file.vpod50.com/', N'', N'E:\niejian\rel\Dingtai.ServerSite\', 1, CAST(0x0000A10F00B17998 AS DateTime))
/****** Object:  Table [dbo].[DT_Media_List]    Script Date: 12/27/2012 10:47:12 ******/
--SET ANSI_NULLS ON
--GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_List](
	[ID2] [uniqueidentifier] NOT NULL,
	[UserName] [nvarchar](64) NULL,
	[ChannelID] [uniqueidentifier] NULL,
	[AlbumID] [uniqueidentifier] NULL,
	[ServerID] [uniqueidentifier] NULL,
	[Name] [nvarchar](256) NULL,
	[ImageUrl] [nvarchar](256) NULL,
	[Tag] [nvarchar](256) NULL,
	[Detail] [ntext] NULL,
	[FileName] [nvarchar](32) NULL,
	[FileExt] [nvarchar](8) NULL,
	[FileSize] [datetime] NULL,
	[TotalView] [int] NULL,
	[TodayView] [int] NULL,
	[YestodayView] [int] NULL,
	[WeekView] [int] NULL,
	[MonthView] [int] NULL,
	[LastView] [datetime] NULL,
	[DigCount] [int] NULL,
	[PaiCount] [int] NULL,
	[CommentCount] [int] NULL,
	[PackCount] [int] NULL,
	[ReferCount] [int] NULL,
	[IsApproved] [bit] NULL,
	[IsConverted] [bit] NULL,
	[UploadDate] [datetime] NULL,
	[MediaType] [tinyint] NULL,
	[RecordServerID] [uniqueidentifier] NULL,
	[Download] [bit] NULL,
	[IsBest] [bit] NULL,
	[Point] [int] NULL,
	[UserBest] [bit] NULL,
	[UserTop] [bit] NULL,
	[PointCount] [int] NULL,
	[UpdateTime] [datetime] NULL,
	[WapUrl] [nvarchar](500) NULL,
	[Converted] [nvarchar](50) NULL,
	[IsHot] [bit] NULL,
	[ImageBest] [bit] NULL,
	[UploadType] [tinyint] NULL,
	[Number] [int] NULL,
	[ID] [int] IDENTITY(1,1) NOT NULL,
 CONSTRAINT [PK_DT_Media_List] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET IDENTITY_INSERT [dbo].[DT_Media_List] ON
INSERT [dbo].[DT_Media_List] ([ID2], [UserName], [ChannelID], [AlbumID], [ServerID], [Name], [ImageUrl], [Tag], [Detail], [FileName], [FileExt], [FileSize], [TotalView], [TodayView], [YestodayView], [WeekView], [MonthView], [LastView], [DigCount], [PaiCount], [CommentCount], [PackCount], [ReferCount], [IsApproved], [IsConverted], [UploadDate], [MediaType], [RecordServerID], [Download], [IsBest], [Point], [UserBest], [UserTop], [PointCount], [UpdateTime], [WapUrl], [Converted], [IsHot], [ImageBest], [UploadType], [Number], [ID]) VALUES (N'398db388-6616-45c1-b2a9-52ee4b12f650', N'admin', N'abf08634-40e8-4ae3-aeef-04b4b88c25fb', N'00000000-0000-0000-0000-000000000000', N'ad36b076-a158-4612-b317-a7b6cb8419b1', N'阿凡达', N'', N'阿凡达标签', N'阿凡达简介', N'20121226185831703978000', N'.mov', CAST(0x00008EAC00002328 AS DateTime), 1, 1, 0, 1, 1, CAST(0x0000A133013A15DC AS DateTime), 0, 0, 0, 0, 0, 1, 1, CAST(0x0000A1330138B520 AS DateTime), 0, NULL, 0, 0, 0, 1, 1, 0, CAST(0x0000A1330138B520 AS DateTime), NULL, N'', 0, 0, 0, 0, 772)
SET IDENTITY_INSERT [dbo].[DT_Media_List] OFF
/****** Object:  Table [dbo].[DT_Media_Convert]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_Convert](
	[ID] [uniqueidentifier] NOT NULL,
	[FileName] [nvarchar](256) NULL,
	[ServerID] [uniqueidentifier] NULL,
	[CurrentExt] [nvarchar](8) NULL,
	[IsConverted] [tinyint] NULL,
	[UploadDate] [datetime] NULL,
	[ConvertIndex] [int] NULL,
	[MediaType] [tinyint] NULL,
	[RecordServerID] [uniqueidentifier] NULL,
	[ImageTime] [int] NULL,
	[Type] [tinyint] NULL,
	[IsHD] [bit] NULL,
	[ServerNum] [int] NULL,
 CONSTRAINT [PK_DT_Media_Convert] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[DT_Media_Convert] ([ID], [FileName], [ServerID], [CurrentExt], [IsConverted], [UploadDate], [ConvertIndex], [MediaType], [RecordServerID], [ImageTime], [Type], [IsHD], [ServerNum]) VALUES (N'398db388-6616-45c1-b2a9-52ee4b12f650', N'20121226185831703978000', N'ad36b076-a158-4612-b317-a7b6cb8419b1', N'.mov', 3, CAST(0x0000A1330138B520 AS DateTime), -1, 0, NULL, 3, 0, 0, 0)
/****** Object:  Table [dbo].[DT_Media_Channels]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_Channels](
	[ID] [uniqueidentifier] NOT NULL,
	[Name] [nvarchar](32) NULL,
	[ImageUrl] [nvarchar](256) NULL,
	[Tag] [nvarchar](256) NULL,
	[Detail] [ntext] NULL,
	[Number] [tinyint] NULL,
	[FileCount] [int] NULL,
	[NewCount] [int] NULL,
	[AdID] [uniqueidentifier] NULL,
	[LastUpdate] [datetime] NULL,
	[ShowHome] [bit] NULL,
	[IsHide] [bit] NULL,
	[ParentID] [uniqueidentifier] NULL,
	[IsBest] [bit] NULL,
 CONSTRAINT [PK_DT_Media_Channel] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
INSERT [dbo].[DT_Media_Channels] ([ID], [Name], [ImageUrl], [Tag], [Detail], [Number], [FileCount], [NewCount], [AdID], [LastUpdate], [ShowHome], [IsHide], [ParentID], [IsBest]) VALUES (N'abf08634-40e8-4ae3-aeef-04b4b88c25fb', N'测试频道', N'/Uploads/admin/images/2333848_145644089_2.jpg', N'测试频道', N'测试频道', 1, 0, 0, N'20b69d6c-9103-49f7-a32f-9b902497f696', CAST(0x00009E0B00000000 AS DateTime), 1, 0, N'00000000-0000-0000-0000-000000000000', 1)
/****** Object:  Table [dbo].[DT_Media_Albums]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Media_Albums](
	[ID] [uniqueidentifier] NOT NULL,
	[ChannelID] [uniqueidentifier] NULL,
	[UserName] [nvarchar](64) NULL,
	[Name] [nvarchar](256) NULL,
	[ImageUrl] [nvarchar](256) NULL,
	[Tag] [nvarchar](256) NULL,
	[Detail] [ntext] NULL,
	[TotalView] [int] NULL,
	[TodayUpdate] [int] NULL,
	[YestodayUpdate] [int] NULL,
	[WeekUpdate] [int] NULL,
	[MonthUpdate] [int] NULL,
	[CreateDate] [datetime] NULL,
	[LastUpdate] [datetime] NULL,
	[FileCount] [int] NULL,
	[NewCount] [int] NULL,
	[IsApproved] [bit] NULL,
	[IsBest] [bit] NULL,
 CONSTRAINT [PK_DT_Media_Albums] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Media_Ads]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[DT_Media_Ads](
	[ID] [uniqueidentifier] NOT NULL,
	[Name] [nvarchar](256) NULL,
	[Type] [tinyint] NULL,
	[Path] [nvarchar](256) NULL,
	[StartDate] [datetime] NULL,
	[EndDate] [datetime] NULL,
	[ShowTime] [int] NULL,
	[AdWidth] [int] NOT NULL,
	[AdHeight] [int] NOT NULL,
	[AdPosition] [varchar](20) NULL,
	[AdLink] [nvarchar](200) NULL,
	[AdStatus] [char](1) NOT NULL,
 CONSTRAINT [PK_DT_Media_Ads] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
INSERT [dbo].[DT_Media_Ads] ([ID], [Name], [Type], [Path], [StartDate], [EndDate], [ShowTime], [AdWidth], [AdHeight], [AdPosition], [AdLink], [AdStatus]) VALUES (N'dff4cf13-7e0b-42d5-a55c-23ab10a4dbad', N'角标广告', 0, NULL, CAST(0x00009FC500C5BB15 AS DateTime), CAST(0x0000A29F00C5BB15 AS DateTime), 5, 100, 100, N'bottom-right', NULL, N'N')
INSERT [dbo].[DT_Media_Ads] ([ID], [Name], [Type], [Path], [StartDate], [EndDate], [ShowTime], [AdWidth], [AdHeight], [AdPosition], [AdLink], [AdStatus]) VALUES (N'9a573440-155c-467b-b45e-2fb70ee95d82', N'暂停广告', 0, NULL, CAST(0x00009FC500C5BB15 AS DateTime), CAST(0x0000A29F00C5BB15 AS DateTime), 5, 100, 100, NULL, NULL, N'N')
INSERT [dbo].[DT_Media_Ads] ([ID], [Name], [Type], [Path], [StartDate], [EndDate], [ShowTime], [AdWidth], [AdHeight], [AdPosition], [AdLink], [AdStatus]) VALUES (N'178a7624-6b76-43eb-9d98-4a272733c4ba', N'后置Flash广告地址', 0, NULL, CAST(0x00009FC500C5BB15 AS DateTime), CAST(0x0000A29F00C5BB15 AS DateTime), 5, 100, 100, NULL, NULL, N'N')
INSERT [dbo].[DT_Media_Ads] ([ID], [Name], [Type], [Path], [StartDate], [EndDate], [ShowTime], [AdWidth], [AdHeight], [AdPosition], [AdLink], [AdStatus]) VALUES (N'19f6c05a-926f-46e9-8442-895228a9a0d2', N'前置视频广告', 0, NULL, CAST(0x0000A11A01298BE0 AS DateTime), CAST(0x0000A13701299540 AS DateTime), 3, 220, 110, N'top-right', NULL, N'N')
INSERT [dbo].[DT_Media_Ads] ([ID], [Name], [Type], [Path], [StartDate], [EndDate], [ShowTime], [AdWidth], [AdHeight], [AdPosition], [AdLink], [AdStatus]) VALUES (N'0c77443f-8a2d-4f2c-b708-8e1b8f7b3404', N'前置Flash广告', 0, NULL, CAST(0x00009FC500C5BB15 AS DateTime), CAST(0x0000A29F00C5BB15 AS DateTime), 5, 100, 100, N'top-left', NULL, N'N')
/****** Object:  Table [dbo].[DT_Logs]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Logs](
	[ID] [uniqueidentifier] NOT NULL,
	[Message] [nvarchar](4000) NULL,
	[UserName] [nvarchar](32) NULL,
	[CreationDate] [datetime] NULL,
	[Guid] [uniqueidentifier] NULL,
 CONSTRAINT [PK_DT_Logs] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Friends]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Friends](
	[UserName] [nvarchar](32) NOT NULL,
	[FriendName] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_DT_Friends] PRIMARY KEY CLUSTERED 
(
	[UserName] ASC,
	[FriendName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Count]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Count](
	[ID] [uniqueidentifier] NOT NULL,
	[LoginCount] [int] NULL,
	[RegisterCount] [int] NULL,
	[MediaCount] [int] NULL,
	[CommentCount] [int] NULL,
	[TodayDate] [datetime] NULL,
	[PlayCount] [int] NULL,
 CONSTRAINT [PK_DT_Count] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
INSERT [dbo].[DT_Count] ([ID], [LoginCount], [RegisterCount], [MediaCount], [CommentCount], [TodayDate], [PlayCount]) VALUES (N'a34c901d-d447-48c1-8830-34499eb546ef', 1, 0, 1, 0, CAST(0x0000A13300000000 AS DateTime), 1)
/****** Object:  Table [dbo].[DT_Comment]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Comment](
	[ID] [uniqueidentifier] NOT NULL,
	[ArticleID] [uniqueidentifier] NULL,
	[ArticleType] [tinyint] NULL,
	[UserName] [nvarchar](32) NULL,
	[Title] [nvarchar](256) NULL,
	[Context] [nvarchar](4000) NULL,
	[CreationDate] [datetime] NULL,
	[IsApproved] [bit] NULL,
	[Ishd] [bit] NULL,
	[CommentType] [tinyint] NULL,
 CONSTRAINT [PK_DT_Comments] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[DT_Cache]    Script Date: 12/27/2012 10:47:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[DT_Cache](
	[CacheKey] [nvarchar](200) NOT NULL,
	[CacheValue] [nvarchar](200) NOT NULL,
	[UpdateTime] [datetime] NOT NULL,
	[Name] [nvarchar](100) NOT NULL
) ON [PRIMARY]
GO
/****** Object:  Default [DF__DT_Media___AdWid__789EE131]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_Ads] ADD  DEFAULT ((0)) FOR [AdWidth]
GO
/****** Object:  Default [DF__DT_Media___AdHei__7993056A]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_Ads] ADD  DEFAULT ((0)) FOR [AdHeight]
GO
/****** Object:  Default [DF__DT_Media___AdSta__7A8729A3]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_Ads] ADD  DEFAULT ('N') FOR [AdStatus]
GO
/****** Object:  Default [DF_DT_Media_Convert_IsHD]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_Convert] ADD  CONSTRAINT [DF_DT_Media_Convert_IsHD]  DEFAULT (0) FOR [IsHD]
GO
/****** Object:  Default [DF_DT_Media_List_PointCount]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_List] ADD  CONSTRAINT [DF_DT_Media_List_PointCount]  DEFAULT ((0)) FOR [PointCount]
GO
/****** Object:  Default [DF_DT_Media_List_UpdateTime]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_List] ADD  CONSTRAINT [DF_DT_Media_List_UpdateTime]  DEFAULT (getdate()) FOR [UpdateTime]
GO
/****** Object:  Default [DF_DT_Media_UserData_AlbumCount]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Media_UserData] ADD  CONSTRAINT [DF_DT_Media_UserData_AlbumCount]  DEFAULT (0) FOR [AlbumCount]
GO
/****** Object:  Default [DF_DT_Passport_Users_IsApproved]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IsApproved]  DEFAULT (0) FOR [IsApproved]
GO
/****** Object:  Default [DF_DT_Passport_Users_IsLockedOut]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IsLockedOut]  DEFAULT (0) FOR [IsLockedOut]
GO
/****** Object:  Default [DF_DT_Passport_Users_IsVipMember]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IsVipMember]  DEFAULT (0) FOR [IsVipMember]
GO
/****** Object:  Default [DF_DT_Passport_Users_IsVipUser]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IsVipUser]  DEFAULT (0) FOR [IsVipUser]
GO
/****** Object:  Default [DF_DT_Passport_Users_ParentID]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_ParentID]  DEFAULT ('00000000-0000-0000-0000-000000000000') FOR [ParentID]
GO
/****** Object:  Default [DF_DT_Passport_Users_ChannalID]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_ChannalID]  DEFAULT ('00000000-0000-0000-0000-000000000000') FOR [ChannalID]
GO
/****** Object:  Default [DF_DT_Passport_Users_ColumnID]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_ColumnID]  DEFAULT ('00000000-0000-0000-0000-000000000000') FOR [ColumnID]
GO
/****** Object:  Default [DF_DT_Passport_Users_RealName]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_RealName]  DEFAULT ('') FOR [RealName]
GO
/****** Object:  Default [DF_DT_Passport_Users_Gender]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_Gender]  DEFAULT (0) FOR [Gender]
GO
/****** Object:  Default [DF_DT_Passport_Users_IMType]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IMType]  DEFAULT (0) FOR [IMType]
GO
/****** Object:  Default [DF_DT_Passport_Users_IM]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_IM]  DEFAULT ('') FOR [IM]
GO
/****** Object:  Default [DF_DT_Passport_Users_TEL]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_TEL]  DEFAULT ('') FOR [TEL]
GO
/****** Object:  Default [DF_DT_Passport_Users_Birthday]    Script Date: 12/27/2012 10:47:12 ******/
ALTER TABLE [dbo].[DT_Passport_Users] ADD  CONSTRAINT [DF_DT_Passport_Users_Birthday]  DEFAULT ('1900-1-1') FOR [Birthday]
GO
