using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for DataGridTest.
	/// </summary>
	public class DataGridTest : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Button btnRun;
		protected System.Web.UI.WebControls.TextBox txtSTMT;
		protected System.Web.UI.WebControls.DataGrid dgQuery;

		private DataTable m_dtFieldNames = null;
		private ArrayList m_alPKeys      = null;
		private string    m_sIdentityCol = null;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			m_alPkeys      = new ArrayList ();

			if (!IsPostBack)
			{
				BindGrid ();
			}
		}

		protected void BindGrid ()
		{
			// don't forget to come back and set the key field for the data grid
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try 
			{
				// store our primary key fields in a list
				// it would appear you can only use a single field name to set the DataKeyField
				// this is not pratical for a multi field primary key
				DataTable dt = db.ExecDT ("exec sp_pkeys '" + Request["TableName"].ToString () + "'");
					
				foreach (DataRow row in dt.Rows)
				{
					m_alPKeys.Add (row["COLUMN_NAME"].ToString ());
				}

				// fetch the columns to display in the data grid
				// the pk fields will be shown and disabled
				// store the field names for use in our update, select, insert, and delete stmts
				dt = db.ExecDT ("exec sp_columns '" + Request["TableName"].ToString () + "'");

				string sFieldList = null;
					
				m_dtFieldNames = new DataTable ("Fields");
				DataColumn dcCol;
				dcCol = dtTable.Columns.Add ("COLUMN_NAME", typeof (string));
				dcCol = dtTable.Columns.Add ("TYPE_NAME",   typeof (SqlDbType));

				foreach (DataRow row in dt.Rows)
				{
					if (sFieldList != null)
					{
						sFieldList += ",";;
					}

					sFieldList += row["COLUMN_NAME"].ToString ();

					// populate DataTable.
					if (row["TYPE_NAME"].ToString ().IndexOf ("identity", 0) > 0)
					{
						m_sIdentityCol = row["COLUMN_NAME"].ToString ();
						dtTable.Rows.Add (new object[] {row["COLUMN_NAME"].ToString (), GetSqlDbType (row["TYPE_NAME"].ToString ().IndexOf ("identity", 0).Substring (0, row["TYPE_NAME"].ToString ().IndexOf ("identity", 0) - 1))});
					}
					else
					{
						dtTable.Rows.Add (new object[] {row["COLUMN_NAME"].ToString (), GetSqlDbType(row["TYPE_NAME"].ToString ())});
					}
				}

				dgQuery.DataSource = db.ExecDS ("select " + sFieldList + " from " + Request["TableName"].ToString ());
				dgQuery.DataBind ();
			}
			catch (Exception ex)
			{
				MsgHandlers.DisplayError (ex);
				Response.End ();
			}
		}

		protected void dgQueury_ItemDataBound (object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			if (e.Item.ItemType == ListItemType.EditItem)
			{
				for (int i = 0; i < e.Item.Controls.Count; i++)
				{
					if (e.Item.Controls[i].Controls[0].GetType().ToString() == "System.Web.UI.WebControls.TextBox")
					{
						TextBox tb = (TextBox)e.Item.Controls[i].Controls[0];
						tb.Text = Server.HtmlDecode(tb.Text);
					}
				}
			}
		}

		protected void dgQueury_Cancel (Object sender, DataGridCommandEventArgs e)
		{
			dgQueury.EditItemIndex = -1;
			BindGrid ();
		}

		protected void dgQueury_Edit (Object sender, DataGridCommandEventArgs e)
		{
			dgQueury.EditItemIndex = (int ) e.Item.ItemIndex;

			BindGrid ();
        
			for (int i = 0; i < e.Item.Cells.Count; i++)
			{
        
				e.Item.Cells[i].Text = Server.HtmlDecode (e.Item.Cells[i].Text);
				Trace.Write (e.Item.Cells[i].Text);
			}
		}

		protected void dgQueury_Update (Object sender, DataGridCommandEventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try 
			{
				SqlCommand cmd = new SqlCommand ();

				string sTemp  = null;
				string sWhere = null;

				// create the update stmt from the field names and primary key array lists
				// as a parameterized query
				string sSqlUpdate = "UPDATE " + Request["TableName"].ToString () + " SET ";

				foreach (DataRow row in m_dtFieldNames.Rows)
				{
					if (String.Compare (m_sIdentityCol, row["COLUMN_NAME"].ToString (), true) == 0 ||
						m_alPKeys.IndexOf (row["COLUMN_NAME"].ToString (), 0) != -1)
					{
						if (sWhere != null)
						{
							sWhere += ",";
						}

						sWhere += row["COLUMN_NAME"].ToString () + " = " + "@" + row["COLUMN_NAME"].ToString ();
						cmd.Parameters.Add (new SqlParameter("@" + row["COLUMN_NAME"].ToString (), (SqlDbType ) row["TYPE_NAME"].ToString (), 11));
					}
					else
					{
						if (sTemp != null)
						{
							sTemp += ",";
						}

						sTemp += row["COLUMN_NAME"].ToString () + " = " + "@" + row["COLUMN_NAME"].ToString ();
						cmd.Parameters.Add (new SqlParameter("@" + row["COLUMN_NAME"].ToString (), (SqlDbType ) row["TYPE_NAME"].ToString (), 11));
					}
				}

				sSqlUpdate += sTemp + " where " + sWhere;

				cmd.CommandText = sSqlUpdate;
			}
			catch (Exception ex)
			{
				MsgHandlers.DisplayError (ex);
				Response.End ();
			}

			/*
			SqlCommand myCommand = new SqlCommand (updateCmd, myConnection);

			myCommand.Parameters.Add(new SqlParameter("@Id", SqlDbType.NVarChar, 11));
			myCommand.Parameters.Add(new SqlParameter("@LName", SqlDbType.NVarChar, 40));
			myCommand.Parameters.Add(new SqlParameter("@FName", SqlDbType.NVarChar, 20));
			myCommand.Parameters.Add(new SqlParameter("@Phone", SqlDbType.NChar, 12));
			myCommand.Parameters.Add(new SqlParameter("@Address", SqlDbType.NVarChar, 40));
			myCommand.Parameters.Add(new SqlParameter("@City", SqlDbType.NVarChar, 20));
			myCommand.Parameters.Add(new SqlParameter("@State", SqlDbType.NChar, 2));
			myCommand.Parameters.Add(new SqlParameter("@Zip", SqlDbType.NChar, 5));
			myCommand.Parameters.Add(new SqlParameter("@Contract", SqlDbType.NVarChar,1));

			myCommand.Parameters["@Id"].Value = MyDataGrid.DataKeys[(int)e.Item.ItemIndex];

			String[] cols = {"@Id","@LName","@FName","@Phone","@Address","@City","@State","@Zip","@Contract"};

			int numCols = e.Item.Cells.Count;
			for (int i=2; i<numCols-1; i++) //skip first, second and last column
			{
				String colvalue =((TextBox)e.Item.Cells[i].Controls[0]).Text;

				// check for null values in required fields
				if (i<6 && colvalue == "")
				{
					//Message.InnerHtml = "ERROR: Null values not allowed for Author ID, Name or Phone";
					//Message.Style["color"] = "red";
					return;
				}

				myCommand.Parameters[cols[i-1]].Value = Server.HtmlEncode(colvalue);
			}

			//append last row, converting true/false values to 0/1
			if (String.Compare(((TextBox)e.Item.Cells[numCols-1].Controls[0]).Text, "true", true)==0)
				myCommand.Parameters["@Contract"].Value =  "1";
			else
				myCommand.Parameters["@Contract"].Value =  "0";

			myCommand.Connection.Open();

			try
			{
				myCommand.ExecuteNonQuery();
				//Message.InnerHtml = "<b>Record Updated</b><br>" + updateCmd;
				dgQueury.EditItemIndex = -1;
			}
			catch (SqlException exc)
			{
				//if (exc.Number == 2627)
				//	Message.InnerHtml = "ERROR: A record already exists with the same primary key";
				//else
				//	Message.InnerHtml = "ERROR: Could not update record, please ensure the fields are correctly filled out";
				//Message.Style["color"] = "red";
			}

			myCommand.Connection.Close();
			*/

			BindGrid ();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
