using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for DatabaseProperties.
	/// </summary>
	public partial class DatabaseProperties : System.Web.UI.Page
	{
		protected ArrayList alDBProps = null;
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					DataSet ds = db.ExecDS ("exec sp_helpdb '" + db.Catalog + "'");

					alDBProps.Add (ds.Tables[0].Rows[0]["name"].ToString ());
					alDBProps.Add (ds.Tables[0].Rows[0]["db_size"].ToString ());
					alDBProps.Add (ds.Tables[0].Rows[0]["owner"].ToString ());
					alDBProps.Add (ds.Tables[0].Rows[0]["created"].ToString ());

					alDBProps.Add (ds.Tables[1].Rows[0]["size"].ToString ());
					alDBProps.Add (ds.Tables[1].Rows[0]["maxsize"].ToString ());
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			alDBProps = new ArrayList ();

			this.ibtnDropDatabase.Click += new System.Web.UI.ImageClickEventHandler(this.ibtnDropDatabase_Click);

		}
		#endregion

		private void ibtnDropDatabase_Click(object sender, System.Web.UI.ImageClickEventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			string dbToDrop = db.Catalog;

			db.Catalog = "master";
	
			try
			{
				db.ExecNonQuery ("DROP DATABASE '" + dbToDrop + "'");

				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'Default.aspx';" +
					"\n</SCRIPT>");
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}
	}
}
