using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for EditLogin.
	/// </summary>
	public partial class EditLogin : System.Web.UI.Page
	{
		protected string LoginName = null;
		protected string Database = null;
		protected string Language = null;
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			LoginName = Request["LoginName"].ToString ();
			txtLoginName.Text = LoginName;

			if (!Page.IsPostBack)
			{
				// Setup a features string. This one has most of the common options
				string sScript = "window.open('ChangePassword.aspx?LoginName=" + LoginName + "', '', 'width=450, height=330'); passwordWin.focus();";

				// Add this to the server controls attributes collection
				btnChngPassword.Attributes.Add ("onclick", sScript);

				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					// set the command text and execute the sp_database reader
					// bind the reader results to the database dropdown list box
					cboDBNames.DataSource = db.ExecDT ("exec sp_databases");
					cboDBNames.DataBind ();

					// set the command text and execute the sp_helpLanguage reader
					// bind the reader results to the languages dropdown list box
					cboLanguages.DataSource = db.ExecDT ("exec sp_helpLanguage");
					cboLanguages.DataBind ();

					// set the command text and execute the sp_helpsrvrole reader
					// bind the reader results to the server roles check list box
					chkRoles.DataSource = db.ExecDT ("exec sp_helpsrvrole");
					chkRoles.DataBind ();

					DataTable dt = null;

					if (LoginName.Length > 0)
					{
						// select each of the server roles for this login
						// sp_helpsrvrolemember '@srvrolename' returns a list of
						// server logins associated with the given @srvrolename
						// the check list box DataFieldValue contains the @srvrolename
						foreach (ListItem li in chkRoles.Items)
						{
							dt = db.ExecDT ("exec sp_helpsrvrolemember " + "'" + li.Value.ToString () + "'");

							foreach (DataRow row in dt.Rows)
							{
								if (String.Compare (row["MemberName"].ToString (), LoginName, true) == 0)
								{
									li.Selected = true;
									break;
								}
							}
						}

						// fetch the default database name and language for this login
						dt = db.ExecDT ("exec sp_helplogins " + "'" + LoginName + "'");
						
						Database = Convert.IsDBNull (dt.Rows[0]["DefDBName"].ToString ())   ? "" : dt.Rows[0]["DefDBName"].ToString ();
						Language = Convert.IsDBNull (dt.Rows[0]["DefLangName"].ToString ()) ? "" : dt.Rows[0]["DefLangName"].ToString ();

						// cycle through the list and find the database that matches the default
						foreach (ListItem li in cboDBNames.Items)
						{
							if (String.Compare (li.Value.ToString (), Database, true) == 0)
							{
								li.Selected = true;
								break;
							}
						}

						// cycle through the list and find the language that matches the default
						foreach (ListItem li in cboLanguages.Items)
						{
							if (String.Compare (li.Value.ToString (), Language, true) == 0)
							{
								li.Selected = true;
								break;
							}
						}
					}
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnSaveLogin_Click(object sender, System.EventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				foreach (ListItem li in chkRoles.Items)
				{
					if (li.Selected)
					{
						db.ExecNonQuery ("exec sp_addsrvrolemember '" + LoginName + "', '" + li.Value.ToString () + "'");
					}
					else
					{
						db.ExecNonQuery ("exec sp_dropsrvrolemember '" + LoginName + "', '" + li.Value.ToString () + "'");
					}
				}

				db.ExecNonQuery ("exec sp_defaultdb '" + LoginName + "', '" + Database + "'");

				if (Language != null)
				{
					db.ExecNonQuery ("exec sp_defaultlanguage '" + LoginName + "', '" + Language + "'");
				}
				
				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'logins.aspx';" +
					"\n</SCRIPT>");
			}
			catch (Exception ex)
			{		
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}

		protected void cboDBNames_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Database = cboDBNames.Items[cboDBNames.SelectedIndex].ToString ();
		}

		protected void cboLanguages_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Language = cboLanguages.Items[cboLanguages.SelectedIndex].ToString ();
		}
	}
}
