using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for EditStoredProc.
	/// </summary>
	public partial class EditStoredProc : System.Web.UI.Page
	{
		private string sStoredProc = null;
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			sStoredProc = Request["SP"].ToString ();

			if (sStoredProc.Length > 0)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					DataSet ds = db.ExecDS ("exec sp_helptext '" + sStoredProc + "'");

					foreach (DataRow row in ds.Tables[0].Rows)
					{
						txtSPText.Text += row["text"].ToString ();
					}
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
			else
			{
				txtSPText.Text = "CREATE PROCEDURE [OWNER].[PROCEDURE NAME] AS";
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnSave_Click(object sender, System.EventArgs e)
		{
			if (sStoredProc != null)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					db.ExecDropObject ("DROP Procedure " + sStoredProc, txtSPText.Text);

					Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
						"\nparent.frames[\"MainFrame\"].location = 'ListStoredProcs.aspx';" +
						"\n</SCRIPT>");
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}
	}
}
