using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for InsertTableData.
	/// </summary>
	public partial class InsertTableData : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					dlInsertData.DataSource = db.ExecDT ("exec sp_columns '" + Request["table"].ToString () + "'");
					dlInsertData.DataBind ();
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		protected void OnItemCreated (Object sender, DataListItemEventArgs e)
		{
			DataRowView drv = (DataRowView) e.Item.DataItem;

			if (drv != null)
			{
				foreach (Control c in e.Item.Controls)
				{
					if (String.Compare (c.GetType ().ToString (), "System.Web.UI.WebControls.TextBox", true) == 0)
					{
						if (drv.Row["type_name"].ToString ().IndexOf ("identity", 0) > 0)
						{
							((TextBox) c).TextMode = TextBoxMode.SingleLine;
							((TextBox) c).Enabled  = false;
						}
						else if (String.Compare ("char",      drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("varchar",   drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("nchar",     drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("nvarchar",  drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("text",      drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("ntext",     drv.Row["type_name"].ToString (), true) == 0 ||
								 String.Compare ("varbinary", drv.Row["type_name"].ToString (), true) == 0 )
						{
							((TextBox) c).Text     = String.Empty;
							((TextBox) c).TextMode = TextBoxMode.MultiLine;
						}
					}
				}
			}
		}

		protected string GetDataType (string sValue)
		{
			string html = sValue;

			int iIndex = sValue.IndexOf ("identity", 0);

			if (iIndex > 0)
			{
				html = sValue.Substring (0, iIndex - 1);
			}

			return html;
		}

		protected string GetData (string sValue, string sDefault)
		{
			string html = String.Empty;

			if (sValue.IndexOf ("identity", 0) > 0)
			{
				html = "Identity Column";
			}
			else if (sDefault.Length > 0)
			{
				html = sDefault.Substring (1, sDefault.Length - 2);
			}

			return html;
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
		}
		#endregion

		/// <summary>
		/// Add the required logic to handle the field data types
		/// Right now it assumes the data entered is pre-formated
		/// for the data type, i.e. char, 'Hello World'
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected void btnInsert_Click(object sender, System.EventArgs e)
		{
			string sSqlFieldList = null;
			string sSqlValueList = null;

			foreach (DataListItem item in dlInsertData.Items)
			{
				foreach (Control c in item.Controls)
				{
					if (String.Compare (c.GetType ().ToString (), "System.Web.UI.WebControls.TextBox", true) == 0)
					{
						if (((TextBox) c).Text.IndexOf ("Identity", 0) == -1)
						{
							if (sSqlFieldList != null)
							{
								sSqlFieldList += " , ";
							}

							if (sSqlValueList != null)
							{
								sSqlValueList += " , ";
							}

							sSqlFieldList += ((Label) item.FindControl ("lblColName")).Text;
							sSqlValueList += ((TextBox) c).Text;
						}
					}
				}
			}

			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				db.ExecNonQuery ("insert into " + Request["Table"].ToString () + " (" + sSqlFieldList + ")" + " values (" + sSqlValueList + ")");

				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'TableProperties.aspx?Table=" + Request["Table"].ToString () + "';" +
					"\n</SCRIPT>");
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}
	}
}
