using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for ListStoredProcs.
	/// </summary>
	public partial class ListStoredProcs : System.Web.UI.Page
	{
		// establish a common cache key... reduces tipynG Erorrs
		const string LIST_SPROCS_DATASET_CACHE_KEY = "ListStoredProcsDataSet";


		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				dlStoredProcs.DataSource = GetStoredProcs ();
				dlStoredProcs.DataBind ();
			}
		}

		/// <summary>Retrieves cached dataset of the databases in the Sql Server.</summary>
		/// <returns>populated dataset with databases</returns>
		private DataTable GetStoredProcs ()
		{
			//DataTable dtTable = (DataTable) this.Context.Cache[LIST_SPROCS_DATASET_CACHE_KEY];
			DataTable dtTable = null;

			if (dtTable == null)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					DataTable dt = db.ExecDT ("exec sp_stored_procedures");

					dtTable = new DataTable ("StoredProcs");

					DataColumn dcCol;
					dcCol = dtTable.Columns.Add ("PROCEDURE_NAME",  typeof (string));
					dcCol = dtTable.Columns.Add ("PROCEDURE_OWNER", typeof (string));
					dcCol = dtTable.Columns.Add ("PROCEDURE_TYPE",  typeof (string));

					// populate DataTable.
					foreach (DataRow row in dt.Rows)
					{
						if (String.Compare (row["PROCEDURE_NAME"].ToString ().Substring (0, 3), "dt_", true) != 0)
						{
							dtTable.Rows.Add (new object[] {row["PROCEDURE_NAME"].ToString ().Substring (0, row["PROCEDURE_NAME"].ToString ().IndexOf (";",0)),
															   row["PROCEDURE_OWNER"].ToString (),
															   row["PROCEDURE_TYPE"].ToString ()});
						}
					}
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			
				//this.Context.Cache.Add(LIST_SPROCS_DATASET_CACHE_KEY, 
				//	dtTable, 
				//	null, 
				//	DateTime.Now.AddMinutes(5), 
				//	TimeSpan.Zero, 
				//	System.Web.Caching.CacheItemPriority.Normal, 
				//	null 
				//	);
			
			}

			return dtTable;
		}

		protected void OnItemCommand (Object sender, DataListCommandEventArgs e)
		{
			dlStoredProcs.SelectedIndex = e.Item.ItemIndex;
			dlStoredProcs.DataSource = GetStoredProcs ();
			dlStoredProcs.DataBind ();
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}
		#endregion
	}
}
