using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for NewTable.
	/// </summary>
	public partial class NewTable : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				DataTable dt = new DataTable ("Fields");

				DataColumn dcCol;
				dcCol = dt.Columns.Add ("id",        typeof (string));
				dcCol = dt.Columns.Add ("pk",        typeof (string));
				dcCol = dt.Columns.Add ("name",      typeof (string));
				dcCol = dt.Columns.Add ("type",      typeof (string));
				dcCol = dt.Columns.Add ("length",    typeof (string));
				dcCol = dt.Columns.Add ("precision", typeof (string));
				dcCol = dt.Columns.Add ("scale",     typeof (string));
				dcCol = dt.Columns.Add ("nullable",  typeof (string));
				dcCol = dt.Columns.Add ("default",   typeof (string));
				dcCol = dt.Columns.Add ("identity",  typeof (string));
				dcCol = dt.Columns.Add ("seed",      typeof (string));
				dcCol = dt.Columns.Add ("increment", typeof (string));

				// populate DataTable.
				for (int i = 0; i < 64; i++)
				{
					dt.Rows.Add (new object[] {i.ToString (), "", "", "", "", "", "", "", "", "", "", ""});
				}

				dlFields.DataSource = dt;
				dlFields.DataBind ();
			}
		}

		protected DataTable GetDataTypes ()
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			DataTable dtTable = new DataTable ("DataTypes");

			try
			{
				DataTable dt = db.ExecDT ("select name, xtype, length, xprec, xscale, allownulls from master..systypes");
				//DataTable dt = db.ExecDT ("select name, xtype, length, xprec, xscale, allownulls from systypes");

				DataColumn dcCol;
				dcCol = dtTable.Columns.Add ("name",       typeof (string));
				dcCol = dtTable.Columns.Add ("xtype",      typeof (int));
				dcCol = dtTable.Columns.Add ("length",     typeof (int));
				dcCol = dtTable.Columns.Add ("xprec",      typeof (int));
				dcCol = dtTable.Columns.Add ("xscale",     typeof (int));
				dcCol = dtTable.Columns.Add ("allownulls", typeof (bool));

				// populate DataTable.
				foreach (DataRow row in dt.Rows)
				{
					dtTable.Rows.Add (new object[] {row["name"].ToString (),
														Convert.ToInt32 (row["xtype"].ToString ()),
														Convert.ToInt32 (row["length"].ToString ()),
														Convert.ToInt32 (row["xprec"].ToString ()),
														Convert.ToInt32 (row["xscale"].ToString ()),
													    Convert.ToBoolean (row["allownulls"].ToString ())});
				}
			}
			catch (Exception ex)
			{
				string s = ex.Message;
			}

			return dtTable;
		}

		protected void OnIdentityClick (Object sender, EventArgs e)
		{
			((TextBox ) dlFields.Controls[0].FindControl ("txtSeedFR")).Enabled      = ((CheckBox) sender).Checked;
			((TextBox ) dlFields.Controls[0].FindControl ("txtIncrementFR")).Enabled = ((CheckBox) sender).Checked;
		}

		protected void OnDataTypeChange (Object sender, EventArgs e)
		{
			//name				xtype	status	xusertype	length	xprec	xscale	allownulls
			//---------------	-----	------	---------	------	-----	------	----------
			//bigint			  127        0        127        8     19        0
			//binary              173        2        173     8000      0        0
			//bit                 104        0        104        1      1        0
			//char                175        2        175     8000      0        0
			//datetime             61        0         61        8     23        3
			//decimal             106        0        106       17     38       38
			//float                62        0         62        8     53        0
			//image                34        0         34       16      0        0
			//int                  56        0         56        4     10        0
			//money                60        0         60        8     19        4
			//nchar               239        2        239     8000      0        0
			//ntext                99        0         99       16      0        0
			//numeric             108        0        108       17     38       38
			//nvarchar            231        2        231     8000      0        0
			//real                 59        0         59        4     24        0
			//smalldatetime        58        0         58        4     16        0
			//smallint             52        0         52        2      5        0
			//smallmoney          122        0        122        4     10        4
			//sql_variant          98        0         98     8016      0        0
			//sysname             231        1        256      256      0        0
			//text                 35        0         35       16      0        0
			//timestamp           189        1        189        8      0        0
			//tinyint              48        0         48        1      3        0
			//uniqueidentifier     36        0         36       16      0        0
			//varbinary           165        2        165     8000      0        0
			//varchar             167        2        167     8000      0        0

			//string z = ((DropDownList) sender).Items[((DropDownList) sender).SelectedIndex].Value;
			//string t = ((DropDownList) sender).SelectedItem.Text;

			DataRow[] row = GetDataTypes ().Select ("name = '" + ((DropDownList) sender).Items[((DropDownList) sender).SelectedIndex].Text + "'");

			if (String.Compare (((DropDownList ) sender).ID, "cboTypeFR", true) == 0)
			{
				((TextBox ) dlFields.Controls[0].FindControl ("txtLengthFR")).Text    = row[0]["length"].ToString ();
				((TextBox ) dlFields.Controls[0].FindControl ("txtPrecisionFR")).Text = row[0]["xprec"].ToString ();
				((TextBox ) dlFields.Controls[0].FindControl ("txtScaleFR")).Text     = row[0]["xscale"].ToString ();

				switch (Convert.ToInt32 (row[0]["xtype"]))
				{
					// length.enable    = true
					// precision.enable = false
					// scale.enable     = false
					case 173:
					case 175:
					case 231:
					case 165:
					case 167:
					case 239:
					{
						((TextBox ) dlFields.Controls[0].FindControl ("txtLengthFR")).Enabled    = true;
						((TextBox ) dlFields.Controls[0].FindControl ("txtPrecisionFR")).Enabled = false;
						((TextBox ) dlFields.Controls[0].FindControl ("txtScaleFR")).Enabled     = false;
					}
					break;

					// length.enable    = false
					// precision.enable = true
					// scale.enable     = true
					case 106:
					case 108:
					{
						((TextBox ) dlFields.Controls[0].FindControl ("txtLengthFR")).Enabled    = false;
						((TextBox ) dlFields.Controls[0].FindControl ("txtPrecisionFR")).Enabled = true;
						((TextBox ) dlFields.Controls[0].FindControl ("txtScaleFR")).Enabled     = true;
					}
					break;

					// length.enable    = false
					// precision.enable = false
					// scale.enable     = false
					default:
					{
						((TextBox ) dlFields.Controls[0].FindControl ("txtLengthFR")).Enabled    = false;
						((TextBox ) dlFields.Controls[0].FindControl ("txtPrecisionFR")).Enabled = false;
						((TextBox ) dlFields.Controls[0].FindControl ("txtScaleFR")).Enabled     = false;
					}
					break;
				}
			}
			else
			{
				for (int i = 0; i < dlFields.Items.Count; i++)
				{
					for (int j = 0; j < dlFields.Items[i].Controls.Count; j++)
					{
						if (String.Compare (((DropDownList) sender).ClientID, dlFields.Items[i].Controls[j].ClientID, true) == 0)
						{
							((TextBox) dlFields.Items[i].FindControl ("txtLength")).Text    = row[0]["length"].ToString ();
							((TextBox) dlFields.Items[i].FindControl ("txtPrecision")).Text = row[0]["xprec"].ToString ();
							((TextBox) dlFields.Items[i].FindControl ("txtScale")).Text     = row[0]["xscale"].ToString ();

							switch (Convert.ToInt32 (row[0]["xtype"]))
							{
								// length.enable    = true
								// precision.enable = false
								// scale.enable     = false
								case 173:
								case 175:
								case 231:
								case 165:
								case 167:
								case 239:
								{
									((TextBox) dlFields.Items[i].FindControl ("txtLength")).Enabled    = true;
									((TextBox) dlFields.Items[i].FindControl ("txtPrecision")).Enabled = false;
									((TextBox) dlFields.Items[i].FindControl ("txtScale")).Enabled     = false;
								}
								break;

								// length.enable    = false
								// precision.enable = true
								// scale.enable     = true
								case 106:
								case 108:
								{
									((TextBox) dlFields.Items[i].FindControl ("txtLength")).Enabled    = false;
									((TextBox) dlFields.Items[i].FindControl ("txtPrecision")).Enabled = true;
									((TextBox) dlFields.Items[i].FindControl ("txtScale")).Enabled     = true;
								}
								break;

								// length.enable    = false
								// precision.enable = false
								// scale.enable     = false
								default:
								{
									((TextBox) dlFields.Items[i].FindControl ("txtLength")).Enabled    = false;
									((TextBox) dlFields.Items[i].FindControl ("txtPrecision")).Enabled = false;
									((TextBox) dlFields.Items[i].FindControl ("txtScale")).Enabled     = false;
								}
								break;
							}

							i = dlFields.Items.Count + 10;
							break;
						}
					}
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnSave_Click (object sender, System.EventArgs e)
		{
			if (txtTableName.Text.Length > 0)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					string sCreateSql = "CREATE TABLE " + txtTableName.Text + " (";
					string sCreateFR  = null;
					string sCreate    = null;
					string sOnPrimary = " ON [PRIMARY]";

					TextBox      NameFR      = (TextBox )      dlFields.Controls[0].FindControl ("txtNameFR");

					if (NameFR.Text.Length > 0)
					{
						CheckBox     PKFR        = (CheckBox )     dlFields.Controls[0].FindControl ("chkPKFR");
						DropDownList TypeFR      = (DropDownList ) dlFields.Controls[0].FindControl ("cboTypeFR");
						TextBox      LengthFR    = (TextBox )      dlFields.Controls[0].FindControl ("txtLengthFR");
						TextBox      PercisionFR = (TextBox )      dlFields.Controls[0].FindControl ("txtPercisionFR");
						TextBox      ScaleFR     = (TextBox )      dlFields.Controls[0].FindControl ("txtScaleFR");
						CheckBox     NullFR      = (CheckBox )     dlFields.Controls[0].FindControl ("chkNullFR");
						TextBox      DefaultFR   = (TextBox )      dlFields.Controls[0].FindControl ("txtDefaultFR");
						CheckBox     IdentityFR  = (CheckBox )     dlFields.Controls[0].FindControl ("chkIdentityFR");
						TextBox      SeedFR      = (TextBox )      dlFields.Controls[0].FindControl ("txtSeedFR");
						TextBox      IncrementFR = (TextBox )      dlFields.Controls[0].FindControl ("txtIncrementFR");

						switch (Convert.ToInt32 (TypeFR.SelectedItem.Value))
						{
								// length.enable    = true
								// precision.enable = false
								// scale.enable     = false
							case 173:
							case 175:
							case 231:
							case 165:
							case 167:
							case 239:
							{
								//[f14] [nvarchar] (50) NULL ,
								sCreateFR += "[" + NameFR.Text + "] [" + TypeFR.SelectedItem.Text + "] (" + LengthFR.Text + ") ";
							}
								break;

								// length.enable    = false
								// precision.enable = true
								// scale.enable     = true
							case 106:
							case 108:
							{
								//[f06] [decimal](18, 4) NULL ,
								sCreateFR += "[" + NameFR.Text + "] [" + TypeFR.SelectedItem.Text + "](" + PercisionFR.Text + "," + ScaleFR.Text + ")";
							}
								break;

								// length.enable    = false
								// precision.enable = false
								// scale.enable     = false
							default:
							{
								//[f01] [bigint] NULL CONSTRAINT [DF_Table1_f1] DEFAULT (23),
								sCreateFR += "[" + NameFR.Text + "] [" + TypeFR.SelectedItem.Text + "] ";
							}
								break;
						}

						if (IdentityFR.Checked)
						{
							//[f09] [int] IDENTITY (3, 9) NOT NULL ,
							sCreateFR += " IDENTITY (" + SeedFR.Text + "," + IncrementFR.Text + ") NOT NULL ";
						}
						else
						{
							if (NullFR.Checked)
							{
								sCreateFR += " NULL ";
							}
							else
							{
								sCreateFR += " NOT NULL ";
							}

							if (DefaultFR.Text.Length > 0)
							{
								sCreateFR += " CONSTRAINT [DF_" + txtTableName.Text + "_" + NameFR.Text + "] DEFAULT (" + DefaultFR.Text + ") ";
							}
						}
					}

					for (int i = 0; i < dlFields.Items.Count; i++)
					{
						for (int j = 0; j < dlFields.Items[i].Controls.Count; j++)
						{
							string a = dlFields.Items[i].Controls[j].ClientID;

							if (dlFields.Items[i].Controls[j].ClientID.IndexOf ("txtColName", 0) != -1)
							{
								TextBox Name = (TextBox ) dlFields.Items[i].FindControl ("txtColName");

								if (Name.Text.Length > 0)
								{
									CheckBox     PK        = (CheckBox )     dlFields.Items[i].FindControl ("chkPK");
									DropDownList Type      = (DropDownList ) dlFields.Items[i].FindControl ("cboType");
									TextBox      Length    = (TextBox )      dlFields.Items[i].FindControl ("txtLength");
									TextBox      Precision = (TextBox )      dlFields.Items[i].FindControl ("txtPrecision");
									TextBox      Scale     = (TextBox )      dlFields.Items[i].FindControl ("txtScale");
									CheckBox     Null      = (CheckBox )     dlFields.Items[i].FindControl ("chkNull");
									TextBox      Default   = (TextBox )      dlFields.Items[i].FindControl ("txtDefault");

									if (sCreate != null)
									{
										sCreate += " , ";
									}

									switch (Convert.ToInt32 (Type.SelectedItem.Value))
									{
											// image data type
										case 34:
										{
											sOnPrimary += " TEXTIMAGE_ON [PRIMARY]";

											//[f01] [bigint] NULL CONSTRAINT [DF_Table1_f1] DEFAULT (23),
											sCreate += "[" + Name.Text + "] [" + Type.SelectedItem.Text + "] ";
										}
											break;
											// length.enable    = true
											// precision.enable = false
											// scale.enable     = false
										case 173:
										case 175:
										case 231:
										case 165:
										case 167:
										case 239:
										{
											//[f14] [nvarchar] (50) NULL ,
											sCreate += "[" + Name.Text + "] [" + Type.SelectedItem.Text + "] (" + Length.Text + ") ";
										}
											break;

											// length.enable    = false
											// precision.enable = true
											// scale.enable     = true
										case 106:
										case 108:
										{
											//[f06] [decimal](18, 4) NULL ,
											sCreate += "[" + Name.Text + "] [" + Type.SelectedItem.Text + "](" + Precision.Text + "," + Scale.Text + ")";
										}
											break;

											// length.enable    = false
											// precision.enable = false
											// scale.enable     = false
										default:
										{
											//[f01] [bigint] NULL CONSTRAINT [DF_Table1_f1] DEFAULT (23),
											sCreate += "[" + Name.Text + "] [" + Type.SelectedItem.Text + "] ";
										}
											break;
									}

									if (Null.Checked)
									{
										sCreate += " NULL ";
									}
									else
									{
										sCreate += " NOT NULL ";
									}

									if (Default.Text.Length > 0)
									{
										sCreate += " CONSTRAINT [DF_" + txtTableName.Text + "_" + Name.Text + "] DEFAULT (" + Default.Text + ") ";
									}
								}
							}
						}
					}

					if (sCreateFR != null)
					{
						sCreateFR += " , ";
					}

					sCreateSql += sCreateFR + sCreate + " ) " + sOnPrimary;

					db.ExecNonQuery (sCreateSql);

					Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
						"\nparent.frames[\"MainFrame\"].location = 'TableProperties.aspx?Table=" + txtTableName.Text + "';" +
						"\n</SCRIPT>");
				}
				catch (Exception ex)
				{
					string s = ex.Message;
				}
			}
		}
	}
}
