using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for UserPermissions.
	/// </summary>
	public partial class UserPermissions : System.Web.UI.Page
	{
		// establish a common cache key... reduces tipynG Erorrs
		//const string PERMISSIONS_DATASET_CACHE_KEY = "PermissionsDataSet";

	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				dlPermissions.DataSource = ((SqlDBHandler ) Session["SqlDBHandler"]).GetPermissions (Request["UserName"].ToString ());
				dlPermissions.DataBind ();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnSave_Click(object sender, System.EventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				foreach (DataListItem item in dlPermissions.Items)
				{
					foreach (Control c in item.Controls)
					{
						if (String.Compare ("System.Web.UI.WebControls.ImageButton", c.ToString (), true) == 0)
						{
							string cn = ((ImageButton) c).CommandName.ToString ();
							string ca = ((ImageButton) c).CommandArgument.ToString ();
							string sName = cn.Substring (2, cn.Length - 2);
							string sArg = ca.Substring (ca.IndexOf ("_") + 1, ca.Length - (ca.IndexOf ("_") + 1));
							string sType = cn.Substring (0, 1);
							string sAction = ca.Substring (0, ca.IndexOf ("_"));

							if (String.Compare ("U", sType, true) == 0 ||
								String.Compare ("V", sType, true) == 0)
							{
								if (String.Compare ("Select", sAction, true) == 0 ||
									String.Compare ("Insert", sAction, true) == 0 ||
									String.Compare ("Update", sAction, true) == 0 ||
									String.Compare ("Delete", sAction, true) == 0 ||
									String.Compare ("References", sAction, true) == 0)
								{
									if (String.Compare ("GRANT", sArg, true) == 0)
									{
										db.ExecNonQuery ("grant " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
									}
									else
									{
										if (String.Compare ("REVOKE", sArg, true) == 0)
										{
											db.ExecNonQuery ("deny " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
										}
										else
										{
											db.ExecNonQuery ("revoke " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
										}
									}
								}
							}
							else
							{
								if (String.Compare ("P", sType, true) == 0)
								{
									if (String.Compare ("Execute", sAction, true) == 0)
									{
										if (String.Compare ("GRANT", sArg, true) == 0)
										{
											db.ExecNonQuery ("grant " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
										}
										else
										{
											if (String.Compare ("REVOKE", sArg, true) == 0)
											{
												db.ExecNonQuery ("deny " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
											}
											else
											{
												db.ExecNonQuery ("revoke " + sAction + " on " + sName + " to " + Request["UserName"].ToString ());
											}
										}
									}
								}
							}
						}
					}
				}

				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'EditUser.aspx?User=" + Request["UserName"].ToString () + "';" +
					"\n</SCRIPT>");
			}
			catch (Exception ex)
			{
				string s = ex.Message;
			}
		}

		protected string FetchImageSrc (string sValue)
		{
			string html = null;

			if (String.Compare (sValue, "P", true) == 0)
			{
				html = "images/small_Icons_Stored_Procedure.gif";
			}
			else
			{
				if (String.Compare (sValue, "U", true) == 0)
				{
					html = "images/small_Icons_tables.gif";
				}
				else
				{
					if (String.Compare (sValue, "V", true) == 0)
					{
						html = "images/small_Icons_views.gif";
					}
				}
			}

			return html;
		}

		protected string FetchImageBtnUrl (string sProtectType)
		{
			string html = null;

			if (String.Compare (sProtectType, "GRANT", true) == 0)
			{
				html = "images/permissions_checked.gif";
			}
			else
			{
				if (String.Compare (sProtectType, "REVOKE", true) == 0)
				{
					html = "images/permissions_redx.gif";
				}
				else
				{
					html = "images/permissions_unchecked.gif";
				}
			}

			return html;
		}
		protected void ibtnClick (Object sender, CommandEventArgs e)
		{
			string ca = ((ImageButton) sender).CommandArgument.ToString ();
			string sArg = ca.Substring (ca.IndexOf ("_") + 1, ca.Length - (ca.IndexOf ("_") + 1));
			string sAction = ca.Substring (0, ca.IndexOf ("_"));

			if (String.Compare (sArg, "GRANT", true) == 0)
			{
				((ImageButton) sender).CommandArgument = sAction + "_REVOKE";
				((ImageButton) sender).ImageUrl        = "images/permissions_redx.gif";
			}
			else
			{
				if (String.Compare (sArg, "REVOKE", true) == 0)
				{
					((ImageButton) sender).CommandArgument = sAction + "_EMPTY";
					((ImageButton) sender).ImageUrl        = "images/permissions_unchecked.gif";
				}
				else
				{
					((ImageButton) sender).CommandArgument = sAction + "_GRANT";
					((ImageButton) sender).ImageUrl        = "images/permissions_checked.gif";
				}
			}
		}
	}
}
