namespace SqlEntManager
{
	using System;
	using System.Data;
	using System.Collections;
	using System.Data.SqlClient;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	/// <summary>
	///		Summary description for ucStoredProcs.
	/// </summary>
	public partial  class ucStoredProcs : System.Web.UI.UserControl
	{
		// establish a common cache key... reduces tipynG Erorrs
		const string PROCS_DATASET_CACHE_KEY = "ProcsDataSet";


		protected void Page_Load(object sender, System.EventArgs e)
		{
			MyDataList.DataSource = GetStoredProcs ();
			MyDataList.DataBind ();
		}

		protected void OnItemCommand (Object sender, DataListCommandEventArgs e)
		{
			MyDataList.SelectedIndex = e.Item.ItemIndex;

			MyDataList.DataSource = GetStoredProcs ();
			MyDataList.DataBind ();
		}

		/// <summary>Retrieves cached dataset of the databases in the Sql Server.</summary>
		/// <returns>populated dataset with databases</returns>
		private DataTable GetStoredProcs ()
		{
			//DataTable dt = (DataTable) this.Context.Cache[PROCS_DATASET_CACHE_KEY];
			DataTable dt = null;

			if( dt == null )
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					DataTable dttemp = db.ExecDT ("exec sp_stored_procedures");

					dt = new DataTable ("StoredProcs");

					DataColumn dcCol;
					dcCol = dt.Columns.Add ("PROC_NAME", typeof (string));

					// populate DataTable.
					foreach (DataRow row in dttemp.Rows)
					{
						if (String.Compare (row["PROCEDURE_NAME"].ToString ().Substring (0, 3), "dt_", true) != 0)
						{
							dt.Rows.Add (new object[] {row["PROCEDURE_NAME"].ToString ().Substring (0, row["PROCEDURE_NAME"].ToString ().IndexOf (";", 0))});
						}
					}
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}

				//this.Context.Cache.Add(PROCS_DATASET_CACHE_KEY, 
				//	dt, 
				//	null, 
				//	DateTime.Now.AddMinutes(5), 
				//	TimeSpan.Zero, 
				//	System.Web.Caching.CacheItemPriority.Normal, 
				//	null 
				//	);
			}

			return dt;
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}
		#endregion
	}
}
