using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for Databases.
	/// </summary>
	public partial class Databases : System.Web.UI.Page
	{
		// establish a common cache key... reduces tipynG Erorrs
		const string DATABASES_DATASET_CACHE_KEY = "DatabasesDataSet";

	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				dlDatabases.DataSource = GetDatabases();
				dlDatabases.DataBind ();
			}
		}

		/// <summary>Retrieves cached dataset of the databases in the Sql Server.</summary>
		/// <returns>populated dataset with databases</returns>
		private DataTable GetDatabases()
		{
			DataTable dt = (DataTable) this.Context.Cache[DATABASES_DATASET_CACHE_KEY];

			if (dt == null)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					dt = db.ExecDT ("sp_helpdb");
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			
				this.Context.Cache.Add(DATABASES_DATASET_CACHE_KEY, 
					dt, 
					null, 
					DateTime.Now.AddMinutes(5), 
					TimeSpan.Zero, 
					System.Web.Caching.CacheItemPriority.Normal, 
					null 
					);
			
			}

			return dt;
		}

		protected void OnItemCommand (Object sender, DataListCommandEventArgs e)
		{
			((SqlDBHandler ) Session["SqlDBHandler"]).Catalog = e.CommandArgument.ToString ();
			//m_iSelectedIndex          = e.Item.ItemIndex;
			dlDatabases.SelectedIndex = e.Item.ItemIndex;

			dlDatabases.DataSource = GetDatabases();
			dlDatabases.DataBind ();

			Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
				"\nparent.frames[\"MainFrame\"].location = 'SetDatabase.aspx?Catalog=" + e.CommandArgument.ToString () + "';" +
				"\n</SCRIPT>");
		}

		protected void btnClick (Object sender, CommandEventArgs e)
		{
			if (String.Compare ("Logins", e.CommandArgument.ToString (), true) == 0)
			{
				//Response.Redirect ("Logins.aspx");
				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'Logins.aspx';" +
					"\n</SCRIPT>");
			}
			else
			{
				if (String.Compare ("ServerRoles", e.CommandArgument.ToString (), true) == 0)
				{
					//Response.Redirect ("ServerRoles.aspx");
					Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
						"\nparent.frames[\"MainFrame\"].location = 'ServerRoles.aspx';" +
						"\n</SCRIPT>");
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
		}
		#endregion
	}
}
