using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for EditTable.
	/// </summary>
	public partial class EditTable : System.Web.UI.Page
	{
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				dlColumns.DataSource = GetColumns ();
				dlColumns.DataBind ();
			}
		}

		protected DataTable GetColumns ()
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			DataTable dtTable = new DataTable ("Columns");

			try
			{
				DataTable dt = db.ExecDT ("exec sp_columns '" + Request["Table"].ToString () + "'");

				DataColumn dcCol;
				dcCol = dtTable.Columns.Add ("name",      typeof (string));
				dcCol = dtTable.Columns.Add ("type",      typeof (string));
				dcCol = dtTable.Columns.Add ("length",    typeof (int));
				dcCol = dtTable.Columns.Add ("precision", typeof (int));
				dcCol = dtTable.Columns.Add ("scale",     typeof (int));
				dcCol = dtTable.Columns.Add ("nullable",  typeof (bool));
				dcCol = dtTable.Columns.Add ("default",   typeof (string));

				// populate DataTable.
				foreach (DataRow row in dt.Rows)
				{
					dtTable.Rows.Add (new object[] {row["column_name"].ToString (),
													   row["type_name"].ToString (),
													   Convert.ToInt32 (row["length"].ToString ()),
													   Convert.ToInt32 (row["precision"].ToString ()),
													   Convert.IsDBNull (row["scale"]) ? 0 : Convert.ToInt32 (row["scale"].ToString ()),
													   row["nullable"].ToString () == "1" ? true : false,
													   Convert.IsDBNull (row["column_def"]) ? String.Empty : row["column_def"].ToString ()});
				}
			}
			catch (Exception ex)
			{
				string s = ex.Message;
			}

			return dtTable;
		}

		protected void OnItemCreated (Object sender, DataListItemEventArgs e)
		{
			DataRowView drv = (DataRowView) e.Item.DataItem;

			if (drv != null)
			{
				foreach (Control c in e.Item.Controls)
				{
					if (String.Compare (c.GetType ().ToString (), "System.Web.UI.WebControls.DropDownList", true) == 0)
					{
						((DropDownList) c).DataSource = GetDataTypes ();
						((DropDownList) c).DataTextField = "name";
						((DropDownList) c).DataValueField = "xtype";
						((DropDownList) c).DataBind ();
						//((DropDownList) c).Items.FindByText (drv.Row["type"].ToString ()).Selected = true;

						// rumor has it, there is a bug in the number of items a drop down list
						// can have selected.  I have noticed after the drop down is filled
						// the first item is the default selected item.
						for (int j = 0; j < ((DropDownList) c).Items.Count; j++)
						{
							if (String.Compare (((DropDownList) c).Items[j].Text, drv.Row["type"].ToString (), true) == 0)
							{
								((DropDownList) c).Items[j].Text = drv.Row["type"].ToString ();
								((DropDownList) c).Items[j].Selected = true;
							}
							else
							{
								((DropDownList) c).Items[j].Selected = false;
							}
						}
					}
				}
			}
		}

		protected void OnIdentityClick (Object sender, EventArgs e)
		{
			//((TextBox ) dlColumns.Controls[0].FindControl ("txtSeedFR")).Enabled      = ((CheckBox) sender).Checked;
			//((TextBox ) dlColumns.Controls[0].FindControl ("txtIncrementFR")).Enabled = ((CheckBox) sender).Checked;
		}

		protected DataTable GetDataTypes ()
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			DataTable dtTable = new DataTable ("DataTypes");

			try
			{
				//DataTable dt = db.ExecDT ("select name, xtype, length, xprec, xscale, allownulls from master..systypes");
				DataTable dt = db.ExecDT ("select name, xtype, length, xprec, xscale, allownulls from systypes");

				DataColumn dcCol;
				dcCol = dtTable.Columns.Add ("name",       typeof (string));
				dcCol = dtTable.Columns.Add ("xtype",      typeof (int));
				dcCol = dtTable.Columns.Add ("length",     typeof (int));
				dcCol = dtTable.Columns.Add ("xprec",      typeof (int));
				dcCol = dtTable.Columns.Add ("xscale",     typeof (int));
				dcCol = dtTable.Columns.Add ("allownulls", typeof (bool));

				// populate DataTable.
				foreach (DataRow row in dt.Rows)
				{
					dtTable.Rows.Add (new object[] {row["name"].ToString (),
													   Convert.ToInt32 (row["xtype"].ToString ()),
													   Convert.ToInt32 (row["length"].ToString ()),
													   Convert.ToInt32 (row["xprec"].ToString ()),
													   Convert.ToInt32 (row["xscale"].ToString ()),
													   Convert.ToBoolean (row["allownulls"].ToString ())});
				}
			}
			catch (Exception ex)
			{
				string s = ex.Message;
			}

			return dtTable;
		}

		protected void OnDataTypeChange (Object sender, EventArgs e)
		{
			//name				xtype	status	xusertype	length	xprec	xscale	allownulls
			//---------------	-----	------	---------	------	-----	------	----------
			//bigint			  127        0        127        8     19        0
			//binary              173        2        173     8000      0        0
			//bit                 104        0        104        1      1        0
			//char                175        2        175     8000      0        0
			//datetime             61        0         61        8     23        3
			//decimal             106        0        106       17     38       38
			//float                62        0         62        8     53        0
			//image                34        0         34       16      0        0
			//int                  56        0         56        4     10        0
			//money                60        0         60        8     19        4
			//nchar               239        2        239     8000      0        0
			//ntext                99        0         99       16      0        0
			//numeric             108        0        108       17     38       38
			//nvarchar            231        2        231     8000      0        0
			//real                 59        0         59        4     24        0
			//smalldatetime        58        0         58        4     16        0
			//smallint             52        0         52        2      5        0
			//smallmoney          122        0        122        4     10        4
			//sql_variant          98        0         98     8016      0        0
			//sysname             231        1        256      256      0        0
			//text                 35        0         35       16      0        0
			//timestamp           189        1        189        8      0        0
			//tinyint              48        0         48        1      3        0
			//uniqueidentifier     36        0         36       16      0        0
			//varbinary           165        2        165     8000      0        0
			//varchar             167        2        167     8000      0        0

			DataRow[] row = GetDataTypes ().Select ("name = '" + ((DropDownList) sender).Items[((DropDownList) sender).SelectedIndex].Text + "'");

			for (int i = 0; i < dlColumns.Items.Count; i++)
			{
				for (int j = 0; j < dlColumns.Items[i].Controls.Count; j++)
				{
					if (String.Compare (((DropDownList) sender).ClientID, dlColumns.Items[i].Controls[j].ClientID, true) == 0)
					{
						((TextBox) dlColumns.Items[i].FindControl ("txtLength")).Text    = row[0]["length"].ToString ();
						((TextBox) dlColumns.Items[i].FindControl ("txtPrecision")).Text = row[0]["xprec"].ToString ();
						((TextBox) dlColumns.Items[i].FindControl ("txtScale")).Text     = row[0]["xscale"].ToString ();

						switch (Convert.ToInt32 (row[0]["xtype"]))
						{
								// length.enable    = true
								// precision.enable = false
								// scale.enable     = false
							case 173:
							case 175:
							case 231:
							case 165:
							case 167:
							case 239:
							{
								((TextBox) dlColumns.Items[i].FindControl ("txtLength")).Enabled    = true;
								((TextBox) dlColumns.Items[i].FindControl ("txtPrecision")).Enabled = false;
								((TextBox) dlColumns.Items[i].FindControl ("txtScale")).Enabled     = false;
							}
								break;

								// length.enable    = false
								// precision.enable = true
								// scale.enable     = true
							case 106:
							case 108:
							{
								((TextBox) dlColumns.Items[i].FindControl ("txtLength")).Enabled    = false;
								((TextBox) dlColumns.Items[i].FindControl ("txtPrecision")).Enabled = true;
								((TextBox) dlColumns.Items[i].FindControl ("txtScale")).Enabled     = true;
							}
								break;

								// length.enable    = false
								// precision.enable = false
								// scale.enable     = false
							default:
							{
								((TextBox) dlColumns.Items[i].FindControl ("txtLength")).Enabled    = false;
								((TextBox) dlColumns.Items[i].FindControl ("txtPrecision")).Enabled = false;
								((TextBox) dlColumns.Items[i].FindControl ("txtScale")).Enabled     = false;
							}
								break;
						}

						i = dlColumns.Items.Count + 10;
						break;
					}
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
		}
		#endregion
	}
}
