using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for EditUser.
	/// </summary>
	public partial class EditUser : System.Web.UI.Page
	{
		// establish a common cache key... reduces tipynG Erorrs
		const string USER_ROLES_DATASET_CACHE_KEY = "UserRolesDataSet";


		protected string m_sUserName = null;
		protected string m_sLoginName = null;
	
		protected void Page_Load (object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					lchkRoles.DataSource     = db.ExecDT ("exec sp_helprole");
					lchkRoles.DataValueField = "RoleName";
					lchkRoles.DataTextField  = "RoleName";
					lchkRoles.DataBind ();

					DataTable dt = db.ExecDT ("exec sp_helpuser '" + Request["user"].ToString () + "'");

					if (dt.Rows.Count > 0)
					{
						m_sUserName  = dt.Rows[0]["UserName"].ToString ();
						m_sLoginName = Convert.IsDBNull (dt.Rows[0]["LoginName"]) ? dt.Rows[0]["UserName"].ToString () : dt.Rows[0]["LoginName"].ToString ();

						// Get the roles the user has in the database
						foreach (ListItem li in lchkRoles.Items)
						{
							if (String.Compare (li.Value.ToString (), "public", true) == 0)
							{
								li.Selected = true;
								//lchkRoles.Attributes.Add ("onClick", "javascript: alert('Members cannot be dropped from \'public\''); return false; \"");
							}
							else
							{
								dt = db.ExecDT ("exec sp_helprolemember " + "'" + li.Value.ToString () + "'");

								if (dt.Rows.Count > 0)
								{							
									if (String.Compare (dt.Rows[0]["MemberName"].ToString (), m_sUserName, true) == 0)
									{
										li.Selected = true;
									}
									else
									{
										if (String.Compare (dt.Rows[0]["MemberName"].ToString (), "public", true) == 0)
										{
											li.Selected = true;
											lchkRoles.Attributes.Add ("onClick", "javascript: alert('Members cannot be dropped from \'public\''); return false; \"");
										}
									}
								}
							}
						}
					}
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnPermissions_Click(object sender, System.EventArgs e)
		{
			Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
				"\nparent.frames[\"MainFrame\"].location = 'UserPermissions.aspx?username=" + Request["user"].ToString () + "';" +
				"\n</SCRIPT>");
		}

		protected void btnSave_Click(object sender, System.EventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				DataTable dt = db.ExecDT ("exec sp_helprole");

				foreach (DataRow row in dt.Rows)
				{
					if ((String.Compare (row["RoleName"].ToString (), "public", true) != 0) &&
						(String.Compare (m_sUserName, "dbo", true) != 0)                   &&
						(String.Compare (row["RoleName"].ToString (), "db_owner", true) != 0) )
					{
						db.ExecNonQuery ("exec sp_droprolemember '" + row["RoleName"].ToString () + "', '" + m_sUserName + "'");
					}
				}

				foreach (ListItem li in lchkRoles.Items)
				{
					if (String.Compare (li.Value.ToString (), "public", true) != 0 && String.Compare (m_sUserName, "dbo", true) != 0)
					{
						db.ExecNonQuery ("exec sp_addrolemember '" + li.Value.ToString () + "', '" + m_sUserName + "'");
					}
				}
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}

		protected void lchkRoles_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (String.Compare (lchkRoles.SelectedItem.Text, "public", true) == 0)
			{
				Page.RegisterClientScriptBlock("AlertPublicChange", "<SCRIPT language=JavaScript>" +
					"\n alert('Members cannot be dropped from \'public\''); return false;" +
					"\n </SCRIPT>");
			}
		}
	}
}
