using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManDataList
{
	/// <summary>
	/// Summary description for LoginsEdit.
	/// </summary>
	public class LoginsEdit : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.Button btnSave;
		protected System.Web.UI.WebControls.Button btnSaveLogin;
		protected System.Web.UI.WebControls.DropDownList cboDBNames;
		protected System.Web.UI.WebControls.DropDownList cboLanguages;
		protected System.Web.UI.WebControls.CheckBoxList chkRoles;

		protected System.Web.UI.WebControls.TextBox txtLoginName;
		protected System.Web.UI.WebControls.Button btnChngPassword;
		protected string RoleStr = null;
		protected string LoginName = null;
		protected string Database = null;
		protected string Language = null;

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!Page.IsPostBack)
			{
				// Setup a features string. This one has most of the common options
				string sScript = "window.open('ChangePassword.aspx?LoginName=" + LoginName + "', '', 'width=450, height=330'); passwordWin.focus();";

				// Add this to the server controls attributes collection
				btnChngPassword.Attributes.Add("onclick", sScript);
			}

			// Put user code to initialize the page here
			LoginName = Request["LoginName"].ToString ();
			txtLoginName.Text = LoginName;

			SqlConnection conn = new SqlConnection (Session["ConnStr"].ToString ());

			try
			{
				conn.Open ();

				SqlCommand cmd = new SqlCommand ();
				cmd.Connection = conn;
				cmd.CommandType = CommandType.StoredProcedure;
				SqlDataReader dr = null;

				cmd.CommandText = "sp_databases";
				dr = cmd.ExecuteReader ();

				cboDBNames.DataSource = dr;
				cboDBNames.DataBind ();

				dr.Close ();

				cmd.CommandText = "sp_helpLanguage";
				dr = cmd.ExecuteReader ();

				cboLanguages.DataSource = dr;
				cboLanguages.DataBind ();

				dr.Close ();

				cmd.CommandText = "sp_helpsrvrole";
				dr = cmd.ExecuteReader ();

				chkRoles.DataSource = dr;
				chkRoles.DataBind ();

				dr.Close ();
			
				if (Request["LoginName"].ToString () != "")
				{
					cmd.CommandText = "sp_helpsrvrole";

					dr = cmd.ExecuteReader ();

					ArrayList alServerRoles = new ArrayList ();

					while (dr.Read ())
					{
						alServerRoles.Add (dr["ServerRole"].ToString ());
					}

					dr.Close ();

					cmd.CommandText = "sp_helpsrvrolemember";
					//cmd.CommandText = "sp_helpsrvrolemember '" + s + "'";

					SqlParameter param = cmd.Parameters.Add ("@srvrolename", SqlDbType.NVarChar, 128);

					foreach (string s in alServerRoles)
					{
						param.Value = s;

						dr = cmd.ExecuteReader ();
						
						while (dr.Read ())
						{
							if (String.Compare (dr["MemberName"].ToString (), Request["LoginName"].ToString (), true) == 0)
							{
								RoleStr = dr["MemberName"].ToString ();
								break;
							}
						}
						dr.Close ();
					}

					cmd.Parameters.RemoveAt ("@srvrolename");

					cmd.CommandText = "sp_helplogins";
					param = cmd.Parameters.Add ("@LoginNamePattern", SqlDbType.NVarChar, 128);

					param.Value = Request["LoginName"].ToString ();

					dr = cmd.ExecuteReader ();
					dr.Read ();
					Database = Convert.IsDBNull (dr["DefDBName"].ToString ()) ? "" : dr["DefDBName"].ToString ();
					Language = Convert.IsDBNull (dr["DefLangName"].ToString ()) ? "" : dr["DefLangName"].ToString ();

					dr.Close ();
					cmd.Parameters.RemoveAt ("@LoginNamePattern");

					foreach (ListItem li in cboDBNames.Items)
					{
						if (String.Compare (li.ToString (), Database, true) == 0)
						{
							li.Selected = true;
							break;
						}
					}

					foreach (ListItem li in cboLanguages.Items)
					{
						if (String.Compare (li.ToString (), Language, true) == 0)
						{
							li.Selected = true;
							break;
						}
					}
				}
			}
			finally
			{
				conn.Close ();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnSaveLogin.Click += new System.EventHandler(this.btnSaveLogin_Click);
			this.btnChngPassword.Click += new System.EventHandler(this.btnChngPassword_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnSaveLogin_Click(object sender, System.EventArgs e)
		{
		
		}

		private void btnChngPassword_Click(object sender, System.EventArgs e)
		{
		}
	}
}
