using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for NewLogin.
	/// </summary>
	public partial class NewLogin : System.Web.UI.Page
	{

		protected string ServerRoles = null;
		protected string LoginName = null;
		protected string Database = null;
		protected string Language = null;
	
		protected void Page_Load(object sender, System.EventArgs e)
		{
			LoginName = txtLoginName.Text;

			if (!Page.IsPostBack)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					// set up the command object to be used in the page load
					// set the command text and execute the sp_database reader
					// bind the reader results to the database dropdown list box
					cboDBNames.DataSource = db.ExecDT ("sp_databases");
					cboDBNames.DataBind ();

					// set the command text and execute the sp_helpLanguage reader
					// bind the reader results to the languages dropdown list box
					cboLanguages.DataSource = db.ExecDT ("sp_helpLanguage");
					cboLanguages.DataBind ();

					// set the command text and execute the sp_helpsrvrole reader
					// bind the reader results to the server roles check list box
					chkRoles.DataSource = db.ExecDT ("sp_helpsrvrole");
					chkRoles.DataBind ();
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion

		protected void btnSaveLogin_Click(object sender, System.EventArgs e)
		{
			if (String.Compare (txtNewPassword.Text, txtConPassword.Text, true) == 0)
			{
				string sqlstr = null;
			
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					sqlstr = "exec sp_addlogin '" + LoginName + "', '" + txtNewPassword.Text + "', '" + Database + "'";

					if (Language != null)
					{
						sqlstr = sqlstr + ", '" + Language + "'";
					}

					db.ExecNonQuery (sqlstr);

					foreach (ListItem li in chkRoles.Items)
					{
						if (li.Selected)
						{
							db.ExecNonQuery ("exec sp_addsrvrolemember '" + LoginName + "', '" + li.Value.ToString () + "'");
						}
					}
				
					Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
						"\nparent.frames[\"MainFrame\"].location = 'logins.aspx';" +
						"\n</SCRIPT>");
				}
				catch (Exception ex)
				{		
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
			else
			{
				Exception ex = new Exception ("New and Confim Passwords Do Not Match");
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}

		protected void cboDBNames_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Database = cboDBNames.Items[cboDBNames.SelectedIndex].ToString ();
		}

		protected void cboLanguages_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Language = cboLanguages.Items[cboLanguages.SelectedIndex].ToString ();
		}

		protected void chkRoles_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			foreach (ListItem li in chkRoles.Items)
			{
				if (li.Selected)
				{
					ServerRoles += "*" + li.ToString () + "*";
				}
			}
		}
	}
}
