using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace SqlEntManager
{
	/// <summary>
	/// Summary description for TableProperties.
	/// </summary>
	public partial class TableProperties : System.Web.UI.Page
	{

		protected void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

				try
				{
					dlTableProps.DataSource = db.ExecDT ("exec sp_columns '" + Request["table"].ToString () + "'");
					dlTableProps.DataBind ();
				}
				catch (Exception ex)
				{
					Response.Write (MsgHandlers.DisplayError (ex));
					Response.End ();
				}
			}
		}

		protected void ibtnDropTable_Click(object sender, System.Web.UI.ImageClickEventArgs e)
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				db.ExecTran ("DROP TABLE '" + Request["table"].ToString () + "'");

				Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
					"\nparent.frames[\"MainFrame\"].location = 'Default.aspx';" +
					"\n</SCRIPT>");
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}
		}

		protected string FetchTableOwner ()
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			string html = "";

			try
			{
				DataTable dt = db.ExecDT ("exec sp_help '" + Request["table"].ToString () + "'");

				html = dt.Rows[0]["owner"].ToString ();
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}

			return html;
		}

		protected string FetchTableCreation ()
		{
			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			string html = "";

			try
			{
				DataTable dt = db.ExecDT ("exec sp_help '" + Request["table"].ToString () + "'");

				html = dt.Rows[0]["created_datetime"].ToString ();
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}

			return html;
		}

		protected string FetchPKImage (string sValue)
		{
			string html = "&nbsp;";

			SqlDBHandler db = (SqlDBHandler ) Session["SqlDBHandler"];

			try
			{
				DataTable dt = db.ExecDT ("exec sp_pkeys '" + Request["Table"].ToString () + "'");
				
				foreach (DataRow row in dt.Rows)
				{
					if (String.Compare (sValue, row["COLUMN_NAME"].ToString (), true) == 0)
					{
						html = "<img src=\"images/key.gif\">";
						break;
					}
				}
			}
			catch (Exception ex)
			{
				Response.Write (MsgHandlers.DisplayError (ex));
				Response.End ();
			}

			return html;
		}

		protected string FetchIDImage (string sValue)
		{
			string html = "&nbsp;";

			if (sValue.IndexOf ("identity", 0) != -1)
			{
				html = "<img src=\"images/checkbox.gif\">";
			}

			return html;
		}

		protected string GetDataType (string sValue)
		{
			string html = sValue;

			int iIndex = sValue.IndexOf ("identity", 0);

			if (iIndex > 0)
			{
				html = sValue.Substring (0, iIndex - 1);
			}

			return html;
		}

		protected string FetchNullImage (string sValue)
		{
			string html = "";

			if (sValue == "1")
				html = "<img src=\"images/checkbox.gif\">";
			else
				html = "&nbsp;";

			return html;
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion
	}
}
