namespace SqlEntManDataList
{
	using System;
	using System.Data;
	using System.Data.SqlClient;
	using System.Drawing;
	using System.Web;
	using System.Web.UI.WebControls;
	using System.Web.UI.HtmlControls;

	/// <summary>
	///		Summary description for ucDatabases.
	/// </summary>
	public abstract class ucDatabases : System.Web.UI.UserControl
	{
		// establish a common cache key... reduces tipynG Erorrs
		const string DATABASES_DATASET_CACHE_KEY = "DatabasesDataSet";

		protected System.Web.UI.WebControls.DataList dlDatabases;
		protected System.Web.UI.WebControls.LinkButton lbtnLogins;
		protected System.Web.UI.WebControls.LinkButton lbtnServerRoles;

		private void Page_Load(object sender, System.EventArgs e)
		{
			//dlDatabases.SelectedIndex = m_iSelectedIndex;

			if (!IsPostBack)
			{
				dlDatabases.DataSource = GetDatabases();
				dlDatabases.DataBind ();
			}
		}

		/// <summary>Retrieves cached dataset of the databases in the Sql Server.</summary>
		/// <returns>populated dataset with databases</returns>
		private DataTable GetDatabases()
		{
			DataTable dt = (DataTable)this.Context.Cache[DATABASES_DATASET_CACHE_KEY];

			if( dt == null )
			{


				SqlConnection conn = new SqlConnection (Session["ConnStr"].ToString ());

				try
				{
					conn.Open ();

					SqlCommand cmd = new SqlCommand ("sp_helpdb", conn);
					cmd.CommandType = CommandType.StoredProcedure;
				
					SqlDataAdapter da = new SqlDataAdapter ("sp_helpdb", conn);

					dt = new DataTable ();
					da.Fill (dt);
				}
				finally
				{
					conn.Close ();
				}
			
				this.Context.Cache.Add(DATABASES_DATASET_CACHE_KEY, 
					dt, 
					null, 
					DateTime.Now.AddMinutes(5), 
					TimeSpan.Zero, 
					System.Web.Caching.CacheItemPriority.Normal, 
					null 
				);
			
			}

			return dt;
		}

		protected void OnItemCommand (Object sender, DataListCommandEventArgs e)
		{
			Session["CatalogName"]    = e.CommandArgument.ToString ();
			//m_iSelectedIndex          = e.Item.ItemIndex;
			dlDatabases.SelectedIndex = e.Item.ItemIndex;

			dlDatabases.DataSource = GetDatabases();
			dlDatabases.DataBind ();
//
//			Page.RegisterClientScriptBlock("frameTargetSet", "<SCRIPT language=JavaScript>" +
//				"\nparent.frames[\"body\"].location = 'SetDatabases.aspx';" +
//				"\n</SCRIPT>");
		}

		protected void btnClick (Object sender, CommandEventArgs e)
		{
			if (String.Compare ("Logins", e.CommandArgument.ToString (), true) == 0)
			{
				Response.Redirect ("Logins.aspx");
			}
			else
			{
				if (String.Compare ("ServerRoles", e.CommandArgument.ToString (), true) == 0)
				{
					Response.Redirect ("ServerRoles.aspx");
				}
			}
		}

		protected void btnNewTableClick (object sender, EventArgs e)
		{
			Response.Redirect ("DesignTable.aspx");
		}

		protected void btnNewViewClick (object sender, EventArgs e)
		{
			Response.Redirect ("EditView.aspx");
		}

		protected void btnNewSProcClick (object sender, EventArgs e)
		{
			Response.Redirect ("EditStoredProc.aspx");
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		///		Required method for Designer support - do not modify
		///		the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion
	}
}
