﻿
//栏目选择器
Vue.component('ui-column-picker', {
    template: '<span>\
   <el-dropdown>\
        <span class="el-dropdown-link">\
             <a href="javascipt:void(0)" v-on:click="openUrl(firstFile)" v-if="showFirst" :title="firstFile.name">\
                <img :src="getThumbnail(firstFile)" class="thumbnail-mini" v-if="isImageList" :onerror="onLoadImageError"/>\
                <span v-else class="fa fa-cloud-download"> {{firstFile.name}}</span>\
            </a>\
            <i class="el-icon-arrow-down el-icon--right" v-if="showMore"></i>\
        </span>\
        <el-dropdown-menu slot="dropdown" v-if="showMore">\
            <el-dropdown-item v-for="item in fileListWithOutFirst" >\
                <a href="javascipt:void(0)" v-on:click="openUrl(item)" :title="item.name">\
                    <img :src="getThumbnail(item)" class="thumbnail-mini" v-if="isImageList" :onerror="onLoadImageError"/>\
                    <span v-else class="fa fa-cloud-download"> {{item.name}}<span></span> <span></span></span>\
                </a>\
            </el-dropdown-item>\
        </el-dropdown-menu>\
    </el-dropdown>\
    <el-dialog :visible.sync="dialogVisible" v-if="isImageList">\
        <el-carousel height="300px" type="card" trigger="click">\
            <el-carousel-item v-for="(item,index) in allFileList">\
                <span style="width:100%;height:100%;display:block;text-align:center;"><img style="max-width:100%;max-height:100%;" :src="loadImage(item)" :onerror="onLoadImageError"/></span>\
                <a :href="item.url" target="_blank" style="background-color:rgba(0,0,0,0.6);color:#fff;display:block;height:25px;width:100%;position:absolute;top:0px;left:0px;text-align:center;overflow:hidden">{{item.name}}</a>\
            </el-carousel-item>\
        </el-carousel>\
    </el-dialog>\
</span>',
    data: function () {
        return {
            imageLoaded: false,//图片是否加载过
            dialogVisible: false,//图片预览窗口
            allFileList: this.fileList,//所有图片
            firstFile: [], //第一条记录
            fileListWithOutFirst: [], //排除第一条记录的数组
            onLoadImageError: "this.style.display='none'"
        }
    },
    props: {
        fileList: {//附件集合，格式[{name:'',url:''}，{name:'',url:''}]
            type: Array,
            default: function () {
                return [];
            }
        },
        displayType: { //展示方式
            type: String,
            default: "file"
        },
    },
    created: function () {
        this.init();
    },
    computed: {
        isImageList: function () { //是否是图片类型附件
            return this.displayType == "image";
        },
        showFirst: function () {
            return this.firstFile != undefined && this.firstFile.url != undefined && this.firstFile.url != undefined
        },
        showMore: function () {
            return this.fileListWithOutFirst.length > 0;
        }
    },
    methods: {
        init: function () {
            if (isNullOrEmpty(this.allFileList)) {
                this.allFileList = [];
            }
            if (this.allFileList.length > 0) {
                this.firstFile = this.allFileList[0];
                this.fileListWithOutFirst = this.allFileList.slice(1);
            }
        },
        loadImage: function (item) {
            var img = new Image();
            img.src = item.url;
            img.onload = function () {
                item.url = img.src;
            }
            return item.url;
        },
        getThumbnail: function (file) { //获取缩略图路径
            var thumbnail = file.thumbnail;
            if (isNullOrEmpty(thumbnail)) {
                return file.url;
            }
            return thumbnail;
        },
        downFile: function (file) { //下载文件
            var url = file.url;
            var fileName = file.name;
            if (isImage(url)) { //图片直接打开
                window.open(url, "_blank");
            }
            else {//其他格式直接下载
                window.open("/e/download?file=" + urlEncode(url) + "&name=" + urlEncode(fileName), "_blank");
            }
        },
        openUrl: function (file) {//打开文件。
            var fileName = file.name;
            var url = file.url;
            if (this.displayType == "file") {
                this.downFile(file);//非图片改为直接下载
            }
            else {
                this.dialogVisible = true;
            }
        },
    }
});