﻿/* basic.js中已引用 */
(function (global, factory) { "use strict"; if (typeof module === "object" && typeof module.exports === "object") { module.exports = global.document ? factory(global, true) : function (w) { if (!w.document) { throw new Error("jQuery requires a window with a document"); } return factory(w) } } else { factory(global) } })(typeof window !== "undefined" ? window : void 0, function (window, noGlobal) { "use strict"; var arr = []; var document = window.document; var getProto = Object.getPrototypeOf; var slice = arr.slice; var concat = arr.concat; var push = arr.push; var indexOf = arr.indexOf; var class2type = {}; var toString = class2type.toString; var hasOwn = class2type.hasOwnProperty; var fnToString = hasOwn.toString; var ObjectFunctionString = fnToString.call(Object); var support = {}; var isFunction = function isFunction(obj) { return typeof obj === "function" && typeof obj.nodeType !== "number" }; var isWindow = function isWindow(obj) { return obj != null && obj === obj.window }; var preservedScriptAttributes = { type: true, src: true, nonce: true, noModule: true }; function DOMEval(code, doc, node) { doc = doc || document; var i, script = doc.createElement("script"); script.text = code; if (node) { for (i in preservedScriptAttributes) { if (node[i]) { script[i] = node[i] } else if (node.getAttribute(i)) { script.setAttribute(i, node.getAttribute(i)) } } } doc.head.appendChild(script).parentNode.removeChild(script) } function toType(obj) { if (obj == null) { return obj + "" } return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : typeof obj } var version = "3.3.2-pre", jQuery = function (selector, context) { return new jQuery.fn.init(selector, context) }, rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g; jQuery.fn = jQuery.prototype = { jquery: version, constructor: jQuery, length: 0, toArray: function () { return slice.call(this) }, get: function (num) { if (num == null) { return slice.call(this) } return num < 0 ? this[num + this.length] : this[num] }, pushStack: function (elems) { var ret = jQuery.merge(this.constructor(), elems); ret.prevObject = this; return ret }, each: function (callback) { return jQuery.each(this, callback) }, map: function (callback) { return this.pushStack(jQuery.map(this, function (elem, i) { return callback.call(elem, i, elem) })) }, slice: function () { return this.pushStack(slice.apply(this, arguments)) }, first: function () { return this.eq(0) }, last: function () { return this.eq(-1) }, eq: function (i) { var len = this.length, j = +i + (i < 0 ? len : 0); return this.pushStack(j >= 0 && j < len ? [this[j]] : []) }, end: function () { return this.prevObject || this.constructor() }, push: push, sort: arr.sort, splice: arr.splice }; jQuery.extend = jQuery.fn.extend = function () { var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = false; if (typeof target === "boolean") { deep = target; target = arguments[i] || {}; i++ } if (typeof target !== "object" && !isFunction(target)) { target = {} } if (i === length) { target = this; i-- } for (; i < length; i++) { if ((options = arguments[i]) != null) { for (name in options) { copy = options[name]; if (target === copy) { continue } if (deep && copy && (jQuery.isPlainObject(copy) || (copyIsArray = Array.isArray(copy)))) { src = target[name]; if (copyIsArray && !Array.isArray(src)) { clone = [] } else if (!copyIsArray && !jQuery.isPlainObject(src)) { clone = {} } else { clone = src } copyIsArray = false; target[name] = jQuery.extend(deep, clone, copy) } else if (copy !== undefined) { target[name] = copy } } } } return target }; jQuery.extend({ expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""), isReady: true, error: function (msg) { throw new Error(msg); }, noop: function () { }, isPlainObject: function (obj) { var proto, Ctor; if (!obj || toString.call(obj) !== "[object Object]") { return false } proto = getProto(obj); if (!proto) { return true } Ctor = hasOwn.call(proto, "constructor") && proto.constructor; return typeof Ctor === "function" && fnToString.call(Ctor) === ObjectFunctionString }, isEmptyObject: function (obj) { var name; for (name in obj) { return false } return true }, globalEval: function (code) { DOMEval(code) }, each: function (obj, callback) { var length, i = 0; if (isArrayLike(obj)) { length = obj.length; for (; i < length; i++) { if (callback.call(obj[i], i, obj[i]) === false) { break } } } else { for (i in obj) { if (callback.call(obj[i], i, obj[i]) === false) { break } } } return obj }, trim: function (text) { return text == null ? "" : (text + "").replace(rtrim, "") }, makeArray: function (arr, results) { var ret = results || []; if (arr != null) { if (isArrayLike(Object(arr))) { jQuery.merge(ret, typeof arr === "string" ? [arr] : arr) } else { push.call(ret, arr) } } return ret }, inArray: function (elem, arr, i) { return arr == null ? -1 : indexOf.call(arr, elem, i) }, merge: function (first, second) { var len = +second.length, j = 0, i = first.length; for (; j < len; j++) { first[i++] = second[j] } first.length = i; return first }, grep: function (elems, callback, invert) { var callbackInverse, matches = [], i = 0, length = elems.length, callbackExpect = !invert; for (; i < length; i++) { callbackInverse = !callback(elems[i], i); if (callbackInverse !== callbackExpect) { matches.push(elems[i]) } } return matches }, map: function (elems, callback, arg) { var length, value, i = 0, ret = []; if (isArrayLike(elems)) { length = elems.length; for (; i < length; i++) { value = callback(elems[i], i, arg); if (value != null) { ret.push(value) } } } else { for (i in elems) { value = callback(elems[i], i, arg); if (value != null) { ret.push(value) } } } return concat.apply([], ret) }, guid: 1, support: support }); if (typeof Symbol === "function") { jQuery.fn[Symbol.iterator] = arr[Symbol.iterator] } jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function (i, name) { class2type["[object " + name + "]"] = name.toLowerCase() }); function isArrayLike(obj) { var length = !!obj && "length" in obj && obj.length, type = toType(obj); if (isFunction(obj) || isWindow(obj)) { return false } return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj } var dir = function (elem, dir, until) { var matched = [], truncate = until !== undefined; while ((elem = elem[dir]) && elem.nodeType !== 9) { if (elem.nodeType === 1) { if (truncate && jQuery(elem).is(until)) { break } matched.push(elem) } } return matched }; var siblings = function (n, elem) { var matched = []; for (; n; n = n.nextSibling) { if (n.nodeType === 1 && n !== elem) { matched.push(n) } } return matched }; var rneedsContext = /^[\x20\t\r\n\f]*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\([\x20\t\r\n\f]*((?:-\d)?\d*)[\x20\t\r\n\f]*\)|)(?=[^-]|$)/i; function nodeName(elem, name) { return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase() }; var rsingleTag = /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i; function winnow(elements, qualifier, not) { if (isFunction(qualifier)) { return jQuery.grep(elements, function (elem, i) { return !!qualifier.call(elem, i, elem) !== not }) } if (qualifier.nodeType) { return jQuery.grep(elements, function (elem) { return elem === qualifier !== not }) } if (typeof qualifier !== "string") { return jQuery.grep(elements, function (elem) { return indexOf.call(qualifier, elem) > -1 !== not }) } return jQuery.filter(qualifier, elements, not) } jQuery.filter = function (expr, elems, not) { var elem = elems[0]; if (not) { expr = ":not(" + expr + ")" } if (elems.length === 1 && elem.nodeType === 1) { return jQuery.find.matchesSelector(elem, expr) ? [elem] : [] } return jQuery.find.matches(expr, jQuery.grep(elems, function (elem) { return elem.nodeType === 1 })) }; jQuery.fn.extend({ find: function (selector) { var i, ret, len = this.length, self = this; if (typeof selector !== "string") { return this.pushStack(jQuery(selector).filter(function () { for (i = 0; i < len; i++) { if (jQuery.contains(self[i], this)) { return true } } })) } ret = this.pushStack([]); for (i = 0; i < len; i++) { jQuery.find(selector, self[i], ret) } return len > 1 ? jQuery.uniqueSort(ret) : ret }, filter: function (selector) { return this.pushStack(winnow(this, selector || [], false)) }, not: function (selector) { return this.pushStack(winnow(this, selector || [], true)) }, is: function (selector) { return !!winnow(this, typeof selector === "string" && rneedsContext.test(selector) ? jQuery(selector) : selector || [], false).length } }); var rootjQuery, rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/, init = jQuery.fn.init = function (selector, context, root) { var match, elem; if (!selector) { return this } root = root || rootjQuery; if (typeof selector === "string") { if (selector[0] === "<" && selector[selector.length - 1] === ">" && selector.length >= 3) { match = [null, selector, null] } else { match = rquickExpr.exec(selector) } if (match && (match[1] || !context)) { if (match[1]) { context = context instanceof jQuery ? context[0] : context; if (rsingleTag.test(match[1]) && jQuery.isPlainObject(context)) { for (match in context) { if (isFunction(this[match])) { this[match](context[match]) } else { this.attr(match, context[match]) } } } return this } else { elem = document.getElementById(match[2]); if (elem) { this[0] = elem; this.length = 1 } return this } } else if (!context || context.jquery) { return (context || root).find(selector) } else { return this.constructor(context).find(selector) } } else if (selector.nodeType) { this[0] = selector; this.length = 1; return this } else if (isFunction(selector)) { return root.ready !== undefined ? root.ready(selector) : selector(jQuery) } return jQuery.makeArray(selector, this) }; init.prototype = jQuery.fn; rootjQuery = jQuery(document); var rparentsprev = /^(?:parents|prev(?:Until|All))/, guaranteedUnique = { children: true, contents: true, next: true, prev: true }; jQuery.fn.extend({ has: function (target) { var targets = jQuery(target, this), l = targets.length; return this.filter(function () { var i = 0; for (; i < l; i++) { if (jQuery.contains(this, targets[i])) { return true } } }) }, closest: function (selectors, context) { var cur, i = 0, l = this.length, matched = [], targets = typeof selectors !== "string" && jQuery(selectors); if (!rneedsContext.test(selectors)) { for (; i < l; i++) { for (cur = this[i]; cur && cur !== context; cur = cur.parentNode) { if (cur.nodeType < 11 && (targets ? targets.index(cur) > -1 : cur.nodeType === 1 && jQuery.find.matchesSelector(cur, selectors))) { matched.push(cur); break } } } } return this.pushStack(matched.length > 1 ? jQuery.uniqueSort(matched) : matched) }, index: function (elem) { if (!elem) { return this[0] && this[0].parentNode ? this.first().prevAll().length : -1 } if (typeof elem === "string") { return indexOf.call(jQuery(elem), this[0]) } return indexOf.call(this, elem.jquery ? elem[0] : elem) }, add: function (selector, context) { return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(), jQuery(selector, context)))) }, addBack: function (selector) { return this.add(selector == null ? this.prevObject : this.prevObject.filter(selector)) } }); function sibling(cur, dir) { while ((cur = cur[dir]) && cur.nodeType !== 1) { } return cur } jQuery.each({ parent: function (elem) { var parent = elem.parentNode; return parent && parent.nodeType !== 11 ? parent : null }, parents: function (elem) { return dir(elem, "parentNode") }, parentsUntil: function (elem, i, until) { return dir(elem, "parentNode", until) }, next: function (elem) { return sibling(elem, "nextSibling") }, prev: function (elem) { return sibling(elem, "previousSibling") }, nextAll: function (elem) { return dir(elem, "nextSibling") }, prevAll: function (elem) { return dir(elem, "previousSibling") }, nextUntil: function (elem, i, until) { return dir(elem, "nextSibling", until) }, prevUntil: function (elem, i, until) { return dir(elem, "previousSibling", until) }, siblings: function (elem) { return siblings((elem.parentNode || {}).firstChild, elem) }, children: function (elem) { return siblings(elem.firstChild) }, contents: function (elem) { if (typeof elem.contentDocument !== "undefined") { return elem.contentDocument } if (nodeName(elem, "template")) { elem = elem.content || elem } return jQuery.merge([], elem.childNodes) } }, function (name, fn) { jQuery.fn[name] = function (until, selector) { var matched = jQuery.map(this, fn, until); if (name.slice(-5) !== "Until") { selector = until } if (selector && typeof selector === "string") { matched = jQuery.filter(selector, matched) } if (this.length > 1) { if (!guaranteedUnique[name]) { jQuery.uniqueSort(matched) } if (rparentsprev.test(name)) { matched.reverse() } } return this.pushStack(matched) } }); var rnothtmlwhite = /[^\x20\t\r\n\f]+/g; function createOptions(options) { var object = {}; jQuery.each(options.match(rnothtmlwhite) || [], function (_, flag) { object[flag] = true }); return object } jQuery.Callbacks = function (options) { options = typeof options === "string" ? createOptions(options) : jQuery.extend({}, options); var firing, memory, fired, locked, list = [], queue = [], firingIndex = -1, fire = function () { locked = locked || options.once; fired = firing = true; for (; queue.length; firingIndex = -1) { memory = queue.shift(); while (++firingIndex < list.length) { if (list[firingIndex].apply(memory[0], memory[1]) === false && options.stopOnFalse) { firingIndex = list.length; memory = false } } } if (!options.memory) { memory = false } firing = false; if (locked) { if (memory) { list = [] } else { list = "" } } }, self = { add: function () { if (list) { if (memory && !firing) { firingIndex = list.length - 1; queue.push(memory) } (function add(args) { jQuery.each(args, function (_, arg) { if (isFunction(arg)) { if (!options.unique || !self.has(arg)) { list.push(arg) } } else if (arg && arg.length && toType(arg) !== "string") { add(arg) } }) })(arguments); if (memory && !firing) { fire() } } return this }, remove: function () { jQuery.each(arguments, function (_, arg) { var index; while ((index = jQuery.inArray(arg, list, index)) > -1) { list.splice(index, 1); if (index <= firingIndex) { firingIndex-- } } }); return this }, has: function (fn) { return fn ? jQuery.inArray(fn, list) > -1 : list.length > 0 }, empty: function () { if (list) { list = [] } return this }, disable: function () { locked = queue = []; list = memory = ""; return this }, disabled: function () { return !list }, lock: function () { locked = queue = []; if (!memory && !firing) { list = memory = "" } return this }, locked: function () { return !!locked }, fireWith: function (context, args) { if (!locked) { args = args || []; args = [context, args.slice ? args.slice() : args]; queue.push(args); if (!firing) { fire() } } return this }, fire: function () { self.fireWith(this, arguments); return this }, fired: function () { return !!fired } }; return self }; function Identity(v) { return v } function Thrower(ex) { throw ex; } function adoptValue(value, resolve, reject, noValue) { var method; try { if (value && isFunction(method = value.promise)) { method.call(value).done(resolve).fail(reject) } else if (value && isFunction(method = value.then)) { method.call(value, resolve, reject) } else { resolve.apply(undefined, [value].slice(noValue)) } } catch (value) { reject.apply(undefined, [value]) } } jQuery.extend({ Deferred: function (func) { var tuples = [["notify", "progress", jQuery.Callbacks("memory"), jQuery.Callbacks("memory"), 2], ["resolve", "done", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 0, "resolved"], ["reject", "fail", jQuery.Callbacks("once memory"), jQuery.Callbacks("once memory"), 1, "rejected"]], state = "pending", promise = { state: function () { return state }, always: function () { deferred.done(arguments).fail(arguments); return this }, "catch": function (fn) { return promise.then(null, fn) }, pipe: function () { var fns = arguments; return jQuery.Deferred(function (newDefer) { jQuery.each(tuples, function (i, tuple) { var fn = isFunction(fns[tuple[4]]) && fns[tuple[4]]; deferred[tuple[1]](function () { var returned = fn && fn.apply(this, arguments); if (returned && isFunction(returned.promise)) { returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject) } else { newDefer[tuple[0] + "With"](this, fn ? [returned] : arguments) } }) }); fns = null }).promise() }, then: function (onFulfilled, onRejected, onProgress) { var maxDepth = 0; function resolve(depth, deferred, handler, special) { return function () { var that = this, args = arguments, mightThrow = function () { var returned, then; if (depth < maxDepth) { return } returned = handler.apply(that, args); if (returned === deferred.promise()) { throw new TypeError("Thenable self-resolution"); } then = returned && (typeof returned === "object" || typeof returned === "function") && returned.then; if (isFunction(then)) { if (special) { then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special)) } else { maxDepth++; then.call(returned, resolve(maxDepth, deferred, Identity, special), resolve(maxDepth, deferred, Thrower, special), resolve(maxDepth, deferred, Identity, deferred.notifyWith)) } } else { if (handler !== Identity) { that = undefined; args = [returned] } (special || deferred.resolveWith)(that, args) } }, process = special ? mightThrow : function () { try { mightThrow() } catch (e) { if (jQuery.Deferred.exceptionHook) { jQuery.Deferred.exceptionHook(e, process.stackTrace) } if (depth + 1 >= maxDepth) { if (handler !== Thrower) { that = undefined; args = [e] } deferred.rejectWith(that, args) } } }; if (depth) { process() } else { if (jQuery.Deferred.getStackHook) { process.stackTrace = jQuery.Deferred.getStackHook() } window.setTimeout(process) } } } return jQuery.Deferred(function (newDefer) { tuples[0][3].add(resolve(0, newDefer, isFunction(onProgress) ? onProgress : Identity, newDefer.notifyWith)); tuples[1][3].add(resolve(0, newDefer, isFunction(onFulfilled) ? onFulfilled : Identity)); tuples[2][3].add(resolve(0, newDefer, isFunction(onRejected) ? onRejected : Thrower)) }).promise() }, promise: function (obj) { return obj != null ? jQuery.extend(obj, promise) : promise } }, deferred = {}; jQuery.each(tuples, function (i, tuple) { var list = tuple[2], stateString = tuple[5]; promise[tuple[1]] = list.add; if (stateString) { list.add(function () { state = stateString }, tuples[3 - i][2].disable, tuples[3 - i][3].disable, tuples[0][2].lock, tuples[0][3].lock) } list.add(tuple[3].fire); deferred[tuple[0]] = function () { deferred[tuple[0] + "With"](this === deferred ? undefined : this, arguments); return this }; deferred[tuple[0] + "With"] = list.fireWith }); promise.promise(deferred); if (func) { func.call(deferred, deferred) } return deferred }, when: function (singleValue) { var remaining = arguments.length, i = remaining, resolveContexts = Array(i), resolveValues = slice.call(arguments), master = jQuery.Deferred(), updateFunc = function (i) { return function (value) { resolveContexts[i] = this; resolveValues[i] = arguments.length > 1 ? slice.call(arguments) : value; if (!--remaining) { master.resolveWith(resolveContexts, resolveValues) } } }; if (remaining <= 1) { adoptValue(singleValue, master.done(updateFunc(i)).resolve, master.reject, !remaining); if (master.state() === "pending" || isFunction(resolveValues[i] && resolveValues[i].then)) { return master.then() } } while (i--) { adoptValue(resolveValues[i], updateFunc(i), master.reject) } return master.promise() } }); var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/; jQuery.Deferred.exceptionHook = function (error, stack) { if (window.console && window.console.warn && error && rerrorNames.test(error.name)) { window.console.warn("jQuery.Deferred exception: " + error.message, error.stack, stack) } }; var location = window.location; var nonce = Date.now(); var rquery = /\?/; jQuery.parseXML = function (data) { var xml; if (!data || typeof data !== "string") { return null } try { xml = new window.DOMParser().parseFromString(data, "text/xml") } catch (e) { xml = undefined } if (!xml || xml.getElementsByTagName("parsererror").length) { jQuery.error("Invalid XML: " + data) } return xml }; var rmsPrefix = /^-ms-/, rdashAlpha = /-([a-z])/g; function fcamelCase(all, letter) { return letter.toUpperCase() } function camelCase(string) { return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase) } var acceptData = function (owner) { return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType }; function Data() { this.expando = jQuery.expando + Data.uid++ } Data.uid = 1; Data.prototype = { cache: function (owner) { var value = owner[this.expando]; if (!value) { value = {}; if (acceptData(owner)) { if (owner.nodeType) { owner[this.expando] = value } else { Object.defineProperty(owner, this.expando, { value: value, configurable: true }) } } } return value }, set: function (owner, data, value) { var prop, cache = this.cache(owner); if (typeof data === "string") { cache[camelCase(data)] = value } else { for (prop in data) { cache[camelCase(prop)] = data[prop] } } return cache }, get: function (owner, key) { return key === undefined ? this.cache(owner) : owner[this.expando] && owner[this.expando][camelCase(key)] }, access: function (owner, key, value) { if (key === undefined || key && typeof key === "string" && value === undefined) { return this.get(owner, key) } this.set(owner, key, value); return value !== undefined ? value : key }, remove: function (owner, key) { var i, cache = owner[this.expando]; if (cache === undefined) { return } if (key !== undefined) { if (Array.isArray(key)) { key = key.map(camelCase) } else { key = camelCase(key); key = key in cache ? [key] : key.match(rnothtmlwhite) || [] } i = key.length; while (i--) { delete cache[key[i]] } } if (key === undefined || jQuery.isEmptyObject(cache)) { if (owner.nodeType) { owner[this.expando] = undefined } else { delete owner[this.expando] } } }, hasData: function (owner) { var cache = owner[this.expando]; return cache !== undefined && !jQuery.isEmptyObject(cache) } }; var dataPriv = new Data(); var documentElement = document.documentElement; var rkeyEvent = /^key/, rmouseEvent = /^(?:mouse|pointer|contextmenu|drag|drop)|click/, rtypenamespace = /^([^.]*)(?:\.(.+)|)/; function returnTrue() { return true } function returnFalse() { return false } function safeActiveElement() { try { return document.activeElement } catch (err) { } } function on(elem, types, selector, data, fn, one) { var origFn, type; if (typeof types === "object") { if (typeof selector !== "string") { data = data || selector; selector = undefined } for (type in types) { on(elem, type, selector, data, types[type], one) } return elem } if (data == null && fn == null) { fn = selector; data = selector = undefined } else if (fn == null) { if (typeof selector === "string") { fn = data; data = undefined } else { fn = data; data = selector; selector = undefined } } if (fn === false) { fn = returnFalse } else if (!fn) { return elem } if (one === 1) { origFn = fn; fn = function (event) { jQuery().off(event); return origFn.apply(this, arguments) }; fn.guid = origFn.guid || (origFn.guid = jQuery.guid++) } return elem.each(function () { jQuery.event.add(this, types, fn, data, selector) }) } jQuery.event = { global: {}, add: function (elem, types, handler, data, selector) { var handleObjIn, eventHandle, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = dataPriv.get(elem); if (!elemData) { return } if (handler.handler) { handleObjIn = handler; handler = handleObjIn.handler; selector = handleObjIn.selector } if (selector) { jQuery.find.matchesSelector(documentElement, selector) } if (!handler.guid) { handler.guid = jQuery.guid++ } if (!(events = elemData.events)) { events = elemData.events = {} } if (!(eventHandle = elemData.handle)) { eventHandle = elemData.handle = function (e) { return typeof jQuery !== "undefined" && jQuery.event.triggered !== e.type ? jQuery.event.dispatch.apply(elem, arguments) : undefined } } types = (types || "").match(rnothtmlwhite) || [""]; t = types.length; while (t--) { tmp = rtypenamespace.exec(types[t]) || []; type = origType = tmp[1]; namespaces = (tmp[2] || "").split(".").sort(); if (!type) { continue } special = jQuery.event.special[type] || {}; type = (selector ? special.delegateType : special.bindType) || type; special = jQuery.event.special[type] || {}; handleObj = jQuery.extend({ type: type, origType: origType, data: data, handler: handler, guid: handler.guid, selector: selector, needsContext: selector && jQuery.expr.match.needsContext.test(selector), namespace: namespaces.join(".") }, handleObjIn); if (!(handlers = events[type])) { handlers = events[type] = []; handlers.delegateCount = 0; if (!special.setup || special.setup.call(elem, data, namespaces, eventHandle) === false) { if (elem.addEventListener) { elem.addEventListener(type, eventHandle) } } } if (special.add) { special.add.call(elem, handleObj); if (!handleObj.handler.guid) { handleObj.handler.guid = handler.guid } } if (selector) { handlers.splice(handlers.delegateCount++, 0, handleObj) } else { handlers.push(handleObj) } jQuery.event.global[type] = true } }, remove: function (elem, types, handler, selector, mappedTypes) { var j, origCount, tmp, events, t, handleObj, special, handlers, type, namespaces, origType, elemData = dataPriv.hasData(elem) && dataPriv.get(elem); if (!elemData || !(events = elemData.events)) { return } types = (types || "").match(rnothtmlwhite) || [""]; t = types.length; while (t--) { tmp = rtypenamespace.exec(types[t]) || []; type = origType = tmp[1]; namespaces = (tmp[2] || "").split(".").sort(); if (!type) { for (type in events) { jQuery.event.remove(elem, type + types[t], handler, selector, true) } continue } special = jQuery.event.special[type] || {}; type = (selector ? special.delegateType : special.bindType) || type; handlers = events[type] || []; tmp = tmp[2] && new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"); origCount = j = handlers.length; while (j--) { handleObj = handlers[j]; if ((mappedTypes || origType === handleObj.origType) && (!handler || handler.guid === handleObj.guid) && (!tmp || tmp.test(handleObj.namespace)) && (!selector || selector === handleObj.selector || selector === "**" && handleObj.selector)) { handlers.splice(j, 1); if (handleObj.selector) { handlers.delegateCount-- } if (special.remove) { special.remove.call(elem, handleObj) } } } if (origCount && !handlers.length) { if (!special.teardown || special.teardown.call(elem, namespaces, elemData.handle) === false) { jQuery.removeEvent(elem, type, elemData.handle) } delete events[type] } } if (jQuery.isEmptyObject(events)) { dataPriv.remove(elem, "handle events") } }, dispatch: function (nativeEvent) { var event = jQuery.event.fix(nativeEvent); var i, j, ret, matched, handleObj, handlerQueue, args = new Array(arguments.length), handlers = (dataPriv.get(this, "events") || {})[event.type] || [], special = jQuery.event.special[event.type] || {}; args[0] = event; for (i = 1; i < arguments.length; i++) { args[i] = arguments[i] } event.delegateTarget = this; if (special.preDispatch && special.preDispatch.call(this, event) === false) { return } handlerQueue = jQuery.event.handlers.call(this, event, handlers); i = 0; while ((matched = handlerQueue[i++]) && !event.isPropagationStopped()) { event.currentTarget = matched.elem; j = 0; while ((handleObj = matched.handlers[j++]) && !event.isImmediatePropagationStopped()) { if (!event.rnamespace || event.rnamespace.test(handleObj.namespace)) { event.handleObj = handleObj; event.data = handleObj.data; ret = ((jQuery.event.special[handleObj.origType] || {}).handle || handleObj.handler).apply(matched.elem, args); if (ret !== undefined) { if ((event.result = ret) === false) { event.preventDefault(); event.stopPropagation() } } } } } if (special.postDispatch) { special.postDispatch.call(this, event) } return event.result }, handlers: function (event, handlers) { var i, handleObj, sel, matchedHandlers, matchedSelectors, handlerQueue = [], delegateCount = handlers.delegateCount, cur = event.target; if (delegateCount && cur.nodeType && !(event.type === "click" && event.button >= 1)) { for (; cur !== this; cur = cur.parentNode || this) { if (cur.nodeType === 1 && !(event.type === "click" && cur.disabled === true)) { matchedHandlers = []; matchedSelectors = {}; for (i = 0; i < delegateCount; i++) { handleObj = handlers[i]; sel = handleObj.selector + " "; if (matchedSelectors[sel] === undefined) { matchedSelectors[sel] = handleObj.needsContext ? jQuery(sel, this).index(cur) > -1 : jQuery.find(sel, this, null, [cur]).length } if (matchedSelectors[sel]) { matchedHandlers.push(handleObj) } } if (matchedHandlers.length) { handlerQueue.push({ elem: cur, handlers: matchedHandlers }) } } } } cur = this; if (delegateCount < handlers.length) { handlerQueue.push({ elem: cur, handlers: handlers.slice(delegateCount) }) } return handlerQueue }, addProp: function (name, hook) { Object.defineProperty(jQuery.Event.prototype, name, { enumerable: true, configurable: true, get: isFunction(hook) ? function () { if (this.originalEvent) { return hook(this.originalEvent) } } : function () { if (this.originalEvent) { return this.originalEvent[name] } }, set: function (value) { Object.defineProperty(this, name, { enumerable: true, configurable: true, writable: true, value: value }) } }) }, fix: function (originalEvent) { return originalEvent[jQuery.expando] ? originalEvent : new jQuery.Event(originalEvent) }, special: { load: { noBubble: true }, focus: { trigger: function () { if (this !== safeActiveElement() && this.focus) { this.focus(); return false } }, delegateType: "focusin" }, blur: { trigger: function () { if (this === safeActiveElement() && this.blur) { this.blur(); return false } }, delegateType: "focusout" }, click: { trigger: function () { if (this.type === "checkbox" && this.click && nodeName(this, "input")) { this.click(); return false } }, _default: function (event) { return nodeName(event.target, "a") } }, beforeunload: { postDispatch: function (event) { if (event.result !== undefined && event.originalEvent) { event.originalEvent.returnValue = event.result } } } } }; jQuery.removeEvent = function (elem, type, handle) { if (elem.removeEventListener) { elem.removeEventListener(type, handle) } }; jQuery.Event = function (src, props) { if (!(this instanceof jQuery.Event)) { return new jQuery.Event(src, props) } if (src && src.type) { this.originalEvent = src; this.type = src.type; this.isDefaultPrevented = src.defaultPrevented || src.defaultPrevented === undefined && src.returnValue === false ? returnTrue : returnFalse; this.target = src.target && src.target.nodeType === 3 ? src.target.parentNode : src.target; this.currentTarget = src.currentTarget; this.relatedTarget = src.relatedTarget } else { this.type = src } if (props) { jQuery.extend(this, props) } this.timeStamp = src && src.timeStamp || Date.now(); this[jQuery.expando] = true }; jQuery.Event.prototype = { constructor: jQuery.Event, isDefaultPrevented: returnFalse, isPropagationStopped: returnFalse, isImmediatePropagationStopped: returnFalse, isSimulated: false, preventDefault: function () { var e = this.originalEvent; this.isDefaultPrevented = returnTrue; if (e && !this.isSimulated) { e.preventDefault() } }, stopPropagation: function () { var e = this.originalEvent; this.isPropagationStopped = returnTrue; if (e && !this.isSimulated) { e.stopPropagation() } }, stopImmediatePropagation: function () { var e = this.originalEvent; this.isImmediatePropagationStopped = returnTrue; if (e && !this.isSimulated) { e.stopImmediatePropagation() } this.stopPropagation() } }; jQuery.each({ altKey: true, bubbles: true, cancelable: true, changedTouches: true, ctrlKey: true, detail: true, eventPhase: true, metaKey: true, pageX: true, pageY: true, shiftKey: true, view: true, "char": true, code: true, charCode: true, key: true, keyCode: true, button: true, buttons: true, clientX: true, clientY: true, offsetX: true, offsetY: true, pointerId: true, pointerType: true, screenX: true, screenY: true, targetTouches: true, toElement: true, touches: true, which: function (event) { var button = event.button; if (event.which == null && rkeyEvent.test(event.type)) { return event.charCode != null ? event.charCode : event.keyCode } if (!event.which && button !== undefined && rmouseEvent.test(event.type)) { if (button & 1) { return 1 } if (button & 2) { return 3 } if (button & 4) { return 2 } return 0 } return event.which } }, jQuery.event.addProp); jQuery.each({ mouseenter: "mouseover", mouseleave: "mouseout", pointerenter: "pointerover", pointerleave: "pointerout" }, function (orig, fix) { jQuery.event.special[orig] = { delegateType: fix, bindType: fix, handle: function (event) { var ret, target = this, related = event.relatedTarget, handleObj = event.handleObj; if (!related || related !== target && !jQuery.contains(target, related)) { event.type = handleObj.origType; ret = handleObj.handler.apply(this, arguments); event.type = fix } return ret } } }); jQuery.fn.extend({ on: function (types, selector, data, fn) { return on(this, types, selector, data, fn) }, one: function (types, selector, data, fn) { return on(this, types, selector, data, fn, 1) }, off: function (types, selector, fn) { var handleObj, type; if (types && types.preventDefault && types.handleObj) { handleObj = types.handleObj; jQuery(types.delegateTarget).off(handleObj.namespace ? handleObj.origType + "." + handleObj.namespace : handleObj.origType, handleObj.selector, handleObj.handler); return this } if (typeof types === "object") { for (type in types) { this.off(type, selector, types[type]) } return this } if (selector === false || typeof selector === "function") { fn = selector; selector = undefined } if (fn === false) { fn = returnFalse } return this.each(function () { jQuery.event.remove(this, types, fn, selector) }) } }); var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/, stopPropagationCallback = function (e) { e.stopPropagation() }; jQuery.extend(jQuery.event, { trigger: function (event, data, elem, onlyHandlers) { var i, cur, tmp, bubbleType, ontype, handle, special, lastElement, eventPath = [elem || document], type = hasOwn.call(event, "type") ? event.type : event, namespaces = hasOwn.call(event, "namespace") ? event.namespace.split(".") : []; cur = lastElement = tmp = elem = elem || document; if (elem.nodeType === 3 || elem.nodeType === 8) { return } if (rfocusMorph.test(type + jQuery.event.triggered)) { return } if (type.indexOf(".") > -1) { namespaces = type.split("."); type = namespaces.shift(); namespaces.sort() } ontype = type.indexOf(":") < 0 && "on" + type; event = event[jQuery.expando] ? event : new jQuery.Event(type, typeof event === "object" && event); event.isTrigger = onlyHandlers ? 2 : 3; event.namespace = namespaces.join("."); event.rnamespace = event.namespace ? new RegExp("(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)") : null; event.result = undefined; if (!event.target) { event.target = elem } data = data == null ? [event] : jQuery.makeArray(data, [event]); special = jQuery.event.special[type] || {}; if (!onlyHandlers && special.trigger && special.trigger.apply(elem, data) === false) { return } if (!onlyHandlers && !special.noBubble && !isWindow(elem)) { bubbleType = special.delegateType || type; if (!rfocusMorph.test(bubbleType + type)) { cur = cur.parentNode } for (; cur; cur = cur.parentNode) { eventPath.push(cur); tmp = cur } if (tmp === (elem.ownerDocument || document)) { eventPath.push(tmp.defaultView || tmp.parentWindow || window) } } i = 0; while ((cur = eventPath[i++]) && !event.isPropagationStopped()) { lastElement = cur; event.type = i > 1 ? bubbleType : special.bindType || type; handle = (dataPriv.get(cur, "events") || {})[event.type] && dataPriv.get(cur, "handle"); if (handle) { handle.apply(cur, data) } handle = ontype && cur[ontype]; if (handle && handle.apply && acceptData(cur)) { event.result = handle.apply(cur, data); if (event.result === false) { event.preventDefault() } } } event.type = type; if (!onlyHandlers && !event.isDefaultPrevented()) { if ((!special._default || special._default.apply(eventPath.pop(), data) === false) && acceptData(elem)) { if (ontype && isFunction(elem[type]) && !isWindow(elem)) { tmp = elem[ontype]; if (tmp) { elem[ontype] = null } jQuery.event.triggered = type; if (event.isPropagationStopped()) { lastElement.addEventListener(type, stopPropagationCallback) } elem[type](); if (event.isPropagationStopped()) { lastElement.removeEventListener(type, stopPropagationCallback) } jQuery.event.triggered = undefined; if (tmp) { elem[ontype] = tmp } } } } return event.result }, simulate: function (type, elem, event) { var e = jQuery.extend(new jQuery.Event(), event, { type: type, isSimulated: true }); jQuery.event.trigger(e, null, elem) } }); jQuery.fn.extend({ trigger: function (type, data) { return this.each(function () { jQuery.event.trigger(type, data, this) }) }, triggerHandler: function (type, data) { var elem = this[0]; if (elem) { return jQuery.event.trigger(type, data, elem, true) } } }); var rcheckableType = /^(?:checkbox|radio)$/i; var access = function (elems, fn, key, value, chainable, emptyGet, raw) { var i = 0, len = elems.length, bulk = key == null; if (toType(key) === "object") { chainable = true; for (i in key) { access(elems, fn, i, key[i], true, emptyGet, raw) } } else if (value !== undefined) { chainable = true; if (!isFunction(value)) { raw = true } if (bulk) { if (raw) { fn.call(elems, value); fn = null } else { bulk = fn; fn = function (elem, key, value) { return bulk.call(jQuery(elem), value) } } } if (fn) { for (; i < len; i++) { fn(elems[i], key, raw ? value : value.call(elems[i], i, fn(elems[i], key))) } } } if (chainable) { return elems } if (bulk) { return fn.call(elems) } return len ? fn(elems[0], key) : emptyGet }; (function () { var input = document.createElement("input"), select = document.createElement("select"), opt = select.appendChild(document.createElement("option")); input.type = "checkbox"; support.checkOn = input.value !== ""; support.optSelected = opt.selected; input = document.createElement("input"); input.value = "t"; input.type = "radio"; support.radioValue = input.value === "t" })(); var rfocusable = /^(?:input|select|textarea|button)$/i, rclickable = /^(?:a|area)$/i; jQuery.fn.extend({ prop: function (name, value) { return access(this, jQuery.prop, name, value, arguments.length > 1) }, removeProp: function (name) { return this.each(function () { delete this[jQuery.propFix[name] || name] }) } }); jQuery.extend({ prop: function (elem, name, value) { var ret, hooks, nType = elem.nodeType; if (nType === 3 || nType === 8 || nType === 2) { return } if (nType !== 1 || !jQuery.isXMLDoc(elem)) { name = jQuery.propFix[name] || name; hooks = jQuery.propHooks[name] } if (value !== undefined) { if (hooks && "set" in hooks && (ret = hooks.set(elem, value, name)) !== undefined) { return ret } return elem[name] = value } if (hooks && "get" in hooks && (ret = hooks.get(elem, name)) !== null) { return ret } return elem[name] }, propHooks: { tabIndex: { get: function (elem) { var tabindex = jQuery.find.attr(elem, "tabindex"); if (tabindex) { return parseInt(tabindex, 10) } if (rfocusable.test(elem.nodeName) || rclickable.test(elem.nodeName) && elem.href) { return 0 } return -1 } } }, propFix: { "for": "htmlFor", "class": "className" } }); if (!support.optSelected) { jQuery.propHooks.selected = { get: function (elem) { var parent = elem.parentNode; if (parent && parent.parentNode) { parent.parentNode.selectedIndex } return null }, set: function (elem) { var parent = elem.parentNode; if (parent) { parent.selectedIndex; if (parent.parentNode) { parent.parentNode.selectedIndex } } } } } jQuery.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function () { jQuery.propFix[this.toLowerCase()] = this }); var rbracket = /\[\]$/, rCRLF = /\r?\n/g, rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i, rsubmittable = /^(?:input|select|textarea|keygen)/i; function buildParams(prefix, obj, traditional, add) { var name; if (Array.isArray(obj)) { jQuery.each(obj, function (i, v) { if (traditional || rbracket.test(prefix)) { add(prefix, v) } else { buildParams(prefix + "[" + (typeof v === "object" && v != null ? i : "") + "]", v, traditional, add) } }) } else if (!traditional && toType(obj) === "object") { for (name in obj) { buildParams(prefix + "[" + name + "]", obj[name], traditional, add) } } else { add(prefix, obj) } } jQuery.param = function (a, traditional) { var prefix, s = [], add = function (key, valueOrFunction) { var value = isFunction(valueOrFunction) ? valueOrFunction() : valueOrFunction; s[s.length] = encodeURIComponent(key) + "=" + encodeURIComponent(value == null ? "" : value) }; if (a == null) { return "" } if (Array.isArray(a) || a.jquery && !jQuery.isPlainObject(a)) { jQuery.each(a, function () { add(this.name, this.value) }) } else { for (prefix in a) { buildParams(prefix, a[prefix], traditional, add) } } return s.join("&") }; jQuery.fn.extend({ serialize: function () { return jQuery.param(this.serializeArray()) }, serializeArray: function () { return this.map(function () { var elements = jQuery.prop(this, "elements"); return elements ? jQuery.makeArray(elements) : this }).filter(function () { var type = this.type; return this.name && !jQuery(this).is(":disabled") && rsubmittable.test(this.nodeName) && !rsubmitterTypes.test(type) && (this.checked || !rcheckableType.test(type)) }).map(function (i, elem) { var val = jQuery(this).val(); if (val == null) { return null } if (Array.isArray(val)) { return jQuery.map(val, function (val) { return { name: elem.name, value: val.replace(rCRLF, "\r\n") } }) } return { name: elem.name, value: val.replace(rCRLF, "\r\n") } }).get() } }); var r20 = /%20/g, rhash = /#.*$/, rantiCache = /([?&])_=[^&]*/, rheaders = /^(.*?):[ \t]*([^\r\n]*)$/mg, rlocalProtocol = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, rnoContent = /^(?:GET|HEAD)$/, rprotocol = /^\/\//, prefilters = {}, transports = {}, allTypes = "*/".concat("*"), originAnchor = document.createElement("a"); originAnchor.href = location.href; function addToPrefiltersOrTransports(structure) { return function (dataTypeExpression, func) { if (typeof dataTypeExpression !== "string") { func = dataTypeExpression; dataTypeExpression = "*" } var dataType, i = 0, dataTypes = dataTypeExpression.toLowerCase().match(rnothtmlwhite) || []; if (isFunction(func)) { while (dataType = dataTypes[i++]) { if (dataType[0] === "+") { dataType = dataType.slice(1) || "*"; (structure[dataType] = structure[dataType] || []).unshift(func) } else { (structure[dataType] = structure[dataType] || []).push(func) } } } } } function inspectPrefiltersOrTransports(structure, options, originalOptions, jqXHR) { var inspected = {}, seekingTransport = structure === transports; function inspect(dataType) { var selected; inspected[dataType] = true; jQuery.each(structure[dataType] || [], function (_, prefilterOrFactory) { var dataTypeOrTransport = prefilterOrFactory(options, originalOptions, jqXHR); if (typeof dataTypeOrTransport === "string" && !seekingTransport && !inspected[dataTypeOrTransport]) { options.dataTypes.unshift(dataTypeOrTransport); inspect(dataTypeOrTransport); return false } else if (seekingTransport) { return !(selected = dataTypeOrTransport) } }); return selected } return inspect(options.dataTypes[0]) || !inspected["*"] && inspect("*") } function ajaxExtend(target, src) { var key, deep, flatOptions = jQuery.ajaxSettings.flatOptions || {}; for (key in src) { if (src[key] !== undefined) { (flatOptions[key] ? target : deep || (deep = {}))[key] = src[key] } } if (deep) { jQuery.extend(true, target, deep) } return target } function ajaxHandleResponses(s, jqXHR, responses) { var ct, type, finalDataType, firstDataType, contents = s.contents, dataTypes = s.dataTypes; while (dataTypes[0] === "*") { dataTypes.shift(); if (ct === undefined) { ct = s.mimeType || jqXHR.getResponseHeader("Content-Type") } } if (ct) { for (type in contents) { if (contents[type] && contents[type].test(ct)) { dataTypes.unshift(type); break } } } if (dataTypes[0] in responses) { finalDataType = dataTypes[0] } else { for (type in responses) { if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) { finalDataType = type; break } if (!firstDataType) { firstDataType = type } } finalDataType = finalDataType || firstDataType } if (finalDataType) { if (finalDataType !== dataTypes[0]) { dataTypes.unshift(finalDataType) } return responses[finalDataType] } } function ajaxConvert(s, response, jqXHR, isSuccess) { var conv2, current, conv, tmp, prev, converters = {}, dataTypes = s.dataTypes.slice(); if (dataTypes[1]) { for (conv in s.converters) { converters[conv.toLowerCase()] = s.converters[conv] } } current = dataTypes.shift(); while (current) { if (s.responseFields[current]) { jqXHR[s.responseFields[current]] = response } if (!prev && isSuccess && s.dataFilter) { response = s.dataFilter(response, s.dataType) } prev = current; current = dataTypes.shift(); if (current) { if (current === "*") { current = prev } else if (prev !== "*" && prev !== current) { conv = converters[prev + " " + current] || converters["* " + current]; if (!conv) { for (conv2 in converters) { tmp = conv2.split(" "); if (tmp[1] === current) { conv = converters[prev + " " + tmp[0]] || converters["* " + tmp[0]]; if (conv) { if (conv === true) { conv = converters[conv2] } else if (converters[conv2] !== true) { current = tmp[0]; dataTypes.unshift(tmp[1]) } break } } } } if (conv !== true) { if (conv && s.throws) { response = conv(response); } else { try { response = conv(response) } catch (e) { return { state: "parsererror", error: conv ? e : "No conversion from " + prev + " to " + current } } } } } } } return { state: "success", data: response } } jQuery.extend({ active: 0, lastModified: {}, etag: {}, ajaxSettings: { url: location.href, type: "GET", isLocal: rlocalProtocol.test(location.protocol), global: true, processData: true, async: true, contentType: "application/x-www-form-urlencoded; charset=UTF-8", accepts: { "*": allTypes, text: "text/plain", html: "text/html", xml: "application/xml, text/xml", json: "application/json, text/javascript" }, contents: { xml: /\bxml\b/, html: /\bhtml/, json: /\bjson\b/ }, responseFields: { xml: "responseXML", text: "responseText", json: "responseJSON" }, converters: { "* text": String, "text html": true, "text json": JSON.parse, "text xml": jQuery.parseXML }, flatOptions: { url: true, context: true } }, ajaxSetup: function (target, settings) { return settings ? ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings) : ajaxExtend(jQuery.ajaxSettings, target) }, ajaxPrefilter: addToPrefiltersOrTransports(prefilters), ajaxTransport: addToPrefiltersOrTransports(transports), ajax: function (url, options) { if (typeof url === "object") { options = url; url = undefined } options = options || {}; var transport, cacheURL, responseHeadersString, responseHeaders, timeoutTimer, urlAnchor, completed, fireGlobals, i, uncached, s = jQuery.ajaxSetup({}, options), callbackContext = s.context || s, globalEventContext = s.context && (callbackContext.nodeType || callbackContext.jquery) ? jQuery(callbackContext) : jQuery.event, deferred = jQuery.Deferred(), completeDeferred = jQuery.Callbacks("once memory"), statusCode = s.statusCode || {}, requestHeaders = {}, requestHeadersNames = {}, strAbort = "canceled", jqXHR = { readyState: 0, getResponseHeader: function (key) { var match; if (completed) { if (!responseHeaders) { responseHeaders = {}; while (match = rheaders.exec(responseHeadersString)) { responseHeaders[match[1].toLowerCase() + " "] = (responseHeaders[match[1].toLowerCase() + " "] || []).concat(match[2]) } } match = responseHeaders[key.toLowerCase() + " "] } return match == null ? null : match.join(", ") }, getAllResponseHeaders: function () { return completed ? responseHeadersString : null }, setRequestHeader: function (name, value) { if (completed == null) { name = requestHeadersNames[name.toLowerCase()] = requestHeadersNames[name.toLowerCase()] || name; requestHeaders[name] = value } return this }, overrideMimeType: function (type) { if (completed == null) { s.mimeType = type } return this }, statusCode: function (map) { var code; if (map) { if (completed) { jqXHR.always(map[jqXHR.status]) } else { for (code in map) { statusCode[code] = [statusCode[code], map[code]] } } } return this }, abort: function (statusText) { var finalText = statusText || strAbort; if (transport) { transport.abort(finalText) } done(0, finalText); return this } }; deferred.promise(jqXHR); s.url = ((url || s.url || location.href) + "").replace(rprotocol, location.protocol + "//"); s.type = options.method || options.type || s.method || s.type; s.dataTypes = (s.dataType || "*").toLowerCase().match(rnothtmlwhite) || [""]; if (s.crossDomain == null) { urlAnchor = document.createElement("a"); try { urlAnchor.href = s.url; urlAnchor.href = urlAnchor.href; s.crossDomain = originAnchor.protocol + "//" + originAnchor.host !== urlAnchor.protocol + "//" + urlAnchor.host } catch (e) { s.crossDomain = true } } if (s.data && s.processData && typeof s.data !== "string") { s.data = jQuery.param(s.data, s.traditional) } inspectPrefiltersOrTransports(prefilters, s, options, jqXHR); if (completed) { return jqXHR } fireGlobals = jQuery.event && s.global; if (fireGlobals && jQuery.active++ === 0) { jQuery.event.trigger("ajaxStart") } s.type = s.type.toUpperCase(); s.hasContent = !rnoContent.test(s.type); cacheURL = s.url.replace(rhash, ""); if (!s.hasContent) { uncached = s.url.slice(cacheURL.length); if (s.data && (s.processData || typeof s.data === "string")) { cacheURL += (rquery.test(cacheURL) ? "&" : "?") + s.data; delete s.data } if (s.cache === false) { cacheURL = cacheURL.replace(rantiCache, "$1"); uncached = (rquery.test(cacheURL) ? "&" : "?") + "_=" + nonce++ + uncached } s.url = cacheURL + uncached } else if (s.data && s.processData && (s.contentType || "").indexOf("application/x-www-form-urlencoded") === 0) { s.data = s.data.replace(r20, "+") } if (s.ifModified) { if (jQuery.lastModified[cacheURL]) { jqXHR.setRequestHeader("If-Modified-Since", jQuery.lastModified[cacheURL]) } if (jQuery.etag[cacheURL]) { jqXHR.setRequestHeader("If-None-Match", jQuery.etag[cacheURL]) } } if (s.data && s.hasContent && s.contentType !== false || options.contentType) { jqXHR.setRequestHeader("Content-Type", s.contentType) } jqXHR.setRequestHeader("Accept", s.dataTypes[0] && s.accepts[s.dataTypes[0]] ? s.accepts[s.dataTypes[0]] + (s.dataTypes[0] !== "*" ? ", " + allTypes + "; q=0.01" : "") : s.accepts["*"]); for (i in s.headers) { jqXHR.setRequestHeader(i, s.headers[i]) } if (s.beforeSend && (s.beforeSend.call(callbackContext, jqXHR, s) === false || completed)) { return jqXHR.abort() } strAbort = "abort"; completeDeferred.add(s.complete); jqXHR.done(s.success); jqXHR.fail(s.error); transport = inspectPrefiltersOrTransports(transports, s, options, jqXHR); if (!transport) { done(-1, "No Transport") } else { jqXHR.readyState = 1; if (fireGlobals) { globalEventContext.trigger("ajaxSend", [jqXHR, s]) } if (completed) { return jqXHR } if (s.async && s.timeout > 0) { timeoutTimer = window.setTimeout(function () { jqXHR.abort("timeout") }, s.timeout) } try { completed = false; transport.send(requestHeaders, done) } catch (e) { if (completed) { throw e; } done(-1, e) } } function done(status, nativeStatusText, responses, headers) { var isSuccess, success, error, response, modified, statusText = nativeStatusText; if (completed) { return } completed = true; if (timeoutTimer) { window.clearTimeout(timeoutTimer) } transport = undefined; responseHeadersString = headers || ""; jqXHR.readyState = status > 0 ? 4 : 0; isSuccess = status >= 200 && status < 300 || status === 304; if (responses) { response = ajaxHandleResponses(s, jqXHR, responses) } response = ajaxConvert(s, response, jqXHR, isSuccess); if (isSuccess) { if (s.ifModified) { modified = jqXHR.getResponseHeader("Last-Modified"); if (modified) { jQuery.lastModified[cacheURL] = modified } modified = jqXHR.getResponseHeader("etag"); if (modified) { jQuery.etag[cacheURL] = modified } } if (status === 204 || s.type === "HEAD") { statusText = "nocontent" } else if (status === 304) { statusText = "notmodified" } else { statusText = response.state; success = response.data; error = response.error; isSuccess = !error } } else { error = statusText; if (status || !statusText) { statusText = "error"; if (status < 0) { status = 0 } } } jqXHR.status = status; jqXHR.statusText = (nativeStatusText || statusText) + ""; if (isSuccess) { deferred.resolveWith(callbackContext, [success, statusText, jqXHR]) } else { deferred.rejectWith(callbackContext, [jqXHR, statusText, error]) } jqXHR.statusCode(statusCode); statusCode = undefined; if (fireGlobals) { globalEventContext.trigger(isSuccess ? "ajaxSuccess" : "ajaxError", [jqXHR, s, isSuccess ? success : error]) } completeDeferred.fireWith(callbackContext, [jqXHR, statusText]); if (fireGlobals) { globalEventContext.trigger("ajaxComplete", [jqXHR, s]); if (!--jQuery.active) { jQuery.event.trigger("ajaxStop") } } } return jqXHR }, getJSON: function (url, data, callback) { return jQuery.get(url, data, callback, "json") }, getScript: function (url, callback) { return jQuery.get(url, undefined, callback, "script") } }); jQuery.each(["get", "post"], function (i, method) { jQuery[method] = function (url, data, callback, type) { if (isFunction(data)) { type = type || callback; callback = data; data = undefined } return jQuery.ajax(jQuery.extend({ url: url, type: method, dataType: type, data: data, success: callback }, jQuery.isPlainObject(url) && url)) } }); jQuery.ajaxSettings.xhr = function () { try { return new window.XMLHttpRequest() } catch (e) { } }; var xhrSuccessStatus = { 0: 200, 1223: 204 }, xhrSupported = jQuery.ajaxSettings.xhr(); support.cors = !!xhrSupported && "withCredentials" in xhrSupported; support.ajax = xhrSupported = !!xhrSupported; jQuery.ajaxTransport(function (options) { var callback, errorCallback; if (support.cors || xhrSupported && !options.crossDomain) { return { send: function (headers, complete) { var i, xhr = options.xhr(); xhr.open(options.type, options.url, options.async, options.username, options.password); if (options.xhrFields) { for (i in options.xhrFields) { xhr[i] = options.xhrFields[i] } } if (options.mimeType && xhr.overrideMimeType) { xhr.overrideMimeType(options.mimeType) } if (!options.crossDomain && !headers["X-Requested-With"]) { headers["X-Requested-With"] = "XMLHttpRequest" } for (i in headers) { xhr.setRequestHeader(i, headers[i]) } callback = function (type) { return function () { if (callback) { callback = errorCallback = xhr.onload = xhr.onerror = xhr.onabort = xhr.ontimeout = xhr.onreadystatechange = null; if (type === "abort") { xhr.abort() } else if (type === "error") { if (typeof xhr.status !== "number") { complete(0, "error") } else { complete(xhr.status, xhr.statusText) } } else { complete(xhrSuccessStatus[xhr.status] || xhr.status, xhr.statusText, (xhr.responseType || "text") !== "text" || typeof xhr.responseText !== "string" ? { binary: xhr.response } : { text: xhr.responseText }, xhr.getAllResponseHeaders()) } } } }; xhr.onload = callback(); errorCallback = xhr.onerror = xhr.ontimeout = callback("error"); if (xhr.onabort !== undefined) { xhr.onabort = errorCallback } else { xhr.onreadystatechange = function () { if (xhr.readyState === 4) { window.setTimeout(function () { if (callback) { errorCallback() } }) } } } callback = callback("abort"); try { xhr.send(options.hasContent && options.data || null) } catch (e) { if (callback) { throw e; } } }, abort: function () { if (callback) { callback() } } } } }); jQuery.ajaxPrefilter(function (s) { if (s.crossDomain) { s.contents.script = false } }); jQuery.ajaxSetup({ accepts: { script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript" }, contents: { script: /\b(?:java|ecma)script\b/ }, converters: { "text script": function (text) { jQuery.globalEval(text); return text } } }); jQuery.ajaxPrefilter("script", function (s) { if (s.cache === undefined) { s.cache = false } if (s.crossDomain) { s.type = "GET" } }); jQuery.ajaxTransport("script", function (s) { if (s.crossDomain || s.scriptAttrs) { var script, callback; return { send: function (_, complete) { script = jQuery("<script>").attr(s.scriptAttrs || {}).prop({ charset: s.scriptCharset, src: s.url }).on("load error", callback = function (evt) { script.remove(); callback = null; if (evt) { complete(evt.type === "error" ? 404 : 200, evt.type) } }); document.head.appendChild(script[0]) }, abort: function () { if (callback) { callback() } } } } }); var oldCallbacks = [], rjsonp = /(=)\?(?=&|$)|\?\?/; jQuery.ajaxSetup({ jsonp: "callback", jsonpCallback: function () { var callback = oldCallbacks.pop() || jQuery.expando + "_" + nonce++; this[callback] = true; return callback } }); jQuery.ajaxPrefilter("json jsonp", function (s, originalSettings, jqXHR) { var callbackName, overwritten, responseContainer, jsonProp = s.jsonp !== false && (rjsonp.test(s.url) ? "url" : typeof s.data === "string" && (s.contentType || "").indexOf("application/x-www-form-urlencoded") === 0 && rjsonp.test(s.data) && "data"); if (jsonProp || s.dataTypes[0] === "jsonp") { callbackName = s.jsonpCallback = isFunction(s.jsonpCallback) ? s.jsonpCallback() : s.jsonpCallback; if (jsonProp) { s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName) } else if (s.jsonp !== false) { s.url += (rquery.test(s.url) ? "&" : "?") + s.jsonp + "=" + callbackName } s.converters["script json"] = function () { if (!responseContainer) { jQuery.error(callbackName + " was not called") } return responseContainer[0] }; s.dataTypes[0] = "json"; overwritten = window[callbackName]; window[callbackName] = function () { responseContainer = arguments }; jqXHR.always(function () { if (overwritten === undefined) { jQuery(window).removeProp(callbackName) } else { window[callbackName] = overwritten } if (s[callbackName]) { s.jsonpCallback = originalSettings.jsonpCallback; oldCallbacks.push(callbackName) } if (responseContainer && isFunction(overwritten)) { overwritten(responseContainer[0]) } responseContainer = overwritten = undefined }); return "script" } }); jQuery.each(["ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend"], function (i, type) { jQuery.fn[type] = function (fn) { return this.on(type, fn) } }); var _jQuery = window.jQuery, _$ = window.$; jQuery.noConflict = function (deep) { if (window.$ === jQuery) { window.$ = _$ } if (deep && window.jQuery === jQuery) { window.jQuery = _jQuery } return jQuery }; if (!noGlobal) { window.$ = jQuery; } return jQuery });