﻿<%@ Page Title="" Language="C#" MasterPageFile="~/profile/profile.Master" EnableViewState="false"  AutoEventWireup="true" CodeBehind="Data_Repair.aspx.cs" Inherits="profile.profile.Data_Repair" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <style>
        .r {
         color:red
        }
        .b {
          color:black;
        }
    </style>
    <div class="alert">
        说明：根据身份证判断用户的出生日期、性别以及籍贯是否正确。 红色表示数字有问题。 <%--<input type="button" value="数据比对"  onclick="comp();" class="btn btn-sm btn-success" />--%>
    </div>

    <asp:GridView runat="server" ID="gv_list" AutoGenerateColumns="false"  GridLines="None" CssClass="table">

        <Columns>
            <asp:BoundField DataField="displayname" HeaderStyle-Width="90px"  HeaderText="姓名"/>
            <asp:BoundField DataField="dept" HeaderStyle-Width="90px"  HeaderText="部门"/>
            <asp:BoundField DataField="idcard" HeaderStyle-Width="180px"  HeaderText="身份证"/>

              <asp:BoundField DataField="sex" HeaderStyle-Width="80px"  HeaderText="性别"/>
              <asp:BoundField DataField="birthday" HeaderStyle-Width="100px"  HeaderText="生日"/>
              <asp:BoundField DataField="province2" HeaderStyle-Width="90px"  HeaderText="籍贯"/>


        </Columns>



    </asp:GridView>






    <script>

        

        function comp()
        {

            $("table.table  tr:not(:first)").each(
                function ()
                { 
                    var tds = $(this).children();
                    _idcard = $(tds[2]).html();
                    _sex = $(tds[3]).html();
                    _birthday = $(tds[4]).html();
                    _pro = $(tds[5]).html();

                    var _isok = IsIdOK(_idcard);

                    if (_isok != 0) {
                        $(tds[2]).html("<font color=red>"+_idcard+"</font>");
                    }
                    else {
 
                        _nsex = GetSex(_idcard);
                        if (_sex != _nsex)
                        {
                            $(tds[3]).html(_sex+"<font color=red>("+_nsex+")</font>")
                        }


                        _nbirthday =  GetBirthday(_idcard);
                        if (_birthday != _nbirthday) {
                            $(tds[4]).html(_birthday + "<font color=red>(" + _nbirthday + ")</font>")
                        }



                        _npro = Getpro(_idcard);
                        if (_pro != _npro) {
                            $(tds[5]).html(_pro + "<font color=red>(" + _npro + ")</font>")
                        }


                    }

                }



               );

        }


        function IsIdOK(code) {
             result = 0;
           

            if (!/^[1-9][0-9]{5}(19|20)[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|31)|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}([0-9]|x|X)$/.test(code)) {
               //"身份证号格式错误";
                return "1";
            }
 
                
          
            code = code.split('');
           
                    //∑(ai×Wi)(mod 11)
                    //加权因子
                    var factor = [ 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 ];
                    //校验位
                    var parity = [ 1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2 ];
                    var sum = 0;
                    var ai = 0;
                    var wi = 0;
                    for (var i = 0; i < 17; i++)
                    {
                        ai = code[i];
                        wi = factor[i];
                        sum += ai * wi;
                    }
                    var last = parity[sum % 11];
                    if (parity[sum % 11] != code[17]) {
                        //校验码不对
                        return 2;
                    }
                 
            
           
            return 0;
        }
      

        function GetSex(code)
        {
          if (parseInt(code.substr(16, 1)) % 2 == 1) {   
                return "男";
            }
          else 
           {  
                 return "女";
           }
        }
 

        function GetBirthday(code) {
            var birth = code.substring(6, 10) + "-" + code.substring(10, 12) + "-" + code.substring(12, 14);
            return birth;
        }
      


        function Getpro(code) {
            var city = {  11: "北京", 12: "天津", 13: "河北", 14: "山西", 15: "内蒙古", 21: "辽宁", 22: "吉林", 23: "黑龙江 ", 31: "上海", 32: "江苏", 33: "浙江", 34: "安徽", 35: "福建", 36: "江西", 37: "山东", 41: "河南", 42: "湖北 ", 43: "湖南", 44: "广东", 45: "广西", 46: "海南", 50: "重庆", 51: "四川", 52: "贵州", 53: "云南", 54: "西藏 ", 61: "陕西", 62: "甘肃", 63: "青海", 64: "宁夏", 65: "新疆", 71: "台湾", 81: "香港", 82: "澳门", 83:"台湾", 91: "国外 "   };
            var _pro = code.substr(0, 2);           
            return city[_pro];

        }


        comp();
    </script>

</asp:Content>
