﻿<%@ Page Title="" Language="C#" MasterPageFile="~/profile/salary.master" AutoEventWireup="true" CodeBehind="salary_trending.aspx.cs" Inherits="profile.profile.salary_trending" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolder2" runat="server">

        <script src="../javascript/echarts/echarts.min.js"></script>
    <script src="../javascript/echarts/macarons.js"></script>

    <script src="../javascript/echarts/MyEcharts.js"></script>

    <script src="../javascript/echarts/WapCharts.js"></script>



    <div class="alert alert-danger">
        <b>说明</b> 了解公司每年工资支出趋势图
    </div>

        <div id="main" style=" width:99%; height:450px;"></div>
    


    <script>


        var myChart = echarts.init(document.getElementById('main'));



        option = {
            title: {
                text: '公司每年工资支出趋势图'
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'cross',
                    label: {
                        backgroundColor: '#6a7985'
                    }
                }
            },
            legend: {
                data: ['基本工资', '加班费', '奖金', '其他补贴', '满勤奖']
            },
            toolbox: {
                feature: {
                    saveAsImage: {}
                }
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    boundaryGap: false,
                    data: [  '<%=(year-6)%>年', '<%=(year-5)%>年', '<%=(year-4)%>年', '<%=(year-3)%>年', '<%=(year-2)%>年', '<%=(year-1)%>年', '<%=(year)%>年', ]
                }
            ],
            yAxis: [
                {
                    type: 'value'
                }
            ],
            series: [
                {
                    name: '基本工资',
                    type: 'line',
                    stack: '支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("基本工资",(year-6)) %>, <%=GetSalary("基本工资",(year-5)) %>,  <%=GetSalary("基本工资",(year-4)) %>, <%=GetSalary("基本工资",(year-3)) %>, <%=GetSalary("基本工资",(year-2)) %>,<%=GetSalary("基本工资",(year-1)) %>, <%=GetSalary("基本工资",(year)) %>]
                },
                {
                    name: '加班费',
                    type: 'line',
                    stack: '支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("加班费",(year-6)) %>, <%=GetSalary("加班费",(year-5)) %>,  <%=GetSalary("加班费",(year-4)) %>, <%=GetSalary("加班费",(year-3)) %>, <%=GetSalary("加班费",(year-2)) %>,<%=GetSalary("加班费",(year-1)) %>, <%=GetSalary("基本工资",(year)) %>]
                },
                {
                    name: '奖金',
                    type: 'line',
                    stack: '支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("奖金",(year-6)) %>, <%=GetSalary("奖金",(year-5)) %>,  <%=GetSalary("奖金",(year-4)) %>, <%=GetSalary("奖金",(year-3)) %>, <%=GetSalary("奖金",(year-2)) %>,<%=GetSalary("奖金",(year-1)) %>, <%=GetSalary("奖金",(year)) %>]
                },
                {
                    name: '其他补贴',
                    type: 'line',
                    stack: '支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("其他补贴",(year-6)) %>, <%=GetSalary("其他补贴",(year-5)) %>,  <%=GetSalary("其他补贴",(year-4)) %>, <%=GetSalary("其他补贴",(year-3)) %>, <%=GetSalary("其他补贴",(year-2)) %>,<%=GetSalary("其他补贴",(year-1)) %>, <%=GetSalary("其他补贴",(year)) %>]
                },
                {
                    name: '满勤奖',
                    type: 'line',
                    stack: '支出', 
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("满勤奖",(year-6)) %>, <%=GetSalary("满勤奖",(year-5)) %>,  <%=GetSalary("满勤奖",(year-4)) %>, <%=GetSalary("满勤奖",(year-3)) %>, <%=GetSalary("满勤奖",(year-2)) %>,<%=GetSalary("满勤奖",(year-1)) %>, <%=GetSalary("满勤奖",(year)) %>]
                }
            ]
        };

        myChart.setOption(option);


    </script>


  





    <br /><br /><br />


    *下表根据工资单计算，因为医保等员工企业各缴纳一部分，这里统计仅以工资单里，员工缴纳为依据。
     <div id="main2" style=" width:99%; height:450px;"></div>

    

    <script>


        var myChart2 = echarts.init(document.getElementById('main2'));



        option2 = {
            title: {
                text: '员工每年支出趋势图'
            },
            tooltip: {
                trigger: 'axis',
                axisPointer: {
                    type: 'cross',
                    label: {
                        backgroundColor: '#6a7985'
                    }
                }
            },
            legend: {
                data: ['养老保险金', '医疗保险金', '住房公积金', '失业保险金', '个人所得税']
            },
            toolbox: {
                feature: {
                    saveAsImage: {}
                }
            },
            grid: {
                left: '3%',
                right: '4%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [
                {
                    type: 'category',
                    boundaryGap: false,
                    data: ['<%=(year-6)%>年', '<%=(year-5)%>年', '<%=(year-4)%>年', '<%=(year-3)%>年', '<%=(year-2)%>年', '<%=(year-1)%>年', '<%=(year)%>年', ]
                }
            ],
            yAxis: [
                {
                    type: 'value'
                }
            ],
            series: [
                {
                    name: '养老保险金',
                    type: 'line',
                    stack: '员工支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("养老保险金",(year-6)) %>, <%=GetSalary("养老保险金",(year-5)) %>,  <%=GetSalary("养老保险金",(year-4)) %>, <%=GetSalary("养老保险金",(year-3)) %>, <%=GetSalary("养老保险金",(year-2)) %>,<%=GetSalary("养老保险金",(year-1)) %>, <%=GetSalary("养老保险金",(year)) %>]
                },
                {
                    name: '医疗保险金',
                    type: 'line',
                    stack: '员工支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("医疗保险金",(year-6)) %>, <%=GetSalary("医疗保险金",(year-5)) %>,  <%=GetSalary("医疗保险金",(year-4)) %>, <%=GetSalary("医疗保险金",(year-3)) %>, <%=GetSalary("医疗保险金",(year-2)) %>,<%=GetSalary("医疗保险金",(year-1)) %>, <%=GetSalary("医疗保险金",(year)) %>]
                },
                {
                    name: '住房公积金',
                    type: 'line',
                    stack: '员工支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("住房公积金",(year-6)) %>, <%=GetSalary("住房公积金",(year-5)) %>,  <%=GetSalary("住房公积金",(year-4)) %>, <%=GetSalary("住房公积金",(year-3)) %>, <%=GetSalary("住房公积金",(year-2)) %>,<%=GetSalary("住房公积金",(year-1)) %>, <%=GetSalary("住房公积金",(year)) %>]
                },
                {
                    name: '失业保险金',
                    type: 'line',
                    stack: '员工支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("失业保险金",(year-6)) %>, <%=GetSalary("失业保险金",(year-5)) %>,  <%=GetSalary("失业保险金",(year-4)) %>, <%=GetSalary("失业保险金",(year-3)) %>, <%=GetSalary("失业保险金",(year-2)) %>,<%=GetSalary("失业保险金",(year-1)) %>, <%=GetSalary("失业保险金",(year)) %>]
                },
                {
                    name: '个人所得税',
                    type: 'line',
                    stack: '员工支出',
                    areaStyle: { normal: {} },
                    data: [<%=GetSalary("个人所得税",(year-6)) %>, <%=GetSalary("个人所得税",(year-5)) %>,  <%=GetSalary("个人所得税",(year-4)) %>, <%=GetSalary("个人所得税",(year-3)) %>, <%=GetSalary("个人所得税",(year-2)) %>,<%=GetSalary("个人所得税",(year-1)) %>, <%=GetSalary("个人所得税",(year)) %>]
                }
            ]
        };

            myChart2.setOption(option2);


    </script>


</asp:Content>
