﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
//该源码下载自www.51aspx.com(５１aｓｐｘ．ｃｏｍ)

namespace DAL
{
    public class T_USERdal
    {
        Model.T_USERmodel _UserEntity;
        /// <summary>
        /// 创建用户实体
        /// </summary>
        public Model.T_USERmodel myUserEntity
        {
            get
            {
                return _UserEntity;
            }
            set
            {
                _UserEntity = value;
            }
        }
        /// <summary>
        /// 检索用户信息
        /// </summary>
        /// <returns>返回用户信息</returns>
        public DataTable selectT_user()
        {
            string SQLstring = "select * from dbo.T_USER where USERNAME=@UserName";
            System.Data.SqlClient.SqlParameter[] cmdParms = new System.Data.SqlClient.SqlParameter[1];
            cmdParms[0] = new System.Data.SqlClient.SqlParameter();
            cmdParms[0].DbType = DbType.String;
            cmdParms[0].ParameterName = "@UserName";
            cmdParms[0].Value = _UserEntity .USERNAME;
            DataTable ds=DBUtility.DbHelperSQL.QueryReturnTable(SQLstring ,cmdParms);
            return ds;
        }
        /// <summary>
        /// 检索用户表所有信息
        /// </summary>
        /// <returns>返回用户信息</returns>
         public DataTable selectAllT_user()
        {
            string SQLstring = "select USERID, USERNAME,case when LEVEL='1' then '系统管理员' when LEVEL='2' then '人事专员' when LEVEL='3'then '人事主管'end as'用户角色' from dbo.T_USER";
            DataTable ds = DBUtility.DbHelperSQL.QueryReturnTable(SQLstring);
            return ds;
        }
      /// <summary>
      /// 删除用户信息
      /// </summary>
      /// <returns>返回行数</returns>
        public int DeleteT_user(string _Userid)
        { 
            string SQLstring = "delete from dbo.T_USER where USERID=@USERID";
            System.Data.SqlClient.SqlParameter[] cmdParms = new System.Data.SqlClient.SqlParameter[1];
            cmdParms[0] = new System.Data.SqlClient.SqlParameter();
            cmdParms[0].DbType = DbType.String;
            cmdParms[0].ParameterName = "@USERID";
            cmdParms[0].Value = _Userid;
            int row = DBUtility.DbHelperSQL.ExecuteSql(SQLstring, cmdParms);
            return row;
        }
        /// <summary>
        /// 以Username为条件检索用户信息
        /// </summary>
        /// <returns>返回用户信息</returns>
        public DataTable selectT_userWhere_UserID(string FileName, string _Username)
        {
            //string SQLstring = "select USERID, USERNAME,case when LEVEL='1' then '系统管理员' when LEVEL='2' then '人事专员' when LEVEL='3'then '人事主管'end as'用户角色' from dbo.T_USER where " + FileName + " like '%' + @USERNAME + '%'";
            string SQLstring = "" ;
            SQLstring += " Select  ";
            SQLstring += " * ";
            SQLstring += " From "; 
            SQLstring += " ( ";
            SQLstring += " select  ";
            SQLstring += " USERID,  ";
            SQLstring += " USERNAME ,  ";
            SQLstring += " case  ";
            SQLstring += " when LEVEL='1' then '系统管理员'  ";
            SQLstring += " when LEVEL='2' then '人事专员'  ";
            SQLstring += " when LEVEL='3'then '人事主管' ";
            SQLstring += " end as '用户角色'  ";
            SQLstring += " from dbo.T_USER  ";
            SQLstring += " ) AS T1 ";
            SQLstring += " where " + FileName + " like '%' + @USERNAME + '%'";
            System.Data.SqlClient.SqlParameter[] cmdParms = new System.Data.SqlClient.SqlParameter[1];
            cmdParms[0] = new System.Data.SqlClient.SqlParameter();
            cmdParms[0].DbType = DbType.String;
            cmdParms[0].ParameterName = "@USERNAME";
            cmdParms[0].Value = _Username;
            DataTable ds = DBUtility.DbHelperSQL.QueryReturnTable(SQLstring, cmdParms);
            return ds;
        }
        /// <summary>
        /// 以Userid为条件检索用户信息
        /// </summary>
        /// <returns>返回用户信息</returns>
        public DataTable selectT_userWhere_Username(string _Userid)
        {
            string SQLstring = "select USERID, USERNAME,PASSWORD,case when LEVEL='1' then '系统管理员' when LEVEL='2' then '人事专员' when LEVEL='3'then '人事主管'end as'用户角色' from dbo.T_USER where USERID=@USERID";
            System.Data.SqlClient.SqlParameter[] cmdParms = new System.Data.SqlClient.SqlParameter[1];
            cmdParms[0] = new System.Data.SqlClient.SqlParameter();
            cmdParms[0].DbType = DbType.String;
            cmdParms[0].ParameterName = "@USERID";
            cmdParms[0].Value = _Userid;
            DataTable ds = DBUtility.DbHelperSQL.QueryReturnTable(SQLstring, cmdParms);
            return ds;
        }
        /// <summary>
        /// 更新用户信息表数据
        /// </summary>
        /// <param name="mt"></param>
        /// <returns></returns>
        public int Update_User(Model .T_USERmodel mt)
        {
            string SQLstring = "update dbo.T_USER set USERNAME=@USERNAME,PASSWORD=@PASSWORD,LEVEL=@LEVEL where USERID=@USERID";
            System.Data.SqlClient.SqlParameter[] cmdParms = new System.Data.SqlClient.SqlParameter[4];
            cmdParms[0] = new System.Data.SqlClient.SqlParameter();
            cmdParms[0].DbType = DbType.String;
            cmdParms[0].ParameterName = "@USERNAME";
            cmdParms[0].Value =mt .USERNAME;

            cmdParms[1] = new System.Data.SqlClient.SqlParameter();
            cmdParms[1].DbType = DbType.String;
            cmdParms[1].ParameterName = "@PASSWORD";
            cmdParms[1].Value =mt.PASSWORD;

            cmdParms[2] = new System.Data.SqlClient.SqlParameter();
            cmdParms[2].DbType = DbType.String;
            cmdParms[2].ParameterName = "@LEVEL";
            cmdParms[2].Value =mt.LEVEL;

            cmdParms[3] = new System.Data.SqlClient.SqlParameter();
            cmdParms[3].DbType = DbType.String;
            cmdParms[3].ParameterName = "@USERID";
            cmdParms[3].Value =mt.USERID;
            int row = DBUtility.DbHelperSQL.ExecuteSql(SQLstring, cmdParms);
            return row;
          }
        /// <summary>
        /// 添加新用户
        /// </summary>
        /// <returns></returns>
        public int Insert_User(string username,string password,string level)
        {
            string SQLstring = "insert into dbo.T_USER(USERNAME,PASSWORD,LEVEL)values(@USERNAME,@PASSWORD,@LEVEL)";
            System.Data.SqlClient.SqlParameter[] sqlparm = new SqlParameter[3];
            sqlparm[0] = new SqlParameter("@USERNAME", SqlDbType.Char ,50);
            sqlparm[0].Value = username;

            sqlparm[1] = new SqlParameter("@PASSWORD", SqlDbType.Char, 50);
            sqlparm[1].Value =password;

            sqlparm[2] = new SqlParameter("@LEVEL", SqlDbType.Char, 50);
            sqlparm[2].Value = level;
            int row = DBUtility.DbHelperSQL.ExecuteSql(SQLstring ,sqlparm);
            return row;
           

        }
    }
}
