using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.ComponentModel;
using System.Drawing.Design;
using System.Web.UI.Design;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace HeroBeastControls.NavMenu
{
    /// <summary>
    /// Navigation Menu Item 
    /// </summary>

    [ParseChildren(true, "Items")]
    [TypeConverter(typeof(NavMenuItemConverter))]
    public class NavMenuItem
    {

        public NavMenuItem()
            : this(String.Empty, String.Empty)
        {
        }

        public NavMenuItem(string cssname, string text)
        {
            CssClass = cssname;
            Text = text;
        }
        /// <summary>
        /// ʽ
        /// </summary>
        private string _CssClass = "";
        [
         Category("Behavior"),
         DefaultValue(""),
         Description("ʽ"),
         NotifyParentProperty(true)
         ]
        public string CssClass
        {
            get { return _CssClass; }
            set { _CssClass = value; }
        }

        //private string _BackGroundImage;
        //[UrlProperty("JPGļ(*.jpg)|*.jpg|PNGļ(*.png)|*.png|GIFļ(*.gif)|*.gif|ļ(*.*)|*.*")]
        //[Description("ʽ")]
        //[Editor(typeof(UrlEditor), typeof(UITypeEditor))]
        //public string BackGroundImage
        //{
        //    get
        //    {
        //        return _BackGroundImage;
        //    }
        //    set
        //    {
        //        _BackGroundImage = value;
        //    }
        //}
        /// <summary>
        /// ı
        /// </summary>
        private string _Text = "";
        [
        Category("Behavior"),
        DefaultValue(""),
        Description("ı"),
        NotifyParentProperty(true),
        ]
        public string Text
        {
            get { return _Text; }
            set { _Text = value; }
        }

        /// <summary>
        /// 
        /// </summary>
        private NavMenuSubItems _ListItems;
        [
        Category("Behavior"),
        Description(""),
        DesignerSerializationVisibility(
        DesignerSerializationVisibility.Content),
        PersistenceMode(PersistenceMode.InnerDefaultProperty),
        Editor(typeof(NavMenuSubItemEditor), typeof(UITypeEditor))
        ]
        public NavMenuSubItems Items
        {
            get
            {
                if (_ListItems == null)
                {
                    _ListItems = new NavMenuSubItems();
                }
                return _ListItems;
            }
        }
    }
}
