using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Globalization;

namespace HeroBeastControls.NavMenu
{
    /// <summary>
    /// NavMenuItemת
    /// </summary>
    public class NavMenuItemConverter : ExpandableObjectConverter
    {
        #region 

        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
        {
            if (sourceType == typeof(string))
            {
                return true;
            }
            return base.CanConvertFrom(context, sourceType);
        }

        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
        {
            if (destinationType == typeof(string))
            {
                return true;
            }
            return base.CanConvertTo(context, destinationType);
        }

        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture,
            object value)
        {
            if (value == null)
            {
                return new NavMenuItem();
            }
            if (value is string)
            {
                string s = (string)value;
                if (s.Length == 0)
                {
                    return new NavMenuItem();
                }
                return "NavMenuItem";

            }
            return base.ConvertFrom(context, culture, value);
        }

        public override object ConvertTo(
            ITypeDescriptorContext context,
            CultureInfo culture, object value, Type destinationType)
        {
            if (value != null)
            {
                if (!(value is NavMenuItem))
                {
                    throw new ArgumentException(
                        "Invalid NavMenuItem", "value");
                }
            }

            if (destinationType == typeof(string))
            {
                if (value == null)
                {
                    return String.Empty;
                }
                return "NavMenuItem";
            }
            return base.ConvertTo(context, culture, value,
                destinationType);
        }
        #endregion
    }
}
