using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.Design;
using System.IO;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.ComponentModel.Design;
using System.ComponentModel;
using System.Drawing.Design;
////p
namespace HeroBeastControls.NavMenu
{
    public class NavMenuDesigner : ControlDesigner
    {

        public override string GetDesignTimeHtml()
        {
            return base.GetDesignTimeHtml();
        }
        public override bool AllowResize
        {
            get { return true; }
        }

        DesignerActionListCollection _actionLists;
        public override DesignerActionListCollection ActionLists
        {
            get
            {
                if (_actionLists == null)
                {
                    _actionLists = new DesignerActionListCollection();
                    _actionLists.AddRange(base.ActionLists);
                    _actionLists.Add(new NavMenuActionList(this));
                }
                return _actionLists;
            }
        }
    }
    class NavMenuActionList : DesignerActionList
    {
        NavMenuDesigner _designer;

        public NavMenuActionList(NavMenuDesigner designer)
            : base(designer.Component)
        {
            _designer = designer;
        }

        public override DesignerActionItemCollection GetSortedActionItems()
        {
            DesignerActionItemCollection list = new DesignerActionItemCollection();
            list.Add(new DesignerActionTextItem("鿴ѡ", "ShowPanel"));
            list.Add(new DesignerActionPropertyItem("CssFilePath", "Cssļ·", "NavMenu"));
            list.Add(new DesignerActionPropertyItem("ListItems", "ListItems", "NavMenu"));
            return list;
        }

        [Editor(typeof(CssUrlEditor), typeof(UITypeEditor))]
        public string CssFilePath
        {
            get
            {
                return (Component as NavMenu).CssFilePath;
            }
            set
            {
                TypeDescriptor.GetProperties(Component)["CssFilePath"].SetValue(Component, value);
                _designer.UpdateDesignTimeHtml();
            }
        }
        /// <summary>
        /// /5/1/a/s/px
        /// </summary>
        public NavMenuItems ListItems
        {
            get
            {
                return (Component as NavMenu).ListItems;
            }
            set
            {
                TypeDescriptor.GetProperties(Component)["ListItems"].SetValue(Component, value);
                _designer.UpdateDesignTimeHtml();
            }
        }
    }
}
