using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing.Design;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Collections;
using System.Drawing;
//Դwww.51aspx.com(1)

namespace HeroBeastControls.NavMenu
{

    [DesignerAttribute(typeof(NavMenuDesigner))]
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:NavMenu runat=server></{0}:NavMenu>")]
    [ParseChildren(true, "ListItems")]
    public class NavMenu : WebControl, INamingContainer
    {
        bool _supportJS = true;
        #region 
        /// <summary>
        /// 
        /// </summary>
        private NavMenuItems _ListItems;
        [
        Category("Behavior"),
        Description(""),
        DesignerSerializationVisibility(
        DesignerSerializationVisibility.Content),
        PersistenceMode(PersistenceMode.InnerDefaultProperty),
        Editor(typeof(NavMenuItemEditor), typeof(UITypeEditor))
        ]
        public NavMenuItems ListItems
        {
            get
            {
                if (_ListItems == null)
                {
                    _ListItems = new NavMenuItems();

                }
                return _ListItems;
            }
        }


        [UrlProperty("*.css")]
        [Category("Behavior")]
        [DefaultValue(CssFilePathConverter.EmbeddedCss)]
        [Editor(typeof(CssUrlEditor), typeof(UITypeEditor))]
        [Description("ָͨⲿCSSļƿؼʽ")]
        public string CssFilePath
        {
            get
            {
                if (ViewState["CssFilePath"] == null)
                    return CssFilePathConverter.EmbeddedCss;
                else
                    return (string)ViewState["CssFilePath"];
            }
            set
            {
                ViewState["CssFilePath"] = value;
            }
        }


        public override Unit Height
        {
            get
            {
                return base.Height;
            }
            set
            {
                base.Height = value;
            }
        }
        [DefaultValue("100%")]
        public override Unit Width
        {
            get
            {
                return base.Width;
            }
            set
            {
                base.Width = value;
            }
        }
        #endregion

        #region 캯
        public NavMenu()
            : base(HtmlTextWriterTag.Div)
        {

        }
        #endregion

        #region RenderContents
        protected override void RenderContents(HtmlTextWriter writer)
        {
            System.Text.StringBuilder sb = new StringBuilder();
            //sb.Append("<div id=\"MenuAll\">");
            sb.Append("</br>");
            sb.Append(" <div class=\"NavMenuContainer\" id=\"" + this.ClientID + "_Container" + "\" style=\"float:left\">");
            //NavMenuItems
            //<div class="collapsed">
            //     <span class="sys">ϵͳ</span> 
            //     <a title="վϢ" href="#">վϢ</a> 
            //     <a title="Ż" href="#">Ż</a>
            //     <a title="ع" href="#">ع</a>style=" background-image:url()"
            // </div>
            if (_ListItems != null)
            {
                foreach (NavMenuItem item in _ListItems)
                {
                    sb.Append("<div class=\"collapsed\">");
                    sb.Append(string.Format("<span class=\"{0}\">{1}</span> ", item.CssClass, item.Text));

                    if (item.Items != null)
                    {
                        foreach (NavMenuSubItem li in item.Items)
                        {
                            sb.Append(string.Format("<a  title=\"{0}\" href=\"{1}\" target=\"{2}\" class=\"{3}\">{4}</a> ",
                                li.Title, li.NavigationURL, li.Target, li.CssClass, li.Text));
                            //sb.Append("</br>");
                        }
                    }
                    sb.Append("</div>");
                    // sb.Append("</br>");
                }
            }
            //
            sb.Append("</div>");
            // sb.Append("</div>");

            writer.Write(sb.ToString());

            base.RenderContents(writer);
        }
        #endregion

        #region AddAttributesToRender
        protected override void AddAttributesToRender(HtmlTextWriter writer)
        {
            writer.AddAttribute(HtmlTextWriterAttribute.Class, this.CssClass);
            base.AddAttributesToRender(writer);
        }
        #endregion


        #region OnPreRender
        protected override void OnPreRender(EventArgs e)
        {
            EnsureID();
            if (!DesignMode)
            {
                if (Page.Request.Browser.EcmaScriptVersion.Major < 1
                    || Page.Request.Browser.W3CDomVersion.Major < 1)
                {
                    _supportJS = false;
                }
            }
            if (_supportJS)
            {
                RegisterCSSFile(this);
                RegisterJavascriptFile();
                RegisterJavascript();
            }
        }
        #endregion

        #region עCSSļ
        public bool RegisterCSSFile(NavMenu control)
        {
            if (!DesignMode)
            {
                string cssFile = control.CssFilePath;
                if (cssFile == CssFilePathConverter.EmbeddedCss)
                    cssFile = control.GetWebResourceCSSPath();
                return control.RegisterCSSFile(control.Page.Header, cssFile);
            }
            return false;
        }

        string GetWebResourceCSSPath()
        {
            return Page.ClientScript.GetWebResourceUrl(typeof(NavMenu), "NavMenu.CSS.NavMenu.css");
        }
        bool RegisterCSSFile(HtmlHead head, string cssFile)
        {
            bool added = false;
            foreach (Control c in head.Controls)
            {
                HtmlLink link = c as HtmlLink;
                if (link != null)
                {
                    if (link.Href == cssFile)
                    {
                        added = true;
                        break;
                    }
                }
            }
            if (!added)
            {
                HtmlLink link = new HtmlLink();
                link.Href = cssFile;
                link.Attributes["type"] = "text/css";
                link.Attributes["rel"] = "Stylesheet";
                link.Attributes["rev"] = "Stylesheet";
                head.Controls.Add(link);
                added = true;
            }
            return added;
        }
        #endregion

        #region עJS
        public void RegisterJavascriptFile()
        {
            Page.ClientScript.RegisterClientScriptResource(typeof(NavMenu), "NavMenu.Javascript.NavMenu.js");

        }
        public void RegisterJavascript()
        {
            string strContainer = this.ClientID + "_Container";
            System.Text.StringBuilder sb = new StringBuilder();

            sb.Append("\n");
            sb.Append("\n\t");
            sb.Append("var " + strContainer + ";");
            sb.Append("\n\t");
            sb.Append("window.onload = function() { " + strContainer + " = new NavMenu(\"" + strContainer + "\");");
            sb.Append(strContainer + ".init();}\n\t");
            sb.Append("\n");
          
            Page.ClientScript.RegisterStartupScript(typeof(NavMenu), strContainer, sb.ToString(), true);


        }
        #endregion



    }
}
